/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.ide.ui.compare.actions;

import com.ibm.teami.filesystem.ide.ui.LoggingHelper;
import com.ibm.teami.filesystem.ide.ui.compare.views.ActionUIUpdateEvent;
import com.ibm.teami.filesystem.ide.ui.compare.views.IActionUIUpdateListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.window.IShellProvider;

public abstract class AbstractUIUpdateAction
extends Action {
    protected IShellProvider shellProvider;
    protected ListenerList listeners;
    protected String description;
    protected Job job;
    protected boolean supportCancel;

    public AbstractUIUpdateAction(IShellProvider shellProvider, String text, String description) {
        super(text);
        this.shellProvider = shellProvider;
        this.description = description;
        this.supportCancel = false;
    }

    public final void runWithDescription(final String description) {
        final String oldDescription = this.getDescription();
        if (description != null) {
            this.setDescription(description);
        }
        final AbstractUIUpdateAction action = this;
        this.job = new Job(action.getDescription()){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        AbstractUIUpdateAction.this.fireActionRunningEvent(new ActionUIUpdateEvent(status, 1, action));
                        status = AbstractUIUpdateAction.this.performAction(monitor);
                    }
                    catch (CoreException e) {
                        LoggingHelper.error("com.ibm.teamp.filesystem.ide.ui", e.getMessage(), e);
                        status = e.getStatus();
                        if (description != null) {
                            AbstractUIUpdateAction.this.setDescription(oldDescription);
                        }
                        AbstractUIUpdateAction.this.fireActionRunningEvent(new ActionUIUpdateEvent(status, 2, action));
                    }
                }
                finally {
                    if (description != null) {
                        AbstractUIUpdateAction.this.setDescription(oldDescription);
                    }
                    AbstractUIUpdateAction.this.fireActionRunningEvent(new ActionUIUpdateEvent(status, 2, action));
                }
                return status;
            }
        };
        this.job.schedule();
    }

    public final void run() {
        this.runWithDescription(null);
    }

    protected void fireActionRunningEvent(final ActionUIUpdateEvent event) {
        if (this.listeners == null || this.shellProvider == null) {
            return;
        }
        this.shellProvider.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] tempListeners = AbstractUIUpdateAction.this.listeners.getListeners();
                int i = 0;
                while (i < tempListeners.length) {
                    IActionUIUpdateListener listener = (IActionUIUpdateListener)tempListeners[i];
                    listener.actionPerformed(event);
                    ++i;
                }
            }
        });
    }

    public void addActionRunningListener(IActionUIUpdateListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)listener);
    }

    public void removeActionRunningListener(IActionUIUpdateListener listener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void cancel() {
        if (this.supportCancel && this.job != null) {
            this.job.cancel();
        }
    }

    public boolean isCancelAllow() {
        return this.supportCancel;
    }

    protected abstract IStatus performAction(IProgressMonitor var1) throws CoreException;
}

