/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class FileSequenceNumberChecker {
    public static String copyright = "(C) Copyright IBM Corp 2008.";
    public static final int SEQUENCE_UNKNOWN = -1;
    public static final int SEQUENCE_FALSE = 0;
    public static final int SEQUENCE_TRUE = 1;

    public static int hasSequenceNumbers(InputStream inputStream) {
        return FileSequenceNumberChecker.hasSequenceNumbers(inputStream, "UTF-8");
    }

    public static int hasSequenceNumbers(InputStream inputStream, String encoding) {
        InputStreamReader isReader = null;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            isReader = new InputStreamReader(inputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
        BufferedReader buffReader = new BufferedReader(isReader);
        String strLine = null;
        int iValue = 0;
        int i = 0;
        while (i < 4) {
            char c;
            try {
                strLine = buffReader.readLine();
            }
            catch (IOException ex) {
                return i == 0 ? -1 : 1;
            }
            if (strLine == null) {
                return i == 0 ? -1 : 1;
            }
            int length = strLine.length();
            if (length < 6) {
                return 0;
            }
            if (length > 6 && !Character.isWhitespace(c = strLine.charAt(6)) && !Character.isDigit(c)) {
                return 0;
            }
            strLine = strLine.substring(0, 6);
            int iNonZeroIndex = 0;
            int j = 0;
            while (j < 6) {
                if (strLine.charAt(j) != '0') {
                    iNonZeroIndex = j;
                    break;
                }
                ++j;
            }
            if (iNonZeroIndex > 0) {
                strLine = strLine.substring(iNonZeroIndex);
            }
            try {
                iValue = Integer.decode(strLine);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
            if (iValue < 0) {
                return 0;
            }
            ++i;
        }
        return 1;
    }
}

