/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.User;
import com.ibm.etools.iseries.comm.ISeriesAPIErrorCodeException;
import com.ibm.etools.iseries.comm.ISeriesListLibraries;
import com.ibm.etools.iseries.comm.ISeriesListMembers;
import com.ibm.etools.iseries.comm.ISeriesListObjectLocks;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.ISeriesRetrieveDatabaseFileDescription;
import com.ibm.etools.iseries.comm.QSYSCheckUserAuthority;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesLibraryFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesMemberFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostFormatDefinition;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostMemberBasic;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectLock;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectNameOnly;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentizedAncestorList;
import com.ibm.team.scm.common.internal.dto.NameItemPair;
import com.ibm.teami.filesystem.client.internal.Messages;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.IFSMetadataResources;
import com.ibm.teami.filesystem.common.util.IIBMiPropertyKeyConstants;
import com.ibm.teami.filesystem.common.util.IProjectInfo;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IProjectToLibraryMap;
import com.ibm.teami.scm.common.IProjectToLibraryMapHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class FileSystemIUtil {
    private static FileSystemIUtil util;
    private static final String READ_AUTHORITIES = "*READ     ";
    private static final String WRITE_AUTHORITIES = "*READ     *ADD      *DLT      *OBJMGT   *OBJOPR   *EXECUTE  ";
    private final long FILE_SIZE_UNKNOWN = -1L;
    private static HashMap<AS400, ISeriesListLibraries> listLibs;
    private static HashMap<AS400, ISeriesListObjects> listObjs;
    private static HashMap<AS400, ISeriesListObjectLocks> listObjLocks;
    private static HashMap<AS400, ISeriesListMembers> listMbrs;

    static {
        listLibs = new HashMap();
        listObjs = new HashMap();
        listObjLocks = new HashMap();
        listMbrs = new HashMap();
    }

    private FileSystemIUtil() {
    }

    public static FileSystemIUtil getInstance() {
        if (util == null) {
            util = new FileSystemIUtil();
        }
        return util;
    }

    private static ISeriesListLibraries getListLibraries(AS400 as400) {
        ISeriesListLibraries listLibraries = listLibs.get(as400);
        if (listLibraries == null) {
            listLibraries = new ISeriesListLibraries(as400);
            listLibs.put(as400, listLibraries);
        }
        return listLibraries;
    }

    private static ISeriesListObjects getListObjects(AS400 as400) {
        ISeriesListObjects listObjects = listObjs.get(as400);
        if (listObjects == null) {
            listObjects = new ISeriesListObjects(as400);
            listObjs.put(as400, listObjects);
        }
        return listObjects;
    }

    private static ISeriesListObjectLocks getListObjectLocks(AS400 as400) {
        ISeriesListObjectLocks listObjectLocks = listObjLocks.get(as400);
        if (listObjectLocks == null) {
            listObjectLocks = new ISeriesListObjectLocks(as400);
            listObjLocks.put(as400, listObjectLocks);
        }
        return listObjectLocks;
    }

    private static ISeriesListMembers getListMembers(AS400 as400) {
        ISeriesListMembers listMembers = listMbrs.get(as400);
        if (listMembers == null) {
            listMembers = new ISeriesListMembers(as400);
            listMbrs.put(as400, listMembers);
        }
        return listMembers;
    }

    public List<IFolderHandle> getIProjects(IWorkspaceHandle workspaceHandle, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, (IProgressMonitor)progress.newChild(20));
        ArrayList<IFolderHandle> projects = new ArrayList<IFolderHandle>();
        List componentHandles = workspaceConnection.getComponents();
        SubMonitor loopProgress = progress.newChild(80).setWorkRemaining(componentHandles.size());
        for (IComponentHandle componentHandle : componentHandles) {
            projects.addAll(this.getIProjects(workspaceHandle, componentHandle, repository, (IProgressMonitor)loopProgress.newChild(1)));
        }
        return projects;
    }

    public List<IFolderHandle> getIProjects(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, null);
        ArrayList<IFolderHandle> projects = new ArrayList<IFolderHandle>();
        IConfiguration configuration = workspaceConnection.configuration(componentHandle);
        Map childEntries = configuration.childEntriesForRoot(null);
        for (IVersionableHandle versionableHandle : childEntries.values()) {
            IFolderHandle folderHandle;
            if (!(versionableHandle instanceof IFolderHandle) || !this.isIProject(folderHandle = (IFolderHandle)versionableHandle, configuration)) continue;
            projects.add(folderHandle);
        }
        return projects;
    }

    public List<Map<String, IFolderHandle>> getIProjectsWithNames(IWorkspaceHandle workspaceHandle, ITeamRepository repository, boolean includeNonMigratedProjects) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, null);
        ArrayList<Map<String, IFolderHandle>> projects = new ArrayList<Map<String, IFolderHandle>>();
        List componentHandles = workspaceConnection.getComponents();
        for (IComponentHandle componentHandle : componentHandles) {
            projects.addAll(this.getIProjectsWithNames(workspaceHandle, componentHandle, repository, includeNonMigratedProjects));
        }
        return projects;
    }

    public List<Map<String, IFolderHandle>> getIProjectsWithNames(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, ITeamRepository repository, boolean includeNonMigratedProjects) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, null);
        ArrayList<Map<String, IFolderHandle>> projects = new ArrayList<Map<String, IFolderHandle>>();
        IConfiguration configuration = workspaceConnection.configuration(componentHandle);
        Map childEntries = configuration.childEntriesForRoot(null);
        Iterator iterator = childEntries.keySet().iterator();
        String projectName = null;
        IVersionableHandle versionableHandle = null;
        while (iterator.hasNext()) {
            IFolderHandle folderHandle;
            projectName = (String)iterator.next();
            versionableHandle = (IVersionableHandle)childEntries.get(projectName);
            if (!(versionableHandle instanceof IFolderHandle) || !this.isIProject(folderHandle = (IFolderHandle)versionableHandle, configuration)) continue;
            boolean addToList = true;
            if (!includeNonMigratedProjects && this.isUsingOldPropertiesModel(folderHandle, configuration)) {
                addToList = false;
            }
            if (!addToList) continue;
            HashMap<String, IFolderHandle> map = new HashMap<String, IFolderHandle>();
            map.put(projectName, folderHandle);
            projects.add(map);
        }
        return projects;
    }

    public List<IProjectInfo> getIProjectsWithInfos(IWorkspaceHandle workspaceHandle, ITeamRepository repository, boolean includeNonMigratedProjects) throws TeamRepositoryException {
        return this.getIProjectsWithInfos(workspaceHandle, repository, includeNonMigratedProjects, false);
    }

    public List<IProjectInfo> getIProjectsWithInfos(IWorkspaceHandle workspaceHandle, ITeamRepository repository, boolean includeNonMigratedProjects, boolean assumeProjectsAreIBMiProjects) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, null);
        ArrayList<IProjectInfo> projects = new ArrayList<IProjectInfo>();
        List componentHandles = workspaceConnection.getComponents();
        for (IComponentHandle componentHandle : componentHandles) {
            List<IProjectInfo> projectsInComponent = this.getIProjectsWithInfos(workspaceHandle, componentHandle, repository, includeNonMigratedProjects, assumeProjectsAreIBMiProjects);
            this.markDuplicateNames(projects, projectsInComponent);
            projects.addAll(projectsInComponent);
        }
        return projects;
    }

    public List<IProjectInfo> getIProjectsWithInfos(IWorkspaceHandle workspaceHandle, ITeamRepository repository, boolean includeNonMigratedProjects, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getIProjectsWithInfos(workspaceHandle, repository, includeNonMigratedProjects, false, monitor);
    }

    public List<IProjectInfo> getIProjectsWithInfos(IWorkspaceHandle workspaceHandle, ITeamRepository repository, boolean includeNonMigratedProjects, boolean assumeProjectsAreIBMiProjects, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, null);
        List ancestorList = workspaceConnection.configuration().fetchAncestorsByName(".project", monitor);
        ArrayList<IProjectInfo> allProjects = new ArrayList<IProjectInfo>();
        for (IComponentizedAncestorList ancestor : ancestorList) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IComponentHandle componentHandle = ancestor.getComponent();
            IConfiguration configuration = workspaceConnection.configuration(componentHandle);
            Map reports = ancestor.getAncestorReports();
            Set uuids = reports.keySet();
            for (UUID uuid : uuids) {
                NameItemPair pair;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IAncestorReport report = (IAncestorReport)reports.get(uuid);
                List nameItemPairs = report.getNameItemPairs();
                if (nameItemPairs.size() <= 2 || !".project".equals((pair = (NameItemPair)nameItemPairs.get(nameItemPairs.size() - 1)).getName())) continue;
                NameItemPair projectPair = (NameItemPair)nameItemPairs.get(nameItemPairs.size() - 2);
                if (!assumeProjectsAreIBMiProjects && !FileSystemIUtil.getInstance().isIProject((IFileItemHandle)pair.getItem(), configuration)) continue;
                IProjectInfo info = new IProjectInfo(projectPair.getName(), (IFolderHandle)projectPair.getItem(), componentHandle);
                allProjects.add(info);
            }
        }
        return allProjects;
    }

    public List<IProjectInfo> getIProjectsWithInfos(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, ITeamRepository repository, boolean includeNonMigratedProjects) throws TeamRepositoryException {
        return this.getIProjectsWithInfos(workspaceHandle, componentHandle, repository, includeNonMigratedProjects, false);
    }

    public List<IProjectInfo> getIProjectsWithInfos(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, ITeamRepository repository, boolean includeNonMigratedProjects, boolean assumeProjectsAreIBMiProjects) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, null);
        ArrayList<IProjectInfo> projects = new ArrayList<IProjectInfo>();
        IConfiguration configuration = workspaceConnection.configuration(componentHandle);
        Map childEntries = configuration.childEntriesForRoot(null);
        Iterator iterator = childEntries.keySet().iterator();
        String projectName = null;
        IVersionableHandle versionableHandle = null;
        while (iterator.hasNext()) {
            projectName = (String)iterator.next();
            versionableHandle = (IVersionableHandle)childEntries.get(projectName);
            if (!(versionableHandle instanceof IFolderHandle)) continue;
            IFolderHandle folderHandle = (IFolderHandle)versionableHandle;
            if (!assumeProjectsAreIBMiProjects && !this.isIProject(folderHandle, configuration)) continue;
            boolean addToList = true;
            if (!assumeProjectsAreIBMiProjects && !includeNonMigratedProjects && this.isUsingOldPropertiesModel(folderHandle, configuration)) {
                addToList = false;
            }
            if (!addToList) continue;
            IProjectInfo info = new IProjectInfo(projectName, folderHandle, componentHandle);
            projects.add(info);
        }
        return projects;
    }

    private void markDuplicateNames(List<IProjectInfo> projects, List<IProjectInfo> projectsInComponent) {
        for (IProjectInfo projectInfo : projectsInComponent) {
            String name = projectInfo.getName();
            for (IProjectInfo projectInfo1 : projects) {
                if (!name.equals(projectInfo1.getName())) continue;
                projectInfo.setDuplicateInWorkspace(true);
                projectInfo1.setDuplicateInWorkspace(true);
            }
        }
    }

    public boolean isIProject(IFolderHandle folderHandle, IConfiguration configuration) throws TeamRepositoryException {
        IVersionableHandle versionableHandle = (IVersionableHandle)configuration.childEntries(folderHandle, null).get(".project");
        if (versionableHandle != null && versionableHandle instanceof IFileItemHandle) {
            IFileItemHandle projectDescriptionFileHandle = (IFileItemHandle)versionableHandle;
            IFileItem projectDescriptionFile = this.getFileItem(projectDescriptionFileHandle, configuration);
            IFileContent content = projectDescriptionFile.getContent();
            InputStream inputStream = FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)projectDescriptionFile, content, null);
            boolean isIProject = false;
            try {
                isIProject = this.checkInputStreamIsIProject(inputStream);
                inputStream.close();
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
            return isIProject;
        }
        return false;
    }

    public boolean isIProject(IFileItemHandle fileHandle, IConfiguration configuration) throws TeamRepositoryException {
        IFileItem projectDescriptionFile = this.getFileItem(fileHandle, configuration);
        IFileContent content = projectDescriptionFile.getContent();
        InputStream inputStream = FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)projectDescriptionFile, content, null);
        boolean isIProject = false;
        try {
            isIProject = this.checkInputStreamIsIProject(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return isIProject;
    }

    private boolean checkInputStreamIsIProject(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        while (line != null) {
            int index;
            String nature;
            if ((line = line.trim()).startsWith("<nature>") && (nature = line.substring(8, index = line.indexOf("</nature>"))).equals("com.ibm.etools.iseries.perspective.nature")) {
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }

    public boolean isUsingOldPropertiesModel(IFolderHandle folderHandle, IConfiguration configuration) throws TeamRepositoryException {
        return configuration.childEntries(folderHandle, null).get(".iseries_project_properties") != null;
    }

    public List<IFolderHandle> filterOutLegacyIProjects(List<IFolderHandle> iPrjHandles, IConfiguration configuration) throws TeamRepositoryException {
        ArrayList<IFolderHandle> nonLegacyProjects = new ArrayList<IFolderHandle>(iPrjHandles.size());
        for (IFolderHandle iPrjHandle : iPrjHandles) {
            if (this.isUsingOldPropertiesModel(iPrjHandle, configuration)) continue;
            nonLegacyProjects.add(iPrjHandle);
        }
        return nonLegacyProjects;
    }

    public List<IFolderHandle> getNonMappedIProjects(IWorkspaceHandle workspaceHandle, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection wsConn = manager.getWorkspaceConnection(workspaceHandle, (IProgressMonitor)progress.newChild(30));
        ArrayList<IFolderHandle> nonMappedProjectsList = new ArrayList<IFolderHandle>();
        List componentHandles = wsConn.getComponents();
        if (componentHandles == null || componentHandles.isEmpty()) {
            return nonMappedProjectsList;
        }
        SubMonitor loopProgress = progress.newChild(70).setWorkRemaining(componentHandles.size());
        for (IComponentHandle componentHandle : componentHandles) {
            nonMappedProjectsList.addAll(this.getNonMappedIProjects(workspaceHandle, componentHandle, repository, (IProgressMonitor)loopProgress.newChild(1)));
        }
        return nonMappedProjectsList;
    }

    public List<IFolderHandle> getNonMappedIProjects(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IFolderHandle> nonMappedProjectsList = new ArrayList<IFolderHandle>();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection wsConn = manager.getWorkspaceConnection(workspaceHandle, (IProgressMonitor)progress.newChild(20));
        IConfiguration configuration = wsConn.configuration(componentHandle);
        List<IFolderHandle> projectHandles = this.getIProjects(workspaceHandle, componentHandle, repository, (IProgressMonitor)progress.newChild(20));
        projectHandles = this.filterOutLegacyIProjects(projectHandles, configuration);
        IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
        IWorkspaceIHandle workspaceIHandle = clientLibrary.getWorkspaceI(workspaceHandle, (IProgressMonitor)progress.newChild(20));
        if (workspaceIHandle == null) {
            return projectHandles;
        }
        List mappingHandles = clientLibrary.getProjectToLibraryMappings(workspaceIHandle, projectHandles, (IProgressMonitor)progress.newChild(20));
        if (mappingHandles == null || mappingHandles.isEmpty()) {
            return projectHandles;
        }
        SubMonitor loopProgress = progress.newChild(20).setWorkRemaining(mappingHandles.size());
        for (IProjectToLibraryMapHandle mapHandle : mappingHandles) {
            IProjectToLibraryMap temp = (IProjectToLibraryMap)repository.itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, (IProgressMonitor)loopProgress.newChild(1));
            IFolderHandle projectHandle = temp.getFolder();
            String library = temp.getLibrary();
            if (library == null || library.equals("")) {
                nonMappedProjectsList.add(projectHandle);
            } else if ((library = library.trim()).equals("")) {
                nonMappedProjectsList.add(projectHandle);
            }
            projectHandles = this.removeProjectHandle(projectHandle, projectHandles);
        }
        if (projectHandles.size() > 0) {
            for (IFolderHandle projectHandle : projectHandles) {
                nonMappedProjectsList.add(projectHandle);
            }
        }
        return nonMappedProjectsList;
    }

    public List<IFolderHandle> removeProjectHandle(IFolderHandle projectHandle, List<IFolderHandle> folderHandles) {
        ArrayList<IFolderHandle> tempFolderHandles = new ArrayList<IFolderHandle>(folderHandles);
        for (IFolderHandle folderHandle : folderHandles) {
            if (!folderHandle.sameItemId((IItemHandle)projectHandle)) continue;
            tempFolderHandles.remove(folderHandle);
        }
        return tempFolderHandles;
    }

    public IFolderHandle getFolderHandle(IVersionableHandle versionableHandle) {
        return (IFolderHandle)versionableHandle;
    }

    public IFileItemHandle getFileHandle(IVersionableHandle versionableHandle) {
        return (IFileItemHandle)versionableHandle;
    }

    public IFolder getFolder(IFolderHandle folderHandle, IConfiguration configuration) throws TeamRepositoryException {
        IFolder folder = (IFolder)configuration.fetchCompleteItem((IVersionableHandle)folderHandle, null);
        return folder;
    }

    public IFileItem getFileItem(IFileItemHandle fileItemHandle, IConfiguration configuration) throws TeamRepositoryException {
        IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, null);
        return fileItem;
    }

    private FileSystemStatusException createAmbiguousSelectorException(String message) {
        return new FileSystemStatusException((IStatus)new Status(4, "com.ibm.teami.filesystem.client", 9, message, null));
    }

    private FileSystemStatusException wrap(TeamRepositoryException e, String failureMsg) {
        if (e instanceof PermissionDeniedException) {
            return this.createFailureException(((PermissionDeniedException)e).getLocalizedMessage(), 18, null);
        }
        if (e instanceof LicenseNotGrantedException) {
            return this.createFailureException(NLS.bind((String)Messages.StatusHelper_12, (Object)e.getMessage()), 29, (Throwable)e);
        }
        return this.createFailureException(failureMsg, 3, (Throwable)e);
    }

    private FileSystemStatusException createFailureException(String message, int errorCode, Throwable t) {
        return new FileSystemStatusException((IStatus)new Status(4, "com.ibm.teami.filesystem.client", errorCode, message, t));
    }

    private Map<String, IVersionableHandle> findAllChildrenEntry(IConfiguration wsConfiguration, IFolderHandle folder) throws TeamRepositoryException {
        try {
            return wsConfiguration.childEntries(folder, null);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public static String stripFileExtension(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(0, index);
    }

    public static String trailingTrim(String temp) {
        int end = temp.length() - 1;
        while (end >= 0 && temp.charAt(end) <= ' ') {
            --end;
        }
        return temp.substring(0, end + 1);
    }

    public static String getRemotePath(String libName, String sourceFileName, String memberName) {
        int index = memberName.indexOf(46);
        String tempMemberName = index == -1 ? memberName : memberName.substring(0, index);
        return "/QSYS.LIB/" + libName + ".LIB/" + sourceFileName + ".FILE/" + tempMemberName + ".MBR";
    }

    public static String getRemotePath(String libName, String sourceFileName) {
        return "/QSYS.LIB/" + libName + ".LIB/" + sourceFileName + ".FILE";
    }

    public static String getRemotePath(String libName) {
        return "/QSYS.LIB/" + libName + ".LIB/";
    }

    public static ISeriesHostMemberBasic getHostMember(String libraryName, String sourceFileName, String memberName, AS400 as400) throws Exception {
        List list;
        ISeriesListMembers pgm = FileSystemIUtil.getListMembers(as400);
        if (memberName.contains("\u00a5")) {
            memberName = memberName.replace('\u00a5', '$');
        }
        if ((list = pgm.getList((ISeriesAbstractFilterString)new ISeriesMemberFilterString(String.valueOf(libraryName) + '/' + sourceFileName + '(' + memberName + ')'))).size() > 0) {
            return (ISeriesHostMemberBasic)list.get(0);
        }
        return null;
    }

    public static long getHostMemberTimestamp(String libraryName, String sourceFileName, String memberName, AS400 as400) throws Exception {
        ISeriesHostMemberBasic remoteMember = FileSystemIUtil.getHostMember(libraryName, sourceFileName, memberName, as400);
        if (remoteMember == null) {
            return -1L;
        }
        return FileSystemIUtil.convertLocal2UTC(remoteMember.getDateModified().getTime());
    }

    public static boolean isHostMemberExist(String libraryName, String sourceFileName, String memberName, AS400 as400) throws Exception {
        ISeriesHostMemberBasic remoteMember = FileSystemIUtil.getHostMember(libraryName, sourceFileName, memberName, as400);
        return remoteMember != null;
    }

    public static ISeriesHostObjectBasic getHostObject(String libraryName, String sourceFileName, String type, String subtype, AS400 as400) {
        try {
            ISeriesListObjects pgm;
            List list;
            String objType = "";
            if (type != null) {
                objType = " OBJTYPE(" + type;
                if (subtype != null) {
                    objType = String.valueOf(objType) + ":" + subtype;
                }
                objType = String.valueOf(objType) + ")";
            }
            if ((list = (pgm = FileSystemIUtil.getListObjects(as400)).getList((ISeriesAbstractFilterString)new ISeriesObjectFilterString(String.valueOf(libraryName) + "/" + sourceFileName + objType))).size() > 0) {
                return (ISeriesHostObjectBasic)list.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static long getHostSourceFileTimestamp(String libraryName, String sourceFileName, AS400 as400) {
        return FileSystemIUtil.getHostObjectTimestamp(libraryName, sourceFileName, "*FILE", "PF-SRC", as400);
    }

    public static long getHostSaveFileTimestamp(String libraryName, String saveFileName, AS400 as400) {
        return FileSystemIUtil.getHostObjectTimestamp(libraryName, saveFileName, "*FILE", "SAVF", as400);
    }

    public static long getHostObjectTimestamp(String libraryName, String objectName, String type, String subtype, AS400 as400) {
        ISeriesHostObjectBasic remoteObject = FileSystemIUtil.getHostObject(libraryName, objectName, type, subtype, as400);
        if (remoteObject == null) {
            return -1L;
        }
        return FileSystemIUtil.convertLocal2UTC(remoteObject.getDateModified().getTime());
    }

    public static boolean isHostObjectExist(String libraryName, String objectName, String type, String subtype, AS400 as400) {
        return FileSystemIUtil.getHostObject(libraryName, objectName, type, subtype, as400) != null;
    }

    public static ISeriesHostObjectBasic getHostLibrary(String libraryName, AS400 as400) throws Exception {
        ISeriesListObjects pgm = FileSystemIUtil.getListObjects(as400);
        List list = pgm.getList((ISeriesAbstractFilterString)new ISeriesLibraryFilterString(libraryName));
        if (list.size() > 0) {
            return (ISeriesHostObjectBasic)list.get(0);
        }
        return null;
    }

    public static boolean isHostLibraryExist(String libraryName, AS400 as400) throws Exception {
        return FileSystemIUtil.getHostLibrary(libraryName, as400) != null;
    }

    public static boolean isIBMiHiddenFolder(String name) {
        return name.equals(".ibmi");
    }

    public static boolean isHiddenFolder(String name) {
        return name.startsWith(".");
    }

    public static boolean isSourceFile(String type, String subType) {
        return type.equalsIgnoreCase("*FILE") && subType.equalsIgnoreCase("PF-SRC");
    }

    public static boolean isSaveFile(String type, String subType) {
        return type.equalsIgnoreCase("*FILE") && subType.equalsIgnoreCase("SAVF");
    }

    public boolean checkAuthority(AS400 as400, String library, String object, String objectType, String authorityList) {
        QSYSCheckUserAuthority api = new QSYSCheckUserAuthority(as400, "*CURRENT", library, object, objectType);
        try {
            return api.checkAuthority(authorityList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean checkFileReadAuthority(AS400 as400, String library, String fileName) {
        return this.checkAuthority(as400, library, fileName, "*FILE", READ_AUTHORITIES);
    }

    public boolean checkFileWriteAuthority(AS400 as400, String library, String fileName) {
        return this.checkAuthority(as400, library, fileName, "*FILE", WRITE_AUTHORITIES);
    }

    public ISeriesHostObjectLock queryMemberLock(AS400 as400, String library, String fileName, String memberName) {
        List<ISeriesHostObjectLock> locks = this.listMemberLocks(as400, library, fileName, memberName);
        if (locks != null) {
            int i = 0;
            while (i < locks.size()) {
                String lockState = locks.get(i).getLockState();
                if (lockState.equalsIgnoreCase("*shrupd") || lockState.equalsIgnoreCase("*exclrd") || lockState.equalsIgnoreCase("*shrnup") || lockState.equalsIgnoreCase("*excl")) {
                    return locks.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    protected List<ISeriesHostObjectLock> listMemberLocks(AS400 as400, String library, String fileName, String memberName) {
        ISeriesListObjectLocks listObjLocks = FileSystemIUtil.getListObjectLocks(as400);
        try {
            return listObjLocks.getList(library, fileName, "*FILE     ", memberName);
        }
        catch (Exception e) {
            return new ArrayList<ISeriesHostObjectLock>(0);
        }
    }

    public String getLibraryName(AS400 as400, String libraryName) {
        List results;
        block4: {
            if (libraryName.startsWith("\"") && libraryName.equals(libraryName.toUpperCase())) {
                libraryName = libraryName.substring(1, libraryName.length() - 1).toUpperCase();
            }
            ISeriesLibraryFilterString filterString = new ISeriesLibraryFilterString(libraryName);
            ISeriesListLibraries listLibraries = FileSystemIUtil.getListLibraries(as400);
            listLibraries.setInfoLevel(0);
            results = null;
            try {
                results = listLibraries.getListNameOnly((ISeriesAbstractFilterString)filterString);
                if (results != null && results.size() != 0) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ISeriesHostObjectNameOnly library = (ISeriesHostObjectNameOnly)results.get(0);
        return library.getName();
    }

    public boolean isLibraryExists(AS400 as400, String libraryName) {
        if (libraryName.startsWith("\"") && libraryName.equals(libraryName.toUpperCase())) {
            libraryName = libraryName.substring(1, libraryName.length() - 1).toUpperCase();
        }
        ISeriesLibraryFilterString filterString = new ISeriesLibraryFilterString(libraryName);
        ISeriesListLibraries listLibraries = FileSystemIUtil.getListLibraries(as400);
        listLibraries.setInfoLevel(0);
        List results = null;
        try {
            results = listLibraries.getListNameOnly((ISeriesAbstractFilterString)filterString);
            return results != null && results.size() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Attributes getSourceFileAttributes(AS400 as400, String libraryName, String sourceFileName) {
        Attributes attributes = new Attributes();
        try {
            ISeriesRetrieveDatabaseFileDescription pgm1 = new ISeriesRetrieveDatabaseFileDescription(as400);
            attributes.setProperty(IIBMiPropertyKeyConstants.KEY_CCSID.toString(), String.valueOf(pgm1.retrieveFileCCSID(libraryName, sourceFileName)));
            IISeriesHostFormatDefinition formatDefinition = pgm1.retrieveFormatDefinition(libraryName, sourceFileName, "*FIRST");
            attributes.setProperty(IIBMiPropertyKeyConstants.KEY_RECORD_LENGTH.toString(), String.valueOf(formatDefinition.getLength()));
            return attributes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSourceFileRecordLength(AS400 as400, String libraryName, String sourceFileName) throws ISeriesAPIErrorCodeException {
        try {
            ISeriesRetrieveDatabaseFileDescription pgm1 = new ISeriesRetrieveDatabaseFileDescription(as400);
            IISeriesHostFormatDefinition formatDefinition = pgm1.retrieveFormatDefinition(libraryName, sourceFileName, "*FIRST");
            return String.valueOf(formatDefinition.getLength());
        }
        catch (ISeriesAPIErrorCodeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String massageTextDescription(String textDescription) {
        StringBuffer temp = new StringBuffer(textDescription);
        String quote = "'";
        int index = -1;
        int startIndex = 0;
        index = temp.indexOf(quote, startIndex);
        while (index != -1) {
            if (index < temp.length() - 1) {
                temp = temp.insert(index + 1, quote);
                startIndex = index + 2;
                index = temp.indexOf(quote, startIndex);
                continue;
            }
            temp = temp.append(quote);
            break;
        }
        return temp.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadFile(IFSFile remoteFile, File localFile, IProgressMonitor monitor) {
        IFSFileInputStream inputStream = null;
        BufferedInputStream bufInputStream = null;
        FileOutputStream outputStream = null;
        FilterOutputStream bufOutputStream = null;
        boolean isCancelled = false;
        try {
            try {
                String remotePath = remoteFile.getAbsolutePath();
                IFSFile ifsFile = new IFSFile(remoteFile.getSystem(), remotePath);
                long totalBytes = ifsFile.length();
                if (monitor != null) {
                    monitor.beginTask(remotePath, (int)totalBytes);
                }
                if (!localFile.exists()) {
                    File parentDir = localFile.getParentFile();
                    parentDir.mkdirs();
                }
                inputStream = new IFSFileInputStream(ifsFile);
                bufInputStream = new BufferedInputStream((InputStream)inputStream, 4096);
                outputStream = new FileOutputStream(localFile);
                bufOutputStream = new BufferedOutputStream(outputStream, 4096);
                byte[] buffer = new byte[4096];
                int numToRead = 0;
                long totalSent = 0L;
                int available = bufInputStream.available();
                while (available > 0) {
                    if (isCancelled) {
                        return;
                    }
                    numToRead = available < 4096 ? available : 4096;
                    int bytesRead = bufInputStream.read(buffer, 0, numToRead);
                    if (bytesRead == -1) {
                        return;
                    }
                    totalSent += (long)bytesRead;
                    ((BufferedOutputStream)bufOutputStream).write(buffer, 0, bytesRead);
                    if (monitor != null) {
                        monitor.worked(bytesRead);
                        long percent = totalSent * 100L / totalBytes;
                        Object[] substitutions = new String[]{String.valueOf(totalSent / 1000L) + " KB", String.valueOf(totalBytes / 1000L) + " KB", String.valueOf(percent) + "%"};
                        String msgTxt = NLS.bind((String)IFSMetadataResources.FILEMSG_MSG_PERCENT_DONE, (Object[])substitutions);
                        monitor.subTask(msgTxt);
                        isCancelled = monitor.isCanceled();
                    }
                    available = bufInputStream.available();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bufInputStream != null) {
                        bufInputStream.close();
                    }
                    if (bufOutputStream == null) return;
                    bufOutputStream.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    return;
                }
            }
        }
        finally {
            try {
                if (bufInputStream != null) {
                    bufInputStream.close();
                }
                if (bufOutputStream != null) {
                    bufOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean uploadFile(File localFile, IFSFile remoteFile) {
        Object monitor = null;
        BufferedInputStream bufInputStream = null;
        IFSFileOutputStream outputStream = null;
        FilterOutputStream bufOutputStream = null;
        boolean isCancelled = false;
        long srcBytes = localFile.length();
        try {
            boolean created;
            FileInputStream inputStream = new FileInputStream(localFile.getAbsolutePath());
            bufInputStream = new BufferedInputStream(inputStream, 4096);
            outputStream = new IFSFileOutputStream(remoteFile);
            bufOutputStream = new BufferedOutputStream((OutputStream)outputStream, 4096);
            if (!remoteFile.exists() && !(created = remoteFile.createNewFile())) {
                return false;
            }
            long totalSent = 0L;
            byte[] buffer = new byte[4096];
            int numToRead = 0;
            int available = bufInputStream.available();
            while (available > 0) {
                if (isCancelled) {
                    return true;
                }
                numToRead = available < 4096 ? available : 4096;
                int bytesRead = bufInputStream.read(buffer, 0, numToRead);
                if (bytesRead == -1) {
                    return true;
                }
                totalSent += (long)bytesRead;
                ((BufferedOutputStream)bufOutputStream).write(buffer, 0, bytesRead);
                if (monitor != null) {
                    if (srcBytes != -1L) {
                        monitor.worked(bytesRead);
                        long percent = totalSent * 100L / srcBytes;
                        Object[] substitutions = new String[]{String.valueOf(totalSent / 1000L) + " KB", String.valueOf(srcBytes / 1000L) + " KB", String.valueOf(percent) + "%"};
                        String msgTxt = NLS.bind((String)IFSMetadataResources.FILEMSG_MSG_PERCENT_DONE, (Object[])substitutions);
                        monitor.subTask(msgTxt);
                    }
                    isCancelled = monitor.isCanceled();
                }
                available = bufInputStream.available();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (bufInputStream != null) {
                    bufInputStream.close();
                }
                if (bufOutputStream != null) {
                    bufOutputStream.close();
                }
                if (isCancelled) {
                    return false;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public int getEditingCCSID(String libraryName, String sourceFileName, AS400 as400) throws FileSystemStatusException {
        try {
            ISeriesRetrieveDatabaseFileDescription api;
            ProgramCall pgm = new ProgramCall(as400);
            Job job = pgm.getServerJob();
            User user = new User(as400, (String)job.getValue(305));
            int ccsid = user.getCCSID();
            if (ccsid < 0) {
                SystemValue qccsid = new SystemValue(as400, "QCCSID");
                ccsid = (Integer)qccsid.getValue();
            }
            if (!(ccsid != 65535 && ccsid != -1 && ccsid != 0 || (ccsid = (api = new ISeriesRetrieveDatabaseFileDescription(as400)).retrieveFileCCSID(libraryName, sourceFileName)) != 65535 && ccsid != -1 && ccsid != 0)) {
                ccsid = job.getCodedCharacterSetID();
            }
            return ccsid;
        }
        catch (Exception e) {
            throw this.createFailureException(e.getMessage(), 113, e);
        }
    }

    public static IProgressMonitor getMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", ticks);
        return monitor;
    }

    public static void checkProgress(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static long convertLocal2UTC(long timestamp) {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = cal.get(15) + cal.get(16);
        return timestamp + (long)offset;
    }

    public IFileItemHandle getIProjectBuildFile(IFolderHandle projectHandle, IConfiguration configuration) throws TeamRepositoryException {
        IVersionableHandle metadataTempHandle = (IVersionableHandle)configuration.childEntries(projectHandle, null).get(".ibmi");
        if (metadataTempHandle != null && metadataTempHandle instanceof IFolderHandle) {
            IFolderHandle metadataFolderHandle = (IFolderHandle)metadataTempHandle;
            IVersionableHandle buildTempHandle = (IVersionableHandle)configuration.childEntries(metadataFolderHandle, null).get(".ibuild");
            if (buildTempHandle != null && buildTempHandle instanceof IFileItemHandle) {
                return (IFileItemHandle)buildTempHandle;
            }
            return null;
        }
        return null;
    }

    public static void clearISeriesListMaps() {
        listLibs.clear();
        listMbrs.clear();
        listObjLocks.clear();
        listObjs.clear();
    }
}

