/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.operations;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teami.filesystem.client.internal.ISeriesCodepageConverter;
import com.ibm.teami.filesystem.client.internal.Messages;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.IBMiProjectResourceNameUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ObjectArchiveResourceUtil {
    private static final String MANIFEST_FILE_NAME = "properties.xml";
    private static final String DEFAULT_TEMP_LIBRARYNAME = "QTEMP";
    private final AS400 as400;
    private final PrintWriter writer;
    private String tmpDirectory;
    private IFSFile ifsOARFile;
    private IFSFile ifsManifestFile;
    private String objLibrary;
    private String objName;
    private String objType;
    private final String binaryObjectName;

    public ObjectArchiveResourceUtil(AS400 as400, PrintWriter writer, String binaryObjectName) throws TeamRepositoryException {
        this.as400 = as400;
        this.writer = writer;
        this.binaryObjectName = binaryObjectName;
        this.tmpDirectory = System.getProperty("java.io.tmpdir");
        if (this.tmpDirectory == null) {
            this.tmpDirectory = "/tmp/";
        }
        this.tmpDirectory = String.valueOf(this.tmpDirectory) + "binaryObjects/";
        IFSFile tmpDir = new IFSFile(as400, this.tmpDirectory);
        try {
            if (!tmpDir.exists() && !tmpDir.mkdirs()) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException("Failed to create tempoary directory: " + this.tmpDirectory, (Throwable)e);
        }
    }

    public IStatus restoreBinaryObject(InputStream inputStream) {
        IFSFile targetFile = new IFSFile(this.as400, String.valueOf(this.tmpDirectory) + this.binaryObjectName + "/binaryObject.oar");
        IFSFile targetDir = targetFile.getParentFile();
        try {
            if (targetFile.exists() ? !targetFile.delete() : !targetDir.exists() && !targetDir.mkdirs()) {
                return Status.CANCEL_STATUS;
            }
            int CHUNKSIZE = 262144;
            IFSFileOutputStream target = new IFSFileOutputStream(this.as400, targetFile.getAbsolutePath(), -4, false);
            byte[] buffer = new byte[CHUNKSIZE];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead > 0) {
                target.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
            target.close();
            return Status.OK_STATUS;
        }
        catch (IOException ioe) {
            this.printMessage("Error restoring binary object");
        }
        catch (AS400SecurityException e) {
            this.printMessage("AS400SecurityException");
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus extractOARFile() {
        try {
            ZipFile oarFile = new ZipFile(String.valueOf(this.tmpDirectory) + this.binaryObjectName + "/binaryObject.oar");
            Enumeration<? extends ZipEntry> entries = oarFile.entries();
            byte[] buffer = new byte[32768];
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String outFileName = entry.getName();
                InputStream in = oarFile.getInputStream(entry);
                IFSFile outFile = new IFSFile(this.as400, String.valueOf(this.tmpDirectory) + this.binaryObjectName, outFileName);
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)new IFSFileOutputStream(outFile));
                int len = in.read(buffer);
                while (len >= 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                    len = in.read(buffer);
                }
                in.close();
                ((OutputStream)out).close();
                if (outFileName.equals(MANIFEST_FILE_NAME)) {
                    this.ifsManifestFile = outFile;
                    continue;
                }
                this.ifsOARFile = outFile;
            }
            oarFile.close();
        }
        catch (IOException e) {
            this.printMessage(e.getMessage());
        }
        catch (AS400SecurityException e) {
            this.printMessage(e.getMessage());
        }
        if (this.ifsManifestFile != null) {
            this.readArchiveManifest(this.ifsManifestFile);
        }
        return Status.OK_STATUS;
    }

    private void readArchiveManifest(IFSFile manifest) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse((InputStream)new IFSFileInputStream(manifest), null);
            doc.getDocumentElement().normalize();
            NodeList nodes = doc.getElementsByTagName("object");
            int i = 0;
            while (i < nodes.getLength()) {
                Node objNode = nodes.item(i);
                if (objNode.getNodeType() == 1) {
                    Element objProps = (Element)objNode;
                    this.objLibrary = objProps.getAttribute("library");
                    this.objName = objProps.getAttribute("name");
                    this.objType = objProps.getAttribute("type");
                }
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (AS400SecurityException e) {
            e.printStackTrace();
        }
    }

    public IStatus copySavfToQTEMP() {
        String saveFileName;
        String savfNameIFS = saveFileName = this.ifsOARFile.getName();
        String fromFileName = String.valueOf(this.tmpDirectory) + this.binaryObjectName + "/" + savfNameIFS;
        String savfLibName = DEFAULT_TEMP_LIBRARYNAME;
        String libraryNameIFS = "/QSYS.LIB/" + savfLibName + ".LIB";
        String toFileName = String.valueOf(libraryNameIFS) + "/" + savfNameIFS;
        String command = "CPYFRMSTMF FROMSTMF('" + fromFileName + "') TOMBR('" + toFileName + "') MBROPT(*REPLACE)";
        IStatus status = this.runCommand(command);
        return status;
    }

    public IStatus restoreSavfContents(String restoreObjectName, String restoreObjectLibrary) {
        String objectName = this.objName;
        String restoreToName = restoreObjectName;
        restoreToName = IBMiProjectResourceNameUtil.unEscapeFileName((String)restoreToName);
        String objectLibrary = this.objLibrary;
        String restoreToLibrary = restoreObjectLibrary;
        String objectType = this.objType;
        String savfLibName = DEFAULT_TEMP_LIBRARYNAME;
        String tempSavfName = this.ifsOARFile.getName().substring(0, this.ifsOARFile.getName().indexOf(".FILE"));
        String tempSavfFullName = String.valueOf(savfLibName) + "/" + tempSavfName;
        String aspDevParam = " RSTASP(1)";
        String command = "RSTOBJ OBJ(" + objectName + ") SAVLIB(" + objectLibrary + ") RSTLIB(" + DEFAULT_TEMP_LIBRARYNAME + ") DEV(*SAVF) OBJTYPE(" + objectType + ") SAVF(" + tempSavfFullName + ")" + aspDevParam;
        IStatus status = this.runCommand(command);
        if (status.getSeverity() == 8) {
            if (objectName.equalsIgnoreCase(restoreToName)) {
                status = this.deleteBinaryObject(restoreToLibrary, restoreToName, objectType);
                if (status.getSeverity() == 8) {
                    this.deleteBinaryObject(savfLibName, restoreToName, objectType);
                    return status;
                }
                command = "RSTOBJ OBJ(" + objectName + ") SAVLIB(" + objectLibrary + ") RSTLIB(" + restoreToLibrary + ") DEV(*SAVF) OBJTYPE(" + objectType + ") SAVF(" + tempSavfFullName + ")" + aspDevParam;
                status = this.runCommand(command);
            } else if (!FileSystemIUtil.isHostObjectExist(restoreToLibrary, objectName, objectType, null, this.as400)) {
                command = "RSTOBJ OBJ(" + objectName + ") SAVLIB(" + objectLibrary + ") RSTLIB(" + restoreToLibrary + ") DEV(*SAVF) OBJTYPE(" + objectType + ") SAVF(" + tempSavfFullName + ")" + aspDevParam;
                status = this.runCommand(command);
            } else {
                String originalName = String.valueOf(restoreToLibrary) + "/" + objectName;
                command = "RNMOBJ OBJ(" + originalName + ") OBJTYPE(" + objectType + ") NEWOBJ(" + tempSavfName + ")";
                status = this.runCommand(command);
                if (status.getSeverity() == 8) {
                    return status;
                }
                command = "RSTOBJ OBJ(" + objectName + ") SAVLIB(" + objectLibrary + ") RSTLIB(" + restoreToLibrary + ") DEV(*SAVF) OBJTYPE(" + objectType + ") SAVF(" + tempSavfFullName + ")" + aspDevParam;
                status = this.runCommand(command);
                if (status.getSeverity() == 8) {
                    return status;
                }
                originalName = String.valueOf(restoreToLibrary) + "/" + objectName;
                command = "RNMOBJ OBJ(" + originalName + ") OBJTYPE(" + objectType + ") NEWOBJ(" + restoreToName + ")";
                status = this.runCommand(command);
                if (status.getSeverity() == 8) {
                    return status;
                }
                originalName = String.valueOf(restoreToLibrary) + "/" + tempSavfName;
                command = "RNMOBJ OBJ(" + originalName + ") OBJTYPE(" + objectType + ") NEWOBJ(" + objectName + ")";
                status = this.runCommand(command);
                if (status.getSeverity() == 8) {
                    return status;
                }
            }
            return status;
        }
        if (!objectName.equalsIgnoreCase(restoreToName)) {
            this.deleteBinaryObject(savfLibName, restoreToName, objectType);
            String originalName = String.valueOf(savfLibName) + "/" + objectName;
            command = "RNMOBJ OBJ(" + originalName + ") OBJTYPE(" + objectType + ") NEWOBJ(" + restoreToName + ")";
            status = this.runCommand(command);
            if (status.getSeverity() == 8) {
                return status;
            }
        }
        if ((status = this.deleteBinaryObject(restoreToLibrary, restoreToName, objectType)).getSeverity() == 8) {
            this.deleteBinaryObject(savfLibName, restoreToName, objectType);
            return status;
        }
        command = "MOVOBJ OBJ(" + savfLibName + "/" + restoreToName + ") OBJTYPE(" + objectType + ") TOLIB(" + restoreToLibrary + ") ASPDEV(*SYSBAS) TOASPDEV(*ASPDEV)";
        status = this.runCommand(command);
        if (status.getSeverity() == 8) {
            command = "RSTOBJ OBJ(" + objectName + ") SAVLIB(" + objectLibrary + ") RSTLIB(" + restoreToLibrary + ") DEV(*SAVF) OBJTYPE(" + objectType + ") SAVF(" + tempSavfFullName + ")" + aspDevParam;
            status = this.runCommand(command);
        }
        return status;
    }

    private IStatus runCommand(String command) {
        this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
        CommandCall cmd = new CommandCall(this.as400, command);
        cmd.setMessageOption(2);
        try {
            boolean cmdRunResult = cmd.run();
            this.printMessageList(cmd);
            if (cmdRunResult) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            this.printMessage(e.getMessage());
            return Status.CANCEL_STATUS;
        }
    }

    private IStatus deleteBinaryObject(String libraryName, String objName, String objType) {
        if (!FileSystemIUtil.isHostObjectExist(libraryName, objName, objType, null, this.as400)) {
            return Status.OK_STATUS;
        }
        String type = objType;
        if (type.startsWith("*")) {
            type = type.substring(1);
        }
        String deleteCommand = "DLT" + type;
        if ("*FILE".equals(objType)) {
            deleteCommand = "DLTF";
        } else if ("*MODULE".equals(objType)) {
            deleteCommand = "DLTMOD";
        } else if ("*MENU".equals(objType)) {
            deleteCommand = "DLTMNU";
        }
        deleteCommand = String.valueOf(deleteCommand) + "  " + libraryName + "/" + objName;
        IStatus status = this.runCommand(deleteCommand);
        return status;
    }

    private void printMessage(String msg) {
        if (this.writer != null) {
            this.writer.println(this.formatMessage(msg));
            this.writer.flush();
            return;
        }
        System.out.println(this.formatMessage(msg));
        System.out.flush();
    }

    private String formatMessage(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date(System.currentTimeMillis()));
        return NLS.bind((String)Messages.LogPrefix, (Object)timestamp, (Object)message);
    }

    private void printMessageList(CommandCall cmd) {
        AS400Message[] messageList = cmd.getMessageList();
        String[] errorMessages = new String[messageList.length];
        int i = 0;
        AS400Message[] aS400MessageArray = messageList;
        int n = messageList.length;
        int n2 = 0;
        while (n2 < n) {
            AS400Message msg = aS400MessageArray[n2];
            errorMessages[i++] = msg.getText();
            this.displayAS400Message(msg, this.as400, true);
            ++n2;
        }
    }

    public void displayAS400Message(AS400Message as400Message, AS400 as400, boolean withHelp) {
        try {
            as400Message.load();
        }
        catch (Exception e) {
            this.printMessage("Error when loading AS400Message. " + e.toString());
        }
        String msgId = as400Message.getID();
        String msgText = as400Message.getText();
        byte[] subData = as400Message.getSubstitutionData();
        int severity = as400Message.getSeverity();
        String help = "";
        if (msgText.length() == 0 && msgId.trim().length() == 0 && subData != null && subData.length > 0) {
            ISeriesCodepageConverter converter = new ISeriesCodepageConverter(as400);
            try {
                msgText = converter.convHostBytesToClientString(as400.getCcsid(), subData);
            }
            catch (UnsupportedEncodingException e) {
                this.printMessage(e.toString());
            }
            msgId = "";
        }
        if (msgText.length() == 0 && msgId.trim().length() == 0) {
            this.printMessage("getSystemMessage: Message returned is empty");
        } else {
            if (withHelp) {
                int indexOfProblemChar;
                help = as400Message.getHelp();
                if (msgId != null && msgId.equalsIgnoreCase("CPFAC11") && (indexOfProblemChar = help.indexOf(0)) > -1) {
                    help = String.valueOf(help.substring(0, indexOfProblemChar)) + ' ' + help.substring(indexOfProblemChar + 1);
                }
            }
            String messageOutput = "Host: " + msgId + ": " + msgText;
            if (severity > 30) {
                this.printMessage(messageOutput);
                if (withHelp && !"".equals(help)) {
                    this.printMessage(help);
                }
            } else if (!msgId.equals("CPD4090")) {
                this.printMessage(messageOutput);
                if (withHelp && !"".equals(help)) {
                    this.printMessage(help);
                }
            }
        }
    }

    public void cleanUpExtractedOar() throws TeamRepositoryException {
        try {
            if (!this.ifsManifestFile.delete()) {
                throw new TeamRepositoryException("Failed to cleanup extracted oar file.");
            }
            if (!this.ifsOARFile.delete()) {
                throw new TeamRepositoryException("Failed to cleanup extracted oar file.");
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException("Failed to cleanup extracted oar file.");
        }
    }
}

