/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.operations;

import com.ibm.as400.access.AS400;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.Messages;
import com.ibm.teami.filesystem.client.internal.operations.AcceptIReport;
import com.ibm.teami.filesystem.client.internal.operations.LoadICmd;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class LoadIOperation {
    public static final int LOADED_EVERYTHING = 10;
    public static final int MISSING_I_PROJECT_TO_LIBRARY_MAPPINGS = 20;
    private String uri;
    private String userName;
    private String password;
    private IWorkspaceHandle workspaceHandle;
    private ITeamRepository repository;
    private AS400 as400;
    private boolean clearLibs;
    private AcceptIReport report;
    private PrintWriter writer;
    private Hashtable<String, String> objectLibrariesPerProject;
    private String ccsidMapping;
    private HashMap<String, String> properties;

    public LoadIOperation(ITeamRepository repository, IWorkspaceHandle workspaceHandle, AS400 as400, boolean clearLibs, AcceptIReport report, PrintWriter writer, Hashtable<String, String> objectLibrariesPerProject, String ccsidMapping, HashMap<String, String> properties) {
        this.repository = repository;
        this.workspaceHandle = workspaceHandle;
        this.as400 = as400;
        this.clearLibs = clearLibs;
        this.report = report;
        this.writer = writer;
        this.objectLibrariesPerProject = objectLibrariesPerProject;
        this.ccsidMapping = ccsidMapping;
        this.properties = properties;
    }

    public IStatus run(IProgressMonitor monitor) throws FileSystemStatusException {
        if (this.repository == null) {
            if (this.userName == null) {
                throw new IllegalArgumentException(Messages.RepoUtil_1);
            }
            if (this.password == null) {
                throw new IllegalArgumentException(Messages.RepoUtil_2);
            }
            if (!TeamPlatform.isStarted()) {
                TeamPlatform.startup();
            }
            try {
                this.repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(this.uri);
            }
            catch (IllegalArgumentException e) {
                throw this.createIllegalArgumentException(NLS.bind((String)Messages.RepoUtil_3, (Object)this.uri));
            }
            this.repository.registerLoginHandler(new ITeamRepository.ILoginHandler(){

                public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repository) {
                    return new ITeamRepository.ILoginHandler.ILoginInfo(){

                        public String getPassword() {
                            return LoadIOperation.this.password;
                        }

                        public String getUserId() {
                            return LoadIOperation.this.userName;
                        }
                    };
                }
            });
            try {
                this.repository.login(null);
            }
            catch (TeamRepositoryException e) {
                throw this.createLoginException(NLS.bind((String)Messages.StatusHelper_1, (Object[])new Object[]{this.uri, this.userName, e.getLocalizedMessage()}));
            }
        }
        if (!this.repository.loggedIn()) {
            throw this.createFailureException(Messages.RepoUtil_4);
        }
        new LoadICmd(this.writer, this.ccsidMapping, this.properties).loadWorkspace(this.repository, this.workspaceHandle, this.as400, this.clearLibs, this.report, this.objectLibrariesPerProject, monitor);
        return Status.OK_STATUS;
    }

    private FileSystemStatusException createIllegalArgumentException(String message) {
        return new FileSystemStatusException((IStatus)new Status(4, "com.ibm.teami.filesystem.client", 1, message, null));
    }

    private FileSystemStatusException createLoginException(String message) {
        return new FileSystemStatusException((IStatus)new Status(4, "com.ibm.teami.filesystem.client", 2, message, null));
    }

    private FileSystemStatusException createFailureException(String message) {
        return new FileSystemStatusException((IStatus)new Status(4, "com.ibm.teami.filesystem.client", 3, message, null));
    }
}

