/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.operations;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SequentialFile;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.User;
import com.ibm.etools.iseries.comm.ISeriesRetrieveDatabaseFileDescription;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectLock;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.teami.filesystem.client.internal.ISeriesCodepageConverter;
import com.ibm.teami.filesystem.client.internal.Messages;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiHelperFactory;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSourceFileMetadata;
import com.ibm.teami.filesystem.client.internal.operations.AcceptIReport;
import com.ibm.teami.filesystem.client.internal.operations.BinaryObjectMinimal;
import com.ibm.teami.filesystem.client.internal.operations.ObjectArchiveResourceUtil;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.FileSequenceNumberChecker;
import com.ibm.teami.filesystem.common.util.IBMiProjectResourceNameUtil;
import com.ibm.teami.filesystem.common.util.IIBMiPropertyKeyConstants;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IProjectToLibraryMap;
import com.ibm.teami.scm.common.IProjectToLibraryMapHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.nio.charset.MalformedInputException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LoadICmd {
    private static final boolean DEBUG = true;
    private static boolean TRACING = false;
    private boolean loadPropertyChanges = false;
    private boolean reloadMemberIfMetadataChanges = false;
    private final PrintWriter writer;
    private String ccsidMapping = "";
    private final HashMap<String, String> properties;
    private String[] errorMessages;
    private boolean ignoreDescriptions = false;
    private boolean skipMetaDataWriting = false;
    private static BufferedWriter loadLogWriter = null;
    private static boolean encounteredComponentLoadException = false;
    private static final int SEQ_NUM_MAX = 999999;
    private static final int SEQ_NUM_START = 100;
    private static final int SEQ_NUM_INCREMENT = 100;
    private final HashMap<String, String> srcFilesExistence;
    private final HashMap<String, String> libraryExistence;
    private final HashMap<IFolderHandle, IFolderHandle> ibmiFolderByProject;
    private final HashMap<IFolderHandle, HashMap<String, IFolderHandle>> ibmiFolderBySourcePhysicalFile;
    private final ArrayList<IBMiSourcePhysicalFile> sourcePhysicalFileForPotentialDeletion;
    private final ArrayList<String> membersAdded;

    public LoadICmd(PrintWriter writer, String ccsidMapping, HashMap<String, String> properties) {
        String reloadMemberIfMetadataChangesProperty;
        String loadPropertyChangesProperty;
        String skipMetaDataWritingProperty;
        String tracingProperty;
        this.writer = writer;
        this.ccsidMapping = ccsidMapping;
        this.properties = properties;
        this.srcFilesExistence = new HashMap();
        this.libraryExistence = new HashMap();
        this.ibmiFolderByProject = new HashMap();
        this.ibmiFolderBySourcePhysicalFile = new HashMap();
        this.sourcePhysicalFileForPotentialDeletion = new ArrayList();
        this.membersAdded = new ArrayList();
        String ignoreDescriptionsProperty = properties.get("teamp.build.ignore.description.changes");
        if (ignoreDescriptionsProperty != null) {
            this.ignoreDescriptions = Boolean.parseBoolean(ignoreDescriptionsProperty);
        }
        if ((tracingProperty = properties.get("teamp.build.tracing")) != null) {
            TRACING = Boolean.parseBoolean(tracingProperty);
        }
        if ((skipMetaDataWritingProperty = properties.get("teamp.build.skip.metadata.writing")) != null) {
            this.skipMetaDataWriting = Boolean.parseBoolean(skipMetaDataWritingProperty);
        }
        if ((loadPropertyChangesProperty = properties.get("teamp.build.load.property.changes")) != null) {
            this.loadPropertyChanges = Boolean.parseBoolean(loadPropertyChangesProperty);
        }
        if ((reloadMemberIfMetadataChangesProperty = properties.get("teamp.build.load.metadata.changes")) != null) {
            this.reloadMemberIfMetadataChanges = Boolean.parseBoolean(reloadMemberIfMetadataChangesProperty);
        }
    }

    public List<String> getMembersAdded() {
        return this.membersAdded;
    }

    public List<ChangeRequest> filterChanges(AcceptIReport report, ITeamRepository repo, IWorkspaceConnection wsConn, IWorkspaceManager manager, SubMonitor progress) throws FileSystemStatusException {
        ArrayList<ChangeRequest> cleanedUpChanges = new ArrayList<ChangeRequest>();
        IUpdateReport updateReport = report.getUpdateReport();
        if (updateReport != null) {
            Collection updates = updateReport.updates();
            if (TRACING) {
                this.printMessage("Update Report Contents: ");
            }
            for (IItemUpdateReport itemReport : updates) {
                IComponentHandle newComponentHandle;
                IFileItem state;
                IVersionableHandle newStateHandle = itemReport.getNewCurrentState();
                IVersionableHandle prevStateHandle = itemReport.getPreviousState();
                if (newStateHandle == null) {
                    cleanedUpChanges.add(new ChangeRequest(16, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                    if (!TRACING) continue;
                    try {
                        IComponentHandle prevComponentHandle = itemReport.getPriorComponent();
                        IConfiguration prevConfiguration = wsConn.configuration(prevComponentHandle);
                        if (prevStateHandle instanceof IFileItemHandle) {
                            state = this.getFileItem((IFileItemHandle)prevStateHandle, prevConfiguration, manager.versionableManager(), (IProgressMonitor)progress);
                            this.printMessage(String.valueOf(state.getName()) + " - " + "DELETE");
                            continue;
                        }
                        state = this.getFolder((IFolderHandle)prevStateHandle, prevConfiguration, manager.versionableManager(), (IProgressMonitor)progress);
                        this.printMessage(String.valueOf(state.getName()) + " - " + "DELETE");
                    }
                    catch (TeamRepositoryException e) {
                        this.printStackTrace(e);
                    }
                    continue;
                }
                if (prevStateHandle == null) {
                    cleanedUpChanges.add(new ChangeRequest(1, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                    if (!TRACING) continue;
                    try {
                        newComponentHandle = itemReport.getComponent();
                        IConfiguration newConfiguration = wsConn.configuration(newComponentHandle);
                        if (newStateHandle instanceof IFileItemHandle) {
                            state = this.getFileItem((IFileItemHandle)newStateHandle, newConfiguration, manager.versionableManager(), (IProgressMonitor)progress);
                            this.printMessage(String.valueOf(state.getName()) + " - " + "ADD");
                            continue;
                        }
                        state = this.getFolder((IFolderHandle)newStateHandle, newConfiguration, manager.versionableManager(), (IProgressMonitor)progress);
                        this.printMessage(String.valueOf(state.getName()) + " - " + "ADD");
                    }
                    catch (TeamRepositoryException e) {
                        this.printStackTrace(e);
                    }
                    continue;
                }
                try {
                    IFileItem prevState;
                    IFileItem newState;
                    IConfiguration prevConfiguration;
                    IConfiguration newConfiguration;
                    IComponentHandle prevComponentHandle;
                    if (newStateHandle instanceof IFileItemHandle) {
                        newComponentHandle = itemReport.getComponent();
                        prevComponentHandle = itemReport.getPriorComponent();
                        newConfiguration = wsConn.configuration(newComponentHandle);
                        prevConfiguration = wsConn.configuration(prevComponentHandle);
                        newState = this.getFileItem((IFileItemHandle)newStateHandle, newConfiguration, manager.versionableManager(), (IProgressMonitor)progress);
                        prevState = this.getFileItem((IFileItemHandle)prevStateHandle, prevConfiguration, manager.versionableManager(), (IProgressMonitor)progress);
                        boolean rename = false;
                        boolean modify = false;
                        boolean reparent = false;
                        boolean propertyChange = false;
                        if (!newState.getName().equals(prevState.getName())) {
                            rename = true;
                        }
                        if (!newState.getContent().getHash().equals((Object)prevState.getContent().getHash())) {
                            modify = true;
                        }
                        if (!newState.getParent().getItemId().equals((Object)prevState.getParent().getItemId()) || !newComponentHandle.equals((Object)prevComponentHandle)) {
                            reparent = true;
                        }
                        if (!(rename || modify || reparent || !this.loadPropertyChanges || newState.getUserProperties().equals(prevState.getUserProperties()))) {
                            propertyChange = true;
                        }
                        if (reparent) {
                            cleanedUpChanges.add(new ChangeRequest(8, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                            if (TRACING) {
                                this.printMessage(String.valueOf(prevState.getName()) + " - REPARENT");
                            }
                        } else if (rename && modify) {
                            cleanedUpChanges.add(new ChangeRequest(6, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                            if (TRACING) {
                                this.printMessage(String.valueOf(prevState.getName()) + " - RENAME AND MODIFY");
                            }
                        } else if (rename) {
                            cleanedUpChanges.add(new ChangeRequest(4, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                            if (TRACING) {
                                this.printMessage(String.valueOf(prevState.getName()) + " - RENAME - NEW NAME: " + newState.getName());
                            }
                        } else if (modify) {
                            cleanedUpChanges.add(new ChangeRequest(2, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                            if (TRACING) {
                                this.printMessage(String.valueOf(prevState.getName()) + " - MODIFY");
                            }
                        } else if (propertyChange) {
                            cleanedUpChanges.add(new ChangeRequest(2, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                            if (TRACING) {
                                this.printMessage(String.valueOf(prevState.getName()) + " - PROPERTY CHANGE");
                            }
                        }
                        if (!TRACING || reparent || rename || modify || propertyChange) continue;
                        this.printMessage(String.valueOf(prevState.getName()) + " - LOOKS IDENTICAL TO PREVIOUS STATE NOT LOADING");
                        continue;
                    }
                    if (!(newStateHandle instanceof IFolderHandle)) continue;
                    newComponentHandle = itemReport.getComponent();
                    prevComponentHandle = itemReport.getPriorComponent();
                    newConfiguration = wsConn.configuration(newComponentHandle);
                    prevConfiguration = wsConn.configuration(prevComponentHandle);
                    newState = this.getFolder((IFolderHandle)newStateHandle, newConfiguration, manager.versionableManager(), true, (IProgressMonitor)progress);
                    prevState = this.getFolder((IFolderHandle)prevStateHandle, prevConfiguration, manager.versionableManager(), true, (IProgressMonitor)progress);
                    if (!newState.getParent().getItemId().equals((Object)prevState.getParent().getItemId()) || !newComponentHandle.equals((Object)prevComponentHandle)) {
                        cleanedUpChanges.add(new ChangeRequest(8, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                        if (!TRACING) continue;
                        this.printMessage(String.valueOf(prevState.getName()) + " - REPARENT");
                        continue;
                    }
                    if (!newState.getName().equals(prevState.getName())) {
                        cleanedUpChanges.add(new ChangeRequest(4, new IBMiChange(itemReport.getPreviousState(), itemReport.getNewCurrentState()), itemReport.getComponent()));
                        if (!TRACING) continue;
                        this.printMessage(String.valueOf(prevState.getName()) + " - RENAME - NEW NAME: " + newState.getName());
                        continue;
                    }
                    if (!TRACING) continue;
                    this.printMessage(String.valueOf(prevState.getName()) + " - FOLDER NOT LOADING IF ANY MEMBERS IN IT WILL BE CREATED BY CHANGES FROM THOSE");
                }
                catch (TeamRepositoryException e) {
                    throw this.wrap(e, e.getLocalizedMessage());
                }
            }
        }
        return cleanedUpChanges;
    }

    public void loadWorkspace(ITeamRepository repo, IWorkspaceHandle wsHandle, AS400 as400, boolean clearLibs, AcceptIReport report, Hashtable<String, String> objectLibrariesPerProject, IProgressMonitor monitor) throws FileSystemStatusException {
        boolean encounteredError = false;
        encounteredComponentLoadException = false;
        this.validateSignon(as400);
        if (report == null) {
            this.loadWorkspace(repo, wsHandle, as400, clearLibs, objectLibrariesPerProject, monitor);
        } else {
            IWorkspaceConnection wsConnOriginalContents;
            IWorkspaceConnection wsConn;
            try {
                String loadLogFileLocation = this.properties.get("teamp.build.load.log.file.location");
                if (loadLogFileLocation != null) {
                    File loadLog = new File(loadLogFileLocation);
                    loadLog.delete();
                    loadLogWriter = new BufferedWriter(new FileWriter(loadLog));
                }
            }
            catch (IOException loadLogFileLocation) {
                // empty catch block
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IComponentHandle[] componentHandles = report.getComponentAdds();
            LoadICmd loadICmd = new LoadICmd(this.writer, this.ccsidMapping, this.properties);
            int i = 0;
            while (i < componentHandles.length) {
                try {
                    loadICmd.loadComponent(repo, wsHandle, componentHandles[i], as400, clearLibs, objectLibrariesPerProject, (IProgressMonitor)progress.newChild(10));
                    this.membersAdded.addAll(loadICmd.getMembersAdded());
                }
                catch (Exception e) {
                    if (loadLogWriter != null) {
                        this.printStackTrace(e);
                        encounteredError = true;
                        try {
                            loadLogWriter.write(e.getMessage());
                            loadLogWriter.write("\n");
                        }
                        catch (IOException iOException) {}
                    }
                    throw this.createFailureException(e.getLocalizedMessage(), 3, e);
                }
                ++i;
            }
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            try {
                wsConn = manager.getWorkspaceConnection(wsHandle, (IProgressMonitor)progress.newChild(10));
                wsConnOriginalContents = manager.getWorkspaceConnection((IWorkspaceHandle)report.getOriginalWorkspace(), (IProgressMonitor)progress.newChild(10));
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
            }
            List<ChangeRequest> changes = this.filterChanges(report, repo, wsConn, manager, progress);
            SubMonitor loop1Progress = progress.newChild(80).setWorkRemaining(changes.size() * 1);
            for (ChangeRequest request : changes) {
                try {
                    for (ChangeKind changeKind : request.getChanges()) {
                        IBMiChange change = changeKind.getChange();
                        try {
                            String oldLibrary;
                            boolean isMember;
                            boolean isFileItem;
                            String library;
                            IBMiMemberMetadata memberMetadata;
                            IBMiSourceFileMetadata sourceFileMetadata;
                            IFileItemHandle fileItemHandle;
                            IFolder folder;
                            IBMiLibraryMetadata libraryMetadata;
                            String sourceFileName;
                            IFolderHandle projectHandle;
                            String sourceFileName2;
                            IBMiLibraryMetadata libraryMetadata2;
                            int kind = changeKind.getChangeKind();
                            IComponentHandle componentHandle = request.getComponentHandle();
                            IConfiguration configuration = wsConn.configuration(componentHandle);
                            IConfiguration configurationOriginal = wsConnOriginalContents.configuration(componentHandle);
                            SubMonitor loop2Progress = loop1Progress.newChild(2).setWorkRemaining(changes.size());
                            loop2Progress.worked(1);
                            IVersionableHandle beforeVersionableHandle = change.getBeforeState();
                            IVersionableHandle afterVersionableHandle = change.getAfterState();
                            if (kind == 2) {
                                IFileItem saveFile;
                                IFolderHandle projectHandle2;
                                String library2;
                                this.printMessage(Messages.LoadCmd_101);
                                IFileItemHandle fileItemHandle2 = null;
                                IFileItem fileItem = null;
                                String fileName = null;
                                if (!(afterVersionableHandle instanceof IFileItemHandle)) continue;
                                fileItemHandle2 = (IFileItemHandle)afterVersionableHandle;
                                fileItem = this.getFileItem(fileItemHandle2, configuration, manager.versionableManager(), null);
                                fileName = fileItem.getName();
                                this.printMessage(NLS.bind((String)Messages.LoadCmd_110, (Object)fileName));
                                boolean isMember2 = this.isMember(fileItem, configuration, manager.versionableManager(), null);
                                if (isMember2) {
                                    this.printMessage(Messages.LoadCmd_112);
                                    this.processMemberChange(repo, wsHandle, as400, clearLibs, manager, componentHandle, configuration, fileItemHandle2, fileItem);
                                    continue;
                                }
                                boolean isBinaryObject = this.isBinaryObject(fileItem, configuration, manager.versionableManager(), null);
                                if (isBinaryObject) {
                                    this.printMessage("CRTCI5118I: Processing binary object");
                                    IFileItemHandle binaryFileHandle = fileItemHandle2;
                                    IFileItem binaryFile = fileItem;
                                    IFolderHandle projectHandle3 = binaryFile.getParent();
                                    IFolder folder2 = this.getFolder(projectHandle3, configuration, manager.versionableManager(), null);
                                    String library3 = this.getLibrary(repo, wsHandle, configuration, projectHandle3, null);
                                    library3 = this.getBinaryLibrary(library3, folder2.getName(), objectLibrariesPerProject);
                                    if (library3 == null) continue;
                                    libraryMetadata2 = new IBMiLibraryMetadata(library3, as400);
                                    this.loadBinaryObject(repo, wsHandle, componentHandle, projectHandle3, library3, binaryFileHandle, libraryMetadata2, as400, clearLibs, null);
                                    if (this.skipMetaDataWriting) continue;
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata2, false, null);
                                    continue;
                                }
                                boolean isSaveFile = this.isSaveFile(fileItem, configuration, manager.versionableManager(), monitor);
                                if (isSaveFile) {
                                    this.printMessage("CRTCI5117I: Processing save file");
                                    IFileItemHandle saveFileHandle = fileItemHandle2;
                                    IFileItem saveFile2 = fileItem;
                                    IFolderHandle projectHandle4 = saveFile2.getParent();
                                    String library4 = this.getLibrary(repo, wsHandle, configuration, projectHandle4, null);
                                    if (library4 == null) continue;
                                    libraryMetadata2 = new IBMiLibraryMetadata(library4, as400);
                                    this.loadSaveFile(repo, wsHandle, componentHandle, projectHandle4, library4, saveFileHandle, libraryMetadata2, as400, clearLibs, null);
                                    if (this.skipMetaDataWriting) continue;
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata2, false, null);
                                    continue;
                                }
                                if (this.ignoreDescriptions) continue;
                                boolean isMemberMetadataFile = this.isMemberMetadataFile(fileItem);
                                if (isMemberMetadataFile) {
                                    this.printMessage(Messages.LoadCmd_114);
                                    IFileItemHandle memberHandle = this.getMemberHandleFromMetadataFile(fileItem, configuration, manager.versionableManager(), null);
                                    if (memberHandle == null) continue;
                                    IFileItem member = this.getFileItem(memberHandle, configuration, manager.versionableManager(), null);
                                    IFolderHandle sourceFileHandle = member.getParent();
                                    IFolder sourceFile = this.getFolder(sourceFileHandle, configuration, manager.versionableManager(), null);
                                    IFolderHandle projectHandle5 = sourceFile.getParent();
                                    library2 = this.getLibrary(repo, wsHandle, configuration, projectHandle5, null);
                                    sourceFileName2 = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFile.getName());
                                    if (library2 == null) continue;
                                    IBMiLibraryMetadata libraryMetadata3 = null;
                                    long pfTimestamp = 0L;
                                    IBMiSourceFileMetadata sourceFileMetadata2 = null;
                                    if (!this.skipMetaDataWriting) {
                                        libraryMetadata3 = new IBMiLibraryMetadata(library2, as400);
                                        pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata3.getName(), sourceFileName2, as400);
                                        sourceFileMetadata2 = new IBMiSourceFileMetadata(sourceFileName2, pfTimestamp, libraryMetadata3, null);
                                        libraryMetadata3.addObjectMetadata(sourceFileMetadata2);
                                    }
                                    boolean updateTextDescriptionOnly = !this.reloadMemberIfMetadataChanges;
                                    IBMiMemberMetadata memberMetadata2 = this.loadMember(repo, wsHandle, componentHandle, projectHandle5, library2, sourceFileHandle, sourceFile, memberHandle, as400, sourceFileMetadata2, clearLibs, updateTextDescriptionOnly, false, null, null);
                                    if (this.skipMetaDataWriting) continue;
                                    if (memberMetadata2 != null) {
                                        pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata3.getName(), sourceFileName2, as400);
                                        sourceFileMetadata2.setIbmiMetadataLastModification(pfTimestamp);
                                        sourceFileMetadata2.addMemberMetadata(memberMetadata2);
                                    }
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveMember(memberMetadata2, pfTimestamp, -2L, null);
                                    continue;
                                }
                                boolean isSourceFileMetadataFile = this.isSourceFileMetadataFile(fileItem);
                                if (isSourceFileMetadataFile) {
                                    this.printMessage(Messages.LoadCmd_115);
                                    IFolderHandle sourceFileHandle = this.getSourceFileHandleFromMetadataFile(fileItem, configuration, manager.versionableManager(), null);
                                    if (sourceFileHandle == null) continue;
                                    IFolder sourceFile = this.getFolder(sourceFileHandle, configuration, manager.versionableManager(), null);
                                    projectHandle = sourceFile.getParent();
                                    String library5 = this.getLibrary(repo, wsHandle, configuration, projectHandle, null);
                                    sourceFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFile.getName());
                                    if (library5 == null) continue;
                                    libraryMetadata = null;
                                    if (!this.skipMetaDataWriting) {
                                        libraryMetadata = new IBMiLibraryMetadata(library5, as400);
                                        long pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata.getName(), sourceFileName, as400);
                                        IBMiSourceFileMetadata sourceFileMetadata3 = new IBMiSourceFileMetadata(sourceFileName, pfTimestamp, libraryMetadata, null);
                                        libraryMetadata.addObjectMetadata(sourceFileMetadata3);
                                    }
                                    this.loadSourceFile(repo, wsHandle, componentHandle, projectHandle, library5, sourceFileHandle, libraryMetadata, as400, clearLibs, false, null);
                                    if (this.skipMetaDataWriting) continue;
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata, false, null);
                                    continue;
                                }
                                boolean isSaveFileMetadataFile = this.isSaveFileMetadataFile(fileItem);
                                if (!isSaveFileMetadataFile) continue;
                                this.printMessage("CRTCI5119I: Processing save file metadata file");
                                IFileItemHandle saveFileHandle = this.getSaveFileHandleFromMetadataFile(fileItem, configuration, manager.versionableManager(), null);
                                if (saveFileHandle == null || (library2 = this.getLibrary(repo, wsHandle, configuration, projectHandle2 = (saveFile = this.getFileItem(saveFileHandle, configuration, manager.versionableManager(), null)).getParent(), null)) == null) continue;
                                libraryMetadata = new IBMiLibraryMetadata(library2, as400);
                                this.loadSaveFile(repo, wsHandle, componentHandle, projectHandle2, library2, saveFileHandle, libraryMetadata, as400, clearLibs, null);
                                if (this.skipMetaDataWriting) continue;
                                IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata, false, null);
                                continue;
                            }
                            if (kind == 1) {
                                IBMiLibraryMetadata libraryMetadata4;
                                boolean isMember3;
                                this.printMessage(Messages.LoadCmd_102);
                                boolean isFolderHandle = this.isFolderHandle(afterVersionableHandle);
                                if (isFolderHandle) {
                                    boolean isSourceFile;
                                    IFolderHandle folderHandle = null;
                                    folder = null;
                                    String folderName = null;
                                    if (afterVersionableHandle instanceof IFolderHandle) {
                                        folderHandle = (IFolderHandle)afterVersionableHandle;
                                        folder = this.getFolder(folderHandle, configuration, manager.versionableManager(), null);
                                        folderName = folder.getName();
                                        this.printMessage(NLS.bind((String)Messages.LoadCmd_111, (Object)folderName));
                                    }
                                    if (!(isSourceFile = this.isSourceFile(folder, configuration, manager.versionableManager(), null))) continue;
                                    this.printMessage(Messages.LoadCmd_113);
                                    IFolderHandle sourceFileHandle = folderHandle;
                                    IFolder sourceFile = folder;
                                    IFolderHandle projectHandle6 = sourceFile.getParent();
                                    String library6 = this.getLibrary(repo, wsHandle, configuration, projectHandle6, null);
                                    String sourceFileName3 = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFile.getName());
                                    if (library6 == null) continue;
                                    libraryMetadata2 = null;
                                    if (!this.skipMetaDataWriting) {
                                        libraryMetadata2 = new IBMiLibraryMetadata(library6, as400);
                                        long pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata2.getName(), sourceFileName3, as400);
                                        IBMiSourceFileMetadata sourceFileMetadata4 = new IBMiSourceFileMetadata(sourceFileName3, pfTimestamp, libraryMetadata2, null);
                                        libraryMetadata2.addObjectMetadata(sourceFileMetadata4);
                                    }
                                    this.loadSourceFile(repo, wsHandle, componentHandle, projectHandle6, library6, sourceFileHandle, libraryMetadata2, as400, clearLibs, false, null);
                                    if (this.skipMetaDataWriting) continue;
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata2, false, null);
                                    continue;
                                }
                                boolean isFileItem2 = this.isFileItemHandle(afterVersionableHandle);
                                if (!isFileItem2) continue;
                                fileItemHandle = null;
                                IFileItem fileItem = null;
                                String fileName = null;
                                if (afterVersionableHandle instanceof IFileItemHandle) {
                                    fileItemHandle = (IFileItemHandle)afterVersionableHandle;
                                    fileItem = this.getFileItem(fileItemHandle, configuration, manager.versionableManager(), null);
                                    fileName = fileItem.getName();
                                    this.printMessage(NLS.bind((String)Messages.LoadCmd_110, (Object)fileName));
                                }
                                if (isMember3 = this.isMember(fileItem, configuration, manager.versionableManager(), null)) {
                                    this.printMessage(Messages.LoadCmd_112);
                                    IFileItemHandle memberHandle = fileItemHandle;
                                    IFileItem member = fileItem;
                                    IFolderHandle sourceFileHandle = member.getParent();
                                    IFolder sourceFile = this.getFolder(sourceFileHandle, configuration, manager.versionableManager(), null);
                                    projectHandle = sourceFile.getParent();
                                    String library7 = this.getLibrary(repo, wsHandle, configuration, projectHandle, null);
                                    sourceFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFile.getName());
                                    if (library7 == null) continue;
                                    libraryMetadata = null;
                                    long pfTimestamp = 0L;
                                    IBMiSourceFileMetadata sourceFileMetadata5 = null;
                                    if (!this.skipMetaDataWriting) {
                                        libraryMetadata = new IBMiLibraryMetadata(library7, as400);
                                        pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata.getName(), sourceFileName, as400);
                                        sourceFileMetadata5 = new IBMiSourceFileMetadata(sourceFileName, pfTimestamp, libraryMetadata, null);
                                        libraryMetadata.addObjectMetadata(sourceFileMetadata5);
                                    }
                                    IBMiMemberMetadata memberMetadata3 = this.loadMember(repo, wsHandle, componentHandle, projectHandle, library7, sourceFileHandle, memberHandle, as400, sourceFileMetadata5, clearLibs, null);
                                    if (this.skipMetaDataWriting) continue;
                                    if (memberMetadata3 != null) {
                                        pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata.getName(), sourceFileName, as400);
                                        sourceFileMetadata5.setIbmiMetadataLastModification(pfTimestamp);
                                        sourceFileMetadata5.addMemberMetadata(memberMetadata3);
                                    }
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveMember(memberMetadata3, pfTimestamp, -2L, null);
                                    continue;
                                }
                                boolean isBinaryObject = this.isBinaryObject(fileItem, configuration, manager.versionableManager(), null);
                                if (isBinaryObject) {
                                    this.printMessage("CRTCI5118I: Processing binary object");
                                    IFileItemHandle binaryFileHandle = fileItemHandle;
                                    IFileItem binaryFile = fileItem;
                                    IFolderHandle projectHandle7 = binaryFile.getParent();
                                    IFolder folder3 = this.getFolder(projectHandle7, configuration, manager.versionableManager(), null);
                                    String library8 = this.getLibrary(repo, wsHandle, configuration, projectHandle7, null);
                                    library8 = this.getBinaryLibrary(library8, folder3.getName(), objectLibrariesPerProject);
                                    if (library8 == null) continue;
                                    libraryMetadata4 = new IBMiLibraryMetadata(library8, as400);
                                    this.loadBinaryObject(repo, wsHandle, componentHandle, projectHandle7, library8, binaryFileHandle, libraryMetadata4, as400, clearLibs, null);
                                    if (this.skipMetaDataWriting) continue;
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata4, false, null);
                                    continue;
                                }
                                boolean isSaveFile = this.isSaveFile(fileItem, configuration, manager.versionableManager(), monitor);
                                if (isSaveFile) {
                                    this.printMessage("CRTCI5117I: Processing save file");
                                    IFileItemHandle saveFileHandle = fileItemHandle;
                                    IFileItem saveFile = fileItem;
                                    projectHandle = saveFile.getParent();
                                    String library9 = this.getLibrary(repo, wsHandle, configuration, projectHandle, null);
                                    if (library9 == null) continue;
                                    libraryMetadata4 = new IBMiLibraryMetadata(library9, as400);
                                    this.loadSaveFile(repo, wsHandle, componentHandle, projectHandle, library9, saveFileHandle, libraryMetadata4, as400, clearLibs, null);
                                    if (this.skipMetaDataWriting) continue;
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata4, false, null);
                                    continue;
                                }
                                if (this.ignoreDescriptions) continue;
                                boolean isMemberMetadataFile = this.isMemberMetadataFile(fileItem);
                                if (isMemberMetadataFile) {
                                    this.printMessage(Messages.LoadCmd_114);
                                    IFileItemHandle memberHandle = this.getMemberHandleFromMetadataFile(fileItem, configuration, manager.versionableManager(), null);
                                    if (memberHandle == null) continue;
                                    IFileItem member = this.getFileItem(memberHandle, configuration, manager.versionableManager(), null);
                                    IFolderHandle sourceFileHandle = member.getParent();
                                    IFolder sourceFile = this.getFolder(sourceFileHandle, configuration, manager.versionableManager(), null);
                                    IFolderHandle projectHandle8 = sourceFile.getParent();
                                    String library10 = this.getLibrary(repo, wsHandle, configuration, projectHandle8, null);
                                    String sourceFileName4 = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFile.getName());
                                    if (library10 == null) continue;
                                    IBMiLibraryMetadata libraryMetadata5 = null;
                                    long pfTimestamp = 0L;
                                    sourceFileMetadata = null;
                                    if (!this.skipMetaDataWriting) {
                                        libraryMetadata5 = new IBMiLibraryMetadata(library10, as400);
                                        pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata5.getName(), sourceFileName4, as400);
                                        sourceFileMetadata = new IBMiSourceFileMetadata(sourceFileName4, pfTimestamp, libraryMetadata5, null);
                                        libraryMetadata5.addObjectMetadata(sourceFileMetadata);
                                    }
                                    memberMetadata = this.loadMember(repo, wsHandle, componentHandle, projectHandle8, library10, sourceFileHandle, sourceFile, memberHandle, as400, sourceFileMetadata, clearLibs, true, false, null, null);
                                    if (this.skipMetaDataWriting) continue;
                                    if (memberMetadata != null) {
                                        pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata5.getName(), sourceFileName4, as400);
                                        sourceFileMetadata.setIbmiMetadataLastModification(pfTimestamp);
                                        sourceFileMetadata.addMemberMetadata(memberMetadata);
                                    }
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveMember(memberMetadata, pfTimestamp, -2L, null);
                                    continue;
                                }
                                boolean isSourceFileMetadataFile = this.isSourceFileMetadataFile(fileItem);
                                if (!isSourceFileMetadataFile) continue;
                                this.printMessage(Messages.LoadCmd_115);
                                IFolderHandle sourceFileHandle = this.getSourceFileHandleFromMetadataFile(fileItem, configuration, manager.versionableManager(), null);
                                if (sourceFileHandle == null) continue;
                                IFolder sourceFile = this.getFolder(sourceFileHandle, configuration, manager.versionableManager(), null);
                                IFolderHandle projectHandle9 = sourceFile.getParent();
                                String library11 = this.getLibrary(repo, wsHandle, configuration, projectHandle9, null);
                                String sourceFileName5 = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFile.getName());
                                if (library11 == null) continue;
                                IBMiLibraryMetadata libraryMetadata6 = null;
                                if (!this.skipMetaDataWriting) {
                                    libraryMetadata6 = new IBMiLibraryMetadata(library11, as400);
                                    long pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata6.getName(), sourceFileName5, as400);
                                    IBMiSourceFileMetadata sourceFileMetadata6 = new IBMiSourceFileMetadata(sourceFileName5, pfTimestamp, libraryMetadata6, null);
                                    libraryMetadata6.addObjectMetadata(sourceFileMetadata6);
                                }
                                this.loadSourceFile(repo, wsHandle, componentHandle, projectHandle9, library11, sourceFileHandle, libraryMetadata6, as400, clearLibs, false, null);
                                if (this.skipMetaDataWriting) continue;
                                IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata6, false, null);
                                continue;
                            }
                            if (kind == 16) {
                                IAncestorReport ancestorReport;
                                this.printMessage(Messages.LoadCmd_103);
                                boolean isFolderHandle = this.isFolderHandle(beforeVersionableHandle);
                                if (isFolderHandle) {
                                    IAncestorReport sourceFileAncestorReport;
                                    IFolderHandle folderHandle = null;
                                    folder = null;
                                    String folderName = null;
                                    if (beforeVersionableHandle instanceof IFolderHandle) {
                                        folderHandle = (IFolderHandle)beforeVersionableHandle;
                                        folder = this.getFolder(folderHandle, configurationOriginal, manager.versionableManager(), null);
                                        folderName = folder.getName();
                                        this.printMessage(NLS.bind((String)Messages.LoadCmd_111, (Object)folderName));
                                    }
                                    if ((sourceFileAncestorReport = this.isSourceFile2(folder, configurationOriginal, manager.versionableManager(), null)) != null) {
                                        this.printMessage(Messages.LoadCmd_113);
                                        IFolder sourceFile = folder;
                                        IFolderHandle projectHandle10 = sourceFile.getParent();
                                        String library12 = this.getLibraryForDeletedProject(repo, wsHandle, configurationOriginal, projectHandle10, null);
                                        if (library12 == null) continue;
                                        this.deleteSourceFile(library12, sourceFile.getName(), as400, sourceFile, configurationOriginal);
                                        continue;
                                    }
                                    boolean isProject = this.isProject(folder, configuration, manager.versionableManager(), null);
                                    if (!isProject) continue;
                                    this.printMessage(Messages.LoadCmd_115);
                                    IFolderHandle projectHandle11 = folderHandle;
                                    String library13 = this.getLibrary(repo, wsHandle, configuration, projectHandle11, null);
                                    if (library13 == null) continue;
                                    this.clearLibrary(library13, as400);
                                    continue;
                                }
                                boolean isFileItem3 = this.isFileItemHandle(beforeVersionableHandle);
                                if (!isFileItem3) continue;
                                fileItemHandle = null;
                                IFileItem fileItem = null;
                                String fileName = null;
                                if (beforeVersionableHandle instanceof IFileItemHandle) {
                                    fileItemHandle = (IFileItemHandle)beforeVersionableHandle;
                                    fileItem = this.getFileItem(fileItemHandle, configuration, manager.versionableManager(), null);
                                    fileName = fileItem.getName();
                                    this.printMessage(NLS.bind((String)Messages.LoadCmd_110, (Object)fileName));
                                }
                                if ((ancestorReport = this.isDeletedMember(fileItem, configuration, manager.versionableManager(), true, null)) != null) {
                                    this.printMessage(Messages.LoadCmd_112);
                                    INameItemPair projectPair = (INameItemPair)ancestorReport.getNameItemPairs().get(1);
                                    INameItemPair sourceFolderPair = (INameItemPair)ancestorReport.getNameItemPairs().get(2);
                                    IFolderHandle projectHandle12 = (IFolderHandle)projectPair.getItem();
                                    String library14 = this.getLibraryForDeletedProject(repo, wsHandle, configurationOriginal, projectHandle12, null);
                                    String sourceFileName6 = sourceFolderPair.getName();
                                    String memberName = this.getMemberName(fileName);
                                    String memberFilterString = String.valueOf(library14) + "/" + sourceFileName6 + "(" + memberName + ")";
                                    if (library14 != null && !this.membersAdded.contains(memberFilterString)) {
                                        this.removeMember(library14, sourceFileName6, memberName, as400);
                                        continue;
                                    }
                                    this.printMessage(Messages.LoadCmd_MemberDoesNotNeedToBeDeletedInfoMsg);
                                    continue;
                                }
                                boolean isBinaryObject = this.isBinaryObject(fileItem, configuration, manager.versionableManager(), null);
                                if (isBinaryObject) {
                                    this.printMessage("CRTCI5118I: Processing binary object");
                                    IFileItem binaryObjectFile = fileItem;
                                    IFolderHandle projectHandle13 = binaryObjectFile.getParent();
                                    IFolder folder4 = this.getFolder(projectHandle13, configuration, manager.versionableManager(), null);
                                    library = this.getLibrary(repo, wsHandle, configuration, projectHandle13, null);
                                    library = this.getBinaryLibrary(library, folder4.getName(), objectLibrariesPerProject);
                                    BinaryObjectMinimal binaryObject = this.getBinaryObject(fileName);
                                    if (library == null) continue;
                                    this.deleteObject(library, binaryObject.getName(), binaryObject.getType(), binaryObject.getSubtype(), as400);
                                    continue;
                                }
                                boolean isSaveFile = this.isSaveFile(fileItem, configuration, manager.versionableManager(), null);
                                if (!isSaveFile) continue;
                                this.printMessage("CRTCI5117I: Processing save file");
                                IFileItem saveFile = fileItem;
                                IFolderHandle projectHandle14 = saveFile.getParent();
                                library = this.getLibrary(repo, wsHandle, configuration, projectHandle14, null);
                                String saveFileName = this.getSaveFileName(fileName);
                                if (library == null) continue;
                                this.deleteSaveFile(library, saveFileName, as400);
                                continue;
                            }
                            if (kind == 4 || kind == 6) {
                                boolean isMember4;
                                boolean isFileItem4;
                                this.printMessage(Messages.LoadCmd_104);
                                boolean isFolderHandle = this.isFolderHandle(afterVersionableHandle);
                                if (isFolderHandle) {
                                    boolean isSourceFile;
                                    IFolderHandle folderHandle = null;
                                    folder = null;
                                    String folderName = null;
                                    if (afterVersionableHandle instanceof IFolderHandle) {
                                        folderHandle = (IFolderHandle)afterVersionableHandle;
                                        folder = this.getFolder(folderHandle, configuration, manager.versionableManager(), null);
                                        folderName = folder.getName();
                                        this.printMessage(NLS.bind((String)Messages.LoadCmd_111, (Object)folderName));
                                    }
                                    if (isSourceFile = this.isSourceFile(folder, configuration, manager.versionableManager(), null)) {
                                        this.printMessage(Messages.LoadCmd_113);
                                        IFolder sourceFile = folder;
                                        IFolderHandle projectHandle15 = sourceFile.getParent();
                                        String library15 = this.getLibrary(repo, wsHandle, configuration, projectHandle15, null);
                                        String newSourceFileName = sourceFile.getName();
                                        folderHandle = (IFolderHandle)beforeVersionableHandle;
                                        folder = this.getFolder(folderHandle, configuration, manager.versionableManager(), null);
                                        String oldSourceFileName = folder.getName();
                                        if (library15 == null) continue;
                                        this.renameSourceFile(library15, oldSourceFileName, newSourceFileName, as400);
                                        continue;
                                    }
                                }
                                if (!(isFileItem4 = this.isFileItemHandle(afterVersionableHandle))) continue;
                                fileItemHandle = null;
                                IFileItem fileItem = null;
                                String fileName = null;
                                if (afterVersionableHandle instanceof IFileItemHandle) {
                                    fileItemHandle = (IFileItemHandle)afterVersionableHandle;
                                    fileItem = this.getFileItem(fileItemHandle, configuration, manager.versionableManager(), null);
                                    fileName = fileItem.getName();
                                    this.printMessage(NLS.bind((String)Messages.LoadCmd_110, (Object)fileName));
                                }
                                if (isMember4 = this.isMember(fileItem, configuration, manager.versionableManager(), null)) {
                                    this.printMessage(Messages.LoadCmd_112);
                                    IFileItem member = fileItem;
                                    IFolderHandle sourceFileHandle = member.getParent();
                                    IFolder sourceFile = this.getFolder(sourceFileHandle, configuration, manager.versionableManager(), null);
                                    IFolderHandle projectHandle16 = sourceFile.getParent();
                                    library = this.getLibrary(repo, wsHandle, configuration, projectHandle16, null);
                                    String sourceFileName7 = sourceFile.getName();
                                    String newMemberName = this.getMemberName(fileName);
                                    IFileItemHandle oldFileItemHandle = (IFileItemHandle)beforeVersionableHandle;
                                    IFileItem oldFileItem = this.getFileItem(oldFileItemHandle, configuration, manager.versionableManager(), null);
                                    String oldMemberName = this.getMemberName(oldFileItem.getName());
                                    String oldType = this.getMemberType(oldFileItem.getName());
                                    String newType = this.getMemberType(fileName);
                                    if (library == null) continue;
                                    boolean forceLoad = this.renameMember(library, sourceFileName7, oldMemberName, newMemberName, as400);
                                    if (kind != 6 && newType.equals(oldType) && !forceLoad) continue;
                                    this.processMemberChange(repo, wsHandle, as400, clearLibs, manager, componentHandle, configuration, fileItemHandle, fileItem);
                                    continue;
                                }
                                boolean isBinaryObject = this.isBinaryObject(fileItem, configuration, manager.versionableManager(), null);
                                if (isBinaryObject) {
                                    this.printMessage("CRTCI5118I: Processing binary object");
                                    IFileItem binaryObjectFile = fileItem;
                                    IFolderHandle projectHandle17 = binaryObjectFile.getParent();
                                    IFolder folder5 = this.getFolder(projectHandle17, configuration, manager.versionableManager(), null);
                                    library = this.getLibrary(repo, wsHandle, configuration, projectHandle17, null);
                                    library = this.getBinaryLibrary(library, folder5.getName(), objectLibrariesPerProject);
                                    BinaryObjectMinimal boNew = this.getBinaryObject(fileName);
                                    fileItemHandle = (IFileItemHandle)beforeVersionableHandle;
                                    fileItem = this.getFileItem(fileItemHandle, configuration, manager.versionableManager(), null);
                                    BinaryObjectMinimal boOld = this.getBinaryObject(fileItem.getName());
                                    if (library == null) continue;
                                    this.renameObject(library, boOld.getName(), boNew.getName(), boNew.getType(), boNew.getSubtype(), as400);
                                    continue;
                                }
                                boolean isSaveFile = this.isSaveFile(fileItem, configuration, manager.versionableManager(), null);
                                if (!isSaveFile) continue;
                                this.printMessage("CRTCI5117I: Processing save file");
                                IFileItem saveFile = fileItem;
                                IFolderHandle projectHandle18 = saveFile.getParent();
                                library = this.getLibrary(repo, wsHandle, configuration, projectHandle18, null);
                                String newSaveFileName = this.getSaveFileName(fileName);
                                fileItemHandle = (IFileItemHandle)beforeVersionableHandle;
                                fileItem = this.getFileItem(fileItemHandle, configuration, manager.versionableManager(), null);
                                String oldSaveFileName = this.getSaveFileName(fileItem.getName());
                                if (library == null) continue;
                                this.renameSaveFile(library, oldSaveFileName, newSaveFileName, as400);
                                continue;
                            }
                            if (kind != 8 && kind != 10) continue;
                            this.printMessage(Messages.LoadCmd_105);
                            boolean isFolderHandle = this.isFolderHandle(beforeVersionableHandle);
                            if (isFolderHandle) {
                                IAncestorReport sourceFileAncestorReport;
                                IFolderHandle oldFolderHandle = null;
                                IFolder oldFolder = null;
                                IFolderHandle newFolderHandle = null;
                                IFolder newFolder = null;
                                String folderName = null;
                                if (beforeVersionableHandle instanceof IFolderHandle) {
                                    oldFolderHandle = (IFolderHandle)beforeVersionableHandle;
                                    oldFolder = this.getFolder(oldFolderHandle, configuration, manager.versionableManager(), null);
                                    newFolderHandle = (IFolderHandle)afterVersionableHandle;
                                    if (newFolderHandle == null) continue;
                                    newFolder = this.getFolder(newFolderHandle, configuration, manager.versionableManager(), null);
                                    folderName = oldFolder.getName();
                                    this.printMessage(NLS.bind((String)Messages.LoadCmd_111, (Object)folderName));
                                }
                                if ((sourceFileAncestorReport = this.isSourceFile2(oldFolder, configuration, manager.versionableManager(), null)) != null) {
                                    this.printMessage(Messages.LoadCmd_113);
                                    IFolder oldSourceFile = oldFolder;
                                    IFolder newSourceFile = newFolder;
                                    IFolderHandle oldProjectHandle = oldSourceFile.getParent();
                                    String oldLibrary2 = this.getLibraryForDeletedProject(repo, wsHandle, configurationOriginal, oldProjectHandle, null);
                                    IFolderHandle newProjectHandle = newSourceFile.getParent();
                                    String newLibrary = this.getLibrary(repo, wsHandle, configuration, newProjectHandle, null);
                                    sourceFileName2 = IBMiProjectResourceNameUtil.unEscapeFileName((String)oldSourceFile.getName());
                                    if (oldLibrary2 == null) continue;
                                    this.deleteSourceFile(oldLibrary2, sourceFileName2, as400, oldSourceFile, configurationOriginal);
                                    IBMiLibraryMetadata libraryMetadata7 = null;
                                    if (!this.skipMetaDataWriting) {
                                        libraryMetadata7 = new IBMiLibraryMetadata(newLibrary, as400);
                                        long pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata7.getName(), sourceFileName2, as400);
                                        IBMiSourceFileMetadata sourceFileMetadata7 = new IBMiSourceFileMetadata(sourceFileName2, pfTimestamp, libraryMetadata7, null);
                                        libraryMetadata7.addObjectMetadata(sourceFileMetadata7);
                                    }
                                    this.loadSourceFile(repo, wsHandle, componentHandle, newProjectHandle, newLibrary, newFolderHandle, libraryMetadata7, as400, clearLibs, true, null);
                                    if (this.skipMetaDataWriting) continue;
                                    IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata7, false, null);
                                    continue;
                                }
                            }
                            if (!(isFileItem = this.isFileItemHandle(beforeVersionableHandle))) continue;
                            IFileItemHandle oldFileItemHandle = null;
                            IFileItem oldFileItem = null;
                            IFileItemHandle newFileItemHandle = null;
                            IFileItem newFileItem = null;
                            String fileName = null;
                            if (beforeVersionableHandle instanceof IFileItemHandle) {
                                oldFileItemHandle = (IFileItemHandle)beforeVersionableHandle;
                                oldFileItem = this.getFileItem(oldFileItemHandle, configuration, manager.versionableManager(), null);
                                newFileItemHandle = (IFileItemHandle)afterVersionableHandle;
                                if (newFileItemHandle == null) continue;
                                newFileItem = this.getFileItem(newFileItemHandle, configuration, manager.versionableManager(), null);
                                fileName = oldFileItem.getName();
                                this.printMessage(NLS.bind((String)Messages.LoadCmd_110, (Object)fileName));
                            }
                            if (isMember = this.isMember(newFileItem, configuration, manager.versionableManager(), null)) {
                                block80: {
                                    this.printMessage(Messages.LoadCmd_112);
                                    IFileItem oldMember = oldFileItem;
                                    try {
                                        IFolderHandle oldSourceFileHandle = oldMember.getParent();
                                        IFolder oldSourceFile = this.getFolder(oldSourceFileHandle, configurationOriginal, manager.versionableManager(), null);
                                        IFolderHandle oldProjectHandle = oldSourceFile.getParent();
                                        oldLibrary = this.getLibraryForDeletedProject(repo, wsHandle, configurationOriginal, oldProjectHandle, null);
                                        String oldSourceFileName = oldSourceFile.getName();
                                        String memberName = this.getMemberName(fileName);
                                        if (oldLibrary != null) {
                                            this.removeMember(oldLibrary, oldSourceFileName, memberName, as400);
                                        }
                                    }
                                    catch (FileSystemStatusException e) {
                                        if (e.getCause() instanceof ItemNotFoundException) break block80;
                                        throw e;
                                    }
                                }
                                IFileItemHandle newMemberHandle = newFileItemHandle;
                                IFileItem newMember = newFileItem;
                                IFolderHandle newSourceFileHandle = newMember.getParent();
                                IFolder newSourceFile = this.getFolder(newSourceFileHandle, configuration, manager.versionableManager(), null);
                                IFolderHandle newProjectHandle = newSourceFile.getParent();
                                String newLibrary = this.getLibrary(repo, wsHandle, configuration, newProjectHandle, null);
                                String newSourceFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)newSourceFile.getName());
                                if (newLibrary == null) continue;
                                IBMiLibraryMetadata libraryMetadata8 = null;
                                long pfTimestamp = 0L;
                                sourceFileMetadata = null;
                                if (!this.skipMetaDataWriting) {
                                    libraryMetadata8 = new IBMiLibraryMetadata(newLibrary, as400);
                                    pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata8.getName(), newSourceFileName, as400);
                                    sourceFileMetadata = new IBMiSourceFileMetadata(newSourceFileName, pfTimestamp, libraryMetadata8, null);
                                    libraryMetadata8.addObjectMetadata(sourceFileMetadata);
                                }
                                memberMetadata = this.loadMember(repo, wsHandle, componentHandle, newProjectHandle, newLibrary, newSourceFileHandle, newMemberHandle, as400, sourceFileMetadata, clearLibs, null);
                                if (this.skipMetaDataWriting) continue;
                                if (memberMetadata != null) {
                                    pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata8.getName(), newSourceFileName, as400);
                                    sourceFileMetadata.setIbmiMetadataLastModification(pfTimestamp);
                                    sourceFileMetadata.addMemberMetadata(memberMetadata);
                                }
                                IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveMember(memberMetadata, pfTimestamp, -2L, null);
                                continue;
                            }
                            boolean isBinaryObject = this.isBinaryObject(oldFileItem, configuration, manager.versionableManager(), null);
                            if (isBinaryObject) {
                                this.printMessage("CRTCI5118I: Processing binary object");
                                IFileItem oldBinaryObject = oldFileItem;
                                IFolderHandle oldProjectHandle = oldBinaryObject.getParent();
                                IFolder oldProject = this.getFolder(oldProjectHandle, configuration, manager.versionableManager(), null);
                                oldLibrary = this.getLibrary(repo, wsHandle, configuration, oldProjectHandle, null);
                                oldLibrary = this.getBinaryLibrary(oldLibrary, oldProject.getName(), objectLibrariesPerProject);
                                BinaryObjectMinimal bo = this.getBinaryObject(fileName);
                                IFileItemHandle newBinaryObjectHandle = newFileItemHandle;
                                IFileItem newBinaryObject = newFileItem;
                                IFolderHandle newProjectHandle = newBinaryObject.getParent();
                                IFolder newProject = this.getFolder(newProjectHandle, configuration, manager.versionableManager(), null);
                                String newLibrary = this.getLibrary(repo, wsHandle, configuration, newProjectHandle, null);
                                newLibrary = this.getBinaryLibrary(newLibrary, newProject.getName(), objectLibrariesPerProject);
                                this.deleteObject(oldLibrary, bo.getName(), bo.getType(), bo.getSubtype(), as400);
                                IBMiLibraryMetadata libraryMetadata9 = new IBMiLibraryMetadata(newLibrary, as400);
                                this.loadBinaryObject(repo, wsHandle, componentHandle, newProjectHandle, newLibrary, newBinaryObjectHandle, libraryMetadata9, as400, clearLibs, monitor);
                                continue;
                            }
                            boolean isSaveFile = this.isSaveFile(oldFileItem, configuration, manager.versionableManager(), null);
                            if (!isSaveFile) continue;
                            this.printMessage("CRTCI5117I: Processing save file");
                            IFileItem oldSaveFile = oldFileItem;
                            IFolderHandle oldProjectHandle = oldSaveFile.getParent();
                            oldLibrary = this.getLibrary(repo, wsHandle, configuration, oldProjectHandle, null);
                            IFileItemHandle newSaveFileHandle = newFileItemHandle;
                            IFileItem newSaveFile = newFileItem;
                            IFolderHandle newProjectHandle = newSaveFile.getParent();
                            String newLibrary = this.getLibrary(repo, wsHandle, configuration, newProjectHandle, null);
                            String saveFileName = this.getSaveFileName(fileName);
                            if (newLibrary == null) continue;
                            this.deleteSaveFile(oldLibrary, saveFileName, as400);
                            IBMiLibraryMetadata libraryMetadata10 = new IBMiLibraryMetadata(newLibrary, as400);
                            this.loadSaveFile(repo, wsHandle, componentHandle, newProjectHandle, newLibrary, newSaveFileHandle, libraryMetadata10, as400, clearLibs, null);
                            if (this.skipMetaDataWriting) continue;
                            IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata10, false, null);
                        }
                        catch (TeamRepositoryException e) {
                            if (loadLogWriter != null) {
                                this.printStackTrace(e);
                                encounteredError = true;
                                loadLogWriter.write(e.getMessage());
                                loadLogWriter.write("\n");
                                continue;
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            if (loadLogWriter != null) {
                                this.printStackTrace(e);
                                encounteredError = true;
                                loadLogWriter.write(e.getMessage());
                                loadLogWriter.write("\n");
                                continue;
                            }
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    this.performCleanup();
                    try {
                        if (loadLogWriter != null) {
                            loadLogWriter.flush();
                            loadLogWriter.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw this.createFailureException(e.getLocalizedMessage(), 3, e);
                }
            }
        }
        if (this.performCleanup()) {
            encounteredError = true;
        }
        try {
            if (loadLogWriter != null) {
                loadLogWriter.flush();
                loadLogWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loadLogWriter != null && (encounteredComponentLoadException || encounteredError)) {
            throw this.createFailureException(Messages.LoadCmd_OneOrMoreErrorsEncounterErrorMsg, 3, null);
        }
    }

    private boolean performCleanup() {
        boolean errorDetected = this.checkSourcePhysicalFilesForDeletion();
        FileSystemIUtil.clearISeriesListMaps();
        this.srcFilesExistence.clear();
        this.libraryExistence.clear();
        this.ibmiFolderByProject.clear();
        this.ibmiFolderBySourcePhysicalFile.clear();
        this.sourcePhysicalFileForPotentialDeletion.clear();
        this.membersAdded.clear();
        return errorDetected;
    }

    private boolean checkSourcePhysicalFilesForDeletion() {
        boolean errorDetected = false;
        if (this.sourcePhysicalFileForPotentialDeletion.size() > 0) {
            for (IBMiSourcePhysicalFile file : this.sourcePhysicalFileForPotentialDeletion) {
                String library = file.getLibrary();
                String name = file.getName();
                AS400 as400 = file.getAs400();
                try {
                    if (FileSystemIUtil.getHostMember(library, name, "*", as400) == null) {
                        this.deleteSourceFile(library, name, as400);
                        continue;
                    }
                    errorDetected = true;
                    if (loadLogWriter == null) continue;
                    loadLogWriter.write(NLS.bind((String)Messages.LoadCmd_61, (Object)this.getQSYSObjectPath(library, name)));
                    loadLogWriter.write("\n");
                }
                catch (Exception e) {
                    this.printMessage(e.getLocalizedMessage());
                }
            }
        }
        return errorDetected;
    }

    private void processMemberChange(ITeamRepository repo, IWorkspaceHandle wsHandle, AS400 as400, boolean clearLibs, IWorkspaceManager manager, IComponentHandle componentHandle, IConfiguration configuration, IFileItemHandle fileItemHandle, IFileItem fileItem) throws FileSystemStatusException, Exception {
        IFileItemHandle memberHandle = fileItemHandle;
        IFileItem member = fileItem;
        IFolderHandle sourceFileHandle = member.getParent();
        IFolder sourceFile = this.getFolder(sourceFileHandle, configuration, manager.versionableManager(), null);
        IFolderHandle projectHandle = sourceFile.getParent();
        String library = this.getLibrary(repo, wsHandle, configuration, projectHandle, null);
        String sourceFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFile.getName());
        if (library != null) {
            IBMiLibraryMetadata libraryMetadata = null;
            IBMiSourceFileMetadata sourceFileMetadata = null;
            long pfTimestamp = 0L;
            if (!this.skipMetaDataWriting) {
                libraryMetadata = new IBMiLibraryMetadata(library, as400);
                pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata.getName(), sourceFileName, as400);
                sourceFileMetadata = new IBMiSourceFileMetadata(sourceFileName, pfTimestamp, libraryMetadata, null);
                sourceFileMetadata.setIbmiMetadataLastModification(pfTimestamp);
                libraryMetadata.addObjectMetadata(sourceFileMetadata);
            }
            IBMiMemberMetadata memberMetadata = this.loadMember(repo, wsHandle, componentHandle, projectHandle, library, sourceFileHandle, memberHandle, as400, sourceFileMetadata, clearLibs, null);
            if (!this.skipMetaDataWriting) {
                if (memberMetadata != null) {
                    pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(libraryMetadata.getName(), sourceFileName, as400);
                    sourceFileMetadata.setIbmiMetadataLastModification(pfTimestamp);
                    sourceFileMetadata.addMemberMetadata(memberMetadata);
                }
                IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(libraryMetadata, false, null);
                IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveMember(memberMetadata, pfTimestamp, -2L, null);
            }
        }
    }

    protected boolean isFolderHandle(IVersionableHandle versionableHandle) {
        return versionableHandle instanceof IFolderHandle;
    }

    protected boolean isFileItemHandle(IVersionableHandle versionableHandle) {
        return versionableHandle instanceof IFileItemHandle;
    }

    protected IFolderHandle getFolderHandle(IVersionableHandle versionableHandle) {
        return (IFolderHandle)versionableHandle;
    }

    protected IFileItemHandle getFileHandle(IVersionableHandle versionableHandle) {
        return (IFileItemHandle)versionableHandle;
    }

    protected IFolder getFolder(IFolderHandle folderHandle, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        return this.getFolder(folderHandle, configuration, versionableManager, false, monitor);
    }

    protected IFolder getFolder(IFolderHandle folderHandle, IConfiguration configuration, IVersionableManager versionableManager, boolean ignoreFolderNotExist, IProgressMonitor monitor) throws FileSystemStatusException {
        IFolder folder = null;
        try {
            folder = folderHandle.hasStateId() ? (IFolder)versionableManager.fetchCompleteState((IVersionableHandle)folderHandle, monitor) : (IFolder)configuration.fetchCompleteItem((IVersionableHandle)folderHandle, monitor);
        }
        catch (ItemNotFoundException e) {
            if (!ignoreFolderNotExist) {
                throw this.wrap((TeamRepositoryException)((Object)e), e.getLocalizedMessage());
            }
            this.printMessage("Warning: Item not located in repository workspace.  This can happen if you have an addition and removal of a source physical file in the list of changes this build, should build.");
            this.printMessage(e.getLocalizedMessage());
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
        return folder;
    }

    protected IFileItem getFileItem(IFileItemHandle fileItemHandle, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        IFileItem fileItem = null;
        try {
            fileItem = fileItemHandle.hasStateId() ? (IFileItem)versionableManager.fetchCompleteState((IVersionableHandle)fileItemHandle, monitor) : (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, monitor);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
        return fileItem;
    }

    protected boolean isMember(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        return this.isMember(fileItem, configuration, versionableManager, true, monitor);
    }

    protected boolean isMember(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, boolean ignoreParentNotExist, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String name = fileItem.getName();
        if (name.endsWith(".properties") || name.endsWith(".project") || name.endsWith(".oar") || name.endsWith(".jazzignore")) {
            return false;
        }
        if (this.isSaveFile(fileItem, configuration, versionableManager, (IProgressMonitor)progress.newChild(30))) {
            return false;
        }
        IFolderHandle parentFolderHandle = fileItem.getParent();
        IFolder parentFolder = this.getFolder(parentFolderHandle, configuration, versionableManager, ignoreParentNotExist, (IProgressMonitor)progress.newChild(40));
        if (parentFolder == null) {
            return false;
        }
        return this.isSourceFile(parentFolder, configuration, versionableManager, (IProgressMonitor)progress.newChild(30));
    }

    protected IAncestorReport isDeletedMember(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, boolean ignoreParentNotExist, IProgressMonitor monitor) throws FileSystemStatusException, TeamRepositoryException {
        IAncestorReport report;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String name = fileItem.getName();
        if (name.endsWith(".properties") || name.endsWith(".project") || name.endsWith(".oar") || name.endsWith(".jazzignore")) {
            return null;
        }
        if (this.isSaveFile(fileItem, configuration, versionableManager, (IProgressMonitor)progress.newChild(30))) {
            return null;
        }
        ArrayList<IFileItem> fileItemList = new ArrayList<IFileItem>();
        fileItemList.add(fileItem);
        List ancestors = configuration.determineAncestorsInHistory(fileItemList, (IProgressMonitor)progress);
        if (ancestors.size() > 0 && (report = (IAncestorReport)ancestors.get(0)).getNameItemPairs().size() == 4) {
            return report;
        }
        return null;
    }

    protected boolean isBinaryObject(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String name = fileItem.getName();
        if (name.toLowerCase().endsWith(".oar")) {
            IFolderHandle parentFolderHandle = fileItem.getParent();
            IFolder parentFolder = this.getFolder(parentFolderHandle, configuration, versionableManager, true, (IProgressMonitor)progress.newChild(50));
            if (parentFolder == null) {
                return false;
            }
            return this.isProject(parentFolder, configuration, versionableManager, (IProgressMonitor)progress.newChild(50));
        }
        return false;
    }

    protected boolean isSourceFile(IFolder folder, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.isRootFolder(folder, configuration) || this.isMetadataFolder(folder) || this.isSettingsFolder(folder)) {
            return false;
        }
        IFolderHandle parentFolderHandle = folder.getParent();
        IFolder parentFolder = this.getFolder(parentFolderHandle, configuration, versionableManager, true, (IProgressMonitor)progress.newChild(50));
        if (parentFolder == null) {
            return false;
        }
        if (this.isRootFolder(parentFolder, configuration) || this.isMetadataFolder(parentFolder) || this.isSettingsFolder(folder)) {
            return false;
        }
        parentFolderHandle = parentFolder.getParent();
        return this.isRootFolder(parentFolder = this.getFolder(parentFolderHandle, configuration, versionableManager, (IProgressMonitor)progress.newChild(50)), configuration);
    }

    protected IAncestorReport isSourceFile2(IFolder folder, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.isRootFolder(folder, configuration) || this.isMetadataFolder(folder) || this.isSettingsFolder(folder)) {
            return null;
        }
        IAncestorReport ancestorReport = null;
        ArrayList<IFolder> folderList = new ArrayList<IFolder>();
        folderList.add(folder);
        List ancestors = configuration.determineAncestorsInHistory(folderList, (IProgressMonitor)progress);
        if (ancestors.size() > 0) {
            ancestorReport = (IAncestorReport)ancestors.get(0);
            if (ancestorReport.getNameItemPairs().size() == 3) {
                return ancestorReport;
            }
            return null;
        }
        return null;
    }

    protected boolean isSaveFile(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String name = fileItem.getName();
        if (name.toLowerCase().endsWith(".savf")) {
            IFolderHandle parentFolderHandle = fileItem.getParent();
            IFolder parentFolder = this.getFolder(parentFolderHandle, configuration, versionableManager, true, (IProgressMonitor)progress.newChild(50));
            if (parentFolder == null) {
                return false;
            }
            return this.isProject(parentFolder, configuration, versionableManager, (IProgressMonitor)progress.newChild(50));
        }
        return false;
    }

    protected boolean isProject(IFolder folder, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        if (this.isRootFolder(folder, configuration) || this.isMetadataFolder(folder)) {
            return false;
        }
        IFolderHandle parentFolderHandle = folder.getParent();
        IFolder parentFolder = this.getFolder(parentFolderHandle, configuration, versionableManager, true, monitor);
        if (parentFolder == null) {
            return false;
        }
        return this.isRootFolder(parentFolder, configuration);
    }

    protected boolean isRootFolder(IFolder folder, IConfiguration configuration) throws FileSystemStatusException {
        IFolderHandle rootHandle = null;
        try {
            rootHandle = configuration.rootFolderHandle(null);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
        return folder.sameItemId((IItemHandle)rootHandle);
    }

    protected boolean isMetadataFolder(IFolder folder) {
        String name = folder.getName().toLowerCase();
        return name.equals(".ibmi");
    }

    protected boolean isSettingsFolder(IFolder folder) {
        String name = folder.getName().toLowerCase();
        return name.equals(".settings");
    }

    protected boolean isSourceFileMetadataFile(IFileItem fileItem) {
        String name = fileItem.getName().toLowerCase();
        return name.equals(".properties");
    }

    protected boolean isMemberMetadataFile(IFileItem fileItem) {
        return this.isMetadataFileForFileItem(fileItem);
    }

    protected boolean isSaveFileMetadataFile(IFileItem fileItem) {
        return this.isMetadataFileForFileItem(fileItem);
    }

    protected boolean isMetadataFileForFileItem(IFileItem fileItem) {
        String name = fileItem.getName().toLowerCase();
        return name.endsWith(".properties") && !name.equals(".properties");
    }

    protected IFolderHandle getSourceFileHandleFromMetadataFile(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFolderHandle parentHandle = fileItem.getParent();
        IFolder parent = this.getFolder(parentHandle, configuration, versionableManager, true, (IProgressMonitor)progress.newChild(30));
        if (parent == null) {
            return null;
        }
        String sourceFileName = parent.getName();
        parentHandle = parent.getParent();
        if (this.isMetadataFolder(parent = this.getFolder(parentHandle, configuration, versionableManager, (IProgressMonitor)progress.newChild(30)))) {
            parentHandle = parent.getParent();
            parent = this.getFolder(parentHandle, configuration, versionableManager, (IProgressMonitor)progress.newChild(40));
            IVersionableHandle versionableHandle = null;
            try {
                versionableHandle = this.findChildEntry(configuration, parentHandle, sourceFileName);
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, e.getLocalizedMessage());
            }
            if (versionableHandle instanceof IFolderHandle) {
                IFolderHandle sourceFileHandle = (IFolderHandle)versionableHandle;
                return sourceFileHandle;
            }
            return null;
        }
        return null;
    }

    protected IFileItemHandle getMemberHandleFromMetadataFile(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String memberName = this.getMemberNameFromMetadataFileName(fileItem.getName());
        IFolderHandle parentHandle = fileItem.getParent();
        IFolder parent = this.getFolder(parentHandle, configuration, versionableManager, true, (IProgressMonitor)progress.newChild(30));
        if (parent == null) {
            return null;
        }
        String sourceFileName = parent.getName();
        parentHandle = parent.getParent();
        if (this.isMetadataFolder(parent = this.getFolder(parentHandle, configuration, versionableManager, (IProgressMonitor)progress.newChild(30)))) {
            parentHandle = parent.getParent();
            parent = this.getFolder(parentHandle, configuration, versionableManager, (IProgressMonitor)progress.newChild(40));
            IVersionableHandle versionableHandle = null;
            try {
                versionableHandle = this.findChildEntry(configuration, parentHandle, sourceFileName);
                if (versionableHandle instanceof IFolderHandle) {
                    IFolderHandle sourceFileHandle = (IFolderHandle)versionableHandle;
                    if ((versionableHandle = this.findChildEntry(configuration, sourceFileHandle, memberName)) instanceof IFileItemHandle) {
                        IFileItemHandle memberHandle = (IFileItemHandle)versionableHandle;
                        return memberHandle;
                    }
                    return null;
                }
                return null;
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, e.getLocalizedMessage());
            }
        }
        return null;
    }

    protected IFileItemHandle getSaveFileHandleFromMetadataFile(IFileItem fileItem, IConfiguration configuration, IVersionableManager versionableManager, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String saveFileName = this.getSaveFileNameFromMetadataFileName(fileItem.getName());
        IFolderHandle parentHandle = fileItem.getParent();
        IFolder parent = this.getFolder(parentHandle, configuration, versionableManager, (IProgressMonitor)progress.newChild(30));
        if (this.isMetadataFolder(parent)) {
            parentHandle = parent.getParent();
            parent = this.getFolder(parentHandle, configuration, versionableManager, (IProgressMonitor)progress.newChild(40));
            IVersionableHandle versionableHandle = null;
            try {
                versionableHandle = this.findChildEntry(configuration, parentHandle, saveFileName);
                if (versionableHandle instanceof IFileItemHandle) {
                    IFileItemHandle memberHandle = (IFileItemHandle)versionableHandle;
                    return memberHandle;
                }
                return null;
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, e.getLocalizedMessage());
            }
        }
        return null;
    }

    protected String getMemberNameFromMetadataFileName(String metadataFileName) {
        return this.getNameFromMetadataFileName(metadataFileName);
    }

    protected String getSaveFileNameFromMetadataFileName(String metadataFileName) {
        return this.getNameFromMetadataFileName(metadataFileName);
    }

    protected String getNameFromMetadataFileName(String metadataFileName) {
        int index = metadataFileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return metadataFileName.substring(0, index);
    }

    protected String getLibrary(ITeamRepository repo, IWorkspaceHandle wsHandle, IConfiguration configuration, IFolderHandle projectHandle, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            configuration.fetchPartialItem((IVersionableHandle)projectHandle, Collections.singletonList(IFolder.NAME_PROPERTY), monitor);
        }
        catch (ItemNotFoundException e) {
            this.printMessage("Warning: Item not located in repository workspace.  This can happen if you have an addition and removal of an IBM i Project in the list of changes this build, should build.");
            this.printMessage(e.getLocalizedMessage());
            return null;
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
        IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repo.getClientLibrary(IScmIClientLibrary.class);
        String library = null;
        try {
            library = clientLibrary.getLibrary(wsHandle, projectHandle, (IProgressMonitor)progress.newChild(50));
        }
        catch (ItemNotFoundException e) {
            this.printMessage("Warning: Item not located in repository workspace.  This can happen if you have an addition and removal of an IBM i Project in the list of changes this build, should build.");
            this.printMessage(e.getLocalizedMessage());
            return null;
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_72, (Object)this.getFolder(projectHandle, configuration, manager.versionableManager(), null).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()));
        }
        if (library == null) {
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_72, (Object)this.getFolder(projectHandle, configuration, manager.versionableManager(), null).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()), 301, null);
        }
        if ((library = library.trim()).equals("")) {
            return null;
        }
        return library;
    }

    protected String getLibraryForDeletedProject(ITeamRepository repo, IWorkspaceHandle wsHandle, IConfiguration configuration, IFolderHandle projectHandle, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repo.getClientLibrary(IScmIClientLibrary.class);
        String library = null;
        try {
            library = clientLibrary.getLibrary(wsHandle, projectHandle, (IProgressMonitor)progress.newChild(50));
        }
        catch (ItemNotFoundException e) {
            this.printMessage("Warning: Item not located in repository workspace.  This can happen if you have an addition and removal of an IBM i Project in the list of changes this build, should build.");
            this.printMessage(e.getLocalizedMessage());
            return null;
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_72, (Object)this.getFolder(projectHandle, configuration, manager.versionableManager(), null).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()));
        }
        if (library == null) {
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_72, (Object)this.getFolder(projectHandle, configuration, manager.versionableManager(), null).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()), 301, null);
        }
        if ((library = library.trim()).equals("")) {
            return null;
        }
        return library;
    }

    public void loadWorkspace(ITeamRepository repo, IWorkspaceHandle wsHandle, AS400 as400, boolean clearLibs, Hashtable objectLibrariesPerProject, IProgressMonitor monitor) throws FileSystemStatusException {
        IWorkspaceConnection wsConn;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            wsConn = manager.getWorkspaceConnection(wsHandle, (IProgressMonitor)progress.newChild(10));
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
        }
        List componentHandles = null;
        try {
            componentHandles = wsConn.getComponents();
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, Messages.RepoUtil_14);
        }
        if (componentHandles == null) {
            this.printMessage(NLS.bind((String)Messages.LoadCmd_73, (Object)this.getWorkspace(repo, wsHandle).getName()));
            return;
        }
        if (componentHandles.isEmpty()) {
            this.printMessage(NLS.bind((String)Messages.LoadCmd_74, (Object)this.getWorkspace(repo, wsHandle).getName()));
            return;
        }
        boolean projectWithoutMapping = false;
        FileSystemIUtil.checkProgress((IProgressMonitor)progress);
        SubMonitor loopProgress = progress.newChild(90).setWorkRemaining(componentHandles.size());
        for (IComponentHandle coHandle : componentHandles) {
            try {
                this.loadComponent(repo, wsHandle, coHandle, as400, clearLibs, objectLibrariesPerProject, (IProgressMonitor)loopProgress.newChild(1));
            }
            catch (FileSystemStatusException e) {
                if (e.getStatus().getCode() == 201) {
                    if (projectWithoutMapping) continue;
                    projectWithoutMapping = true;
                    continue;
                }
                throw e;
            }
        }
        if (projectWithoutMapping) {
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_70, (Object)this.getWorkspace(repo, wsHandle).getName()), 202, null);
        }
    }

    public void loadComponent(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, AS400 as400, boolean clearLibs, Hashtable objectLibrariesPerProject, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.validateSignon(as400);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection wsConn = null;
        IConfiguration configuration = null;
        try {
            wsConn = manager.getWorkspaceConnection(wsHandle, (IProgressMonitor)progress.newChild(10));
            configuration = wsConn.configuration(coHandle);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
        }
        List<IFolderHandle> projectHandles = null;
        try {
            projectHandles = FileSystemIUtil.getInstance().getIProjects(wsHandle, coHandle, repo, (IProgressMonitor)progress.newChild(10));
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_22, (Object)wsHandle));
        }
        if (projectHandles == null) {
            this.printMessage(NLS.bind((String)Messages.LoadCmd_23, (Object)this.getComponent(repo, coHandle, wsHandle).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()));
            return;
        }
        if (projectHandles.isEmpty()) {
            this.printMessage(NLS.bind((String)Messages.LoadCmd_24, (Object)this.getComponent(repo, coHandle, wsHandle).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()));
            return;
        }
        IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repo.getClientLibrary(IScmIClientLibrary.class);
        IWorkspaceIHandle workspaceIHandle = null;
        try {
            workspaceIHandle = clientLibrary.getWorkspaceI(wsHandle, (IProgressMonitor)progress.newChild(10));
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_20, (Object)wsHandle));
        }
        if (workspaceIHandle == null) {
            this.printMessageForPreviousProjectOrNoProjectLibraryMappings(projectHandles, configuration, manager.versionableManager());
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_69, (Object)this.getComponent(repo, coHandle, wsHandle).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()), 201, null);
        }
        List mappingHandles = null;
        try {
            mappingHandles = clientLibrary.getProjectToLibraryMappings(workspaceIHandle, projectHandles, (IProgressMonitor)progress.newChild(10));
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_25, (Object)wsHandle));
        }
        if (mappingHandles == null) {
            this.printMessageForPreviousProjectOrNoProjectLibraryMappings(projectHandles, configuration, manager.versionableManager());
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_26, (Object)this.getComponent(repo, coHandle, wsHandle).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()), 201, null);
        }
        if (mappingHandles.isEmpty()) {
            this.printMessageForPreviousProjectOrNoProjectLibraryMappings(projectHandles, configuration, manager.versionableManager());
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_27, (Object)this.getComponent(repo, coHandle, wsHandle).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()), 201, null);
        }
        boolean projectWithoutMapping = false;
        SubMonitor loopProgress = progress.newChild(60).setWorkRemaining(mappingHandles.size() * 100);
        for (IProjectToLibraryMapHandle mapHandle : mappingHandles) {
            IProjectToLibraryMap temp = null;
            try {
                temp = (IProjectToLibraryMap)repo.itemManager().fetchCompleteItem((IItemHandle)mapHandle, 1, (IProgressMonitor)loopProgress.newChild(50));
            }
            catch (TeamRepositoryException e) {
                this.printStackTrace(e);
            }
            IFolderHandle projectHandle = temp.getFolder();
            String library = temp.getLibrary();
            boolean isPreviousProject = false;
            try {
                isPreviousProject = FileSystemIUtil.getInstance().isUsingOldPropertiesModel(projectHandle, configuration);
            }
            catch (TeamRepositoryException e) {
                this.printProjectErrorMessage(Messages.LoadCmd_34, projectHandle, configuration, manager.versionableManager());
                continue;
            }
            if (isPreviousProject) {
                this.printProjectErrorMessage(Messages.LoadCmd_33, projectHandle, configuration, manager.versionableManager());
                projectHandles = FileSystemIUtil.getInstance().removeProjectHandle(projectHandle, projectHandles);
                continue;
            }
            if (library == null || library.equals("")) {
                this.printMessageForNoProjectLibraryMapping(projectHandle, configuration, manager.versionableManager());
                if (projectWithoutMapping) continue;
                projectWithoutMapping = true;
                continue;
            }
            if (!(library = library.trim()).equals("")) {
                try {
                    this.loadProject(repo, wsHandle, coHandle, projectHandle, library, as400, clearLibs, objectLibrariesPerProject, (IProgressMonitor)loopProgress.newChild(50));
                    projectHandles = FileSystemIUtil.getInstance().removeProjectHandle(projectHandle, projectHandles);
                    continue;
                }
                catch (Exception e) {
                    if (loadLogWriter != null) {
                        this.printStackTrace(e);
                        encounteredComponentLoadException = true;
                        try {
                            loadLogWriter.write(e.getMessage());
                            loadLogWriter.write("\n");
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    throw this.createFailureException(e.getLocalizedMessage(), 3, e);
                }
            }
            this.printMessageForNoProjectLibraryMapping(projectHandle, configuration, manager.versionableManager());
            if (projectWithoutMapping) continue;
            projectWithoutMapping = true;
        }
        boolean result = this.printMessageForPreviousProjectOrNoProjectLibraryMappings(projectHandles, configuration, manager.versionableManager());
        if (result || projectWithoutMapping) {
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_71, (Object)this.getComponent(repo, coHandle, wsHandle).getName(), (Object)this.getWorkspace(repo, wsHandle).getName()), 201, null);
        }
    }

    protected boolean printMessageForPreviousProjectOrNoProjectLibraryMappings(List<IFolderHandle> projectHandles, IConfiguration configuration, IVersionableManager versionableManager) throws FileSystemStatusException {
        boolean projectWithoutMapping = false;
        if (projectHandles.size() > 0) {
            boolean isPreviousProject = false;
            for (IFolderHandle projectHandle : projectHandles) {
                try {
                    isPreviousProject = FileSystemIUtil.getInstance().isUsingOldPropertiesModel(projectHandle, configuration);
                }
                catch (TeamRepositoryException e) {
                    this.printProjectErrorMessage(Messages.LoadCmd_34, projectHandle, configuration, versionableManager);
                    continue;
                }
                if (isPreviousProject) {
                    this.printProjectErrorMessage(Messages.LoadCmd_33, projectHandle, configuration, versionableManager);
                    continue;
                }
                this.printMessageForNoProjectLibraryMapping(projectHandle, configuration, versionableManager);
                if (projectWithoutMapping) continue;
                projectWithoutMapping = true;
            }
        }
        return projectWithoutMapping;
    }

    protected void printMessageForNoProjectLibraryMapping(IFolderHandle projectHandle, IConfiguration configuration, IVersionableManager versionableManager) throws FileSystemStatusException {
        IFolder folder = this.getFolder(projectHandle, configuration, versionableManager, null);
        String name = folder.getName();
        this.printMessage(NLS.bind((String)Messages.LoadCmd_28, (Object)name));
    }

    protected void printProjectErrorMessage(String errorMessage, IFolderHandle projectHandle, IConfiguration configuration, IVersionableManager versionableManager) throws FileSystemStatusException {
        IFolder folder = this.getFolder(projectHandle, configuration, versionableManager, null);
        String name = folder.getName();
        this.printMessage(NLS.bind((String)errorMessage, (Object)name));
    }

    protected IWorkspace getWorkspace(ITeamRepository repo, IWorkspaceHandle wsHandle) throws FileSystemStatusException {
        try {
            return (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)wsHandle, 1, null);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_67, (Object)wsHandle));
        }
    }

    protected IComponent getComponent(ITeamRepository repo, IComponentHandle coHandle, IWorkspaceHandle wsHandle) throws FileSystemStatusException {
        try {
            return (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)coHandle, 1, null);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_68, (Object)coHandle, (Object)wsHandle));
        }
    }

    public void loadProject(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libSelector, AS400 as400, boolean clearLibs, Hashtable objectLibrariesPerProject, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.validateSignon(as400);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IConfiguration configuration = null;
        try {
            IWorkspaceConnection wsConn = manager.getWorkspaceConnection(wsHandle, (IProgressMonitor)progress.newChild(10));
            configuration = wsConn.configuration(coHandle);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
        }
        Map<String, IVersionableHandle> folders = null;
        String command = null;
        CommandCall cmd = null;
        boolean cmdRunResult = true;
        boolean createdLibrary = false;
        FileSystemIUtil.checkProgress((IProgressMonitor)progress);
        try {
            boolean isLibraryExists = false;
            if (!this.libraryExistence.containsKey(libSelector)) {
                isLibraryExists = FileSystemIUtil.isHostLibraryExist(libSelector, as400);
                String libSelectorOld = libSelector;
                if (!isLibraryExists) {
                    command = "CRTLIB " + libSelector + " ASPDEV(*SYSTEM)";
                    this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
                    cmd = new CommandCall(as400, command);
                    cmdRunResult = cmd.run();
                    if (cmdRunResult) {
                        isLibraryExists = true;
                        createdLibrary = true;
                        libSelector = FileSystemIUtil.getInstance().getLibraryName(as400, libSelector);
                    } else {
                        this.printMessageList(cmd);
                        throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_5, (Object)libSelector), 76, null);
                    }
                }
                this.libraryExistence.put(libSelectorOld, libSelector);
            } else {
                libSelector = this.libraryExistence.get(libSelector);
            }
            if (clearLibs && !isLibraryExists) {
                command = "CLRLIB " + libSelector;
                this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
                cmd = new CommandCall(as400, command);
                cmdRunResult = cmd.run();
                if (!cmdRunResult) {
                    this.printMessageList(cmd);
                    throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_6, (Object)libSelector), 76, null);
                }
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        progress.worked(10);
        IFolder projFolder = this.getFolder(iPrjHandle, configuration, manager.versionableManager(), null);
        String projectName = projFolder.getName();
        String binaryLibrary = this.getBinaryLibrary(libSelector, projectName, objectLibrariesPerProject);
        try {
            folders = this.findAllChildrenEntry(configuration, iPrjHandle, (IProgressMonitor)progress.newChild(10));
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
        SubMonitor loopProgress = progress.newChild(60).setWorkRemaining(folders.size() * 100);
        IBMiLibraryMetadata library = new IBMiLibraryMetadata(libSelector, as400);
        for (String folderName : folders.keySet()) {
            IVersionableHandle versionableHandle = folders.get(folderName);
            try {
                if (versionableHandle instanceof IFolderHandle) {
                    IBMiSourceFileMetadata physicalFile = this.loadSourceFile(repo, wsHandle, coHandle, iPrjHandle, libSelector, (IFolderHandle)versionableHandle, library, as400, clearLibs, true, createdLibrary, (IProgressMonitor)loopProgress.newChild(100));
                    if (physicalFile == null) continue;
                    library.addObjectMetadata(physicalFile);
                    continue;
                }
                if (!(versionableHandle instanceof IFileItemHandle)) continue;
                IFileItemHandle fileItemHandle = (IFileItemHandle)versionableHandle;
                IFileItem fileItem = this.getFileItem(fileItemHandle, configuration, manager.versionableManager(), (IProgressMonitor)loopProgress.newChild(50));
                if (this.isSaveFile(fileItem, configuration, manager.versionableManager(), null)) {
                    IBMiSaveFileMetadata saveFile = this.loadSaveFile(repo, wsHandle, coHandle, iPrjHandle, libSelector, fileItemHandle, library, as400, false, (IProgressMonitor)loopProgress.newChild(50));
                    if (saveFile == null) continue;
                    library.addObjectMetadata(saveFile);
                    continue;
                }
                if (!this.isBinaryObject(fileItem, configuration, manager.versionableManager(), null)) continue;
                this.loadBinaryObject(repo, wsHandle, coHandle, iPrjHandle, binaryLibrary, fileItemHandle, library, as400, clearLibs, (IProgressMonitor)loopProgress.newChild(50));
            }
            catch (Exception e) {
                if (loadLogWriter != null) {
                    this.printStackTrace(e);
                    encounteredComponentLoadException = true;
                    try {
                        loadLogWriter.write(e.getMessage());
                        loadLogWriter.write("\n");
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                throw this.createFailureException(e.getLocalizedMessage(), 3, e);
            }
        }
        try {
            if (!this.skipMetaDataWriting) {
                IBMiHelperFactory.instance().getIFSMetadataWriter(as400).saveLibrary(library, clearLibs, (IProgressMonitor)progress.newChild(10));
            }
        }
        catch (Exception e) {
            this.createFailureException(e.getLocalizedMessage(), 3, e);
        }
    }

    public IBMiSourceFileMetadata loadSourceFile(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libSelector, IFolderHandle iSrcFileHandle, IBMiLibraryMetadata library, AS400 as400, boolean clearLibs, boolean loadMembers, IProgressMonitor monitor) throws FileSystemStatusException {
        return this.loadSourceFile(repo, wsHandle, coHandle, iPrjHandle, libSelector, iSrcFileHandle, library, as400, clearLibs, loadMembers, false, monitor);
    }

    public IBMiSourceFileMetadata loadSourceFile(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libSelector, IFolderHandle iSrcFileHandle, IBMiLibraryMetadata library, AS400 as400, boolean clearLibs, boolean loadMembers, boolean libraryCreated, IProgressMonitor monitor) throws FileSystemStatusException {
        IFolder folder;
        IConfiguration configuration;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.validateSignon(as400);
        try {
            if (libraryCreated) {
                libSelector = this.libraryExistence.get(libSelector);
            } else if (!this.libraryExistence.containsKey(libSelector)) {
                String libSelectorOld = libSelector;
                libSelector = FileSystemIUtil.isHostLibraryExist(libSelector, as400) ? FileSystemIUtil.getInstance().getLibraryName(as400, libSelector) : this.createLibrary(libSelector, as400);
                this.libraryExistence.put(libSelectorOld, libSelector);
            } else {
                libSelector = this.libraryExistence.get(libSelector);
            }
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            IWorkspaceConnection wsConn = manager.getWorkspaceConnection(wsHandle, (IProgressMonitor)progress.newChild(10));
            configuration = wsConn.configuration(coHandle);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
        }
        try {
            folder = (IFolder)configuration.fetchPartialItem((IVersionableHandle)iSrcFileHandle, Collections.singletonList(IFolder.NAME_PROPERTY), monitor);
        }
        catch (ItemNotFoundException e) {
            this.printMessage("Warning: Item not located in repository workspace.  This can happen if you have an addition and removal of a source physical file in the list of changes this build, should build.");
            this.printMessage(e.getLocalizedMessage());
            return null;
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
        Map<String, IVersionableHandle> files = null;
        String folderName = IBMiProjectResourceNameUtil.unEscapeFileName((String)folder.getName());
        if (FileSystemIUtil.isHiddenFolder(folderName)) {
            return null;
        }
        FileSystemIUtil.checkProgress((IProgressMonitor)progress);
        IBMiSourceFileMetadata physicalFile = new IBMiSourceFileMetadata(folderName, -1L, library, null);
        String command = null;
        CommandCall cmd = null;
        boolean cmdRunResult = true;
        boolean createdSourceFile = false;
        String recordLength = null;
        try {
            SourceFileMetadataProperties metadataProperties = this.getSourceFileMetadataProperties(configuration, iPrjHandle, folder.getName());
            Attributes attributes = new Attributes(metadataProperties.getTimestamp());
            physicalFile.setAttributes(attributes);
            String ccsid = metadataProperties.getCcsid();
            String textDescription = metadataProperties.getTextDescription();
            textDescription = FileSystemIUtil.getInstance().massageTextDescription(textDescription);
            recordLength = metadataProperties.getRecordLength();
            boolean isSourceFileExists = false;
            if (!libraryCreated) {
                isSourceFileExists = !this.srcFilesExistence.containsKey(String.valueOf(libSelector) + "/" + folderName) ? FileSystemIUtil.isHostObjectExist(libSelector, folderName, "*FILE", "PF-SRC", as400) : true;
            }
            if (!isSourceFileExists) {
                String igcData = metadataProperties.getIgcData();
                command = "CRTSRCPF FILE(" + libSelector + "/" + folderName + ") CCSID(" + ccsid + ") RCDLEN(" + recordLength + ") IGCDTA(" + igcData + ") TEXT('" + textDescription + "')";
                createdSourceFile = true;
            } else {
                command = "CHGSRCPF FILE(" + libSelector + "/" + folderName + ") TEXT('" + textDescription + "')";
            }
            this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
            cmd = new CommandCall(as400, command);
            cmdRunResult = cmd.run();
            this.srcFilesExistence.put(String.valueOf(libSelector) + "/" + folderName, folderName);
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_7, (Object)this.getQSYSObjectPath(libSelector, folderName)), 76, null);
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        catch (TeamRepositoryException e) {
            this.printStackTrace(e);
            throw this.wrap(e, e.getLocalizedMessage());
        }
        progress.worked(10);
        if (loadMembers) {
            try {
                files = this.findAllChildrenEntry(configuration, iSrcFileHandle, (IProgressMonitor)progress.newChild(10));
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, e.getLocalizedMessage());
            }
            SubMonitor loopProgress = progress.newChild(60).setWorkRemaining(files.size());
            for (String name : files.keySet()) {
                IVersionableHandle fileHandle = files.get(name);
                try {
                    IBMiMemberMetadata member;
                    if (fileHandle == null || !(fileHandle instanceof IFileItemHandle) || (member = this.loadMember(repo, wsHandle, coHandle, iPrjHandle, libSelector, iSrcFileHandle, folder, (IFileItemHandle)fileHandle, as400, physicalFile, clearLibs, false, createdSourceFile, recordLength, (IProgressMonitor)loopProgress.newChild(1))) == null) continue;
                    physicalFile.addMemberMetadata(member);
                }
                catch (Exception e) {
                    if (loadLogWriter != null) {
                        this.printStackTrace(e);
                        encounteredComponentLoadException = true;
                        try {
                            loadLogWriter.write(e.getMessage());
                            loadLogWriter.write("\n");
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    throw this.createFailureException(e.getLocalizedMessage(), 3, e);
                }
            }
        }
        try {
            if (!this.skipMetaDataWriting) {
                long pfTimestamp = FileSystemIUtil.getHostSourceFileTimestamp(library.getName(), folderName, as400);
                physicalFile.setIbmiMetadataLastModification(pfTimestamp);
            }
        }
        catch (Exception e) {
            throw this.createFailureException("", 3, e);
        }
        return physicalFile;
    }

    public IBMiMemberMetadata loadMember(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libSelector, IFolderHandle iSrcFileHandle, IFolder srcFile, IFileItemHandle mbrHandle, AS400 as400, IBMiSourceFileMetadata physicalFile, boolean clearLibs, boolean updateTextDescriptionOnly, boolean createdSourceFile, String recordLengthFromIBMiMetadata, IProgressMonitor monitor) throws FileSystemStatusException {
        boolean justCreatedMember;
        boolean isMemberExists;
        String textDescription;
        String encoding;
        LineNumberReader lineReader;
        InputStreamReader reader;
        BufferedInputStream bufStream;
        boolean cmdRunResult;
        CommandCall cmd;
        String command;
        SequentialFile seqFile;
        String sourceType;
        String memberName;
        String fileName;
        String srcFileName;
        IFileContent remoteContent;
        IFileItem metadataFile;
        IFileItem file;
        SubMonitor progress;
        block95: {
            int propertyRecordLength;
            IWorkspaceConnection wsConn;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.validateSignon(as400);
            try {
                if (createdSourceFile) {
                    libSelector = this.libraryExistence.get(libSelector);
                } else if (!this.libraryExistence.containsKey(libSelector)) {
                    String libSelectorOld = libSelector;
                    libSelector = FileSystemIUtil.isHostLibraryExist(libSelector, as400) ? FileSystemIUtil.getInstance().getLibraryName(as400, libSelector) : this.createLibrary(libSelector, as400);
                    this.libraryExistence.put(libSelectorOld, libSelector);
                } else {
                    libSelector = this.libraryExistence.get(libSelector);
                }
            }
            catch (Exception e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 54, e);
            }
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            try {
                wsConn = manager.getWorkspaceConnection(wsHandle, (IProgressMonitor)progress.newChild(10));
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
            }
            file = null;
            metadataFile = null;
            IConfiguration configuration = null;
            try {
                configuration = wsConn.configuration(coHandle);
                file = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)mbrHandle, (IProgressMonitor)progress.newChild(10));
            }
            catch (ItemNotFoundException e) {
                this.printMessage(Messages.LoadCmd_AddModifyDeleteWarning);
                this.printMessage(e.getLocalizedMessage());
                return null;
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, e.getLocalizedMessage());
            }
            if (this.ignoreFile(file.getName())) {
                return null;
            }
            if (srcFile == null) {
                try {
                    srcFile = (IFolder)configuration.fetchPartialItem((IVersionableHandle)iSrcFileHandle, Collections.singletonList(IFolder.NAME_PROPERTY), monitor);
                }
                catch (ItemNotFoundException e) {
                    this.printMessage("Warning: Item not located in repository workspace.  This can happen if you have an addition and removal of a source physical file in the list of changes this build, should build.");
                    this.printMessage(e.getLocalizedMessage());
                    return null;
                }
                catch (TeamRepositoryException e) {
                    throw this.wrap(e, e.getLocalizedMessage());
                }
            }
            remoteContent = file.getContent();
            srcFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)srcFile.getName());
            if (createdSourceFile) {
                srcFileName = this.srcFilesExistence.get(String.valueOf(libSelector) + "/" + srcFileName);
            } else if (!this.srcFilesExistence.containsKey(String.valueOf(libSelector) + "/" + srcFileName)) {
                if (!FileSystemIUtil.isHostObjectExist(libSelector, srcFileName, "*FILE", "PF-SRC", as400)) {
                    srcFileName = this.createSourceFile(wsConn, coHandle, iPrjHandle, libSelector, srcFile.getName(), as400);
                }
                this.srcFilesExistence.put(String.valueOf(libSelector) + "/" + srcFileName, srcFileName);
            } else {
                srcFileName = this.srcFilesExistence.get(String.valueOf(libSelector) + "/" + srcFileName);
            }
            fileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)file.getName());
            memberName = this.getMemberName(fileName);
            sourceType = this.getMemberExtension(fileName);
            String contentType = file.getContentType();
            boolean contentTypeText = contentType.equalsIgnoreCase("text/plain");
            if (!contentTypeText) {
                this.printMessage(NLS.bind((String)Messages.LoadCmd_56, (Object)memberName, (Object)srcFileName));
            }
            seqFile = null;
            command = null;
            cmd = null;
            cmdRunResult = true;
            bufStream = null;
            reader = null;
            lineReader = null;
            encoding = "UTF-8";
            FileSystemIUtil.checkProgress((IProgressMonitor)progress);
            boolean canWrite = FileSystemIUtil.getInstance().checkFileWriteAuthority(as400, libSelector, srcFileName);
            if (!canWrite) {
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_51, (Object)this.getQSYSObjectPath(libSelector, srcFileName)), 98, null);
            }
            ISeriesHostObjectLock lock = FileSystemIUtil.getInstance().queryMemberLock(as400, libSelector, srcFileName, memberName);
            if (lock != null) {
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_52, (Object)this.getQSYSMemberPath(libSelector, srcFileName, memberName), (Object)lock.getJob()), 99, null);
            }
            int existingRecordLength = Integer.parseInt(FileSystemIUtil.getInstance().getSourceFileRecordLength(as400, libSelector, srcFileName));
            String propertyRecordLengthString = recordLengthFromIBMiMetadata;
            if (propertyRecordLengthString == null) {
                propertyRecordLengthString = this.getRecordLength(configuration, iPrjHandle, srcFile.getName());
            }
            if (existingRecordLength < (propertyRecordLength = Integer.parseInt(propertyRecordLengthString))) {
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_59, (Object[])new Object[]{this.getQSYSObjectPath(libSelector, srcFileName), String.valueOf(existingRecordLength), String.valueOf(propertyRecordLength)}), 121, null);
            }
            Properties properties = new Properties();
            IFileItemHandle metadaFileHandle = this.getMemberMetadataFile(configuration, iPrjHandle, srcFile.getName(), file.getName());
            if (metadaFileHandle == null) {
                textDescription = "";
            } else {
                InputStream inputStream;
                try {
                    metadataFile = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)metadaFileHandle, null);
                    IFileContent content = metadataFile.getContent();
                    inputStream = FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)metadataFile, content, null);
                }
                catch (TeamRepositoryException e) {
                    throw this.wrap(e, e.getLocalizedMessage());
                }
                try {
                    try {
                        properties.load(inputStream);
                        textDescription = properties.getProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), "");
                    }
                    catch (IOException e) {
                        this.printStackTrace(e);
                        throw this.createFailureException(e.getLocalizedMessage(), 51, e);
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        this.printStackTrace(e);
                        throw this.createFailureException(e.getLocalizedMessage(), 51, e);
                    }
                }
            }
            textDescription = FileSystemIUtil.getInstance().massageTextDescription(textDescription);
            isMemberExists = false;
            if (!createdSourceFile) {
                isMemberExists = FileSystemIUtil.isHostMemberExist(libSelector, srcFileName, memberName, as400);
            }
            justCreatedMember = false;
            if (isMemberExists || !updateTextDescriptionOnly) break block95;
            return null;
        }
        try {
            if (isMemberExists) {
                command = "CHGPFM FILE(" + libSelector + "/" + srcFileName + ") MBR(" + memberName + ") TEXT('" + textDescription + "') SRCTYPE(" + sourceType + ")";
            } else {
                command = "ADDPFM FILE(" + libSelector + "/" + srcFileName + ") MBR(" + memberName + ") TEXT('" + textDescription + "') SRCTYPE(" + sourceType + ")";
                justCreatedMember = true;
            }
            this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
            cmd = new CommandCall(as400, command);
            cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_8, (Object)this.getQSYSMemberPath(libSelector, srcFileName, memberName)), 76, null);
            }
            if (!justCreatedMember) {
                if (updateTextDescriptionOnly) {
                    long attributeTimestamp = metadataFile == null ? -1L : metadataFile.getFileTimestamp().getTime();
                    Attributes attributesMember = new Attributes(attributeTimestamp);
                    long memberLastModification = FileSystemIUtil.getHostMemberTimestamp(libSelector, srcFileName, memberName, as400);
                    return new IBMiMemberMetadata(fileName, file.getFileTimestamp().getTime(), memberLastModification, memberLastModification, attributesMember, physicalFile);
                }
                command = "CLRPFM FILE(" + libSelector + "/" + srcFileName + ") MBR(" + memberName + ")";
                this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
                cmd = new CommandCall(as400, command);
                cmdRunResult = cmd.run();
                if (!cmdRunResult) {
                    this.printMessageList(cmd);
                    throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_9, (Object)this.getQSYSMemberPath(libSelector, srcFileName, memberName)), 76, null);
                }
            }
            if ((encoding = remoteContent.getCharacterEncoding()) == null) {
                this.printMessage(NLS.bind((String)Messages.LoadCmd_58, (Object)this.getQSYSMemberPath(libSelector, srcFileName, memberName)));
                encoding = "UTF-8";
            }
            this.printMessage(NLS.bind((String)Messages.LoadCmd_57, (Object)this.getQSYSMemberPath(libSelector, srcFileName, memberName), (Object)encoding));
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        catch (TeamRepositoryException e) {
            this.printStackTrace(e);
            throw this.wrap(e, e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        progress.worked(10);
        int numtries = 2;
        SubMonitor loopProgress = progress.newChild(60).setWorkRemaining(numtries);
        int downloadTry = 0;
        while (downloadTry < numtries) {
            FileSystemIUtil.checkProgress((IProgressMonitor)loopProgress);
            try {
                byte[] adjustedBytes;
                byte[] tempBytes;
                String line;
                String path = this.getRemoteMemberPath(libSelector, srcFileName, memberName);
                if (path.contains("\u00a5")) {
                    path = path.replace('\u00a5', '$');
                }
                seqFile = new SequentialFile(as400, path);
                seqFile.setRecordFormat();
                seqFile.open(2, 4740, 3);
                boolean needsSequenceNumbers = false;
                InputStream testStream = FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContentStream((IFileItemHandle)file, remoteContent, null);
                int hasSequenceNumbers = FileSequenceNumberChecker.hasSequenceNumbers((InputStream)testStream, (String)encoding);
                testStream.close();
                if (hasSequenceNumbers == 1) {
                    needsSequenceNumbers = false;
                } else {
                    needsSequenceNumbers = true;
                    this.printMessage(NLS.bind((String)Messages.LoadCmd_30, (Object)this.getQSYSMemberPath(libSelector, srcFileName, memberName)));
                }
                bufStream = new BufferedInputStream(FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContentStream((IFileItemHandle)file, remoteContent, null));
                reader = new InputStreamReader((InputStream)bufStream, encoding);
                lineReader = new LineNumberReader(reader);
                try {
                    line = lineReader.readLine();
                }
                catch (MalformedInputException e) {
                    if (e.getMessage() == null || "".equals(e.getMessage())) {
                        throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_117, (Object[])new Object[]{encoding, memberName, "" + (lineReader.getLineNumber() + 1)}), 54, e);
                    }
                    throw e;
                }
                Record newRecord = seqFile.getRecordFormat().getNewRecord();
                int recordLength = newRecord.getRecordLength();
                int ccsid = this.getEditingCCSID(libSelector, srcFileName, as400);
                ISeriesCodepageConverter converter = new ISeriesCodepageConverter(ccsid, as400, false);
                byte[] spaceBytes = converter.convClientStringToHostBytes(ccsid, " ");
                ArrayList<Record> recordArray = new ArrayList<Record>();
                int seqNum = 0;
                int startSeqNum = 100;
                int incrSeqNum = 100;
                this.printMessage(NLS.bind((String)Messages.LoadCmd_31, (Object)startSeqNum, (Object)incrSeqNum));
                boolean overflow = false;
                Date currDate = null;
                int i = 0;
                while (line != null) {
                    Record aRecord = seqFile.getRecordFormat().getNewRecord();
                    if (needsSequenceNumbers) {
                        if (i == 0) {
                            seqNum = startSeqNum;
                            currDate = new Date(System.currentTimeMillis());
                        } else if (i > 0) {
                            if (i < 999999) {
                                seqNum += incrSeqNum;
                            }
                            if (seqNum > 999999) {
                                overflow = true;
                            }
                        }
                        if (!overflow) {
                            line = String.valueOf(this.getPrefixText(seqNum, currDate)) + line;
                        }
                    }
                    if (!overflow) {
                        tempBytes = converter.convClientStringToHostBytes(ccsid, line);
                        adjustedBytes = tempBytes.length < recordLength ? this.padWithSpaces(tempBytes, recordLength, spaceBytes) : (tempBytes.length == recordLength ? tempBytes : this.trim(tempBytes, recordLength));
                        aRecord.setContents(adjustedBytes);
                        recordArray.add(aRecord);
                    }
                    try {
                        line = lineReader.readLine();
                    }
                    catch (MalformedInputException e) {
                        if (e.getMessage() == null || "".equals(e.getMessage())) {
                            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_117, (Object[])new Object[]{encoding, memberName, "" + (lineReader.getLineNumber() + 1)}), 54, e);
                        }
                        throw e;
                    }
                    ++i;
                }
                if (overflow) {
                    this.printMessage(Messages.LoadCmd_32);
                    int result = startSeqNum + i * incrSeqNum;
                    while (result > 999999 && incrSeqNum > 1) {
                        if ((incrSeqNum /= 10) == 0) {
                            incrSeqNum = 1;
                        }
                        result = startSeqNum + i * incrSeqNum;
                    }
                    if (result > 999999 && incrSeqNum == 1) {
                        startSeqNum = 0;
                        result = startSeqNum + i * incrSeqNum;
                    }
                    lineReader.close();
                    bufStream = new BufferedInputStream(FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContentStream((IFileItemHandle)file, remoteContent, null));
                    reader = new InputStreamReader((InputStream)bufStream, encoding);
                    lineReader = new LineNumberReader(reader);
                    recordArray.clear();
                    i = 0;
                    seqNum = startSeqNum;
                    this.printMessage(NLS.bind((String)Messages.LoadCmd_31, (Object)startSeqNum, (Object)incrSeqNum));
                    line = lineReader.readLine();
                    while (line != null) {
                        Record aRecord = seqFile.getRecordFormat().getNewRecord();
                        if (i > 0 && i < 999999) {
                            seqNum += incrSeqNum;
                        }
                        adjustedBytes = (tempBytes = converter.convClientStringToHostBytes(ccsid, line = String.valueOf(this.getPrefixText(seqNum, currDate)) + line)).length < recordLength ? this.padWithSpaces(tempBytes, recordLength, spaceBytes) : (tempBytes.length == recordLength ? tempBytes : this.trim(tempBytes, recordLength));
                        aRecord.setContents(adjustedBytes);
                        recordArray.add(aRecord);
                        line = lineReader.readLine();
                        ++i;
                    }
                }
                Record[] records = new Record[recordArray.size()];
                int w = 0;
                while (w < recordArray.size()) {
                    records[w] = (Record)recordArray.get(w);
                    ++w;
                }
                if (records.length > 0) {
                    seqFile.write(records);
                }
                if (bufStream != null) {
                    bufStream.close();
                }
                if (lineReader != null) {
                    lineReader.close();
                }
                if (seqFile.isOpen()) {
                    seqFile.close();
                }
                loopProgress.worked(1);
                long attributeTimestamp = metadataFile == null ? -1L : metadataFile.getFileTimestamp().getTime();
                Attributes attributes = new Attributes(attributeTimestamp);
                long memberLastModification = FileSystemIUtil.getHostMemberTimestamp(libSelector, srcFileName, memberName, as400);
                this.membersAdded.add(String.valueOf(libSelector) + "/" + srcFileName + "(" + memberName + ")");
                return new IBMiMemberMetadata(fileName, file.getFileTimestamp().getTime(), memberLastModification, memberLastModification, attributes, physicalFile);
            }
            catch (AS400Exception e) {
                String text = e.getMessage();
                if (text.indexOf("CPI2417") <= -1 || downloadTry >= numtries - 1) {
                    this.printStackTrace(e);
                    throw this.createFailureException(e.getLocalizedMessage(), 54, e);
                }
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
            catch (AS400SecurityException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 52, e);
            }
            catch (InterruptedException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 53, e);
            }
            catch (PropertyVetoException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 55, e);
            }
            catch (TeamRepositoryException e) {
                this.printStackTrace(e);
                throw this.wrap(e, e.getLocalizedMessage());
            }
            catch (Exception e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 54, e);
            }
            ++downloadTry;
        }
        return null;
    }

    public IBMiMemberMetadata loadMember(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libSelector, IFolderHandle iSrcFileHandle, IFileItemHandle mbrHandle, AS400 as400, IBMiSourceFileMetadata physicalFile, boolean clearLibs, IProgressMonitor monitor) throws FileSystemStatusException {
        return this.loadMember(repo, wsHandle, coHandle, iPrjHandle, libSelector, iSrcFileHandle, null, mbrHandle, as400, physicalFile, clearLibs, false, false, null, monitor);
    }

    public void loadBinaryObject(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libSelector, IFileItemHandle binaryObjectHandle, IBMiLibraryMetadata library, AS400 as400, boolean clearLibs, IProgressMonitor monitor) throws FileSystemStatusException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            libSelector = FileSystemIUtil.isHostLibraryExist(libSelector, as400) ? FileSystemIUtil.getInstance().getLibraryName(as400, libSelector) : this.createLibrary(libSelector, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        String libraryName = libSelector;
        this.internalLoadBinaryObject(repo, wsHandle, coHandle, libraryName, binaryObjectHandle, as400, progress, manager);
    }

    private void internalLoadBinaryObject(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, String libSelector, IFileItemHandle binaryObjectHandle, AS400 as400, SubMonitor progress, IWorkspaceManager manager) throws FileSystemStatusException {
        IConfiguration configuration = null;
        try {
            IWorkspaceConnection wsConn = manager.getWorkspaceConnection(wsHandle, null);
            configuration = wsConn.configuration(coHandle);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
        }
        IFileItem binaryObjectFile = this.getFileItem(binaryObjectHandle, configuration, manager.versionableManager(), (IProgressMonitor)progress.newChild(50));
        IFileContent remoteContent = binaryObjectFile.getContent();
        try {
            ObjectArchiveResourceUtil oarUtil = new ObjectArchiveResourceUtil(as400, this.writer, binaryObjectFile.getName());
            InputStream inputStream = FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContentStream((IFileItemHandle)binaryObjectFile, remoteContent, null);
            IStatus status = oarUtil.restoreBinaryObject(inputStream);
            if (status.getSeverity() == 0) {
                status = oarUtil.extractOARFile();
            }
            if (status.getSeverity() == 0) {
                status = oarUtil.copySavfToQTEMP();
            }
            if (status.getSeverity() == 0) {
                BinaryObjectMinimal bo = this.getBinaryObject(binaryObjectFile.getName());
                status = oarUtil.restoreSavfContents(bo.getName(), libSelector);
            }
            oarUtil.cleanUpExtractedOar();
        }
        catch (TeamRepositoryException e) {
            this.wrap(e, e.getLocalizedMessage());
        }
    }

    private String getPrefixText(int sequenceNumber, Date date) {
        StringBuffer buf = new StringBuffer();
        DecimalFormat numFormat = new DecimalFormat("000000", new DecimalFormatSymbols(Locale.US));
        String seqNumString = numFormat.format(sequenceNumber);
        buf.append(seqNumString);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd", Locale.US);
        String dateString = dateFormat.format(date);
        buf.append(dateString);
        return buf.toString();
    }

    public IBMiSaveFileMetadata loadSaveFile(ITeamRepository repo, IWorkspaceHandle wsHandle, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libSelector, IFileItemHandle saveFileHandle, IBMiLibraryMetadata library, AS400 as400, boolean clearLibs, IProgressMonitor monitor) throws FileSystemStatusException {
        IWorkspaceConnection wsConn;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            libSelector = FileSystemIUtil.isHostLibraryExist(libSelector, as400) ? FileSystemIUtil.getInstance().getLibraryName(as400, libSelector) : this.createLibrary(libSelector, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        IConfiguration configuration = null;
        try {
            wsConn = manager.getWorkspaceConnection(wsHandle, null);
            configuration = wsConn.configuration(coHandle);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, NLS.bind((String)Messages.LoadCmd_4, (Object)wsHandle));
        }
        IFileItem saveFile = this.getFileItem(saveFileHandle, configuration, manager.versionableManager(), (IProgressMonitor)progress.newChild(50));
        String saveFileNameWithExtension = IBMiProjectResourceNameUtil.unEscapeFileName((String)saveFile.getName());
        String saveFileName = this.getSaveFileName(saveFileNameWithExtension);
        IFSFileOutputStream target = null;
        IFileContent remoteContent = saveFile.getContent();
        InputStream inputStream = null;
        String targetName = QSYSObjectPathName.toPath((String)libSelector, (String)saveFileName, (String)"FILE");
        IFSFile targetFile = new IFSFile(as400, targetName);
        int CHUNKSIZE = 262144;
        String command = null;
        CommandCall cmd = null;
        boolean cmdRunResult = true;
        FileSystemIUtil.checkProgress((IProgressMonitor)progress);
        try {
            String textDescription = this.getSaveFileTextDescription(configuration, iPrjHandle, saveFile.getName());
            command = targetFile.exists() ? "CLRSAVF FILE(" + libSelector + "/" + saveFileName + ")" : "CRTSAVF FILE(" + libSelector + "/" + saveFileName + ")";
            this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
            cmd = new CommandCall(as400, command);
            cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_10, (Object)targetName), 76, null);
            }
            inputStream = FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContentStream((IFileItemHandle)saveFile, remoteContent, null);
            target = new IFSFileOutputStream(as400, targetName, -4, false);
            byte[] buffer = new byte[CHUNKSIZE];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead > 0) {
                target.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
            target.close();
            command = "CHGSAVF FILE(" + libSelector + "/" + saveFileName + ") TEXT('" + textDescription + "')";
            this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
            cmd = new CommandCall(as400, command);
            cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_10, (Object)targetName), 76, null);
            }
            progress.worked(50);
            long attributeTimestamp = this.getSaveFilePropertyTimestamp(wsConn.configuration(coHandle), iPrjHandle, saveFile.getName());
            Attributes attributes = new Attributes(attributeTimestamp);
            return new IBMiSaveFileMetadata(saveFileName, saveFile.getFileTimestamp().getTime(), targetFile.lastModified(), targetFile.lastModified(), attributes, library);
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        catch (TeamRepositoryException e) {
            this.printStackTrace(e);
            this.wrap(e, e.getLocalizedMessage());
            return null;
        }
    }

    private String createLibrary(String libraryName, AS400 as400) throws FileSystemStatusException {
        String command = "CRTLIB " + libraryName + " ASPDEV(*SYSTEM)";
        this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
        CommandCall cmd = new CommandCall(as400, command);
        try {
            boolean cmdRunResult = cmd.run();
            if (cmdRunResult) {
                libraryName = FileSystemIUtil.getInstance().getLibraryName(as400, libraryName);
                return libraryName;
            }
            this.printMessageList(cmd);
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_5, (Object)libraryName), 76, null);
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
    }

    private void clearLibrary(String libraryName, AS400 as400) throws FileSystemStatusException {
        boolean isLibraryExists = false;
        try {
            isLibraryExists = FileSystemIUtil.isHostLibraryExist(libraryName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isLibraryExists) {
            return;
        }
        String command = "CLRLIB LIB(" + libraryName + ")";
        this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
        CommandCall cmd = new CommandCall(as400, command);
        try {
            boolean cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_60, (Object)this.getQSYSLibraryPath(libraryName)), 180, null);
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
    }

    private String createSourceFile(IWorkspaceConnection wsConn, IComponentHandle coHandle, IFolderHandle iPrjHandle, String libraryName, String sourceFileName, AS400 as400) throws FileSystemStatusException {
        CommandCall cmd;
        block8: {
            SourceFileMetadataProperties properties = this.getSourceFileMetadataProperties(wsConn.configuration(coHandle), iPrjHandle, sourceFileName);
            String ccsid = properties.getCcsid();
            String textDescription = properties.getTextDescription();
            textDescription = FileSystemIUtil.getInstance().massageTextDescription(textDescription);
            String recordLength = properties.getRecordLength();
            String igcData = properties.getIgcData();
            sourceFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFileName);
            String command = "CRTSRCPF FILE(" + libraryName + "/" + sourceFileName + ") CCSID(" + ccsid + ") RCDLEN(" + recordLength + ") IGCDTA(" + igcData + ") TEXT('" + textDescription + "')";
            this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
            cmd = new CommandCall(as400, command);
            boolean cmdRunResult = cmd.run();
            if (!cmdRunResult) break block8;
            ISeriesHostObjectBasic object = FileSystemIUtil.getHostObject(libraryName, sourceFileName, "*FILE", "PF-SRC", as400);
            if (object != null) {
                return object.getName();
            }
            return null;
        }
        try {
            this.printMessageList(cmd);
            throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_7, (Object)this.getQSYSObjectPath(libraryName, sourceFileName)), 76, null);
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        catch (TeamRepositoryException e) {
            this.printStackTrace(e);
            throw this.wrap(e, e.getLocalizedMessage());
        }
    }

    private void deleteSourceFile(String libraryName, String sourceFileName, AS400 as400, IFolder sourceFile, IConfiguration configuration) throws FileSystemStatusException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.sourcePhysicalFileForPotentialDeletion.add(new IBMiSourcePhysicalFile(libraryName, sourceFileName, as400));
        try {
            Map<String, IVersionableHandle> files = this.findAllChildrenEntry(configuration, (IFolderHandle)sourceFile, (IProgressMonitor)monitor);
            for (String name : files.keySet()) {
                IVersionableHandle fileHandle = files.get(name);
                if (fileHandle == null || !(fileHandle instanceof IFileItemHandle)) continue;
                IFileItem file = (IFileItem)configuration.fetchCompleteItem(fileHandle, (IProgressMonitor)monitor);
                String memberName = IBMiProjectResourceNameUtil.unEscapeFileName((String)this.getMemberName(file.getName()));
                String memberFilterString = String.valueOf(libraryName) + "/" + sourceFileName + "(" + memberName + ")";
                if (!this.membersAdded.contains(memberFilterString)) {
                    this.removeMember(libraryName, sourceFileName, memberName, as400);
                    continue;
                }
                this.printMessage(Messages.LoadCmd_MemberDoesNotNeedToBeDeletedInfoMsg);
            }
        }
        catch (ItemNotFoundException name) {
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
    }

    private void deleteSourceFile(String libraryName, String sourceFileName, AS400 as400) throws FileSystemStatusException {
        this.deleteFile(libraryName, sourceFileName, "PF-SRC", as400);
    }

    private void deleteSaveFile(String libraryName, String saveFileName, AS400 as400) throws FileSystemStatusException {
        this.deleteFile(libraryName, saveFileName, "SAVF", as400);
    }

    private void deleteFile(String libraryName, String fileName, String subtype, AS400 as400) throws FileSystemStatusException {
        boolean isLibraryExists = false;
        try {
            isLibraryExists = FileSystemIUtil.isHostLibraryExist(libraryName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isLibraryExists) {
            return;
        }
        boolean isFileExists = FileSystemIUtil.isHostObjectExist(libraryName, fileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)fileName), "*FILE", subtype, as400);
        if (!isFileExists) {
            return;
        }
        String command = "DLTF FILE(" + libraryName + "/" + fileName + ")";
        this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
        CommandCall cmd = new CommandCall(as400, command);
        try {
            boolean cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)"CRTCI5051E: Could not delete file \"{0}\"", (Object)this.getQSYSObjectPath(libraryName, fileName)), 181, null);
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
    }

    private void deleteObject(String libraryName, String objectName, String objectType, String objectSubtype, AS400 as400) throws FileSystemStatusException {
        boolean isLibraryExists = false;
        try {
            isLibraryExists = FileSystemIUtil.isHostLibraryExist(libraryName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isLibraryExists) {
            return;
        }
        boolean isObjectExists = FileSystemIUtil.isHostObjectExist(libraryName, objectName = IBMiProjectResourceNameUtil.unEscapeFileName((String)objectName), objectType, objectSubtype, as400);
        if (!isObjectExists) {
            return;
        }
        String deleteCommand = null;
        if (objectType.equals("*FILE")) {
            deleteCommand = "DLTF FILE(&L/&O)";
        } else if (objectType.equals("*LIB")) {
            deleteCommand = "DLTLIB LIB(&O)";
        } else if (objectType.equals("*DTAARA")) {
            deleteCommand = "DLTDTAARA DTAARA(&L/&O)";
        } else if (objectType.equals("*USRQ")) {
            deleteCommand = "DLTUSRQ USRQ(&L/&O)";
        } else if (objectType.equals("*USRSPC")) {
            deleteCommand = "DLTUSRSPC USRSPC(&L/&O)";
        } else if (objectType.equals("*OUTQ")) {
            deleteCommand = "DLTOUTQ OUTQ(&L/&O)";
        } else if (objectType.equals("*PGM")) {
            deleteCommand = "DLTPGM PGM(&L/&O)";
        } else if (objectType.equals("*CMD")) {
            deleteCommand = "DLTCMD CMD(&L/&O)";
        } else if (objectType.equals("*DTAQ")) {
            deleteCommand = "DLTDTAQ DTAQ(&L/&O)";
        } else if (objectType.equals("*JOBD")) {
            deleteCommand = "DLTJOBD JOBD(&L/&O)";
        } else if (objectType.equals("*JOBQ")) {
            deleteCommand = "DLTJOBQ JOBQ(&L/&O)";
        } else if (objectType.equals("*SRVPGM")) {
            deleteCommand = "DLTSRVPGM SRVPGM(&L/&O)";
        } else if (objectType.equals("*MENU")) {
            deleteCommand = "DLTMNU MENU(&L/&O)";
        } else if (objectType.equals("*MODULE")) {
            deleteCommand = "DLTMOD MODULE(&L/&O)";
        } else if (objectType.equals("*PNLGRP")) {
            deleteCommand = "DLTPNLGRP PNLGRP(&L/&O)";
        } else if (objectType.equals("*MSGF")) {
            deleteCommand = "DLTMSGF MSGF(&L/&O)";
        } else if (objectType.equals("*MSGQ")) {
            deleteCommand = "DLTMSGQ MSGQ(&L/&O)";
        } else if (objectType.equals("*SBSD")) {
            deleteCommand = "DLTSBSD SBSD(&L/&O)";
        } else if (objectType.equals("*QRYDFN")) {
            deleteCommand = "DLTQRY QRY(&L/&O)";
        } else if (objectType.equals("*QMFORM")) {
            deleteCommand = "DLTQMFORM QMFORM(&L/&O)";
        } else if (objectType.equals("*QMQRY")) {
            deleteCommand = "DLTQMQRY QMQRY(&L/&O)";
        } else if (objectType.equals("*ALRTBL")) {
            deleteCommand = "DLTALRTBL ALRTBL(&L/&O)";
        } else if (objectType.equals("*BNDDIR")) {
            deleteCommand = "DLTBNDDIR BNDDIR(&L/&O)";
        } else if (objectType.equals("*CLS")) {
            deleteCommand = "DLTCLS CLS(&L/&O)";
        } else if (objectType.equals("*CRQD")) {
            deleteCommand = "DLTCRQD CRQD(&L/&O)";
        } else if (objectType.equals("*CSI")) {
            deleteCommand = "DLTCSI CSI(&L/&O)";
        } else if (objectType.equals("*EDTD")) {
            deleteCommand = "DLTEDTD EDTD(&L/&O)";
        } else if (objectType.equals("*FCT")) {
            deleteCommand = "DLTFCT FCT(&L/&O)";
        } else if (objectType.equals("*FNTRSC")) {
            deleteCommand = "DLTFNTRSC FNTRSC(&L/&O)";
        } else if (objectType.equals("*FNTTBL")) {
            deleteCommand = "DLTFNTTBL FNTTBL(&L/&O)";
        } else if (objectType.equals("*FORMDF")) {
            deleteCommand = "DLTFORMDF FORMDF(&L/&O)";
        } else if (objectType.equals("*FTR")) {
            deleteCommand = "DLTFTR FILTER(&L/&O)";
        } else if (objectType.equals("*GSS")) {
            deleteCommand = "DLTGSS GSS(&L/&O)";
        } else if (objectType.equals("*JRN")) {
            deleteCommand = "DLTJRN JRN(&L/&O)";
        } else if (objectType.equals("*JRNRCV")) {
            deleteCommand = "DLTJRNRCV JRNRCV(&L/&O)";
        } else if (objectType.equals("*OVL")) {
            deleteCommand = "DLTOVL OVL(&L/&O)";
        } else if (objectType.equals("*PAGDFN")) {
            deleteCommand = "DLTPAGDFN PAGDFN(&L/&O)";
        } else if (objectType.equals("*PAGSEG")) {
            deleteCommand = "DLTPAGSEG PAGSEG(&L/&O)";
        } else if (objectType.equals("*PDG")) {
            deleteCommand = "DLTPDG PDG(&L/&O)";
        } else if (objectType.equals("*PSFCFG")) {
            deleteCommand = "DLTPSFCFG PSFCFG(&L/&O)";
        } else if (objectType.equals("*SCHIDX")) {
            deleteCommand = "DLTSCHIDX SCHIDX(&L/&O)";
        } else if (objectType.equals("*SPADCT")) {
            deleteCommand = "DLTSPADCT SPADCT(&L/&O)";
        } else if (objectType.equals("*SQLPKG")) {
            deleteCommand = "DLTSQLPKG SQLPKG(&L/&O)";
        } else if (objectType.equals("*SSND")) {
            deleteCommand = "DLTSSND SSND(&L/&O)";
        } else if (objectType.equals("*TBL")) {
            deleteCommand = "DLTTBL TBL(&L/&O)";
        } else if (objectType.equals("*USRIDX")) {
            deleteCommand = "DLTUSRIDX USRIDX(&L/&O)";
        } else if (objectType.equals("*WSCST")) {
            deleteCommand = "DLTWSCST WSCST(&L/&O)";
        } else if (objectType.equals("*AUTL")) {
            deleteCommand = "DLTAUTL AUTL(&O)";
        } else if (objectType.equals("*CFGL")) {
            deleteCommand = "DLTCFGL CFGL(&O)";
        } else if (objectType.equals("*CNNL")) {
            deleteCommand = "DLTCNNL CNNL(&O)";
        } else if (objectType.equals("*COSD")) {
            deleteCommand = "DLTCOSD COSD(&O)";
        } else if (objectType.equals("*CSPMAP")) {
            deleteCommand = "DLTCSPMAP";
        } else if (objectType.equals("*CTLD")) {
            deleteCommand = "DLTCTLD CTLD(&O)";
        } else if (objectType.equals("*DEVD")) {
            deleteCommand = "DLTDEVD DEVD(&O)";
        } else if (objectType.equals("*DTADCT")) {
            deleteCommand = "DLTDTADCT DTADCT(&O)";
        } else if (objectType.equals("*IPXD")) {
            deleteCommand = "DLTIPXD IPXD(&O)";
        } else if (objectType.equals("*LIND")) {
            deleteCommand = "DLTLIND LIND(&O)";
        } else if (objectType.equals("*LOCAL")) {
            deleteCommand = "DLTLOCALE LOCALE(&O)";
        } else if (objectType.equals("*MODD")) {
            deleteCommand = "DLTMODD MODD(&O)";
        } else if (objectType.equals("*NTBD")) {
            deleteCommand = "DLTNTBD NTBD(&O)";
        } else if (objectType.equals("*NWID")) {
            deleteCommand = "DLTNWID NWID(&O)";
        } else if (objectType.equals("*NWSD")) {
            deleteCommand = "DLTNWSD NWSD(&O)";
        } else if (objectType.equals("*USRPRF")) {
            deleteCommand = "DLTUSRPRF USRPRF(&O)";
        } else {
            return;
        }
        if (deleteCommand != null) {
            int idx = deleteCommand.indexOf("&L");
            if (idx != -1) {
                deleteCommand = String.valueOf(deleteCommand.substring(0, idx)) + libraryName + deleteCommand.substring(idx + 2, deleteCommand.length());
            }
            if ((idx = deleteCommand.indexOf("&O")) != -1) {
                deleteCommand = String.valueOf(deleteCommand.substring(0, idx)) + objectName + deleteCommand.substring(idx + 2, deleteCommand.length());
            }
            this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)deleteCommand));
            CommandCall cmd = new CommandCall(as400, deleteCommand);
            try {
                boolean cmdRunResult = cmd.run();
                if (!cmdRunResult) {
                    this.printMessageList(cmd);
                    throw this.createFailureException(NLS.bind((String)"CRTCI5052E: Could not delete object \"{0}\"", (Object)this.getQSYSObjectPath(libraryName, objectName)), 181, null);
                }
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
            catch (AS400SecurityException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 52, e);
            }
            catch (InterruptedException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 53, e);
            }
            catch (ErrorCompletingRequestException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 54, e);
            }
        }
    }

    private void removeMember(String libraryName, String sourceFileName, String memberName, AS400 as400) throws FileSystemStatusException {
        boolean isLibraryExists = false;
        try {
            isLibraryExists = FileSystemIUtil.isHostLibraryExist(libraryName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isLibraryExists) {
            return;
        }
        boolean isSourceFileExists = FileSystemIUtil.isHostObjectExist(libraryName, sourceFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFileName), "*FILE", "PF-SRC", as400);
        if (!isSourceFileExists) {
            return;
        }
        memberName = IBMiProjectResourceNameUtil.unEscapeFileName((String)memberName);
        boolean isSourceMemberExists = false;
        try {
            isSourceMemberExists = FileSystemIUtil.isHostMemberExist(libraryName, sourceFileName, memberName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isSourceMemberExists) {
            return;
        }
        String command = "RMVM FILE(" + libraryName + "/" + sourceFileName + ") MBR(" + memberName + ")";
        this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
        CommandCall cmd = new CommandCall(as400, command);
        try {
            boolean cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_62, (Object)this.getQSYSMemberPath(libraryName, sourceFileName, memberName)), 182, null);
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
    }

    private void renameSourceFile(String libraryName, String oldSourceFileName, String newSourceFileName, AS400 as400) throws FileSystemStatusException {
        this.renameObject(libraryName, oldSourceFileName, newSourceFileName, "*FILE", "PF-SRC", as400);
    }

    private void renameSaveFile(String libraryName, String oldSaveFileName, String newSaveFileName, AS400 as400) throws FileSystemStatusException {
        this.renameObject(libraryName, oldSaveFileName, newSaveFileName, "*FILE", "SAVF", as400);
    }

    private void renameObject(String libraryName, String oldObjectName, String newObjectName, String type, String subtype, AS400 as400) throws FileSystemStatusException {
        boolean isLibraryExists = false;
        try {
            isLibraryExists = FileSystemIUtil.isHostLibraryExist(libraryName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isLibraryExists) {
            return;
        }
        boolean isOldObjectExists = FileSystemIUtil.isHostObjectExist(libraryName, oldObjectName = IBMiProjectResourceNameUtil.unEscapeFileName((String)oldObjectName), type, subtype, as400);
        if (!isOldObjectExists) {
            return;
        }
        boolean isNewObjectExists = FileSystemIUtil.isHostObjectExist(libraryName, newObjectName = IBMiProjectResourceNameUtil.unEscapeFileName((String)newObjectName), type, subtype, as400);
        if (isNewObjectExists) {
            return;
        }
        String command = "RNMOBJ OBJ(" + libraryName + "/" + oldObjectName + ") OBJTYPE(" + type + ") NEWOBJ(" + newObjectName + ")";
        this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
        CommandCall cmd = new CommandCall(as400, command);
        try {
            boolean cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)"CRTCI5040E: Could not rename object \"{0}\"", (Object)this.getQSYSObjectPath(libraryName, oldObjectName)), 184, null);
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
    }

    private boolean renameMember(String libraryName, String sourceFileName, String oldMemberName, String newMemberName, AS400 as400) throws FileSystemStatusException {
        boolean isLibraryExists = false;
        try {
            isLibraryExists = FileSystemIUtil.isHostLibraryExist(libraryName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isLibraryExists) {
            return false;
        }
        boolean isSourceFileExists = FileSystemIUtil.isHostObjectExist(libraryName, sourceFileName = IBMiProjectResourceNameUtil.unEscapeFileName((String)sourceFileName), "*FILE", "PF-SRC", as400);
        if (!isSourceFileExists) {
            return false;
        }
        oldMemberName = IBMiProjectResourceNameUtil.unEscapeFileName((String)oldMemberName);
        boolean isOldSourceMemberExists = false;
        try {
            isOldSourceMemberExists = FileSystemIUtil.isHostMemberExist(libraryName, sourceFileName, oldMemberName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        if (!isOldSourceMemberExists) {
            return false;
        }
        newMemberName = IBMiProjectResourceNameUtil.unEscapeFileName((String)newMemberName);
        boolean isNewSourceMemberExists = false;
        try {
            isNewSourceMemberExists = FileSystemIUtil.isHostMemberExist(libraryName, sourceFileName, newMemberName, as400);
        }
        catch (Exception e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        String oldMemberFilterString = String.valueOf(libraryName) + "/" + sourceFileName + "(" + oldMemberName + ")";
        String newMemberFilterString = String.valueOf(libraryName) + "/" + sourceFileName + "(" + newMemberName + ")";
        if (isNewSourceMemberExists) {
            if (!this.membersAdded.contains(oldMemberFilterString)) {
                this.removeMember(libraryName, sourceFileName, oldMemberName, as400);
                this.membersAdded.add(newMemberFilterString);
            }
            return true;
        }
        if (this.membersAdded.contains(oldMemberFilterString)) {
            return true;
        }
        String command = "RNMM FILE(" + libraryName + "/" + sourceFileName + ") MBR(" + oldMemberName + ") NEWMBR(" + newMemberName + ")";
        this.printMessage(NLS.bind((String)Messages.LoadCmd_100, (Object)command));
        CommandCall cmd = new CommandCall(as400, command);
        try {
            boolean cmdRunResult = cmd.run();
            if (!cmdRunResult) {
                this.printMessageList(cmd);
                throw this.createFailureException(NLS.bind((String)Messages.LoadCmd_65, (Object)this.getQSYSMemberPath(libraryName, sourceFileName, oldMemberName)), 185, null);
            }
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (AS400SecurityException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
        catch (InterruptedException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 53, e);
        }
        catch (ErrorCompletingRequestException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 54, e);
        }
        return false;
    }

    private IFileItemHandle getSourcePhysicalFileMetadataFile(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName) throws TeamRepositoryException, ItemNotFoundException {
        IFolderHandle ibmiFolderHandle = null;
        if (this.ibmiFolderByProject.containsKey(prjHandle)) {
            ibmiFolderHandle = this.ibmiFolderByProject.get(prjHandle);
        } else {
            ibmiFolderHandle = (IFolderHandle)this.findChildEntry(configuration, prjHandle, ".ibmi");
            this.ibmiFolderByProject.put(prjHandle, ibmiFolderHandle);
        }
        if (ibmiFolderHandle == null) {
            return null;
        }
        IFolderHandle psFolderHandle = null;
        if (this.ibmiFolderBySourcePhysicalFile.containsKey(ibmiFolderHandle)) {
            HashMap<String, IFolderHandle> folders = this.ibmiFolderBySourcePhysicalFile.get(ibmiFolderHandle);
            if (folders.containsKey(sourcePhysicalFileName)) {
                psFolderHandle = folders.get(sourcePhysicalFileName);
            } else {
                psFolderHandle = (IFolderHandle)this.findChildEntry(configuration, ibmiFolderHandle, sourcePhysicalFileName);
                folders.put(sourcePhysicalFileName, psFolderHandle);
            }
        } else {
            psFolderHandle = (IFolderHandle)this.findChildEntry(configuration, ibmiFolderHandle, sourcePhysicalFileName);
            HashMap<String, IFolderHandle> folders = new HashMap<String, IFolderHandle>();
            folders.put(sourcePhysicalFileName, psFolderHandle);
            this.ibmiFolderBySourcePhysicalFile.put(ibmiFolderHandle, folders);
        }
        if (psFolderHandle == null) {
            return null;
        }
        return (IFileItemHandle)this.findChildEntry(configuration, psFolderHandle, ".properties");
    }

    private IFileItemHandle getMemberMetadataFile(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName, String memberName) throws TeamRepositoryException, ItemNotFoundException {
        IFolderHandle ibmiFolderHandle = null;
        if (this.ibmiFolderByProject.containsKey(prjHandle)) {
            ibmiFolderHandle = this.ibmiFolderByProject.get(prjHandle);
        } else {
            ibmiFolderHandle = (IFolderHandle)this.findChildEntry(configuration, prjHandle, ".ibmi");
            this.ibmiFolderByProject.put(prjHandle, ibmiFolderHandle);
        }
        if (ibmiFolderHandle == null) {
            return null;
        }
        IFolderHandle psFolderHandle = null;
        if (this.ibmiFolderBySourcePhysicalFile.containsKey(ibmiFolderHandle)) {
            HashMap<String, IFolderHandle> folders = this.ibmiFolderBySourcePhysicalFile.get(ibmiFolderHandle);
            if (folders.containsKey(sourcePhysicalFileName)) {
                psFolderHandle = folders.get(sourcePhysicalFileName);
            } else {
                psFolderHandle = (IFolderHandle)this.findChildEntry(configuration, ibmiFolderHandle, sourcePhysicalFileName);
                folders.put(sourcePhysicalFileName, psFolderHandle);
            }
        } else {
            psFolderHandle = (IFolderHandle)this.findChildEntry(configuration, ibmiFolderHandle, sourcePhysicalFileName);
            HashMap<String, IFolderHandle> folders = new HashMap<String, IFolderHandle>();
            folders.put(sourcePhysicalFileName, psFolderHandle);
            this.ibmiFolderBySourcePhysicalFile.put(ibmiFolderHandle, folders);
        }
        if (psFolderHandle == null) {
            return null;
        }
        return (IFileItemHandle)this.findChildEntry(configuration, psFolderHandle, String.valueOf(memberName) + ".properties");
    }

    private IFileItemHandle getSaveFileMetadataFile(IConfiguration configuration, IFolderHandle prjHandle, String saveFileName) throws TeamRepositoryException, ItemNotFoundException {
        IFolderHandle ibmiFolderHandle = null;
        if (this.ibmiFolderByProject.containsKey(prjHandle)) {
            ibmiFolderHandle = this.ibmiFolderByProject.get(prjHandle);
        } else {
            ibmiFolderHandle = (IFolderHandle)this.findChildEntry(configuration, prjHandle, ".ibmi");
            this.ibmiFolderByProject.put(prjHandle, ibmiFolderHandle);
        }
        if (ibmiFolderHandle == null) {
            return null;
        }
        return (IFileItemHandle)this.findChildEntry(configuration, ibmiFolderHandle, String.valueOf(saveFileName) + ".properties");
    }

    private InputStream getInputStream(IConfiguration configuration, IFileItemHandle fileHandle) throws FileSystemStatusException {
        IFileItem file = null;
        try {
            file = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileHandle, null);
            IFileContent content = file.getContent();
            return FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)file, content, null);
        }
        catch (TeamRepositoryException e) {
            throw this.wrap(e, e.getLocalizedMessage());
        }
    }

    private String getCCSID(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName) throws TeamRepositoryException, ItemNotFoundException, FileSystemStatusException {
        Properties properties = new Properties();
        IFileItemHandle metadaFileHandle = this.getSourcePhysicalFileMetadataFile(configuration, prjHandle, sourcePhysicalFileName);
        if (metadaFileHandle == null) {
            return "*JOB";
        }
        InputStream inputStream = this.getInputStream(configuration, metadaFileHandle);
        try {
            String ccsid;
            properties.load(inputStream);
            String string = ccsid = properties.getProperty(IIBMiPropertyKeyConstants.KEY_CCSID.toString(), "*JOB");
            return string;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
        }
    }

    private String getRecordLength(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName) throws TeamRepositoryException, ItemNotFoundException, FileSystemStatusException {
        Properties properties = new Properties();
        IFileItemHandle metadaFileHandle = this.getSourcePhysicalFileMetadataFile(configuration, prjHandle, sourcePhysicalFileName);
        if (metadaFileHandle == null) {
            return "112";
        }
        InputStream inputStream = this.getInputStream(configuration, metadaFileHandle);
        try {
            String recordLength;
            properties.load(inputStream);
            String string = recordLength = properties.getProperty(IIBMiPropertyKeyConstants.KEY_RECORD_LENGTH.toString(), "112");
            return string;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
        }
    }

    private String getIGCData(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName) throws TeamRepositoryException, ItemNotFoundException, FileSystemStatusException {
        Properties properties = new Properties();
        IFileItemHandle metadaFileHandle = this.getSourcePhysicalFileMetadataFile(configuration, prjHandle, sourcePhysicalFileName);
        if (metadaFileHandle == null) {
            return "*NO";
        }
        InputStream inputStream = this.getInputStream(configuration, metadaFileHandle);
        try {
            properties.load(inputStream);
            String igcData = properties.getProperty(IIBMiPropertyKeyConstants.KEY_DBCS.toString(), "false");
            boolean igcDataFlag = Boolean.valueOf(igcData);
            if (!igcDataFlag) {
                return "*NO";
            }
            return "*YES";
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
        }
    }

    private SourceFileMetadataProperties getSourceFileMetadataProperties(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName) throws TeamRepositoryException, ItemNotFoundException, FileSystemStatusException {
        String ccsid = "*JOB";
        String recordLength = "112";
        String textDescription = "";
        String igcData = "*NO";
        long timestamp = -1L;
        Properties properties = new Properties();
        IFileItemHandle metadaFileHandle = this.getSourcePhysicalFileMetadataFile(configuration, prjHandle, sourcePhysicalFileName);
        if (metadaFileHandle != null) {
            InputStream inputStream;
            IFileItem file = null;
            try {
                file = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)metadaFileHandle, null);
                IFileContent content = file.getContent();
                inputStream = FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)file, content, null);
            }
            catch (TeamRepositoryException e) {
                throw this.wrap(e, e.getLocalizedMessage());
            }
            try {
                try {
                    properties.load(inputStream);
                    ccsid = properties.getProperty(IIBMiPropertyKeyConstants.KEY_CCSID.toString(), "*JOB");
                    recordLength = properties.getProperty(IIBMiPropertyKeyConstants.KEY_RECORD_LENGTH.toString(), "112");
                    textDescription = properties.getProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), "");
                    igcData = properties.getProperty(IIBMiPropertyKeyConstants.KEY_DBCS.toString(), "false");
                    boolean igcDataFlag = Boolean.valueOf(igcData);
                    igcData = !igcDataFlag ? "*NO" : "*YES";
                    timestamp = file.getFileTimestamp().getTime();
                }
                catch (IOException e) {
                    this.printStackTrace(e);
                    throw this.createFailureException(e.getLocalizedMessage(), 51, e);
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.printStackTrace(e);
                    throw this.createFailureException(e.getLocalizedMessage(), 51, e);
                }
            }
        }
        return new SourceFileMetadataProperties(ccsid, recordLength, textDescription, igcData, timestamp);
    }

    private String getTextDescription(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName) throws TeamRepositoryException, ItemNotFoundException, FileSystemStatusException {
        Properties properties = new Properties();
        IFileItemHandle metadaFileHandle = this.getSourcePhysicalFileMetadataFile(configuration, prjHandle, sourcePhysicalFileName);
        if (metadaFileHandle == null) {
            return "";
        }
        InputStream inputStream = this.getInputStream(configuration, metadaFileHandle);
        try {
            String textDescription;
            properties.load(inputStream);
            String string = textDescription = properties.getProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), "");
            return string;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
        }
    }

    private String getTextDescription(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName, String memberName) throws TeamRepositoryException, ItemNotFoundException, FileSystemStatusException {
        Properties properties = new Properties();
        IFileItemHandle metadaFileHandle = this.getMemberMetadataFile(configuration, prjHandle, sourcePhysicalFileName, memberName);
        if (metadaFileHandle == null) {
            return "";
        }
        InputStream inputStream = this.getInputStream(configuration, metadaFileHandle);
        try {
            String textDescription;
            properties.load(inputStream);
            String string = textDescription = properties.getProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), "");
            return string;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
        }
    }

    private String getSaveFileTextDescription(IConfiguration configuration, IFolderHandle prjHandle, String saveFileName) throws TeamRepositoryException, ItemNotFoundException, FileSystemStatusException {
        Properties properties = new Properties();
        IFileItemHandle metadaFileHandle = this.getSaveFileMetadataFile(configuration, prjHandle, saveFileName);
        if (metadaFileHandle == null) {
            return "";
        }
        InputStream inputStream = this.getInputStream(configuration, metadaFileHandle);
        try {
            String textDescription;
            properties.load(inputStream);
            String string = textDescription = properties.getProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), "");
            return string;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.printStackTrace(e);
                throw this.createFailureException(e.getLocalizedMessage(), 51, e);
            }
        }
    }

    public int getEditingCCSID(String libraryName, String sourceFileName, AS400 as400) throws FileSystemStatusException {
        try {
            ISeriesRetrieveDatabaseFileDescription api;
            ProgramCall pgm = new ProgramCall(as400);
            Job job = pgm.getServerJob();
            User user = new User(as400, (String)job.getValue(305));
            int ccsid = user.getCCSID();
            if (ccsid < 0) {
                SystemValue qccsid = new SystemValue(as400, "QCCSID");
                ccsid = (Integer)qccsid.getValue();
            }
            if (!(ccsid != 65535 && ccsid != -1 && ccsid != 0 || (ccsid = (api = new ISeriesRetrieveDatabaseFileDescription(as400)).retrieveFileCCSID(libraryName, sourceFileName)) != 65535 && ccsid != -1 && ccsid != 0)) {
                ccsid = job.getCodedCharacterSetID();
            }
            return this.getMappedCcsid(ccsid);
        }
        catch (Exception e) {
            throw this.createFailureException(e.getMessage(), 113, e);
        }
    }

    public int getMappedCcsid(int ccsid) {
        int result = ccsid;
        if (this.ccsidMapping != null && this.ccsidMapping.trim().length() > 0) {
            this.printMessage("Although CCSID mapping is provided, the usage of it is strongly discouraged!");
            String[] entries = this.ccsidMapping.split(",");
            if (entries != null) {
                String[] stringArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    String entry = stringArray[n2];
                    String[] thisMap = entry.split(":");
                    if (thisMap != null && thisMap.length == 2) {
                        try {
                            int sourceCCSID = Integer.parseInt(thisMap[0]);
                            if (sourceCCSID == ccsid) {
                                result = Integer.parseInt(thisMap[1]);
                                break;
                            }
                        }
                        catch (NumberFormatException e) {
                            this.printMessage("Error when mapping CCSIDs.");
                            this.printStackTrace(e);
                        }
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    private long getPhysicalFilePropertyTimestamp(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName) throws TeamRepositoryException, FileSystemStatusException {
        IFileItem file;
        IFileItemHandle metadaFileHandle = this.getSourcePhysicalFileMetadataFile(configuration, prjHandle, sourcePhysicalFileName);
        if (metadaFileHandle != null && (file = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)metadaFileHandle, null)) != null) {
            return file.getFileTimestamp().getTime();
        }
        return -1L;
    }

    private long getMemberPropertyTimestamp(IConfiguration configuration, IFolderHandle prjHandle, String sourcePhysicalFileName, String memberName) throws TeamRepositoryException, FileSystemStatusException {
        IFileItem file;
        IFileItemHandle metadaFileHandle = this.getMemberMetadataFile(configuration, prjHandle, sourcePhysicalFileName, memberName);
        if (metadaFileHandle != null && (file = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)metadaFileHandle, null)) != null) {
            return file.getFileTimestamp().getTime();
        }
        return -1L;
    }

    private long getSaveFilePropertyTimestamp(IConfiguration configuration, IFolderHandle prjHandle, String saveFileName) throws TeamRepositoryException, FileSystemStatusException {
        IFileItem file;
        IFileItemHandle metadaFileHandle = this.getSaveFileMetadataFile(configuration, prjHandle, saveFileName);
        if (metadaFileHandle != null && (file = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)metadaFileHandle, null)) != null) {
            return file.getFileTimestamp().getTime();
        }
        return -1L;
    }

    private void printMessage(String msg) {
        if (this.writer != null) {
            this.writer.println(this.formatMessage(msg));
            this.writer.flush();
        }
        System.out.println(this.formatMessage(msg));
        System.out.flush();
    }

    private String formatMessage(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date(System.currentTimeMillis()));
        return NLS.bind((String)Messages.LogPrefix, (Object)timestamp, (Object)message);
    }

    private void printStackTrace(Throwable e) {
        if (this.writer != null) {
            e.printStackTrace(this.writer);
        }
        e.printStackTrace();
    }

    private void printMessageList(CommandCall cmd) {
        AS400Message[] messageList = cmd.getMessageList();
        this.errorMessages = new String[messageList.length];
        int i = 0;
        AS400Message[] aS400MessageArray = messageList;
        int n = messageList.length;
        int n2 = 0;
        while (n2 < n) {
            AS400Message msg = aS400MessageArray[n2];
            this.errorMessages[i++] = msg.getText();
            this.printMessage(msg.getText());
            ++n2;
        }
    }

    public String[] getErrorMessages() {
        return this.errorMessages;
    }

    private boolean ignoreFile(String name) {
        return name.toLowerCase().endsWith("properties") || name.endsWith(".project");
    }

    private String getMemberName(String fileName) {
        return this.getSubStringBeforeDot(fileName);
    }

    private String getMemberType(String fileName) {
        return this.getSubStringAfterDot(fileName);
    }

    private BinaryObjectMinimal getBinaryObject(String fileName) {
        String fullObjectName = this.getSubStringBeforeDot(fileName);
        int index = fullObjectName.indexOf(".");
        if (index != -1) {
            String objectName = fullObjectName.substring(0, index);
            int subIndex = fullObjectName.indexOf(".", index + 1);
            String objectType = null;
            String objectSubtype = null;
            if (subIndex == -1) {
                objectType = "*" + fullObjectName.substring(index + 1);
            } else {
                objectType = "*" + fullObjectName.substring(index + 1, subIndex);
                objectSubtype = fullObjectName.substring(subIndex + 1);
            }
            return new BinaryObjectMinimal(objectName, objectType, objectSubtype);
        }
        return null;
    }

    private String getSaveFileName(String fileName) {
        return this.getSubStringBeforeDot(fileName);
    }

    private String getSubStringBeforeDot(String str) {
        int index = str.lastIndexOf(46);
        if (index != -1) {
            return str.substring(0, index);
        }
        return str;
    }

    private String getSubStringAfterDot(String str) {
        int index = str.lastIndexOf(46);
        if (index != -1) {
            return str.substring(index + 1);
        }
        return "";
    }

    private String getMemberExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "*NONE";
        }
        if (index == name.length() - 1) {
            return "*NONE";
        }
        return name.substring(index + 1);
    }

    private byte[] padWithSpaces(byte[] byteArray, int length, byte[] spaceArray) {
        if ((length - byteArray.length) % spaceArray.length != 0) {
            return byteArray;
        }
        byte[] paddedArray = new byte[length];
        int i = 0;
        while (i < byteArray.length) {
            paddedArray[i] = byteArray[i];
            ++i;
        }
        int j = byteArray.length;
        while (j < length) {
            int k = 0;
            while (k < spaceArray.length) {
                paddedArray[j + k] = spaceArray[k];
                ++k;
            }
            j += spaceArray.length;
        }
        return paddedArray;
    }

    private byte[] trim(byte[] byteArray, int length) {
        byte[] trimmedArray = new byte[length];
        int i = 0;
        while (i < length) {
            trimmedArray[i] = byteArray[i];
            ++i;
        }
        return trimmedArray;
    }

    private String getQSYSLibraryPath(String libName) {
        return libName;
    }

    private String getQSYSObjectPath(String libName, String objectName) {
        return String.valueOf(libName) + "/" + objectName;
    }

    private String getRemoteMemberPath(String libName, String sourceFileName, String memberName) {
        return "/QSYS.LIB/" + libName + ".LIB/" + sourceFileName + ".FILE/" + memberName + ".MBR";
    }

    private String getQSYSMemberPath(String libName, String sourceFileName, String memberName) {
        return String.valueOf(libName) + "/" + sourceFileName + "(" + memberName + ")";
    }

    private IVersionableHandle findChildEntry(IConfiguration wsConfiguration, IFolderHandle folder, String name) throws TeamRepositoryException, ItemNotFoundException {
        return (IVersionableHandle)wsConfiguration.childEntries(folder, null).get(name);
    }

    private Map<String, IVersionableHandle> findAllChildrenEntry(IConfiguration wsConfiguration, IFolderHandle folder, IProgressMonitor monitor) throws TeamRepositoryException, ItemNotFoundException {
        return wsConfiguration.childEntries(folder, monitor);
    }

    private boolean validateSignon(AS400 as400) throws FileSystemStatusException {
        try {
            return as400.validateSignon();
        }
        catch (AS400SecurityException e) {
            int returnCode = e.getReturnCode();
            if (returnCode == 7) {
                this.printMessage(Messages.LoadCmd_53);
            } else if (returnCode == 31) {
                this.printMessage(Messages.LoadCmd_54);
            }
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 51, e);
        }
        catch (IOException e) {
            this.printStackTrace(e);
            throw this.createFailureException(e.getLocalizedMessage(), 52, e);
        }
    }

    private FileSystemStatusException wrap(TeamRepositoryException e, String failureMsg) {
        if (e instanceof PermissionDeniedException) {
            return this.createFailureException(((PermissionDeniedException)e).getLocalizedMessage(), 18, null);
        }
        if (e instanceof LicenseNotGrantedException) {
            return this.createFailureException(NLS.bind((String)Messages.StatusHelper_12, (Object)e.getMessage()), 29, e);
        }
        return this.createFailureException(failureMsg, 3, e);
    }

    private FileSystemStatusException createFailureException(String message, int errorCode, Throwable t) {
        return new FileSystemStatusException((IStatus)new Status(4, "com.ibm.teami.filesystem.client", errorCode, message, t));
    }

    private String getBinaryLibrary(String mainLibrary, String projName, Hashtable<String, String> projectsToObjectLibraries) {
        String potentialBinaryLib;
        String library = mainLibrary;
        if (projectsToObjectLibraries != null && (potentialBinaryLib = projectsToObjectLibraries.get(projName)) != null) {
            library = potentialBinaryLib;
        }
        return library;
    }

    public class ChangeKind {
        private int changeKind = 0;
        private IBMiChange change;

        public void setChangeKind(int kind) {
            this.changeKind = kind;
        }

        public void setChange(IBMiChange change) {
            this.change = change;
        }

        public int getChangeKind() {
            return this.changeKind;
        }

        public IBMiChange getChange() {
            return this.change;
        }

        public ChangeKind(int changeKind, IBMiChange change) {
            this.changeKind = changeKind;
            this.change = change;
        }
    }

    public class ChangeRequest {
        private IComponentHandle componentHandle;
        private final List<ChangeKind> changes = new ArrayList<ChangeKind>();
        int changeKind;
        private ChangeKind mainChange;

        public ChangeRequest(int changeKind, IBMiChange change, IComponentHandle componentHandle) {
            this.mainChange = new ChangeKind(changeKind, change);
            this.changeKind = changeKind;
            this.changes.add(this.mainChange);
            this.setComponentHandle(componentHandle);
        }

        public void setChangeKind(int kind) {
            this.changeKind = kind;
            this.mainChange.setChangeKind(kind);
        }

        public void setChange(IBMiChange change) {
            this.mainChange.setChange(change);
        }

        public int getChangeKind() {
            return this.changeKind;
        }

        public IBMiChange getChange() {
            return this.mainChange.getChange();
        }

        public void addAdditionalChange(int kind, IChange additionalChange) {
            if (kind == 6) {
                for (ChangeKind change : this.changes) {
                    if (change.getChangeKind() != 6) continue;
                    change.setChangeKind(4);
                }
                if (this.changeKind == 4) {
                    this.changeKind = 6;
                }
            } else if (kind == 4) {
                for (ChangeKind change : this.changes) {
                    if (change.getChangeKind() != 6) continue;
                    change.setChangeKind(4);
                    kind = 6;
                }
            }
            ChangeKind newChangeKind = new ChangeKind(kind, new IBMiChange(additionalChange.beforeState(), additionalChange.afterState()));
            this.changes.add(newChangeKind);
            if (this.mainChange.getChangeKind() == 1 && (kind == 6 || kind == 4)) {
                this.mainChange = newChangeKind;
                this.changeKind = 6;
                newChangeKind.setChangeKind(this.changeKind);
                this.changes.remove(0);
            }
        }

        public List<ChangeKind> getChanges() {
            return this.changes;
        }

        public void setComponentHandle(IComponentHandle componentHandle) {
            this.componentHandle = componentHandle;
        }

        public IComponentHandle getComponentHandle() {
            return this.componentHandle;
        }
    }

    private class IBMiChange {
        private IVersionableHandle beforeState;
        private IVersionableHandle afterState;

        public IBMiChange(IVersionableHandle beforeState, IVersionableHandle afterState) {
            this.setBeforeState(beforeState);
            this.setAfterState(afterState);
        }

        public void setBeforeState(IVersionableHandle beforeState) {
            this.beforeState = beforeState;
        }

        public IVersionableHandle getBeforeState() {
            return this.beforeState;
        }

        public void setAfterState(IVersionableHandle afterState) {
            this.afterState = afterState;
        }

        public IVersionableHandle getAfterState() {
            return this.afterState;
        }
    }

    private class IBMiSourcePhysicalFile {
        private String library;
        private String name;
        private AS400 as400;

        public IBMiSourcePhysicalFile(String library, String name, AS400 as400) {
            this.setLibrary(library);
            this.setName(name);
            this.setAs400(as400);
        }

        public void setLibrary(String library) {
            this.library = library;
        }

        public String getLibrary() {
            return this.library;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAs400(AS400 as400) {
            this.as400 = as400;
        }

        public AS400 getAs400() {
            return this.as400;
        }
    }

    public class SourceFileMetadataProperties {
        private String ccsid;
        private String recordLength;
        private String igcData;
        private String textDescription;
        private long timestamp;

        public SourceFileMetadataProperties(String ccsid, String recordLength, String textDescription, String igcData, long timestamp) {
            this.setCcsid(ccsid);
            this.setRecordLength(recordLength);
            this.setTextDescription(textDescription);
            this.setIgcData(igcData);
            this.setTimestamp(timestamp);
        }

        public void setCcsid(String ccsid) {
            this.ccsid = ccsid;
        }

        public String getCcsid() {
            return this.ccsid;
        }

        public void setRecordLength(String recordLength) {
            this.recordLength = recordLength;
        }

        public String getRecordLength() {
            return this.recordLength;
        }

        public void setIgcData(String igcData) {
            this.igcData = igcData;
        }

        public String getIgcData() {
            return this.igcData;
        }

        public void setTextDescription(String textDescription) {
            this.textDescription = textDescription;
        }

        public String getTextDescription() {
            return this.textDescription;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

