/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.metadata.ScmAttributesReader;
import com.ibm.teami.filesystem.client.internal.metadata.ScmComponentMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmSourceFileMetadata;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScmMetadataReader {
    private final ITeamRepository repository;
    private final IWorkspaceHandle workspaceHandle;

    public ScmMetadataReader(ITeamRepository repository, IWorkspaceHandle workspaceHandle) {
        this.repository = repository;
        this.workspaceHandle = workspaceHandle;
    }

    public ScmLibraryMetadata getLibraryMetadata(ScmComponentMetadata componentMetadata, IFolderHandle iProjectHandle, String mappingLibrary, IProgressMonitor monitor) throws Exception {
        IComponentHandle componentHandle = componentMetadata.getComponentHandle();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository);
        IWorkspaceConnection wsConn = manager.getWorkspaceConnection(this.workspaceHandle, monitor);
        IFolder project = (IFolder)wsConn.configuration(componentHandle).fetchPartialItem((IVersionableHandle)iProjectHandle, Collections.singletonList(IFolder.NAME_PROPERTY), monitor);
        ScmLibraryMetadata library = new ScmLibraryMetadata(project.getName(), iProjectHandle, componentMetadata, mappingLibrary);
        if (!library.hasMappingLibrary()) {
            return library;
        }
        Map childHandles = wsConn.configuration(componentHandle).childEntries(iProjectHandle, monitor);
        ScmAttributesReader attrReader = new ScmAttributesReader(wsConn, this.repository, componentHandle);
        this.parseAttributesInIBMiFolder(attrReader, childHandles, monitor);
        for (String childName : childHandles.keySet()) {
            IFileItem fileItem;
            Map files = null;
            IVersionableHandle childHandle = (IVersionableHandle)childHandles.get(childName);
            if (childHandle == null) continue;
            if (childHandle instanceof IFolderHandle) {
                IFolder folder = (IFolder)wsConn.configuration(componentHandle).fetchCompleteItem(childHandle, monitor);
                if (FileSystemIUtil.isHiddenFolder(folder.getName())) continue;
                ScmSourceFileMetadata sourceFile = new ScmSourceFileMetadata(folder.getName(), (IFolderHandle)childHandle, library, attrReader.getSourceFileAttributes(folder.getName(), monitor));
                files = wsConn.configuration(componentHandle).childEntries((IFolderHandle)childHandle, monitor);
                for (String name : files.keySet()) {
                    IFileItem fileItem2;
                    IVersionableHandle fileHandle = (IVersionableHandle)files.get(name);
                    if (fileHandle == null || !(fileHandle instanceof IFileItemHandle) || this.ignoreFile((fileItem2 = (IFileItem)wsConn.configuration(componentHandle).fetchCompleteItem(fileHandle, monitor)).getName())) continue;
                    ScmMemberMetadata member = new ScmMemberMetadata(fileItem2, attrReader.getMemberAttributes(folder.getName(), fileItem2.getName(), monitor), sourceFile);
                    sourceFile.addMemberMetadata(member);
                }
                library.addObjectMetadata(sourceFile);
                continue;
            }
            if (!(childHandle instanceof IFileItemHandle) || !(fileItem = (IFileItem)wsConn.configuration(componentHandle).fetchCompleteItem(childHandle, monitor)).getName().endsWith("SAVF")) continue;
            ScmSaveFileMetadata saveFile = new ScmSaveFileMetadata(fileItem, library, attrReader.getSaveFileAttributes(fileItem.getName(), monitor));
            library.addObjectMetadata(saveFile);
        }
        return library;
    }

    private void parseAttributesInIBMiFolder(ScmAttributesReader attrReader, Map<String, IVersionableHandle> folderHandles, IProgressMonitor monitor) {
        for (String folderName : folderHandles.keySet()) {
            if (!FileSystemIUtil.isIBMiHiddenFolder(folderName)) continue;
            IVersionableHandle folderHandle = folderHandles.get(folderName);
            attrReader.parseAllLibraryPropertyFiles((IFolderHandle)folderHandle, monitor);
            return;
        }
    }

    private boolean ignoreFile(String name) {
        return name.endsWith("properties") || name.endsWith(".project");
    }
}

