/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.MemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ObjectMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ScmLibraryMetadata;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ScmMemberMetadata
extends MemberMetadata {
    private IFileItem fileItem;
    byte[] byteContents = null;

    public ScmMemberMetadata(IFileItem fileItem, Attributes attributes, ObjectMetadata objectMetadata) {
        if (fileItem != null) {
            this.name = fileItem.getName();
            this.scmTimestamp = fileItem.getFileTimestamp().getTime();
            this.ibmiMetadataTimestamp = -1L;
            this.ibmiFileTimestamp = -1L;
            this.fileItem = fileItem;
        }
        this.objectMetadata = objectMetadata;
        this.setAttributes(attributes);
    }

    public IFileItem getFileItem() {
        return this.fileItem;
    }

    @Override
    public final int origin() {
        return 1;
    }

    @Override
    public byte[] getContents() throws Exception {
        Job job = new Job(""){

            public IStatus run(IProgressMonitor monitor) {
                InputStream is = null;
                try {
                    try {
                        IFileContent content = ScmMemberMetadata.this.fileItem.getContent();
                        ITeamRepository repository = ((ScmLibraryMetadata)ScmMemberMetadata.this.getObjectMetadata().getLibraryMetadata()).getScmComponentMetadata().getScmWorkspaceMetadata().getRepository();
                        is = FileSystemCore.getContentManager((ITeamRepository)repository).retrieveContentStream((IFileItemHandle)ScmMemberMetadata.this.fileItem, content, monitor);
                        byte[] bytes = new byte[1024];
                        int numRead = is.read(bytes);
                        StringBuffer buffer = new StringBuffer();
                        while (numRead != -1) {
                            buffer.append(new String(bytes, 0, numRead));
                            numRead = is.read(bytes);
                        }
                        ScmMemberMetadata.this.byteContents = buffer.toString().getBytes();
                    }
                    catch (Exception e) {
                        ScmMemberMetadata.this.byteContents = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        job.join();
        return this.byteContents;
    }
}

