/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.DefaultAttributesReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScmAttributesReader
extends DefaultAttributesReader {
    private final IWorkspaceConnection wsConnection;
    private final ITeamRepository teamRepository;
    private final IComponentHandle componentHandle;
    private Map<String, SimpleProperty> propertyMap;

    public ScmAttributesReader(IWorkspaceConnection wsConnection, ITeamRepository teamRepository, IComponentHandle componentHandle) {
        this.wsConnection = wsConnection;
        this.teamRepository = teamRepository;
        this.componentHandle = componentHandle;
    }

    public void parseAllLibraryPropertyFiles(IFolderHandle ibmiFolder, IProgressMonitor monitor) {
        this.propertyMap = new HashMap<String, SimpleProperty>();
        try {
            Map childHandlers = this.wsConnection.configuration(this.componentHandle).childEntries(ibmiFolder, monitor);
            for (String childName : childHandlers.keySet()) {
                IVersionableHandle childHandle = (IVersionableHandle)childHandlers.get(childName);
                if (childHandle == null) continue;
                if (childHandle instanceof IFolderHandle) {
                    Map files = this.wsConnection.configuration(this.componentHandle).childEntries((IFolderHandle)childHandle, monitor);
                    ComplexProperty property = new ComplexProperty();
                    for (String fileName : files.keySet()) {
                        IVersionableHandle fileHandle = (IVersionableHandle)files.get(fileName);
                        if (fileHandle == null || !(fileHandle instanceof IFileItemHandle)) continue;
                        if (this.isMemberPropertyFile(fileName)) {
                            property.addMemberPropertyFile(this.getPropertyFileName(fileName), (IFileItemHandle)fileHandle);
                            continue;
                        }
                        if (!this.isSourceFilePropertyFile(fileName)) continue;
                        property.setPropertyFile((IFileItemHandle)fileHandle);
                    }
                    this.propertyMap.put(childName, property);
                    continue;
                }
                if (!(childHandle instanceof IFileItemHandle) || !this.isSaveFilePropertyFile(childName)) continue;
                SimpleProperty property = new SimpleProperty();
                property.setPropertyFile((IFileItemHandle)childHandle);
                this.propertyMap.put(this.getPropertyFileName(childName), property);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IFileItemHandle getSourceFileAttributeFile(String sourceFileName) {
        ComplexProperty property = (ComplexProperty)this.propertyMap.get(sourceFileName);
        if (property != null) {
            return property.getPropertyFile();
        }
        return null;
    }

    private IFileItemHandle getMemberAttributeFile(String sourceFileName, String memberName) {
        ComplexProperty property = (ComplexProperty)this.propertyMap.get(sourceFileName);
        if (property != null) {
            return property.getMemberPropertyFile(memberName);
        }
        return null;
    }

    private IFileItemHandle getSaveFileAttributeFile(String saveFileName) {
        SimpleProperty property = this.propertyMap.get(saveFileName);
        if (property != null) {
            return property.getPropertyFile();
        }
        return null;
    }

    private void parseAttributes(IFileItemHandle attributeFile, Attributes defaultAttributes, IProgressMonitor monitor) {
        if (attributeFile != null) {
            try {
                IFileItem fileItem = (IFileItem)this.wsConnection.configuration(this.componentHandle).fetchCompleteItem((IVersionableHandle)attributeFile, monitor);
                InputStream is = FileSystemCore.getContentManager((ITeamRepository)this.teamRepository).retrieveContentStream((IFileItemHandle)fileItem, fileItem.getContent(), monitor);
                if (is != null) {
                    defaultAttributes.load(is);
                    defaultAttributes.setLastModification(fileItem.getFileTimestamp().getTime());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Attributes getMemberAttributes(String sourceFileName, String memberName, IProgressMonitor monitor) {
        Attributes attributes = this.getDefaultMemberAttributes();
        this.parseAttributes(this.getMemberAttributeFile(sourceFileName, memberName), attributes, monitor);
        return attributes;
    }

    public Attributes getSourceFileAttributes(String sourceFileName, IProgressMonitor monitor) {
        Attributes attributes = this.getDefaultSourceFileAttributes();
        this.parseAttributes(this.getSourceFileAttributeFile(sourceFileName), attributes, monitor);
        return attributes;
    }

    public Attributes getSaveFileAttributes(String saveFileName, IProgressMonitor monitor) {
        Attributes attributes = this.getDefaultSaveFileAttributes();
        this.parseAttributes(this.getSaveFileAttributeFile(saveFileName), attributes, monitor);
        return attributes;
    }

    private boolean isSourceFilePropertyFile(String name) {
        return name.toLowerCase().equals(".properties");
    }

    private boolean isMemberPropertyFile(String name) {
        return !this.isSourceFilePropertyFile(name) && name.toLowerCase().endsWith(".properties");
    }

    private boolean isSaveFilePropertyFile(String name) {
        return name.toLowerCase().endsWith(".savf.properties");
    }

    private String getPropertyFileName(String propertyFile) {
        return propertyFile.substring(0, propertyFile.lastIndexOf(46));
    }

    class ComplexProperty
    extends SimpleProperty {
        Map<String, IFileItemHandle> memberPropertyFiles;

        ComplexProperty() {
        }

        public void addMemberPropertyFile(String memberName, IFileItemHandle fileHandle) {
            if (this.memberPropertyFiles == null) {
                this.memberPropertyFiles = new HashMap<String, IFileItemHandle>();
            }
            this.memberPropertyFiles.put(memberName, fileHandle);
        }

        public IFileItemHandle getMemberPropertyFile(String memberName) {
            if (this.memberPropertyFiles == null) {
                return null;
            }
            return this.memberPropertyFiles.get(memberName);
        }
    }

    class SimpleProperty {
        IFileItemHandle propertyFile;

        SimpleProperty() {
        }

        public void setPropertyFile(IFileItemHandle fileHandle) {
            this.propertyFile = fileHandle;
        }

        public IFileItemHandle getPropertyFile() {
            return this.propertyFile;
        }
    }
}

