/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.teami.filesystem.client.internal.metadata.AbstractMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.LibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.MemberMetadata;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObjectMetadata
extends AbstractMetadata {
    protected LibraryMetadata libMetadata;
    protected List<MemberMetadata> mMetadatas;
    protected String type;
    protected String subType;

    public ObjectMetadata(String name, String type, String subType, LibraryMetadata libMetadata) {
        super(name, -1L, -1L, -1L, new Attributes());
        this.libMetadata = libMetadata;
        this.type = type;
        this.subType = subType;
        this.mMetadatas = new ArrayList<MemberMetadata>();
    }

    public void addMemberMetadata(MemberMetadata mMetadata) {
        this.mMetadatas.add(mMetadata);
    }

    public void setMemberMetadata(int index, MemberMetadata mMetadata) {
        if (index >= 0 && index < this.getMemberMetadataCount()) {
            this.mMetadatas.set(index, mMetadata);
        }
    }

    public void clearMemberMetadatas() {
        this.mMetadatas.clear();
    }

    public Iterator<MemberMetadata> memberMetadatas() {
        return this.mMetadatas.iterator();
    }

    public int getMemberMetadataCount() {
        return this.mMetadatas.size();
    }

    public boolean hasMemberMetadatas() {
        return this.getMemberMetadataCount() > 0;
    }

    public MemberMetadata getMemberMetadata(String name) {
        Iterator<MemberMetadata> iterator = this.memberMetadatas();
        while (iterator.hasNext()) {
            MemberMetadata member = iterator.next();
            if (!member.getName().equalsIgnoreCase(name)) continue;
            return member;
        }
        return null;
    }

    public int getMemberMetadataIndex(String name) {
        int count = this.getMemberMetadataCount();
        int i = 0;
        while (i < count) {
            MemberMetadata member = this.mMetadatas.get(i);
            if (member.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasMemberMetadata(String name) {
        return this.getMemberMetadataIndex(name) > -1;
    }

    public LibraryMetadata getLibraryMetadata() {
        return this.libMetadata;
    }

    public void setLibraryMetadata(LibraryMetadata libMetadata) {
        this.libMetadata = libMetadata;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    @Override
    public int origin() {
        return 2;
    }

    public boolean isSourceFile() {
        return FileSystemIUtil.isSourceFile(this.type, this.subType);
    }

    public boolean isSaveFile() {
        return FileSystemIUtil.isSaveFile(this.type, this.subType);
    }

    public boolean isModule() {
        return this.type.equals("*MODULE");
    }

    public boolean isProgram() {
        return this.type.equals("*PGM");
    }

    public boolean isServiceProgram() {
        return this.type.equals("*SRVPGM");
    }

    public boolean isOtherPhysicalFile() {
        return this.type.equals("*FILE") && !this.subType.equals("PF-SRC");
    }
}

