/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.teami.filesystem.client.internal.metadata.AbstractMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.ObjectMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.SourceFileMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class LibraryMetadata
extends AbstractMetadata {
    protected List<ObjectMetadata> objMetadatas = new ArrayList<ObjectMetadata>();

    public LibraryMetadata(String name) {
        super(name, -1L, -1L, -1L, new Attributes());
    }

    public void addObjectMetadata(ObjectMetadata pfMetadata) {
        this.objMetadatas.add(pfMetadata);
    }

    public void setObjectMetadata(int index, ObjectMetadata pfMetadata) {
        if (index >= 0 && index < this.objMetadatas.size()) {
            this.objMetadatas.set(index, pfMetadata);
        }
    }

    public Iterator<ObjectMetadata> objectMetadatas() {
        return this.objMetadatas.iterator();
    }

    public ObjectMetadata[] getObjectMetadatas(String type) {
        ArrayList<ObjectMetadata> results = new ArrayList<ObjectMetadata>();
        for (ObjectMetadata obj : this.objMetadatas) {
            if (!obj.getType().equalsIgnoreCase(type)) continue;
            results.add(obj);
        }
        return results.toArray(new ObjectMetadata[results.size()]);
    }

    public ObjectMetadata[] getObjectMetadatas(String type, String subType) {
        ArrayList<ObjectMetadata> results = new ArrayList<ObjectMetadata>();
        for (ObjectMetadata obj : this.objMetadatas) {
            if (!obj.getType().equalsIgnoreCase(type) || !obj.getSubType().equalsIgnoreCase(subType)) continue;
            results.add(obj);
        }
        return results.toArray(new ObjectMetadata[results.size()]);
    }

    public boolean hasObjectMetadatas() {
        return this.objMetadatas.size() > 0;
    }

    public ObjectMetadata getObjectMetadata(String name, String type, String subType) {
        for (ObjectMetadata obj : this.objMetadatas) {
            if (!obj.getName().equalsIgnoreCase(name) || !obj.getType().equalsIgnoreCase(type) || !obj.getSubType().equalsIgnoreCase(subType)) continue;
            return obj;
        }
        return null;
    }

    public ObjectMetadata getObjectMetadata(String name, String type) {
        for (ObjectMetadata obj : this.objMetadatas) {
            if (!obj.getName().equalsIgnoreCase(name) || !obj.getType().equalsIgnoreCase(type)) continue;
            return obj;
        }
        return null;
    }

    public int getObjectMetadataIndex(String name, String type) {
        int count = this.objMetadatas.size();
        int i = 0;
        while (i < count) {
            ObjectMetadata obj = this.objMetadatas.get(i);
            if (obj.getName().equalsIgnoreCase(name) && obj.getType().equalsIgnoreCase(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getObjectMetadataIndex(String name, String type, String subType) {
        int count = this.objMetadatas.size();
        int i = 0;
        while (i < count) {
            ObjectMetadata obj = this.objMetadatas.get(i);
            if (obj.getName().equalsIgnoreCase(name) && obj.getType().equalsIgnoreCase(type) && obj.getSubType().equalsIgnoreCase(subType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public SourceFileMetadata getSourceFileMetadata(String name) {
        return (SourceFileMetadata)this.getObjectMetadata(name, "*FILE", "PF-SRC");
    }

    public int getSourceFileMetadataIndex(String name) {
        int count = this.objMetadatas.size();
        int i = 0;
        while (i < count) {
            ObjectMetadata objFile = this.objMetadatas.get(i);
            if (objFile.getName().equalsIgnoreCase(name) && objFile.isSourceFile()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasObjectMetadata(ObjectMetadata object) {
        return this.hasObjectMetadata(object.getName(), object.getType(), object.getSubType());
    }

    public boolean hasObjectMetadata(String name, String type, String subType) {
        return this.getObjectMetadataIndex(name, type, subType) > -1;
    }
}

