/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.teami.filesystem.client.internal.metadata.MetadataConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class LibraryDirectoryMappings
implements MetadataConstants {
    private static final String MAP_FILE = "map.txt";
    private final MappingsCache mappingsCache;

    public LibraryDirectoryMappings(AS400 as400) {
        this.mappingsCache = new MappingsCache(as400);
    }

    public String getDirectory(String libraryName, boolean generateIfNotExist, IProgressMonitor monitor) throws IOException, AS400SecurityException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        if (!libraryName.startsWith("\"")) {
            return libraryName;
        }
        if (libraryName.equals(libraryName.toUpperCase())) {
            return libraryName.substring(1, libraryName.length() - 1);
        }
        if (!this.mappingsCache.isUpToDate()) {
            this.parse((IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        String directory = this.mappingsCache.getLibraryDirectory(libraryName);
        if (generateIfNotExist && directory == null) {
            directory = this.generateUniqueDirectoryName(this.mappingsCache.getMappingFile().getSystem(), libraryName);
            this.mappingsCache.setMapping(libraryName, directory);
            this.save((IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        monitor.done();
        return directory;
    }

    private void save(IProgressMonitor monitor) throws IOException, AS400SecurityException {
        if (this.mappingsCache.hasMappings()) {
            IFSFile remoteFile = this.mappingsCache.getMappingFile();
            IFSFileOutputStream ofs = new IFSFileOutputStream(remoteFile);
            this.mappingsCache.saveMappings((OutputStream)ofs);
            ofs.close();
            this.mappingsCache.setTimestamp(remoteFile.lastModified());
        }
    }

    private void parse(IProgressMonitor monitor) throws IOException, AS400SecurityException {
        IFSFile remoteFile = this.mappingsCache.getMappingFile();
        if (remoteFile.exists()) {
            IFSFileInputStream fis = new IFSFileInputStream(remoteFile);
            this.mappingsCache.loadMappings((InputStream)fis);
            this.mappingsCache.setTimestamp(remoteFile.lastModified());
            fis.close();
        }
    }

    private String generateUniqueDirectoryName(AS400 as400, String directory) throws IOException {
        String tempDirectory = this.stripOffQuotes(directory);
        int counter = 1;
        String uniqueDirectory = String.valueOf(tempDirectory) + "_" + counter++;
        IFSFile testFile = new IFSFile(as400, "/QIBM/UserData/.jazz/" + uniqueDirectory);
        while (testFile.exists()) {
            uniqueDirectory = String.valueOf(tempDirectory) + "_" + counter++;
            testFile = new IFSFile(as400, "/QIBM/UserData/.jazz/" + uniqueDirectory);
        }
        return uniqueDirectory;
    }

    private String stripOffQuotes(String libraryName) {
        if (libraryName == null) {
            return libraryName;
        }
        String temp = libraryName;
        if (temp.startsWith("\"")) {
            temp = temp.substring(1);
        }
        if (temp.endsWith("\"")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    class MappingsCache {
        Properties mappings;
        long timestamp;
        IFSFile mappingFile;

        public MappingsCache(AS400 as400) {
            this.mappingFile = new IFSFile(as400, "/QIBM/UserData/.jazz/map.txt");
            this.mappings = new Properties();
            this.timestamp = -1L;
        }

        public boolean hasMappings() {
            return !this.mappings.isEmpty();
        }

        public void saveMappings(OutputStream outputStream) throws IOException {
            this.mappings.store(outputStream, "");
        }

        public void loadMappings(InputStream inputStream) throws IOException {
            this.mappings.load(inputStream);
        }

        public void setMapping(String libraryName, String libraryDirectory) {
            this.mappings.setProperty(libraryName, libraryDirectory);
        }

        public String getLibraryDirectory(String libraryName) {
            return this.mappings.getProperty(libraryName);
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean isUpToDate() {
            block3: {
                try {
                    if (this.mappingFile.exists()) break block3;
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return this.timestamp >= this.mappingFile.lastModified();
        }

        public IFSFile getMappingFile() {
            return this.mappingFile;
        }
    }
}

