/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiHelperFactory;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSourceFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.LibraryDirectoryMappings;
import com.ibm.teami.filesystem.client.internal.metadata.LibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.MemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.MetadataConstants;
import com.ibm.teami.filesystem.client.internal.metadata.ObjectMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.SourceFileMetadata;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class IBMiMetadataWriter
implements MetadataConstants {
    private final AS400 as400;
    private final LibraryDirectoryMappings libDirMap;

    public IBMiMetadataWriter(AS400 as400) {
        this.as400 = as400;
        this.libDirMap = new LibraryDirectoryMappings(as400);
    }

    public boolean saveLibrary(LibraryMetadata library, boolean clearLib, IProgressMonitor monitor) throws Exception {
        return this.saveLibrary(library, clearLib, true, monitor);
    }

    private boolean saveLibrary(LibraryMetadata library, boolean clearLibrary, boolean saveMembers, IProgressMonitor monitor) throws Exception {
        boolean success = true;
        String libraryDirectoryName = this.libDirMap.getDirectory(library.getName(), true, monitor);
        String libraryPath = "/QIBM/UserData/.jazz/" + libraryDirectoryName;
        IFSFile libraryFolder = new IFSFile(this.as400, libraryPath);
        if (clearLibrary && libraryFolder.exists()) {
            this.deleteLibrary(libraryFolder);
        }
        if (!libraryFolder.exists()) {
            this.createFolder(libraryFolder);
        }
        String filePath = String.valueOf(libraryPath) + "/" + "iteminfo.dat";
        IFSFile itemInfoFile = new IFSFile(this.as400, filePath);
        DataOutputStream dos = new DataOutputStream((OutputStream)new IFSFileOutputStream(itemInfoFile));
        Iterator<ObjectMetadata> iterator = library.objectMetadatas();
        while (iterator.hasNext()) {
            ObjectMetadata objectFile = iterator.next();
            if (objectFile.isSourceFile()) {
                if (saveMembers) {
                    this.saveMembers((SourceFileMetadata)objectFile, monitor);
                }
                this.saveObject(dos, objectFile);
                continue;
            }
            if (!objectFile.isSaveFile()) continue;
            this.saveObject(dos, objectFile);
        }
        dos.close();
        return success;
    }

    public boolean saveSourceFile(IBMiSourceFileMetadata sourceFile, IProgressMonitor monitor) throws Exception {
        if (sourceFile == null || sourceFile.getLibraryMetadata() == null) {
            return false;
        }
        IBMiLibraryMetadata library = new IBMiLibraryMetadata(sourceFile.getLibraryMetadata().getName(), this.as400);
        IBMiHelperFactory.instance().getIFSMetadataReader(this.as400).getObjectsFromItemInfo(library, true, monitor);
        int index = library.getSourceFileMetadataIndex(sourceFile.getName());
        if (index == -1) {
            library.addObjectMetadata(sourceFile);
        } else {
            library.setObjectMetadata(index, sourceFile);
        }
        return IBMiHelperFactory.instance().getIFSMetadataWriter(this.as400).saveLibrary(library, false, true, monitor);
    }

    public boolean saveSaveFile(IBMiSaveFileMetadata saveFile, IProgressMonitor monitor) throws Exception {
        if (saveFile == null || saveFile.getLibraryMetadata() == null) {
            return false;
        }
        IBMiLibraryMetadata library = new IBMiLibraryMetadata(saveFile.getLibraryMetadata().getName(), this.as400);
        IBMiHelperFactory.instance().getIFSMetadataReader(this.as400).getObjectsFromItemInfo(library, false, monitor);
        int index = library.getObjectMetadataIndex(saveFile.getName(), "*FILE", "SAVF");
        if (index == -1) {
            library.addObjectMetadata(saveFile);
        } else {
            library.setObjectMetadata(index, saveFile);
        }
        return IBMiHelperFactory.instance().getIFSMetadataWriter(this.as400).saveLibrary(library, false, false, monitor);
    }

    private void saveObject(DataOutputStream dos, ObjectMetadata object) throws IOException {
        if (object != null) {
            dos.write(1);
            dos.writeUTF(object.getName());
            dos.write(5);
            dos.writeUTF(object.getType());
            dos.write(6);
            dos.writeUTF(object.getSubType());
            dos.write(2);
            dos.writeLong(object.getScmLastModification());
            dos.write(3);
            dos.writeLong(object.getIbmiMetadataLastModification());
            dos.write(4);
            dos.writeLong(object.getAttributesLastModification());
        }
    }

    public boolean saveMember(IBMiMemberMetadata member, long sourceFileTimestamp, long sourceFileAttributeTimestamp, IProgressMonitor monitor) throws Exception {
        if (member == null || member.getObjectMetadata() == null || member.getObjectMetadata().getLibraryMetadata() == null) {
            return false;
        }
        IBMiLibraryMetadata library = new IBMiLibraryMetadata(member.getObjectMetadata().getLibraryMetadata().getName(), this.as400);
        IBMiSourceFileMetadata sourceFile = new IBMiSourceFileMetadata(member.getObjectMetadata().getName(), sourceFileTimestamp, library, new Attributes(sourceFileAttributeTimestamp));
        if (sourceFileAttributeTimestamp == -2L) {
            sourceFile.setAttributes(new Attributes(-1L));
        }
        IBMiHelperFactory.instance().getIFSMetadataReader(this.as400).getMembersFromItemInfo(sourceFile, monitor);
        int index = sourceFile.getMemberMetadataIndex(member.getName());
        if (index == -1) {
            sourceFile.addMemberMetadata(member);
        } else {
            sourceFile.setMemberMetadata(index, member);
        }
        IBMiHelperFactory.instance().getIFSMetadataWriter(library.getAS400()).saveMembers(sourceFile, monitor);
        IBMiHelperFactory.instance().getIFSMetadataReader(library.getAS400()).getObjectsFromItemInfo(library, false, monitor);
        index = library.getSourceFileMetadataIndex(sourceFile.getName());
        if (index == -1) {
            library.addObjectMetadata(sourceFile);
        } else {
            if (sourceFileAttributeTimestamp == -2L) {
                SourceFileMetadata oldSourceFileMetadata = library.getSourceFileMetadata(sourceFile.getName());
                sourceFile.setAttributes(new Attributes(oldSourceFileMetadata.getAttributesLastModification()));
            }
            library.setObjectMetadata(index, sourceFile);
        }
        return IBMiHelperFactory.instance().getIFSMetadataWriter(this.as400).saveLibrary(library, false, false, monitor);
    }

    private boolean saveMembers(SourceFileMetadata sourceFile, IProgressMonitor monitor) {
        try {
            LibraryMetadata library = sourceFile.getLibraryMetadata();
            String libraryDirectoryName = this.libDirMap.getDirectory(library.getName(), true, monitor);
            String parentPath = "/QIBM/UserData/.jazz/" + libraryDirectoryName + "/" + sourceFile.getName();
            IFSFile parentFolder = new IFSFile(this.as400, parentPath);
            if (!parentFolder.exists()) {
                this.createFolder(parentFolder);
            }
            String filePath = String.valueOf(parentPath) + "/" + "iteminfo.dat";
            IFSFile itemInfoFile = new IFSFile(this.as400, filePath);
            DataOutputStream dos = new DataOutputStream((OutputStream)new IFSFileOutputStream(itemInfoFile));
            Iterator<MemberMetadata> iterator = sourceFile.memberMetadatas();
            while (iterator.hasNext()) {
                this.saveMember(dos, iterator.next());
            }
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean saveMember(DataOutputStream dos, MemberMetadata member) throws IOException {
        if (member == null) {
            return false;
        }
        dos.write(1);
        dos.writeUTF(member.getName());
        dos.write(2);
        dos.writeLong(member.getScmLastModification());
        dos.write(3);
        dos.writeLong(member.getIbmiMetadataLastModification());
        dos.write(4);
        dos.writeLong(member.getAttributesLastModification());
        return true;
    }

    protected boolean createFolder(IFSFile folder) {
        try {
            if (!folder.exists()) {
                return folder.mkdirs();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean deleteLibrary(IFSFile library) {
        try {
            if (library.exists()) {
                IFSFile[] files = library.listFiles();
                if (files != null) {
                    int i = 0;
                    while (i < files.length) {
                        IFSFile[] items;
                        if (files[i].isDirectory() && (items = files[i].listFiles("iteminfo.dat")) != null) {
                            int j = 0;
                            while (j < items.length) {
                                items[j].delete();
                                ++j;
                            }
                        }
                        files[i].delete();
                        ++i;
                    }
                }
                return library.delete();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

