/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.etools.iseries.comm.ISeriesListMembers;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesMemberFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostMemberBasic;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBrief;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiAttributesReader;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSaveFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiSourceFileMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.LibraryDirectoryMappings;
import com.ibm.teami.filesystem.client.internal.metadata.LibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.MemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.MetadataConstants;
import com.ibm.teami.filesystem.client.internal.metadata.ObjectMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.SourceFileMetadata;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.IIBMiPropertyKeyConstants;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class IBMiMetadataReader
implements MetadataConstants {
    private final AS400 as400;
    private final IBMiAttributesReader attrReader;
    private final LibraryDirectoryMappings libDirMap;

    public IBMiMetadataReader(AS400 as400) {
        this.as400 = as400;
        this.attrReader = new IBMiAttributesReader(as400);
        this.libDirMap = new LibraryDirectoryMappings(as400);
    }

    public boolean parseLibrary(IBMiLibraryMetadata library, IProgressMonitor monitor) throws Exception {
        IBMiLibraryMetadata metadataLibrary = new IBMiLibraryMetadata(library);
        boolean success1 = this.getObjectsFromItemInfo(metadataLibrary, false, monitor);
        boolean success2 = this.getObjectsFromFileSystem(library, metadataLibrary, monitor);
        return success1 || success2;
    }

    private boolean getObjectsFromFileSystem(IBMiLibraryMetadata library, IBMiLibraryMetadata metadataLibrary, IProgressMonitor monitor) throws Exception {
        IFSFile libDir = new IFSFile(this.as400, FileSystemIUtil.getRemotePath(library.getNameOnHost()));
        if (!libDir.exists()) {
            return false;
        }
        ISeriesListObjects pgm = new ISeriesListObjects(this.as400);
        List list = pgm.getListBrief((ISeriesAbstractFilterString)new ISeriesObjectFilterString(library.getNameOnHost()));
        int i = 0;
        while (i < list.size()) {
            ISeriesHostObjectBrief ishob = (ISeriesHostObjectBrief)list.get(i);
            ObjectMetadata object = metadataLibrary.getObjectMetadata(ishob.getName(), ishob.getType(), ishob.getSubType());
            if (object == null) {
                long ibmiFileTimestamp;
                if (FileSystemIUtil.isSourceFile(ishob.getType(), ishob.getSubType())) {
                    ibmiFileTimestamp = FileSystemIUtil.getHostObjectTimestamp(library.getNameOnHost(), ishob.getName(), ishob.getType(), ishob.getSubType(), this.as400);
                    object = new IBMiSourceFileMetadata(ishob.getName(), -1L, ibmiFileTimestamp, library, this.attrReader.getSourceFileAttributes(library.getNameOnHost(), ishob.getName(), monitor));
                    if (this.getMembers((SourceFileMetadata)object, monitor)) {
                        library.addObjectMetadata(object);
                    }
                } else if (FileSystemIUtil.isSaveFile(ishob.getType(), ishob.getSubType())) {
                    ibmiFileTimestamp = FileSystemIUtil.getHostObjectTimestamp(library.getNameOnHost(), ishob.getName(), ishob.getType(), ishob.getSubType(), this.as400);
                    object = new IBMiSaveFileMetadata(ishob.getName(), -1L, -1L, ibmiFileTimestamp, this.attrReader.getSaveFileAttributes(library.getNameOnHost(), ishob.getName(), monitor), library);
                    library.addObjectMetadata(object);
                } else {
                    object = new ObjectMetadata(ishob.getName(), ishob.getType(), ishob.getSubType(), library);
                    library.addObjectMetadata(object);
                }
            } else if (object.isSourceFile()) {
                if (this.getMembers((SourceFileMetadata)object, monitor)) {
                    library.addObjectMetadata(object);
                }
            } else if (object.isSaveFile()) {
                library.addObjectMetadata(object);
            }
            ++i;
        }
        return true;
    }

    public boolean getObjectsFromItemInfo(IBMiLibraryMetadata library, boolean parseMembers, IProgressMonitor monitor) throws Exception {
        String libraryDirectoryName = this.libDirMap.getDirectory(library.getName(), false, monitor);
        if (libraryDirectoryName == null) {
            return false;
        }
        IFSFile itemInfoFile = new IFSFile(this.as400, "/QIBM/UserData/.jazz/" + libraryDirectoryName + "/" + "iteminfo.dat");
        if (!itemInfoFile.exists()) {
            return false;
        }
        DataInputStream dis = new DataInputStream((InputStream)new IFSFileInputStream(itemInfoFile));
        ObjectMetadata object = null;
        do {
            if ((object = this.readObjectMetadata(dis, library, monitor)) == null || library.hasObjectMetadata(object)) continue;
            if (object.isSourceFile()) {
                if (parseMembers) {
                    if (!this.getMembers((SourceFileMetadata)object, monitor)) continue;
                    library.addObjectMetadata(object);
                    continue;
                }
                library.addObjectMetadata(object);
                continue;
            }
            if (!object.isSaveFile()) continue;
            library.addObjectMetadata(object);
        } while (object != null && dis.available() > 0);
        dis.close();
        return true;
    }

    private boolean getMembers(SourceFileMetadata sourceFile, IProgressMonitor monitor) throws Exception {
        IBMiSourceFileMetadata metadataSourceFile = new IBMiSourceFileMetadata(sourceFile.getName(), -1L, sourceFile.getLibraryMetadata(), null);
        boolean success1 = this.getMembersFromItemInfo(metadataSourceFile, monitor);
        boolean success2 = this.getMembersFromFileSystem(sourceFile, metadataSourceFile, monitor);
        return success1 || success2;
    }

    private boolean getMembersFromFileSystem(SourceFileMetadata sourceFile, SourceFileMetadata metadataSourceFile, IProgressMonitor monitor) throws Exception {
        String hostLibraryName = ((IBMiLibraryMetadata)sourceFile.getLibraryMetadata()).getNameOnHost();
        ISeriesListMembers pgm1 = new ISeriesListMembers(this.as400);
        List list = pgm1.getListBrief((ISeriesAbstractFilterString)new ISeriesMemberFilterString(String.valueOf(hostLibraryName) + "/" + sourceFile.getName()));
        for (ISeriesHostMemberBasic memberBasic : list) {
            MemberMetadata member;
            String memberName = memberBasic.getName();
            if (!memberBasic.getType().equals("")) {
                memberName = String.valueOf(memberName) + '.' + memberBasic.getType();
            }
            if ((member = metadataSourceFile.getMemberMetadata(memberName)) == null) {
                long ibmiFileTimestamp = FileSystemIUtil.convertLocal2UTC(memberBasic.getDateModified().getTime());
                Attributes attributes = this.attrReader.getDefaultMemberAttributes();
                attributes.setProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), memberBasic.getDescription());
                member = new IBMiMemberMetadata(memberName, -1L, -1L, ibmiFileTimestamp, attributes, sourceFile);
                sourceFile.addMemberMetadata(member);
                continue;
            }
            sourceFile.addMemberMetadata(member);
        }
        return true;
    }

    public boolean getMembersFromItemInfo(SourceFileMetadata sourceFile, IProgressMonitor monitor) throws Exception {
        LibraryMetadata library = sourceFile.getLibraryMetadata();
        String libraryDirectoryName = this.libDirMap.getDirectory(library.getName(), false, monitor);
        if (libraryDirectoryName == null) {
            return true;
        }
        IFSFile itemInfoFile = new IFSFile(this.as400, "/QIBM/UserData/.jazz/" + libraryDirectoryName + "/" + sourceFile.getName() + "/" + "iteminfo.dat");
        if (!itemInfoFile.exists()) {
            return true;
        }
        DataInputStream dis = new DataInputStream((InputStream)new IFSFileInputStream(itemInfoFile));
        MemberMetadata member = null;
        do {
            if ((member = this.readMetadata(dis, sourceFile, monitor)) == null) continue;
            sourceFile.addMemberMetadata(member);
        } while (member != null && dis.available() > 0);
        dis.close();
        return true;
    }

    private MemberMetadata readMetadata(DataInputStream dis, SourceFileMetadata sourceFile, IProgressMonitor monitor) throws Exception {
        int tag = dis.read();
        if (tag == 1) {
            String memberName = dis.readUTF();
            tag = dis.read();
            if (tag == 2) {
                long scmTimestamp = dis.readLong();
                tag = dis.read();
                if (tag == 3) {
                    long ibmiMetadataTimestamp = dis.readLong();
                    tag = dis.read();
                    if (tag == 4) {
                        long attributeTimestamp = dis.readLong();
                        String hostLibraryName = ((IBMiLibraryMetadata)sourceFile.getLibraryMetadata()).getNameOnHost();
                        Attributes attributes = this.attrReader.getMemberAttributes(hostLibraryName, sourceFile.getName(), FileSystemIUtil.stripFileExtension(memberName), monitor);
                        long ibmiFileTimestamp = this.attrReader.getLastModificationAttribute(attributes);
                        attributes = this.attrReader.filterMemberCompareAttributes(attributes);
                        attributes.setLastModification(attributeTimestamp);
                        return new IBMiMemberMetadata(memberName, scmTimestamp, ibmiMetadataTimestamp, ibmiFileTimestamp, attributes, sourceFile);
                    }
                }
            }
        }
        return null;
    }

    private ObjectMetadata readObjectMetadata(DataInputStream dis, IBMiLibraryMetadata library, IProgressMonitor monitor) throws Exception {
        int tag = dis.read();
        if (tag == 1) {
            String name = dis.readUTF();
            tag = dis.read();
            if (tag == 5) {
                String type = dis.readUTF();
                tag = dis.read();
                if (tag == 6) {
                    String subType = dis.readUTF();
                    tag = dis.read();
                    if (tag == 2) {
                        long scmTimestamp = dis.readLong();
                        tag = dis.read();
                        if (tag == 3) {
                            long ibmiMetadataTimestamp = dis.readLong();
                            tag = dis.read();
                            if (tag == 4) {
                                long attributeTimestamp = dis.readLong();
                                if (FileSystemIUtil.isSourceFile(type, subType)) {
                                    long ibmiFileTimestamp = FileSystemIUtil.getHostObjectTimestamp(library.getNameOnHost(), name, type, subType, this.as400);
                                    Attributes attributes = this.attrReader.getSourceFileAttributes(library.getNameOnHost(), name, monitor);
                                    attributes.setLastModification(attributeTimestamp);
                                    return new IBMiSourceFileMetadata(name, ibmiMetadataTimestamp, ibmiFileTimestamp, library, attributes);
                                }
                                if (FileSystemIUtil.isSaveFile(type, subType)) {
                                    long ibmiFileTimestamp = FileSystemIUtil.getHostObjectTimestamp(library.getNameOnHost(), name, type, subType, this.as400);
                                    Attributes attributes = this.attrReader.getSaveFileAttributes(library.getNameOnHost(), name, monitor);
                                    attributes.setLastModification(attributeTimestamp);
                                    return new IBMiSaveFileMetadata(name, scmTimestamp, ibmiMetadataTimestamp, ibmiFileTimestamp, attributes, library);
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }
}

