/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SequentialFile;
import com.ibm.teami.filesystem.client.internal.ISeriesCodepageConverter;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiLibraryMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.MemberMetadata;
import com.ibm.teami.filesystem.client.internal.metadata.ObjectMetadata;
import com.ibm.teami.filesystem.client.internal.operations.LoadICmd;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import java.util.HashMap;

public class IBMiMemberMetadata
extends MemberMetadata {
    public IBMiMemberMetadata(String name, long scmTimestamp, long ibmiMetadataTimestamp, long ibmiFileTimestamp, Attributes attributes, ObjectMetadata pfMetadata) {
        super(name, scmTimestamp, ibmiMetadataTimestamp, ibmiFileTimestamp, attributes, pfMetadata);
    }

    @Override
    public final int origin() {
        return 2;
    }

    public byte[] getContents(String ccsidmapping) throws Exception {
        String lineSeparator = System.getProperty("line.separator");
        ObjectMetadata objectFile = this.getObjectMetadata();
        IBMiLibraryMetadata library = (IBMiLibraryMetadata)objectFile.getLibraryMetadata();
        AS400 as400 = library.getAS400();
        StringBuffer buffer = new StringBuffer();
        int ccsid = FileSystemIUtil.getInstance().getEditingCCSID(FileSystemIUtil.getInstance().getLibraryName(as400, library.getName()), objectFile.getName(), as400);
        LoadICmd loadCmd = new LoadICmd(null, ccsidmapping, new HashMap<String, String>());
        ISeriesCodepageConverter converter = new ISeriesCodepageConverter(loadCmd.getMappedCcsid(ccsid), as400, false);
        SequentialFile seqFile = new SequentialFile(as400, FileSystemIUtil.getRemotePath(library.getName(), objectFile.getName(), this.getName()));
        seqFile.setRecordFormat();
        Record[] records = seqFile.readAll();
        int i = 0;
        while (i < records.length) {
            byte[] hostBytes = records[i].getContents();
            String line = converter.convHostBytesToClientString(hostBytes, 0, hostBytes.length);
            buffer.append(FileSystemIUtil.trailingTrim(line)).append(lineSeparator);
            ++i;
        }
        if (seqFile.isOpen()) {
            seqFile.close();
        }
        return buffer.toString().getBytes();
    }

    @Override
    public byte[] getContents() throws Exception {
        return this.getContents("");
    }
}

