/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.as400.access.AS400;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMetadataReader;
import com.ibm.teami.filesystem.client.internal.metadata.IBMiMetadataWriter;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IAutoLoadConnectionInfo;
import com.ibm.teami.scm.common.IAutoLoadConnectionInfoHandle;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.util.HashMap;
import java.util.Map;

public class IBMiHelperFactory {
    private final Map<String, AS400> connections = new HashMap<String, AS400>();
    private static IBMiHelperFactory instance;

    private IBMiHelperFactory() {
    }

    public static IBMiHelperFactory instance() {
        if (instance == null) {
            instance = new IBMiHelperFactory();
        }
        return instance;
    }

    public void setAS400(String hostName, String userName, String password, AS400 as400) {
        this.connections.put(this.generateUniqueId(hostName, userName, password), as400);
    }

    public AS400 getAS400(ITeamRepository repository, IWorkspaceHandle wsHandle) {
        try {
            IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
            IWorkspaceIHandle wsIHandle = clientLibrary.getWorkspaceI(wsHandle, null);
            if (wsIHandle != null) {
                IAutoLoadConnectionInfoHandle autoLoadConnectionInfoHandle = clientLibrary.getAutoLoadConnectionInfo(wsIHandle, null);
                IAutoLoadConnectionInfo autoLoadConnectionInfo = (IAutoLoadConnectionInfo)repository.itemManager().fetchCompleteItem((IItemHandle)autoLoadConnectionInfoHandle, 0, null);
                return this.getAS400(autoLoadConnectionInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public AS400 getAS400(String hostname, String username, String password) {
        if (hostname == null) {
            return new AS400();
        }
        AS400 connection = this.connections.get(this.generateUniqueId(hostname, username, password));
        if (connection == null) {
            connection = username == null ? new AS400(hostname) : (password == null ? new AS400(hostname, username) : new AS400(hostname, username, password));
            this.connections.put(this.generateUniqueId(hostname, username, password), connection);
        }
        return connection;
    }

    public AS400 getAS400(IAutoLoadConnectionInfo autoLoadConnectionInfo) {
        if (autoLoadConnectionInfo == null) {
            return new AS400();
        }
        return this.getAS400(autoLoadConnectionInfo.getHostname(), autoLoadConnectionInfo.getUserName(), autoLoadConnectionInfo.getPassword());
    }

    public AS400 getAS400(String hostname, String userId) {
        String searchString = String.valueOf(hostname) + "|";
        if (userId != null && !userId.equals("")) {
            searchString = String.valueOf(searchString) + userId + "|";
        }
        String key = null;
        for (String next : this.connections.keySet()) {
            if (!next.startsWith(searchString)) continue;
            key = next;
            break;
        }
        AS400 connection = null;
        if (key != null) {
            connection = this.connections.get(key);
        }
        if (connection == null) {
            connection = userId == null ? new AS400(hostname) : new AS400(hostname, userId);
        }
        return connection;
    }

    public IBMiMetadataReader getIFSMetadataReader(AS400 as400) {
        return new IBMiMetadataReader(as400);
    }

    public IBMiMetadataWriter getIFSMetadataWriter(AS400 as400) {
        return new IBMiMetadataWriter(as400);
    }

    private String generateUniqueId(String hostname, String username, String password) {
        return String.valueOf(hostname) + "|" + username + "|" + password;
    }
}

