/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal.metadata;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.ISeriesListMembers;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.ISeriesRetrieveDatabaseFileDescription;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesMemberFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostFormatDefinition;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostMemberBasic;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBrief;
import com.ibm.teami.filesystem.client.internal.metadata.Attributes;
import com.ibm.teami.filesystem.client.internal.metadata.DefaultAttributesReader;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.IIBMiPropertyKeyConstants;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class IBMiAttributesReader
extends DefaultAttributesReader {
    private final AS400 as400;

    public IBMiAttributesReader(AS400 as400) {
        this.as400 = as400;
    }

    public Attributes getSourceFileAttributes(String libraryName, String sourceFileName, IProgressMonitor monitor) {
        Attributes attributes = this.getDefaultSourceFileAttributes();
        try {
            ISeriesRetrieveDatabaseFileDescription pgm1 = new ISeriesRetrieveDatabaseFileDescription(this.as400);
            attributes.setProperty(IIBMiPropertyKeyConstants.KEY_CCSID.toString(), String.valueOf(pgm1.retrieveFileCCSID(libraryName, sourceFileName)));
            IISeriesHostFormatDefinition formatDefinition = pgm1.retrieveFormatDefinition(libraryName, sourceFileName, "*FIRST");
            attributes.setProperty(IIBMiPropertyKeyConstants.KEY_RECORD_LENGTH.toString(), String.valueOf(formatDefinition.getLength()));
            ISeriesListObjects pgm2 = new ISeriesListObjects(this.as400);
            List list = pgm2.getListBrief((ISeriesAbstractFilterString)new ISeriesObjectFilterString(String.valueOf(libraryName) + '/' + sourceFileName + " OBJTYPE(*FILE:PF-SRC)"));
            if (list.size() > 0) {
                ISeriesHostObjectBrief obj = (ISeriesHostObjectBrief)list.get(0);
                attributes.setProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), obj.getDescription());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributes;
    }

    public Attributes getSaveFileAttributes(String libraryName, String saveFileName, IProgressMonitor monitor) {
        Attributes attributes = this.getDefaultSourceFileAttributes();
        try {
            ISeriesListObjects pgm2 = new ISeriesListObjects(this.as400);
            List list = pgm2.getListBrief((ISeriesAbstractFilterString)new ISeriesObjectFilterString(String.valueOf(libraryName) + '/' + saveFileName + " OBJTYPE(*FILE:SAVF)"));
            if (list.size() > 0) {
                ISeriesHostObjectBrief obj = (ISeriesHostObjectBrief)list.get(0);
                attributes.setProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), obj.getDescription());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attributes;
    }

    public Attributes getMemberAttributes(String libraryName, String sourceFileName, String memberName, IProgressMonitor monitor) {
        Attributes attributes = this.getDefaultMemberAttributes();
        try {
            ISeriesListMembers pgm = new ISeriesListMembers(this.as400);
            List list = pgm.getList((ISeriesAbstractFilterString)new ISeriesMemberFilterString(String.valueOf(libraryName) + '/' + sourceFileName + '(' + memberName + ')'));
            if (list.size() > 0) {
                ISeriesHostMemberBasic obj = (ISeriesHostMemberBasic)list.get(0);
                attributes.setProperty(IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString(), obj.getDescription());
                long utcTimestamp = FileSystemIUtil.convertLocal2UTC(obj.getDateModified().getTime());
                attributes.put("KEY_LAST_MODIFIED_TIMESTAMP", new Long(utcTimestamp));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attributes;
    }

    public Attributes filterMemberCompareAttributes(Attributes attributes) {
        Attributes results = new Attributes(1L);
        String text_description_key = IIBMiPropertyKeyConstants.KEY_TEXT_DESCRIPTION.toString();
        String text_description_value = attributes.getProperty(text_description_key);
        if (text_description_value != null) {
            results.setProperty(text_description_key, text_description_value);
        }
        return results;
    }

    public long getLastModificationAttribute(Attributes attributes) {
        try {
            return (Long)attributes.get("KEY_LAST_MODIFIED_TIMESTAMP");
        }
        catch (Exception exception) {
            return -1L;
        }
    }
}

