/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.filesystem.client.internal;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.CharConverter;
import java.awt.Point;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class ISeriesCodepageConverter {
    public static final String Copyright = "(C) Copyright IBM Corp. 2002, 2003.  All Rights Reserved.";
    public static final int CCSID_NO_CONVERSION = 65535;
    public static final byte SHIFT_IN = 15;
    public static final byte SHIFT_OUT = 14;
    public static final byte EBCDIC_SPACE = 64;
    public static final char SOSI_SPLITTER = '\u200c';
    public static final String SOSI_SPLITTER_STRING = String.valueOf('\u200c');
    private static final List<Integer> mixedDBCSccsids = Arrays.asList(930, 932, 933, 934, 935, 936, 937, 938, 939, 942, 943, 944, 946, 948, 949, 950, 954, 956, 957, 958, 959, 964, 965, 970, 1363, 1364, 1381, 1383, 1386, 1388, 1399, 5026, 5035, 5050, 5052, 5053, 5054, 5055, 17354, 25546, 33722);
    private static final int EOR = -1;
    private int ccsid;
    private AS400 _as400;
    private CharConverter converter;
    private boolean leaveVisual = false;
    List<Integer> _stringIndices;

    public ISeriesCodepageConverter(AS400 as400) {
        this._as400 = as400;
    }

    public ISeriesCodepageConverter(AS400 as400, boolean leaveVisual) {
        this(as400);
        this.leaveVisual = leaveVisual;
    }

    public ISeriesCodepageConverter(int ccsid, AS400 as400, boolean leaveVisual) throws UnsupportedEncodingException {
        this(ccsid, as400);
        this.leaveVisual = leaveVisual;
    }

    public ISeriesCodepageConverter(int ccsid, AS400 as400) throws UnsupportedEncodingException {
        this(as400);
        this.ccsid = ccsid;
        this.converter = new CharConverter(ccsid, this._as400);
    }

    public AS400 getAS400Object() {
        return this._as400;
    }

    public void setAS400Object(AS400 as400) {
        this._as400 = as400;
    }

    public String convHostBytesToClientString(int sourceCCSID, byte[] source) throws UnsupportedEncodingException {
        if (AS400BidiTransform.isBidiCcsid((int)sourceCCSID) && (AS400BidiTransform.isVisual((int)sourceCCSID) || this.leaveVisual)) {
            ISeriesCodepageConverter bidiConverter = new ISeriesCodepageConverter(sourceCCSID, this._as400, this.leaveVisual);
            return bidiConverter.convHostBytesToClientString(source, 0, source.length);
        }
        return CharConverter.byteArrayToString((int)sourceCCSID, (AS400)this._as400, (byte[])source);
    }

    public String convHostBytesToClientString(byte[] source, int offset, int length) {
        return this.converter.byteArrayToString(source, offset, length);
    }

    @Deprecated
    public byte[] convHostBytesToClientBytes(int sourceCCSID, byte[] source) throws UnsupportedEncodingException {
        if (sourceCCSID == 65535) {
            return source;
        }
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && (AS400BidiTransform.isVisual((int)this.ccsid) || this.leaveVisual)) {
            ISeriesCodepageConverter bidiConverter = new ISeriesCodepageConverter(sourceCCSID, this._as400, this.leaveVisual);
            return bidiConverter.convHostBytesToClientString(source, 0, source.length).getBytes();
        }
        return CharConverter.byteArrayToString((int)sourceCCSID, (AS400)this._as400, (byte[])source).getBytes();
    }

    public byte[] convHostBytesToClientBytes(byte[] source, int offset, int length) throws UnsupportedEncodingException {
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && (AS400BidiTransform.isVisual((int)this.ccsid) || this.leaveVisual)) {
            return this.convHostBytesToClientString(source, offset, length).getBytes();
        }
        return this.converter.byteArrayToString(source, offset, length).getBytes();
    }

    public byte[] convHostBytesToClientBytesUTF8(int sourceCCSID, byte[] source) throws UnsupportedEncodingException {
        return this.convHostBytesToClientBytes(sourceCCSID, source, "UTF8");
    }

    public byte[] convHostBytesToClientBytesUTF8(byte[] source, int offset, int length) throws UnsupportedEncodingException {
        return this.convHostBytesToClientBytes(source, offset, length, "UTF8");
    }

    public byte[] convHostBytesToClientBytes(int sourceCCSID, byte[] source, String encoding) throws UnsupportedEncodingException {
        if (sourceCCSID == 65535) {
            return source;
        }
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && (AS400BidiTransform.isVisual((int)this.ccsid) || this.leaveVisual)) {
            ISeriesCodepageConverter bidiConverter = new ISeriesCodepageConverter(sourceCCSID, this._as400, this.leaveVisual);
            return bidiConverter.convHostBytesToClientString(source, 0, source.length).getBytes(encoding);
        }
        return CharConverter.byteArrayToString((int)sourceCCSID, (AS400)this._as400, (byte[])source).getBytes(encoding);
    }

    public byte[] convHostBytesToClientBytes(byte[] source, int offset, int length, String encoding) throws UnsupportedEncodingException {
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && (AS400BidiTransform.isVisual((int)this.ccsid) || this.leaveVisual)) {
            return this.convHostBytesToClientString(source, offset, length).getBytes(encoding);
        }
        return this.converter.byteArrayToString(source, offset, length).getBytes(encoding);
    }

    public byte[] convClientStringToHostBytes(int targetCCSID, String source) throws UnsupportedEncodingException {
        Vector<Point> overrideFormat = null;
        if (mixedDBCSccsids.contains(targetCCSID)) {
            source = this.removeSplitters(source);
            overrideFormat = this.getRecordFormat();
        }
        Vector<byte[]> result = new Vector<byte[]>();
        if (overrideFormat != null && !overrideFormat.isEmpty()) {
            int start = 0;
            int arrayLen = 0;
            int i = 0;
            while (i < overrideFormat.size()) {
                byte[] temp;
                Point point = overrideFormat.elementAt(i);
                int x = point.x;
                int y = point.y;
                if (y == -1) {
                    y = source.length();
                }
                if (start < x - 1) {
                    temp = CharConverter.stringToByteArray((int)targetCCSID, (AS400)this._as400, (String)source.substring(start, x - 1));
                    result.add(temp);
                    arrayLen += temp.length;
                    temp = CharConverter.stringToByteArray((int)targetCCSID, (AS400)this._as400, (String)source.substring(x - 1, y));
                    result.add(temp);
                    arrayLen += temp.length;
                    start = y;
                } else {
                    temp = CharConverter.stringToByteArray((int)targetCCSID, (AS400)this._as400, (String)source.substring(x - 1, y));
                    result.add(temp);
                    arrayLen += temp.length;
                    start = y;
                }
                ++i;
            }
            byte[] byteResult = new byte[arrayLen];
            int position = 0;
            int i2 = 0;
            while (i2 < result.size()) {
                int length = ((byte[])result.get(i2)).length;
                System.arraycopy(result.get(i2), 0, byteResult, position, length);
                position += length;
                ++i2;
            }
            return byteResult;
        }
        return CharConverter.stringToByteArray((int)targetCCSID, (AS400)this._as400, (String)source);
    }

    public byte[] convClientBytesToHostBytes(int targetCCSID, byte[] source) throws UnsupportedEncodingException {
        if (targetCCSID == 65535) {
            return source;
        }
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && (AS400BidiTransform.isVisual((int)this.ccsid) || this.leaveVisual)) {
            ISeriesCodepageConverter bidiConverter = new ISeriesCodepageConverter(targetCCSID, this._as400, this.leaveVisual);
            return bidiConverter.convClientBytesToHostBytes(source, 0, source.length);
        }
        return CharConverter.stringToByteArray((int)targetCCSID, (AS400)this._as400, (String)new String(source));
    }

    @Deprecated
    public byte[] convClientBytesToHostBytes(byte[] source, int offset, int length) throws UnsupportedEncodingException {
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && (AS400BidiTransform.isVisual((int)this.ccsid) || this.leaveVisual)) {
            return this.convClientStringToHostBytes(this.ccsid, new String(source, offset, length));
        }
        return this.converter.stringToByteArray(new String(source, offset, length));
    }

    public byte[] convClientBytesToHostBytesUTF8(int targetCCSID, byte[] source) throws UnsupportedEncodingException {
        return this.convClientBytesToHostBytes(targetCCSID, source, "UTF8");
    }

    public byte[] convClientBytesToHostBytesUTF8(byte[] source, int offset, int length) throws UnsupportedEncodingException {
        return this.convClientBytesToHostBytes(source, offset, length, "UTF8");
    }

    public byte[] convClientBytesToHostBytes(int targetCCSID, byte[] source, String encoding) throws UnsupportedEncodingException {
        if (targetCCSID == 65535) {
            return source;
        }
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && (AS400BidiTransform.isVisual((int)this.ccsid) || this.leaveVisual)) {
            ISeriesCodepageConverter bidiConverter = new ISeriesCodepageConverter(targetCCSID, this._as400, this.leaveVisual);
            return bidiConverter.convClientStringToHostBytes(targetCCSID, new String(source, encoding));
        }
        return CharConverter.stringToByteArray((int)targetCCSID, (AS400)this._as400, (String)new String(source, encoding));
    }

    public byte[] convClientBytesToHostBytes(byte[] source, int offset, int length, String encoding) throws UnsupportedEncodingException {
        if (AS400BidiTransform.isBidiCcsid((int)this.ccsid) && AS400BidiTransform.isVisual((int)this.ccsid)) {
            return this.convClientStringToHostBytes(this.ccsid, new String(source, offset, length, encoding));
        }
        return this.converter.stringToByteArray(new String(source, offset, length, encoding));
    }

    public String xlateNameToHostEquiv(String name) throws UnsupportedEncodingException {
        byte[] tempBytes = this.convClientStringToHostBytes(this._as400.getCcsid(), name);
        return this.convHostBytesToClientString(37, tempBytes);
    }

    public String xlateNameToVisualEquiv(String equivNameOnServer) throws UnsupportedEncodingException {
        if (equivNameOnServer.indexOf("$") >= 0 || equivNameOnServer.indexOf("@") >= 0 || equivNameOnServer.indexOf("#") >= 0 || equivNameOnServer.indexOf("\\") >= 0 || equivNameOnServer.indexOf("_") >= 0) {
            byte[] tempBytes = this.convClientStringToHostBytes(37, equivNameOnServer);
            return this.convHostBytesToClientString(this._as400.getCcsid(), tempBytes);
        }
        return equivNameOnServer;
    }

    public static String getEncoding(int ccsidVal) throws UnsupportedEncodingException {
        return new CharConverter(ccsidVal).getEncoding();
    }

    public static byte[] convertContiguousShiftInShiftOutToSpaces(byte[] input) {
        int i = 0;
        while (i < input.length - 1) {
            if (input[i] == 15 && input[i + 1] == 14 || input[i] == 14 && input[i + 1] == 15) {
                input[i] = 64;
                input[++i] = 64;
            }
            ++i;
        }
        return input;
    }

    private String removeSplitters(String line) {
        int found;
        StringBuffer lineBuf = new StringBuffer(line);
        this._stringIndices = new LinkedList<Integer>();
        int start = 0;
        do {
            if ((found = lineBuf.indexOf(SOSI_SPLITTER_STRING, start)) != -1) {
                lineBuf.deleteCharAt(found);
                this._stringIndices.add(found);
            }
            start = found;
        } while (found != -1);
        return lineBuf.toString();
    }

    private Vector<Point> getRecordFormat() {
        Vector<Point> points = new Vector<Point>();
        if (!this._stringIndices.isEmpty()) {
            Point lastPoint = new Point(this._stringIndices.get(0) + 1, -1);
            int i = 1;
            while (i < this._stringIndices.size()) {
                int index;
                lastPoint.y = index = this._stringIndices.get(i).intValue();
                points.add(lastPoint);
                lastPoint = new Point(index + 1, -1);
                ++i;
            }
            points.add(lastPoint);
        }
        return points;
    }
}

