/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.ui;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.ibmi.build.common.IBuildUtility;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.wizards.component.SelectSnapshotWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.teami.build.internal.ui.BaseLibraryListControlListener;
import com.ibm.teami.build.internal.ui.ProjectMappingControlListener;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.ui.BuildUIPlugin;
import com.ibm.teami.build.ui.IBMiPersonalBuildReferencedLibrariesControl;
import com.ibm.teami.build.ui.IBMiProjectMappingControl;
import com.ibm.teami.build.ui.Messages;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.IProjectInfo;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class IBMiRequestBuildSection
extends RequestBuildSection {
    public static final String PREFERENCE_WORKSPACE_PREFIX = "personalBuildWorkspace";
    public static final String PREFERENCE_BUILDPROPERTY_PREFIX = "personalBuildWorkspace_BuildProperty";
    public static final String PREFERENCE_BUILDORDER_PREFIX = "personalBuildWorkspace_BuildOrderProperty";
    public static final String PREFERENCE_LOADLIBRARY_PREFIX = "personalBuildWorkspace_LoadLibraryProperty";
    public static final String PREFERENCE_TARGETLIBRARY_PREFIX = "personalBuildWorkspace_TargetLibraryProperty";
    public static final String PREFERENCE_LOADALL_PREFIX = "personalBuildWorkspace_LoadAllProperty";
    public static final String PREFERENCE_LOADLATEST_PREFIX = "personalBuildWorkspace_LoadLatestProperty";
    public static final String PREFERENCE_LOADSINCESNAPSHOT_PREFIX = "personalBuildWorkspace_LoadSinceSnapshotProperty";
    public static final String PREFERENCE_SNAPSHOT_PREFIX = "personalBuildWorkspace_SnapshotProperty";
    public static final String PREFERENCE_REFERENCED_LIBRARIES_PREFIX = "personalBuildWorkspace_ReferencedLibraries";
    private Composite fIBMiBuildOptionsComposite;
    protected Button fPersonalBuildButton;
    protected Button fBrowseWorkspaceButton;
    protected Text fPersonalBuildWorkspaceText;
    protected Text fSnapshotNameText;
    private IWorkspace fPersonalBuildWorkspace;
    private IBMiProjectMappingControl fProjectMappingControl;
    private IBMiPersonalBuildReferencedLibrariesControl fReferencedLibrariesControl;
    private String buildPropertyValue;
    private String buildOrderValue;
    private String loadLibraryPropertyValue;
    private String targetLibraryPropertyValue;
    private String baseLiblProperty;
    private List<IFolderHandle> folderHandles;
    private List<String> projects;
    protected IBaselineSet fSnapshot;
    private Button loadLatestButton;
    private Button fSelectSnapshotButton;
    private Button loadAllButton;
    private Button loadSinceSnapshotButton;
    private Boolean loadLatest;
    private Boolean loadAll;
    private Boolean loadSinceSnapshot;
    private SelectionListener loadOptionsListener;

    public IBMiRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
    }

    protected String getSectionName() {
        return Messages.IBMiRequestBuildDialog_OPTIONS;
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        ((GridData)this.getSection().getLayoutData()).exclude = true;
        this.getSection().setVisible(false);
    }

    protected void createSectionContent(Section section) {
        if (this.fIBMiBuildOptionsComposite != null && !this.fIBMiBuildOptionsComposite.isDisposed()) {
            this.fIBMiBuildOptionsComposite.dispose();
        }
        this.fIBMiBuildOptionsComposite = new Composite((Composite)section, 0);
        this.fIBMiBuildOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 10;
        this.fIBMiBuildOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.fIBMiBuildOptionsComposite);
        if (this.hasIBMiJazzScmConfiguration()) {
            ((GridData)this.getSection().getLayoutData()).exclude = false;
            this.getSection().setVisible(true);
            this.fPersonalBuildButton = new Button(this.fIBMiBuildOptionsComposite, 32);
            this.fPersonalBuildButton.setText(Messages.IBMiRequestBuildDialog_PERSONAL_BUILD_BUTTON);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.fPersonalBuildButton.setLayoutData((Object)gridData);
            this.fPersonalBuildButton.addSelectionListener(this.getPersonalBuildButtonListener());
            boolean isPersonalBuild = this.getSite().isPersonalBuild();
            this.fPersonalBuildButton.setSelection(isPersonalBuild);
            Label label = new Label(this.fIBMiBuildOptionsComposite, 64);
            label.setText(Messages.IBMiRequestBuildDialog_PERSONAL_BUILD_DESCRIPTION);
            gridData = new GridData(768);
            gridData.horizontalIndent = 10;
            gridData.widthHint = 300;
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            label = new Label(this.fIBMiBuildOptionsComposite, 0);
            label.setText(Messages.IBMiRequestBuildDialog_REPOSITORY_WORKSPACE);
            GridDataFactory.swtDefaults().applyTo((Control)label);
            this.fPersonalBuildWorkspaceText = new Text(this.fIBMiBuildOptionsComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).applyTo((Control)this.fPersonalBuildWorkspaceText);
            this.fPersonalBuildWorkspaceText.setEnabled(isPersonalBuild);
            if (this.fPersonalBuildWorkspace != null) {
                this.fPersonalBuildWorkspaceText.setText(this.fPersonalBuildWorkspace.getName());
            }
            this.fBrowseWorkspaceButton = new Button(this.fIBMiBuildOptionsComposite, 8);
            this.fBrowseWorkspaceButton.setText(Messages.IBMiRequestBuildDialog_BROWSE_WORKSPACE);
            this.fBrowseWorkspaceButton.addSelectionListener(this.getBrowseWorkspaceButtonListener());
            this.fBrowseWorkspaceButton.setEnabled(isPersonalBuild);
            this.loadLatestButton = new Button(this.fIBMiBuildOptionsComposite, 16);
            this.loadLatestButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_LATEST_CHANGES_RADIO_LABEL);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.loadLatestButton.setLayoutData((Object)gridData);
            this.loadLatestButton.setSelection(this.loadLatest.booleanValue());
            this.loadLatestButton.addSelectionListener(this.getLoadOptionsSelectionListener());
            this.loadLatestButton.setEnabled(isPersonalBuild);
            this.loadAllButton = new Button(this.fIBMiBuildOptionsComposite, 16);
            this.loadAllButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_ALL_RADIO_LABEL);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.loadAllButton.setLayoutData((Object)gridData);
            this.loadAllButton.setSelection(this.loadAll.booleanValue());
            this.loadAllButton.addSelectionListener(this.getLoadOptionsSelectionListener());
            this.loadAllButton.setEnabled(isPersonalBuild);
            this.loadSinceSnapshotButton = new Button(this.fIBMiBuildOptionsComposite, 16);
            this.loadSinceSnapshotButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_SINCE_SNAPSHOT_RADIO_LABEL);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.loadSinceSnapshotButton.setLayoutData((Object)gridData);
            this.loadSinceSnapshotButton.setSelection(this.loadSinceSnapshot.booleanValue());
            this.loadSinceSnapshotButton.addSelectionListener(this.getLoadOptionsSelectionListener());
            this.loadSinceSnapshotButton.setEnabled(isPersonalBuild);
            Label snapshotLabel = new Label(this.fIBMiBuildOptionsComposite, 131072);
            snapshotLabel.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SNAPSHOT_LABEL);
            GridDataFactory.swtDefaults().applyTo((Control)snapshotLabel);
            this.fSnapshotNameText = new Text(this.fIBMiBuildOptionsComposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).applyTo((Control)this.fSnapshotNameText);
            this.fSnapshotNameText.setEnabled(this.loadSinceSnapshot != false && isPersonalBuild);
            this.fSnapshotNameText.setEditable(false);
            if (this.fSnapshot != null) {
                this.fSnapshotNameText.setText(this.fSnapshot.getName());
            }
            this.fSelectSnapshotButton = new Button(this.fIBMiBuildOptionsComposite, 0);
            this.fSelectSnapshotButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_SNAPSHOT_BUTTON_TITLE);
            this.fSelectSnapshotButton.addSelectionListener(this.getSelectSnapshotListener());
            this.fSelectSnapshotButton.setEnabled(this.loadSinceSnapshot != false && isPersonalBuild);
            this.createSpacer(this.fIBMiBuildOptionsComposite, 5, 3);
            label = new Label(this.fIBMiBuildOptionsComposite, 0);
            label.setText(Messages.IBMiRequestBuildDialog_iPROJECTMAPPINGS_LABEL);
            gridData = new GridData(768);
            gridData.widthHint = 300;
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            Composite fIBMiProjectMappingsComposite = new Composite(this.fIBMiBuildOptionsComposite, 0);
            GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(fIBMiProjectMappingsComposite);
            this.fProjectMappingControl = new IBMiProjectMappingControl(fIBMiProjectMappingsComposite);
            this.fProjectMappingControl.addListener(this.getProjectMappingControlListener());
            this.fProjectMappingControl.init(this.projects, this.buildPropertyValue, this.buildOrderValue, this.loadLibraryPropertyValue, this.targetLibraryPropertyValue, false);
            this.fProjectMappingControl.enable(isPersonalBuild);
            gridData = new GridData(768);
            gridData.heightHint = 150;
            gridData.horizontalSpan = 3;
            gridData.widthHint = 300;
            fIBMiProjectMappingsComposite.setLayoutData((Object)gridData);
            this.createSpacer(this.fIBMiBuildOptionsComposite, 5, 3);
            label = new Label(this.fIBMiBuildOptionsComposite, 0);
            label.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_BASELIBL);
            gridData = new GridData(768);
            gridData.widthHint = 300;
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            Composite fIBMiReferencedLibrariesComposite = new Composite(this.fIBMiBuildOptionsComposite, 0);
            GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(fIBMiReferencedLibrariesComposite);
            this.fReferencedLibrariesControl = new IBMiPersonalBuildReferencedLibrariesControl(fIBMiReferencedLibrariesComposite, this.baseLiblProperty);
            this.fReferencedLibrariesControl.addListener(this.getBaseLibraryListControlListener());
            this.fReferencedLibrariesControl.enable(isPersonalBuild && this.fPersonalBuildWorkspace != null);
            gridData = new GridData(768);
            gridData.heightHint = 180;
            gridData.horizontalSpan = 3;
            gridData.widthHint = 300;
            fIBMiReferencedLibrariesComposite.setLayoutData((Object)gridData);
        } else {
            Label noOptionsLabel = new Label(this.fIBMiBuildOptionsComposite, 64);
            noOptionsLabel.setText("There are no options available");
        }
    }

    protected ProjectMappingControlListener getProjectMappingControlListener() {
        ProjectMappingControlListener fProjectMappingControlListener = new ProjectMappingControlListener(){

            @Override
            public void projectMappingModified() {
                IBMiRequestBuildSection.this.buildPropertyValue = IBMiRequestBuildSection.this.fProjectMappingControl.getBuildProperty();
                IBMiRequestBuildSection.this.buildOrderValue = IBMiRequestBuildSection.this.fProjectMappingControl.getBuildOrderProperty();
                IBMiRequestBuildSection.this.loadLibraryPropertyValue = IBMiRequestBuildSection.this.fProjectMappingControl.getLoadLibProperty();
                IBMiRequestBuildSection.this.targetLibraryPropertyValue = IBMiRequestBuildSection.this.fProjectMappingControl.getTargetLibProperty();
                IBMiRequestBuildSection.this.getSite().revalidate();
            }
        };
        return fProjectMappingControlListener;
    }

    protected BaseLibraryListControlListener getBaseLibraryListControlListener() {
        BaseLibraryListControlListener fBaseLiblControlListener = new BaseLibraryListControlListener(){

            @Override
            public void baseLibraryListModified() {
                IBMiRequestBuildSection.this.baseLiblProperty = IBMiRequestBuildSection.this.fReferencedLibrariesControl.getBaseLibraryListProperty();
            }
        };
        return fBaseLiblControlListener;
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        if (this.hasIBMiJazzScmConfiguration() && this.getSite().isPersonalBuild()) {
            this.savePersonalBuildOptions();
            this.setPersonalBuildProperties(buildDefinition);
        }
    }

    private void setPersonalBuildProperties(IBuildDefinition buildDefinition) {
        IBuildProperty property = buildDefinition.getProperty("team.scm.workspaceUUID");
        property.setValue(this.fPersonalBuildWorkspace.getItemId().getUuidValue());
        buildDefinition.setProperty("teami.scm.baseLibraries", this.fReferencedLibrariesControl.getBaseLibraryListProperty());
        buildDefinition.setProperty("teami.scm.buildProjects", this.fProjectMappingControl.getBuildProperty());
        buildDefinition.setProperty("teami.scm.projectBuildOrder", this.fProjectMappingControl.getBuildOrderProperty());
        buildDefinition.setProperty("teami.scm.projectLoadDirectory", this.fProjectMappingControl.getLoadLibProperty());
        buildDefinition.setProperty("teami.scm.projectTargetDirectory", this.fProjectMappingControl.getTargetLibProperty());
        buildDefinition.setProperty("teami.scm.loadLatest", Boolean.toString(this.loadLatest));
        buildDefinition.setProperty("teami.scm.loadSnapshot", Boolean.toString(this.loadSinceSnapshot));
        buildDefinition.setProperty("teami.scm.loadAll", Boolean.toString(this.loadAll));
        if (this.loadSinceSnapshot.booleanValue()) {
            buildDefinition.setProperty("teami.scm.snapshotUUID", this.fSnapshot.getItemId().getUuidValue());
        }
        this.setWorkingCopy();
    }

    public void setWorkingCopy() {
        String loadLibrary = this.fProjectMappingControl.getLoadLibProperty();
        try {
            ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
            String workspaceUuid = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_WORKSPACE_PREFIX + this.getSite().getBuildDefinition().getId());
            IWorkspaceHandle handle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
            IScmIClientLibrary clientLibrary = (IScmIClientLibrary)repository.getClientLibrary(IScmIClientLibrary.class);
            IWorkspaceIHandle workspaceIHandle = clientLibrary.getWorkspaceI(handle, (IProgressMonitor)new NullProgressMonitor());
            if (workspaceIHandle == null) {
                workspaceIHandle = clientLibrary.createWorkspaceI(handle, null);
            }
            Hashtable loadLibPair = IBuildUtility.parseNameValuePairFormat((String)loadLibrary);
            ArrayList<String> libraries = new ArrayList<String>();
            for (String projectName : this.projects) {
                libraries.add((String)loadLibPair.get(projectName));
            }
            clientLibrary.setProjectToLibraryMappings(workspaceIHandle, this.folderHandles, libraries, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    public void handlePropertyChanged(String propertyName) {
        if ("buildDefinition".equals(propertyName)) {
            this.getSite().setProperty("personalBuild", (Object)false);
            this.setPersonalBuildWorkspace(null);
        }
    }

    protected synchronized void setPersonalBuildWorkspace(IWorkspace personalBuildWorkspace) {
        this.fPersonalBuildWorkspace = personalBuildWorkspace;
    }

    protected SelectionListener getPersonalBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isPersonalBuild = IBMiRequestBuildSection.this.fPersonalBuildButton.getSelection();
                IBMiRequestBuildSection.this.getSite().setProperty("personalBuild", (Object)isPersonalBuild);
                IBMiRequestBuildSection.this.fPersonalBuildWorkspaceText.setEnabled(isPersonalBuild);
                IBMiRequestBuildSection.this.fBrowseWorkspaceButton.setEnabled(isPersonalBuild);
                IBMiRequestBuildSection.this.fProjectMappingControl.enable(isPersonalBuild);
                IBMiRequestBuildSection.this.fReferencedLibrariesControl.enable(isPersonalBuild);
                IBMiRequestBuildSection.this.loadAllButton.setEnabled(isPersonalBuild);
                IBMiRequestBuildSection.this.loadLatestButton.setEnabled(isPersonalBuild);
                IBMiRequestBuildSection.this.loadSinceSnapshotButton.setEnabled(isPersonalBuild);
                if (IBMiRequestBuildSection.this.loadSinceSnapshot.booleanValue()) {
                    IBMiRequestBuildSection.this.fSelectSnapshotButton.setEnabled(isPersonalBuild);
                    IBMiRequestBuildSection.this.fSnapshotNameText.setEnabled(isPersonalBuild);
                }
            }
        };
    }

    protected SelectionListener getBrowseWorkspaceButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository teamRepository = IBMiRequestBuildSection.this.getSite().getTeamRepository();
                IWorkspace workspace = IBMiRequestBuildSection.this.openWorkspaceChooserDialog(IBMiRequestBuildSection.this.fBrowseWorkspaceButton.getShell(), teamRepository);
                if (!(workspace == null || IBMiRequestBuildSection.this.fPersonalBuildWorkspace != null && IBMiRequestBuildSection.this.fPersonalBuildWorkspace.getName().equals(workspace.getName()))) {
                    IBMiRequestBuildSection.this.fPersonalBuildWorkspace = workspace;
                    IBMiRequestBuildSection.this.fPersonalBuildWorkspaceText.setText(workspace.getName());
                    IBMiRequestBuildSection.this.projects = IBMiRequestBuildSection.this.getWorkspaceProjects();
                    IBMiRequestBuildSection.this.fProjectMappingControl.init(IBMiRequestBuildSection.this.projects, IBMiRequestBuildSection.this.buildPropertyValue, IBMiRequestBuildSection.this.buildOrderValue, IBMiRequestBuildSection.this.loadLibraryPropertyValue, IBMiRequestBuildSection.this.targetLibraryPropertyValue, true);
                    IBMiRequestBuildSection.this.getSite().revalidate();
                }
            }
        };
    }

    private SelectionListener getSelectSnapshotListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectSnapshotWizard wizard = new SelectSnapshotWizard(IBMiRequestBuildSection.this.getSite().getTeamRepository());
                WizardDialog dialog = new WizardDialog(IBMiRequestBuildSection.this.fSelectSnapshotButton.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    IBMiRequestBuildSection.this.fSnapshot = wizard.getSnapshot().getSnapshot();
                    IBMiRequestBuildSection.this.setSnapshotNameText(IBMiRequestBuildSection.this.fSnapshot.getName(), true);
                }
            }
        };
    }

    private void setSnapshotNameText(String snapshot, boolean hyperlinkEnablement) {
        this.fSnapshotNameText.setText(snapshot);
        this.fSnapshotNameText.setEnabled(hyperlinkEnablement);
        this.getSite().revalidate();
    }

    private SelectionListener getLoadOptionsSelectionListener() {
        if (this.loadOptionsListener != null) {
            return this.loadOptionsListener;
        }
        this.loadOptionsListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IBMiRequestBuildSection.this.fPersonalBuildButton.getSelection()) {
                    IBMiRequestBuildSection.this.loadLatest = IBMiRequestBuildSection.this.loadLatestButton.getSelection();
                    IBMiRequestBuildSection.this.loadAll = IBMiRequestBuildSection.this.loadAllButton.getSelection();
                    IBMiRequestBuildSection.this.loadSinceSnapshot = IBMiRequestBuildSection.this.loadSinceSnapshotButton.getSelection();
                    if (IBMiRequestBuildSection.this.loadSinceSnapshotButton.getSelection()) {
                        IBMiRequestBuildSection.this.fSnapshotNameText.setEnabled(true);
                        IBMiRequestBuildSection.this.fSelectSnapshotButton.setEnabled(true);
                    } else {
                        IBMiRequestBuildSection.this.fSnapshotNameText.setEnabled(false);
                        IBMiRequestBuildSection.this.fSelectSnapshotButton.setEnabled(false);
                    }
                    IBMiRequestBuildSection.this.getSite().revalidate();
                }
            }
        };
        return this.loadOptionsListener;
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    public void initializeLoadOptionsVariables(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPersonalBuildWorkspace != null) {
            if (this.getSite().isRebuild() && this.getSite().isPersonalBuild()) {
                this.initializeLoadOptionsVariables(this.getSite().getBuildRequest(), monitor);
            } else {
                this.loadLatest = Boolean.valueOf(BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_LOADLATEST_PREFIX + this.getSite().getBuildDefinition().getId()));
                this.loadAll = Boolean.valueOf(BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_LOADALL_PREFIX + this.getSite().getBuildDefinition().getId()));
                this.loadSinceSnapshot = Boolean.valueOf(BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_LOADSINCESNAPSHOT_PREFIX + this.getSite().getBuildDefinition().getId()));
                if (this.loadSinceSnapshot.booleanValue()) {
                    ITeamRepository teamRepository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
                    if (BuildUIPlugin.getDefault().getPreferenceStore().contains(PREFERENCE_SNAPSHOT_PREFIX + this.getSite().getBuildDefinition().getId())) {
                        IBaselineSetHandle baselineSetHandle = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_SNAPSHOT_PREFIX + this.getSite().getBuildDefinition().getId())), null);
                        this.fSnapshot = (IBaselineSet)teamRepository.itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, monitor);
                    }
                }
            }
        } else {
            BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_LOADALL_PREFIX + this.getSite().getBuildDefinition().getId(), "true");
            this.loadAll = true;
            this.loadLatest = false;
            this.loadSinceSnapshot = false;
        }
    }

    public void initializeLoadOptionsVariables(IBuildRequest buildRequest, IProgressMonitor monitor) throws TeamRepositoryException {
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty loadLatestProperty = instance.getProperty("teami.scm.loadLatest");
        IBuildProperty loadSnapshotProperty = instance.getProperty("teami.scm.loadSnapshot");
        IBuildProperty loadAllProperty = instance.getProperty("teami.scm.loadAll");
        this.loadAll = Boolean.valueOf(loadAllProperty.getValue());
        this.loadLatest = Boolean.valueOf(loadLatestProperty.getValue());
        this.loadSinceSnapshot = Boolean.valueOf(loadSnapshotProperty.getValue());
        if (this.loadSinceSnapshot.booleanValue()) {
            ITeamRepository teamRepository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
            String SnapshotUUIDPropertyValue = instance.getProperty("teami.scm.snapshotUUID").getValue();
            IBaselineSetHandle baselineSetHandle = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)SnapshotUUIDPropertyValue), null);
            this.fSnapshot = (IBaselineSet)teamRepository.itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, monitor);
        }
    }

    protected boolean hasIBMiJazzScmConfiguration() {
        return this.getSite().getBuildDefinition().getConfigurationElement("com.ibm.teami.build.jazzscm.iant") != null;
    }

    public void initializeProjectControlVariables() {
        this.buildPropertyValue = "";
        this.buildOrderValue = "";
        this.loadLibraryPropertyValue = "";
        this.targetLibraryPropertyValue = "";
        if (this.fPersonalBuildWorkspace != null) {
            this.projects = this.getWorkspaceProjects();
            if (this.getSite().isRebuild() && this.getSite().isPersonalBuild()) {
                this.initializeProjectControlVariables(this.getSite().getBuildRequest());
            } else {
                this.buildPropertyValue = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_BUILDPROPERTY_PREFIX + this.getSite().getBuildDefinition().getId());
                this.buildOrderValue = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_BUILDORDER_PREFIX + this.getSite().getBuildDefinition().getId());
                this.loadLibraryPropertyValue = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_LOADLIBRARY_PREFIX + this.getSite().getBuildDefinition().getId());
                this.targetLibraryPropertyValue = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_TARGETLIBRARY_PREFIX + this.getSite().getBuildDefinition().getId());
            }
        }
    }

    public void initializeProjectControlVariables(IBuildRequest buildRequest) {
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty buildProperty = instance.getProperty("teami.scm.buildProjects");
        IBuildProperty buildOrderProperty = instance.getProperty("teami.scm.projectBuildOrder");
        IBuildProperty loadLibraryProperty = instance.getProperty("teami.scm.projectLoadDirectory");
        IBuildProperty targetLibraryProperty = instance.getProperty("teami.scm.projectTargetDirectory");
        if (buildProperty != null && buildOrderProperty != null && loadLibraryProperty != null && targetLibraryProperty != null) {
            this.buildPropertyValue = buildProperty.getValue();
            this.buildOrderValue = buildOrderProperty.getValue();
            this.loadLibraryPropertyValue = loadLibraryProperty.getValue();
            this.targetLibraryPropertyValue = targetLibraryProperty.getValue();
        }
    }

    protected List<String> getWorkspaceProjects() {
        ArrayList<String> projectNames = new ArrayList<String>();
        ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
        String workspaceUuid = this.fPersonalBuildWorkspace.getItemId().getUuidValue();
        IWorkspaceHandle handle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
        this.folderHandles = new ArrayList<IFolderHandle>();
        if (handle == null || repository == null) {
            return projectNames;
        }
        try {
            List allProjects = FileSystemIUtil.getInstance().getIProjectsWithInfos(handle, repository, false);
            if (allProjects == null || allProjects.size() == 0) {
                return projectNames;
            }
            for (IProjectInfo projInfo : allProjects) {
                projectNames.add(projInfo.getName());
                this.folderHandles.add(projInfo.getFolderHandle());
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return projectNames;
    }

    public void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.hasIBMiJazzScmConfiguration()) {
            this.fPersonalBuildWorkspace = this.getSite().isRebuild() ? this.getWorkspace(this.getSite().getBuildRequest(), monitor) : this.getPersistedWorkspace(this.getSite().getBuildDefinition(), monitor);
            this.initializeProjectControlVariables();
            this.initializeLoadOptionsVariables(monitor);
            this.initializeReferencedLibraries();
        }
    }

    protected void initializeReferencedLibraries() {
        this.baseLiblProperty = "";
        if (this.fPersonalBuildWorkspace != null) {
            if (this.getSite().isRebuild() && this.getSite().isPersonalBuild()) {
                IBuildDefinitionInstance instance = this.getSite().getBuildRequest().getBuildDefinitionInstance();
                IBuildProperty buildProperty = instance.getProperty("teami.scm.baseLibraries");
                if (buildProperty != null) {
                    this.baseLiblProperty = buildProperty.getValue();
                }
            } else {
                this.baseLiblProperty = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_REFERENCED_LIBRARIES_PREFIX + this.getSite().getBuildDefinition().getId());
            }
        }
    }

    protected IWorkspace getPersistedWorkspace(IBuildDefinition buildDefinition, IProgressMonitor monitor) {
        String workspaceUuid = BuildUIPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_WORKSPACE_PREFIX + buildDefinition.getId());
        ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
        return this.getWorkspace(workspaceUuid, teamRepository, monitor);
    }

    protected IWorkspace getWorkspace(IBuildRequest buildRequest, IProgressMonitor monitor) {
        IWorkspace workspace = null;
        IBuildDefinitionInstance instance = buildRequest.getBuildDefinitionInstance();
        IBuildProperty property = instance.getProperty("team.scm.workspaceUUID");
        if (property != null) {
            ITeamRepository teamRepository = (ITeamRepository)buildRequest.getOrigin();
            String workspaceUuid = property.getValue();
            workspace = this.getWorkspace(workspaceUuid, teamRepository, monitor);
        }
        return workspace;
    }

    protected IWorkspace getWorkspace(String workspaceUuid, ITeamRepository teamRepository, IProgressMonitor monitor) {
        IWorkspace workspace = null;
        try {
            if (workspaceUuid != null && workspaceUuid.length() > 0) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
                workspace = this.fetchWorkspace(workspaceHandle, teamRepository, monitor);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return workspace;
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)teamRepository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    public void savePersonalBuildOptions() {
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_WORKSPACE_PREFIX + this.getSite().getBuildDefinition().getId(), this.fPersonalBuildWorkspace.getItemId().getUuidValue());
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_REFERENCED_LIBRARIES_PREFIX + this.getSite().getBuildDefinition().getId(), this.baseLiblProperty);
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_BUILDPROPERTY_PREFIX + this.getSite().getBuildDefinition().getId(), this.buildPropertyValue);
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_BUILDORDER_PREFIX + this.getSite().getBuildDefinition().getId(), this.buildOrderValue);
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_LOADLIBRARY_PREFIX + this.getSite().getBuildDefinition().getId(), this.loadLibraryPropertyValue);
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_TARGETLIBRARY_PREFIX + this.getSite().getBuildDefinition().getId(), this.targetLibraryPropertyValue);
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_LOADALL_PREFIX + this.getSite().getBuildDefinition().getId(), Boolean.toString(this.loadAll));
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_LOADLATEST_PREFIX + this.getSite().getBuildDefinition().getId(), Boolean.toString(this.loadLatest));
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_LOADSINCESNAPSHOT_PREFIX + this.getSite().getBuildDefinition().getId(), Boolean.toString(this.loadSinceSnapshot));
        if (this.loadSinceSnapshot.booleanValue()) {
            BuildUIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_SNAPSHOT_PREFIX + this.getSite().getBuildDefinition().getId(), this.fSnapshot.getItemId().getUuidValue());
        }
        BuildUIPlugin.getDefault().savePluginPreferences();
    }

    public String validate() {
        if (this.fPersonalBuildButton != null && this.fPersonalBuildButton.getSelection() && this.hasIBMiJazzScmConfiguration()) {
            if (this.fPersonalBuildWorkspace == null) {
                return Messages.IBMiRequestBuildDialog_PERSONAL_WORKSPACE_NOTSPECIFIED;
            }
            String mappingsValid = this.fProjectMappingControl.validate();
            if (mappingsValid != null) {
                return Messages.IBMiRequestBuildDialog_PERSONAL_INCOMPLETE_MAPPING;
            }
            if (this.loadSinceSnapshot.booleanValue() && this.fSnapshot == null) {
                return Messages.IBMiRequestBuildDialog_PERSONAL_SNAPSHOTNOTSPECIFIED;
            }
        }
        return null;
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = new Label(parent, 64);
        label.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        gridData.heightHint = height;
        label.setLayoutData((Object)gridData);
    }
}

