/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.ui;

import com.ibm.team.enterprise.ibmi.build.common.IBuildUtility;
import com.ibm.teami.build.internal.ui.BuildUIMessages;
import com.ibm.teami.build.internal.ui.ProjectMappingControlListener;
import com.ibm.teami.build.internal.ui.dialogs.ProjectMappingEntryDialog;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.internal.ui.editors.builddefinition.ProjectMapping;
import com.ibm.teami.build.internal.ui.editors.builddefinition.ProjectMappingTableContentProvider;
import com.ibm.teami.build.internal.ui.editors.builddefinition.ProjectMappingTableLabelProvider;
import com.ibm.teami.build.ui.Messages;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class IBMiProjectMappingControl {
    private List projects;
    private boolean foundNewProject = false;
    protected CheckboxTableViewer fTableViewer;
    protected Button fEditButton;
    protected Button fMoveUpButton;
    protected Button fMoveDownButton;
    protected List<ProjectMapping> projectMappingEntries;
    private Shell fParentShell;
    private ListenerList fListenerList = new ListenerList();

    public IBMiProjectMappingControl(Composite parent) {
        this.fParentShell = parent.getShell();
        Composite fComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(fComposite);
        Composite tableComposite = new Composite(fComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)tableComposite);
        Table table = new Table(tableComposite, 68386);
        TableColumnLayout tableLayout = new TableColumnLayout();
        String[] columnHeaders = new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_BUILD, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_PROJECT, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_LOADLIBRARY, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_TARGETLIBRARY};
        int[] columnWeights = new int[]{10, 25, 25, 25};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        this.fTableViewer = new CheckboxTableViewer(table);
        ProjectMappingTableContentProvider contentProvider = new ProjectMappingTableContentProvider();
        ProjectMappingTableLabelProvider labelProvider = new ProjectMappingTableLabelProvider();
        this.fTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.projectMappingEntries = this.computeProjectMappings(true, "", "", "", "");
        this.fTableViewer.setInput(this.projectMappingEntries);
        for (ProjectMapping mapping : this.projectMappingEntries) {
            this.fTableViewer.setChecked((Object)mapping, mapping.needBuild());
        }
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTableViewer.addCheckStateListener(this.getCheckStateListener());
        this.fTableViewer.addDoubleClickListener(this.getDoubleClickListener());
        Composite buttonBar = new Composite(fComposite, 0);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fEditButton = new Button(buttonBar, 8);
        this.fEditButton.setText(Messages.IBMiRequestBuildDialog_iPROJECTMAPPINGS_EDITBUTTON);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiProjectMappingControl.this.editMappingEntry();
            }
        });
        this.fMoveUpButton = new Button(buttonBar, 8);
        this.fMoveUpButton.setText(Messages.IBMiRequestBuildDialog_iPROJECTMAPPINGS_MOVEUPBUTTON);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiProjectMappingControl.this.moveEntries(true);
            }
        });
        this.fMoveDownButton = new Button(buttonBar, 8);
        this.fMoveDownButton.setText(Messages.IBMiRequestBuildDialog_iPROJECTMAPPINGS_MOVEDOWNBUTTON);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiProjectMappingControl.this.moveEntries(false);
            }
        });
    }

    private IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IBMiProjectMappingControl.this.editMappingEntry();
            }
        };
    }

    protected List<ProjectMapping> getProjectMappingEntries() {
        if (this.projectMappingEntries == null) {
            this.projectMappingEntries = new ArrayList<ProjectMapping>();
        }
        return this.projectMappingEntries;
    }

    public void init(List projects, String buildProperty, String buildOrderProperty, String loadLibProperty, String targetLibProperty, boolean newWorkspace) {
        this.projects = projects;
        this.projectMappingEntries = this.computeProjectMappings(newWorkspace, buildProperty, buildOrderProperty, loadLibProperty, targetLibProperty);
        this.fTableViewer.setInput(this.projectMappingEntries);
        for (ProjectMapping mapping : this.projectMappingEntries) {
            this.fTableViewer.setChecked((Object)mapping, mapping.needBuild());
        }
        this.enable(true);
    }

    public void enable(boolean enable) {
        if (enable) {
            this.fTableViewer.getTable().setEnabled(true);
            this.updatePropertyButtonEnablement();
        } else {
            this.fTableViewer.getTable().setEnabled(false);
            this.fEditButton.setEnabled(false);
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    protected ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectMapping mapping = (ProjectMapping)event.getElement();
                mapping.setNeedBuild(event.getChecked());
                IBMiProjectMappingControl.this.notifyMappingModified();
            }
        };
    }

    protected List<ProjectMapping> computeProjectMappings(boolean newWorkspace, String buildProperty, String buildOrderProperty, String loadLibProperty, String targetLibProperty) {
        if (this.projects == null || this.projects.size() == 0) {
            return new ArrayList<ProjectMapping>();
        }
        List<Object> projectOrderList = new ArrayList();
        if (newWorkspace) {
            ArrayList<ProjectMapping> newProjectMappingEntries = new ArrayList<ProjectMapping>();
            for (String projectName : this.projects) {
                ProjectMapping projectMapping = this.getProjectMapping(projectName, newWorkspace);
                newProjectMappingEntries.add(projectMapping);
            }
            this.projectMappingEntries = newProjectMappingEntries;
        } else {
            Iterator projectIter = this.projects.iterator();
            if (buildOrderProperty.trim().length() > 0) {
                projectOrderList = this.parseCompactFormat(buildOrderProperty);
            }
            List<String> buildProjectList = this.parseCompactFormat(buildProperty);
            Hashtable loadLibPair = IBuildUtility.parseNameValuePairFormat((String)loadLibProperty);
            Hashtable targetLibPair = IBuildUtility.parseNameValuePairFormat((String)targetLibProperty);
            while (projectIter.hasNext()) {
                String projectName = (String)projectIter.next();
                ProjectMapping projectMapping = this.getProjectMapping(projectName, newWorkspace);
                projectMapping.setNeedBuild(buildProjectList.contains(projectName));
                String loadLib = (String)loadLibPair.get(projectName);
                String targetLib = (String)targetLibPair.get(projectName);
                if (loadLib != null) {
                    projectMapping.setLoadLibrary(loadLib);
                }
                if (targetLib == null) continue;
                projectMapping.setTargetLibrary(targetLib);
            }
            if (projectOrderList.size() > 0) {
                int location = 0;
                int i = 0;
                while (i < projectOrderList.size()) {
                    int projectLocation = this.findProjectInProjectMappingList((String)projectOrderList.get(i));
                    if (projectLocation != -1) {
                        ProjectMapping mapping = this.projectMappingEntries.get(projectLocation);
                        this.projectMappingEntries.remove(projectLocation);
                        this.projectMappingEntries.add(location, mapping);
                        ++location;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.projectMappingEntries.size()) {
                    String projectMapName = this.projectMappingEntries.get(i).getProjectName();
                    boolean found = false;
                    int j = 0;
                    while (j < projectOrderList.size() && !found) {
                        String name = (String)projectOrderList.get(j);
                        if (name.equals(projectMapName)) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        this.projectMappingEntries.get(i).setNeedBuild(true);
                        this.foundNewProject = true;
                    }
                    ++i;
                }
            }
        }
        return this.projectMappingEntries;
    }

    public boolean foundNewProjectDuringInit() {
        return this.foundNewProject;
    }

    private int findProjectInProjectMappingList(String project) {
        int i = 0;
        while (i < this.projectMappingEntries.size()) {
            if (project.equals(this.projectMappingEntries.get(i).getProjectName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ProjectMapping getProjectMapping(String projectName, Boolean newWorkspace) {
        ProjectMapping projectMapping2;
        for (ProjectMapping projectMapping2 : this.getProjectMappingEntries()) {
            if (!projectMapping2.getProjectName().equals(projectName)) continue;
            return projectMapping2;
        }
        projectMapping2 = new ProjectMapping(projectName);
        if (!newWorkspace.booleanValue()) {
            this.projectMappingEntries.add(projectMapping2);
        }
        return projectMapping2;
    }

    protected List<String> parseCompactFormat(String concatedProjectNames) {
        String[] projects = concatedProjectNames.split(";;");
        ArrayList<String> projectNameList = new ArrayList<String>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            if (projectName.trim().length() > 0) {
                projectNameList.add(projectName);
            }
            ++n2;
        }
        return projectNameList;
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IBMiProjectMappingControl.this.updatePropertyButtonEnablement();
            }
        };
    }

    private void moveEntries(boolean up) {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (up) {
                for (ProjectMapping entry : structuredSelection) {
                    int orig = this.projectMappingEntries.indexOf(entry);
                    this.projectMappingEntries.remove(entry);
                    this.projectMappingEntries.add(orig - 1, entry);
                }
            } else {
                Vector<ProjectMapping> move = new Vector<ProjectMapping>();
                for (ProjectMapping entry : structuredSelection) {
                    move.add(0, entry);
                }
                int i = 0;
                while (i < move.size()) {
                    int orig = this.projectMappingEntries.indexOf(move.get(i));
                    this.projectMappingEntries.remove(move.get(i));
                    this.projectMappingEntries.add(orig + 1, (ProjectMapping)move.get(i));
                    ++i;
                }
            }
            this.fTableViewer.refresh();
            this.updatePropertyButtonEnablement();
            this.notifyMappingModified();
        }
    }

    private void editMappingEntry() {
        ISelection selection = this.fTableViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        ProjectMapping entry = (ProjectMapping)((IStructuredSelection)selection).getFirstElement();
        ProjectMappingEntryDialog dialog = new ProjectMappingEntryDialog(this.fParentShell, BuildUIMessages.ProjectMappingControl_EDIT_TITLE, entry);
        String oldTargetLib = entry.getTargetLibrary();
        String oldLoadLib = entry.getLoadLibrary();
        boolean oldBuildFlag = entry.needBuild();
        if (!(dialog.open() != 0 || entry.getLoadLibrary().equals(oldLoadLib) && entry.getTargetLibrary().equals(oldTargetLib) && entry.needBuild() == oldBuildFlag)) {
            this.fTableViewer.setChecked((Object)entry, entry.needBuild());
            this.fTableViewer.refresh();
            this.notifyMappingModified();
        }
    }

    private IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updatePropertyButtonEnablement() {
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fEditButton.setEnabled(selection.size() == 1);
        if (!selection.isEmpty()) {
            int size = selection.size();
            ProjectMapping first = (ProjectMapping)selection.getFirstElement();
            if (this.projectMappingEntries.indexOf(first) == 0) {
                this.fMoveUpButton.setEnabled(false);
            } else {
                this.fMoveUpButton.setEnabled(true);
            }
            if (this.projectMappingEntries.indexOf(first) + size == this.projectMappingEntries.size()) {
                this.fMoveDownButton.setEnabled(false);
            } else {
                this.fMoveDownButton.setEnabled(true);
            }
        } else {
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    public String getBuildProperty() {
        StringBuffer projBuildProperty = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (!mapping.needBuild()) continue;
            if (projBuildProperty.length() != 0) {
                projBuildProperty.append(";;");
            }
            projBuildProperty.append(mapping.getProjectName());
        }
        return projBuildProperty.toString();
    }

    public String getBuildOrderProperty() {
        StringBuffer buildOrder = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (buildOrder.length() != 0) {
                buildOrder.append(";;");
            }
            buildOrder.append(mapping.getProjectName());
        }
        return buildOrder.toString();
    }

    public String getLoadLibProperty() {
        StringBuffer projLoadLibrary = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (projLoadLibrary.length() != 0) {
                projLoadLibrary.append(";;");
            }
            projLoadLibrary.append(mapping.getProjectName());
            projLoadLibrary.append("=");
            projLoadLibrary.append(mapping.getLoadLibrary());
        }
        return projLoadLibrary.toString();
    }

    public String getTargetLibProperty() {
        StringBuffer projTargetLibrary = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (projTargetLibrary.length() != 0) {
                projTargetLibrary.append(";;");
            }
            projTargetLibrary.append(mapping.getProjectName());
            projTargetLibrary.append("=");
            projTargetLibrary.append(mapping.getTargetLibrary());
        }
        return projTargetLibrary.toString();
    }

    public void addListener(ProjectMappingControlListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeListener(ProjectMappingControlListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected void notifyMappingModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof ProjectMappingControlListener) {
                ProjectMappingControlListener listener = (ProjectMappingControlListener)listeners[i];
                listener.projectMappingModified();
            }
            ++i;
        }
    }

    public void cleanup() {
    }

    public String validate() {
        for (ProjectMapping entry : this.projectMappingEntries) {
            String loadLib = entry.getLoadLibrary();
            String targLib = entry.getTargetLibrary();
            if (loadLib != null && !loadLib.equals("") && targLib != null && !targLib.equals("") || !entry.needBuild()) continue;
            return BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_INVALID_STATE;
        }
        return null;
    }
}

