/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.ui;

import com.ibm.teami.build.internal.ui.BaseLibraryListControlListener;
import com.ibm.teami.build.internal.ui.BuildUIMessages;
import com.ibm.teami.build.internal.ui.dialogs.BaseLibraryListEntryDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractReferencedLibrariesControl {
    protected TableViewer fTableViewer;
    protected List<String> baseLibraryListEntries;
    protected Button fAddButton;
    protected Button fEditButton;
    protected Button fRemoveButton;
    protected Button fMoveUpButton;
    protected Button fMoveDownButton;
    protected Shell fParentShell;
    protected ListenerList fListenerList = new ListenerList();

    protected List<String> getBaseLibraryList(String baseLibraryListProperty) {
        ArrayList<String> v = new ArrayList<String>();
        if (baseLibraryListProperty != null && baseLibraryListProperty.length() > 0) {
            StringTokenizer st = new StringTokenizer(baseLibraryListProperty, new String(new char[]{' '}));
            while (st.hasMoreTokens()) {
                String lib = st.nextToken();
                v.add(lib);
            }
        }
        return v;
    }

    public String getBaseLibraryListProperty() {
        String libraryList = "";
        int i = 0;
        while (i < this.baseLibraryListEntries.size()) {
            libraryList = libraryList.concat(this.baseLibraryListEntries.get(i));
            if (i < this.baseLibraryListEntries.size() - 1) {
                libraryList = libraryList.concat(new String(new char[]{' '}));
            }
            ++i;
        }
        return libraryList;
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractReferencedLibrariesControl.this.updatePropertyButtonEnablement();
            }
        };
    }

    protected void updatePropertyButtonEnablement() {
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fEditButton.setEnabled(selection.size() == 1);
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        if (!selection.isEmpty()) {
            int size = selection.size();
            String first = (String)selection.getFirstElement();
            if (this.baseLibraryListEntries.indexOf(first) == 0) {
                this.fMoveUpButton.setEnabled(false);
            } else {
                this.fMoveUpButton.setEnabled(true);
            }
            if (this.baseLibraryListEntries.indexOf(first) + size == this.baseLibraryListEntries.size()) {
                this.fMoveDownButton.setEnabled(false);
            } else {
                this.fMoveDownButton.setEnabled(true);
            }
        } else {
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.editEntry();
    }

    private IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    protected void editEntry() {
        ISelection selection = this.fTableViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        String entry = (String)((IStructuredSelection)selection).getFirstElement();
        BaseLibraryListEntryDialog dialog = new BaseLibraryListEntryDialog(this.fParentShell, BuildUIMessages.BaseLibraryListControl_EDIT_TITLE, entry, this.baseLibraryListEntries, false);
        if (dialog.open() == 0) {
            int pos = this.baseLibraryListEntries.indexOf(entry);
            this.baseLibraryListEntries.remove(entry);
            this.baseLibraryListEntries.add(pos, dialog.getLibraryListEntry());
            this.fTableViewer.refresh();
            this.notifyBaseLibraryListTableModified();
        }
    }

    protected void notifyBaseLibraryListTableModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof BaseLibraryListControlListener) {
                BaseLibraryListControlListener listener = (BaseLibraryListControlListener)listeners[i];
                listener.baseLibraryListModified();
            }
            ++i;
        }
    }

    protected void addEntry() {
        BaseLibraryListEntryDialog dialog = this.getBuildPropertyDialog("");
        if (dialog.open() == 0) {
            this.baseLibraryListEntries.add(dialog.getLibraryListEntry());
            this.fTableViewer.refresh();
            this.notifyBaseLibraryListTableModified();
        }
    }

    protected void moveEntries(boolean up) {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (up) {
                for (String entry : structuredSelection) {
                    int orig = this.baseLibraryListEntries.indexOf(entry);
                    this.baseLibraryListEntries.remove(entry);
                    this.baseLibraryListEntries.add(orig - 1, entry);
                }
            } else {
                Vector<String> move = new Vector<String>();
                for (String entry : structuredSelection) {
                    move.add(0, entry);
                }
                int i = 0;
                while (i < move.size()) {
                    int orig = this.baseLibraryListEntries.indexOf(move.get(i));
                    this.baseLibraryListEntries.remove(move.get(i));
                    this.baseLibraryListEntries.add(orig + 1, (String)move.get(i));
                    ++i;
                }
            }
            this.fTableViewer.refresh();
            this.updatePropertyButtonEnablement();
            this.notifyBaseLibraryListTableModified();
        }
    }

    protected void removeSelectedEntries() {
        ISelection selection;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)this.fParentShell, (String)BuildUIMessages.BaseLibraryListControl_CONFIRM_TITLE, (String)BuildUIMessages.BaseLibraryListControl_CONFIRM);
        if (deleteConfirmed && (selection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<String> entriesRemoved = new ArrayList<String>();
            for (String entry : structuredSelection) {
                this.fTableViewer.remove((Object)entry);
                this.baseLibraryListEntries.remove(entry);
                entriesRemoved.add(entry);
            }
            if (!entriesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.updatePropertyButtonEnablement();
                this.notifyBaseLibraryListTableModified();
            }
        }
    }

    private BaseLibraryListEntryDialog getBuildPropertyDialog(String entry) {
        return new BaseLibraryListEntryDialog(this.fParentShell, BuildUIMessages.BaseLibraryListControl_ADD_TITLE, entry, this.baseLibraryListEntries, true);
    }

    public void addListener(BaseLibraryListControlListener baseLibraryListControlListener) {
        this.fListenerList.add((Object)baseLibraryListControlListener);
    }
}

