/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.teami.build.internal.ui.LibraryListControl;
import com.ibm.teami.build.internal.ui.LibraryListControlListener;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class QcmdConfigurationEditor
extends AbstractConfigurationElementEditor {
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Text fQcmdText;
    private Button fBuildEachChangedMember;
    private Button fBuildAllMembers;
    private Text fPrebuildText;
    private Text fPostbuildText;
    private Text fCurrLibText;
    private FormToolkit fToolkit;
    private LibraryListControl llc;
    private LibraryListControlListener fLibraryListListener = this.getLibraryListListener();
    private final String CMD_WARNING = "cmd.warning";
    private final String POST_CMD_WARNING = "post.cmd.warning";
    private final String PRE_CMD_WARNING = "pre.cmd.warning";
    private final String CURLIB_WARNING = "curlib.warning";
    private final String PLUGIN_ID = "com.ibm.teamp.build.ui";

    public QcmdConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected LibraryListControlListener getLibraryListListener() {
        return new LibraryListControlListener(){

            @Override
            public void libraryListModified() {
                String list = QcmdConfigurationEditor.this.llc.getLibraryListProperty();
                IBuildConfigurationElement element = QcmdConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.qcmd");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.librarylist");
                property.setValue(list);
                QcmdConfigurationEditor.this.setDirty(true);
            }
        };
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fQcmdText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fQcmdText.toString(), BuildDefinitionEditorMessages.SystemIConfigurationEditor_CMD_REQUIRED, (Control)this.fQcmdText);
            isValid = false;
        } else {
            String label;
            this.removeErrorMessage(this.fQcmdText.toString(), (Control)this.fQcmdText);
            if (!this.fBuildAllMembers.getSelection() && !this.fBuildEachChangedMember.getSelection() && this.containsSubstitutionVariables(this.fQcmdText.getText().trim())) {
                label = BuildDefinitionEditorMessages.SystemIConfigurationEditor_CMD_LABEL;
                if (label.indexOf(38) >= 0) {
                    label = String.valueOf(label.substring(0, label.indexOf(38))) + label.substring(label.indexOf(38) + 1);
                }
                if (label.indexOf(58) >= 0) {
                    label = label.substring(0, label.indexOf(58));
                }
                this.addErrorMessage("cmd.warning", NLS.bind((String)BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS, (Object)label), (IStatus)new Status(2, "com.ibm.teamp.build.ui", BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS_WARNING_CMD));
            } else {
                this.removeErrorMessage("cmd.warning");
            }
            if (this.containsSubstitutionVariables(this.fPrebuildText.getText().trim())) {
                label = BuildDefinitionEditorMessages.SystemIConfigurationEditor_PREBUILD_LABEL;
                if (label.indexOf(38) >= 0) {
                    label = String.valueOf(label.substring(0, label.indexOf(38))) + label.substring(label.indexOf(38) + 1);
                }
                if (label.indexOf(58) >= 0) {
                    label = label.substring(0, label.indexOf(58));
                }
                this.addErrorMessage("pre.cmd.warning", NLS.bind((String)BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS, (Object)label), (IStatus)new Status(2, "com.ibm.teamp.build.ui", BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS_WARNING_OTHER));
            } else {
                this.removeErrorMessage("pre.cmd.warning");
            }
            if (this.containsSubstitutionVariables(this.fPostbuildText.getText().trim())) {
                label = BuildDefinitionEditorMessages.SystemIConfigurationEditor_POSTBUILD_LABEL;
                if (label.indexOf(38) >= 0) {
                    label = String.valueOf(label.substring(0, label.indexOf(38))) + label.substring(label.indexOf(38) + 1);
                }
                if (label.indexOf(58) >= 0) {
                    label = label.substring(0, label.indexOf(58));
                }
                this.addErrorMessage("post.cmd.warning", NLS.bind((String)BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS, (Object)label), (IStatus)new Status(2, "com.ibm.teamp.build.ui", BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS_WARNING_OTHER));
            } else {
                this.removeErrorMessage("post.cmd.warning");
            }
            if (this.containsSubstitutionVariables(this.fCurrLibText.getText().trim())) {
                label = BuildDefinitionEditorMessages.SystemIConfigurationEditor_CURRENT_LIBRARY_LABEL;
                if (label.indexOf(38) >= 0) {
                    label = String.valueOf(label.substring(0, label.indexOf(38))) + label.substring(label.indexOf(38) + 1);
                }
                if (label.indexOf(58) >= 0) {
                    label = label.substring(0, label.indexOf(58));
                }
                this.addErrorMessage("curlib.warning", NLS.bind((String)BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS, (Object)label), (IStatus)new Status(2, "com.ibm.teamp.build.ui", BuildDefinitionEditorMessages.SystemIConfigurationEditor_CONTAINS_SUBS_VARS_WARNING_OTHER));
            } else {
                this.removeErrorMessage("curlib.warning");
            }
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean containsSubstitutionVariables(String trim) {
        return trim.contains("&L") || trim.contains("&F") || trim.contains("&N") || trim.contains("&T") || trim.contains("&S") || trim.contains("&A");
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.createBuildCommandsWidgets(parent);
        this.createBuildEnvironmentWidgets(parent);
        this.validate();
    }

    private ModifyListener getTextModifiedListenerRequired(final String prop, final Text txtBox) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QcmdConfigurationEditor.this.validate();
                IBuildConfigurationElement element = QcmdConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.qcmd");
                IConfigurationProperty property = element.getConfigurationProperty(prop);
                property.setValue(txtBox.getText().trim());
                QcmdConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getTextModifiedListenerOptional(final String prop, final Text txtBox) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QcmdConfigurationEditor.this.validate();
                IBuildConfigurationElement element = QcmdConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.qcmd");
                IConfigurationProperty property = element.getConfigurationProperty(prop);
                property.setValue(txtBox.getText().trim());
                QcmdConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildEachChangedMemberSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QcmdConfigurationEditor.this.validate();
                IBuildConfigurationElement element = QcmdConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.qcmd");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildEachChangedMember");
                property.setValue(Boolean.toString(QcmdConfigurationEditor.this.fBuildEachChangedMember.getSelection()));
                QcmdConfigurationEditor.this.setDirty(true);
                QcmdConfigurationEditor.this.fBuildAllMembers.setEnabled(!QcmdConfigurationEditor.this.fBuildEachChangedMember.getSelection());
            }
        };
    }

    protected SelectionListener getBuildAllMembersSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QcmdConfigurationEditor.this.validate();
                IBuildConfigurationElement element = QcmdConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.qcmd");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildAllMembers");
                property.setValue(Boolean.toString(QcmdConfigurationEditor.this.fBuildAllMembers.getSelection()));
                QcmdConfigurationEditor.this.setDirty(true);
                QcmdConfigurationEditor.this.fBuildEachChangedMember.setEnabled(!QcmdConfigurationEditor.this.fBuildAllMembers.getSelection());
            }
        };
    }

    private void createBuildCommandsWidgets(Composite parent) {
        Section fSection = this.fToolkit.createSection(parent, 384);
        fSection.setLayoutData((Object)new TableWrapData(256, 256));
        fSection.setLayout((Layout)new TableWrapLayout());
        fSection.setText(BuildDefinitionEditorMessages.SystemIConfigurationEditor_COMMANDS_SECTION_TITLE);
        fSection.setDescription(BuildDefinitionEditorMessages.SystemIConfigurationEditor_COMMANDS_SECTION_DESC);
        Composite composite = this.fToolkit.createComposite((Composite)fSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        fSection.setClient((Control)composite);
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.qcmd");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.command");
        this.createSpacer(composite, 5, 2);
        this.fQcmdText = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm") != null ? this.createLabeledText(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_CMD_LABEL, BuildDefinitionEditorMessages.SystemIConfigurationEditor_CMD_DESC, property.getValue()) : this.createLabeledText(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_CMD_LABEL, BuildDefinitionEditorMessages.SystemIConfigurationEditor_CMD_DESC_NO_JAZZSCM, property.getValue());
        this.fQcmdText.addModifyListener(this.getTextModifiedListenerRequired("com.ibm.teami.build.qcmd.command", this.fQcmdText));
        if (this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm") != null) {
            property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildEachChangedMember");
            this.fBuildEachChangedMember = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.SystemIConfigurationEditor_BUILDEACHCHANGEDMEMBER_LABEL, (Object)"com.ibm.teami.build.qcmd.buildEachChangedMember"), 32);
            TableWrapData layoutData = new TableWrapData(2, 32, 1, 2);
            this.fBuildEachChangedMember.setLayoutData((Object)layoutData);
            this.fBuildEachChangedMember.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
            this.fBuildEachChangedMember.addSelectionListener(this.getBuildEachChangedMemberSelectionListener());
            Label descriptionLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_BUILDEACHCHANGEDMEMBER_DESC, 64);
            descriptionLabel.setLayoutData((Object)new TableWrapData(2, 32, 1, 2));
            descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
            property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildAllMembers");
            this.fBuildAllMembers = this.fToolkit.createButton(composite, NLS.bind((String)BuildDefinitionEditorMessages.SystemIConfigurationEditor_BUILDALLMEMBERS_LABEL, (Object)"com.ibm.teami.build.qcmd.buildAllMembers"), 32);
            layoutData = new TableWrapData(2, 32, 1, 2);
            this.fBuildAllMembers.setLayoutData((Object)layoutData);
            this.fBuildAllMembers.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
            this.fBuildAllMembers.addSelectionListener(this.getBuildAllMembersSelectionListener());
            descriptionLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_BUILDALLMEMBERS_DESC, 64);
            descriptionLabel.setLayoutData((Object)new TableWrapData(2, 32, 1, 2));
            descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
            if (element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildAllMembers") != null) {
                this.fBuildEachChangedMember.setEnabled(Boolean.valueOf(element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildAllMembers").getValue()) == false);
            }
            if (element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildEachChangedMember") != null) {
                this.fBuildAllMembers.setEnabled(Boolean.valueOf(element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildEachChangedMember").getValue()) == false);
            }
        } else {
            element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildAllMembers").setValue("false");
            element.getConfigurationProperty("com.ibm.teami.build.qcmd.buildEachChangedMember").setValue("false");
        }
        this.createSpacer(composite, 5, 2);
        property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.prebuild");
        this.fPrebuildText = this.createLabeledText(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_PREBUILD_LABEL, BuildDefinitionEditorMessages.SystemIConfigurationEditor_PREBUILD_DESC, property.getValue());
        this.fPrebuildText.addModifyListener(this.getTextModifiedListenerOptional("com.ibm.teami.build.qcmd.prebuild", this.fPrebuildText));
        property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.postbuild");
        this.createSpacer(composite, 5, 2);
        this.fPostbuildText = this.createLabeledText(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_POSTBUILD_LABEL, BuildDefinitionEditorMessages.SystemIConfigurationEditor_POSTBUILD_DESC, property.getValue());
        this.fPostbuildText.addModifyListener(this.getTextModifiedListenerOptional("com.ibm.teami.build.qcmd.postbuild", this.fPostbuildText));
        this.createSpacer(composite, 5, 2);
    }

    private void createBuildEnvironmentWidgets(Composite parent) {
        Section fSection = this.fToolkit.createSection(parent, 384);
        fSection.setLayoutData((Object)new TableWrapData(256, 256));
        fSection.setLayout((Layout)new TableWrapLayout());
        fSection.setText(BuildDefinitionEditorMessages.SystemIConfigurationEditor_ENV_SECTION_TITLE);
        fSection.setDescription(BuildDefinitionEditorMessages.SystemIConfigurationEditor_ENV_SECTION_DESC);
        Composite composite = this.fToolkit.createComposite((Composite)fSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        fSection.setClient((Control)composite);
        this.createSpacer(composite, 5, 2);
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.qcmd");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.currentlibrary");
        this.fCurrLibText = this.createLabeledText(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_CURRENT_LIBRARY_LABEL, BuildDefinitionEditorMessages.SystemIConfigurationEditor_CURRENT_LIBRARY_DESC, property.getValue());
        this.fCurrLibText.addModifyListener(this.getTextModifiedListenerOptional("com.ibm.teami.build.qcmd.currentlibrary", this.fCurrLibText));
        property = element.getConfigurationProperty("com.ibm.teami.build.qcmd.librarylist");
        Label libListLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_LIBRARY_LIST_LABEL, 64);
        libListLabel.setLayoutData((Object)new TableWrapData(2, 32, 1, 2));
        Label descriptionLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.SystemIConfigurationEditor_LIBRARY_LIST_DESC, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(2, 32, 1, 2));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.llc = new LibraryListControl(parent, this.fToolkit, property.getValue(), true);
        this.llc.addListener(this.fLibraryListListener);
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.fToolkit.createLabel(parent, label);
        Text text = this.fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public void dispose() {
        super.dispose();
        if (this.llc != null) {
            this.llc.removeListener(this.fLibraryListListener);
        }
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionsystemiqcmd";
    }

    public Control getFocusControl() {
        return this.fQcmdText;
    }
}

