/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MakeConfigurationEditor
extends AbstractConfigurationElementEditor {
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Text fMakeCmdText;
    private Text fOptions;
    private Text fTargets;
    private Text fWorkingDir;
    private Text fMakefile;
    private FormToolkit fToolkit;

    public MakeConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.createBuildCommandsWidgets(parent);
        this.validate();
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fMakeCmdText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fMakeCmdText.toString(), BuildDefinitionEditorMessages.MakeConfigurationEditor_CMD_REQUIRED, (Control)this.fMakeCmdText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fMakeCmdText.toString(), (Control)this.fMakeCmdText);
        }
        if (this.fWorkingDir.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.fWorkingDir.toString(), BuildDefinitionEditorMessages.MakeConfigurationEditor_WORKINGDIR_REQUIRED, (Control)this.fWorkingDir);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fWorkingDir.toString(), (Control)this.fWorkingDir);
        }
        return isValid;
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.fToolkit.createLabel(parent, label);
        Text text = this.fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private ModifyListener getTextModifiedListenerRequired(final String prop, final Text txtBox) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MakeConfigurationEditor.this.validate();
                IBuildConfigurationElement element = MakeConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teamp.build.make");
                IConfigurationProperty property = element.getConfigurationProperty(prop);
                property.setValue(txtBox.getText().trim());
                MakeConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void createBuildCommandsWidgets(Composite parent) {
        Section fSection = this.fToolkit.createSection(parent, 384);
        fSection.setLayoutData((Object)new TableWrapData(256, 256));
        fSection.setLayout((Layout)new TableWrapLayout());
        fSection.setText(BuildDefinitionEditorMessages.MakeConfigurationEditor_COMMANDS_SECTION_TITLE);
        fSection.setDescription(BuildDefinitionEditorMessages.MakeConfigurationEditor_COMMANDS_SECTION_DESC);
        Composite composite = this.fToolkit.createComposite((Composite)fSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        fSection.setClient((Control)composite);
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teamp.build.make");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.teamp.build.cmdline.command");
        this.createSpacer(composite, 5, 2);
        this.fMakeCmdText = this.createLabeledText(composite, BuildDefinitionEditorMessages.MakeConfigurationEditor_CMD_LABEL, BuildDefinitionEditorMessages.MakeConfigurationEditor_CMD_DESC, property.getValue());
        this.fMakeCmdText.addModifyListener(this.getTextModifiedListenerRequired("com.ibm.teamp.build.cmdline.command", this.fMakeCmdText));
        this.createSpacer(composite, 5, 2);
        property = element.getConfigurationProperty("com.ibm.teamp.build.cmdline.makefile");
        this.fMakefile = this.createLabeledText(composite, BuildDefinitionEditorMessages.MakeConfigurationEditor_MAKEFILE_LABEL, BuildDefinitionEditorMessages.MakeConfigurationEditor_MAKEFILE_DESC, property.getValue());
        this.fMakefile.addModifyListener(this.getTextModifiedListenerRequired("com.ibm.teamp.build.cmdline.makefile", this.fMakefile));
        this.createSpacer(composite, 5, 2);
        property = element.getConfigurationProperty("com.ibm.teamp.build.cmdline.options");
        this.fOptions = this.createLabeledText(composite, BuildDefinitionEditorMessages.MakeConfigurationEditor_OPTIONS_LABEL, BuildDefinitionEditorMessages.MakeConfigurationEditor_OPTIONS_DESC, property.getValue());
        this.fOptions.addModifyListener(this.getTextModifiedListenerRequired("com.ibm.teamp.build.cmdline.options", this.fOptions));
        this.createSpacer(composite, 5, 2);
        property = element.getConfigurationProperty("com.ibm.teamp.build.cmdline.targets");
        this.fTargets = this.createLabeledText(composite, BuildDefinitionEditorMessages.MakeConfigurationEditor_TARGETS_LABEL, BuildDefinitionEditorMessages.MakeConfigurationEditor_TARGETS_DESC, property.getValue());
        this.fTargets.addModifyListener(this.getTextModifiedListenerRequired("com.ibm.teamp.build.cmdline.targets", this.fTargets));
        this.createSpacer(composite, 5, 2);
        property = element.getConfigurationProperty("com.ibm.teamp.build.cmdline.workingDir");
        this.fWorkingDir = this.createLabeledText(composite, BuildDefinitionEditorMessages.MakeConfigurationEditor_WORKINGDIR_LABEL, BuildDefinitionEditorMessages.MakeConfigurationEditor_WORKINGDIR_DESC, property.getValue());
        this.fWorkingDir.addModifyListener(this.getTextModifiedListenerRequired("com.ibm.teamp.build.cmdline.workingDir", this.fWorkingDir));
        this.createSpacer(composite, 5, 2);
    }
}

