/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.ui.BuildUIPlugin;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class JazzScmConfigurationEditor
extends AbstractConfigurationElementEditor {
    public static final String PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING = "showWorkspaceOwnerWarning";
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    protected Button fLoadEverythingButton;
    protected Button fLoadChangesOnlyButton;
    protected Button fClearBeforeLoadButton;
    protected Button fAcceptBeforeLoadButton;
    protected Button fLoadAndBuildOnlyIfChanges_EverythingButton;
    protected Button fLoadAndBuildOnlyIfChanges_ChangesButton;
    protected FormToolkit fToolkit;
    protected Hyperlink fWorkspaceTitleHyperlink;
    protected Text fWorkspaceNameText;
    protected Button fSelectWorkspaceButton;
    protected Button fCreateWorkspaceButton;
    protected IWorkspace fWorkspace;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    protected Button fDontShowWarningButton;

    public JazzScmConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, true);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.createWorkspaceNameWidgets(parent);
        this.createLoadAndAcceptOptionsWidgets(parent);
    }

    protected void createWorkspaceNameWidgets(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_REPOSITORY);
        section.setDescription(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.fWorkspaceTitleHyperlink = this.fToolkit.createHyperlink(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_LABEL, 0);
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fWorkspaceTitleHyperlink.getForeground();
        this.fWorkspaceTitleHyperlink.setLayoutData((Object)new TableWrapData());
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fWorkspaceNameText = this.fToolkit.createText(composite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fWorkspaceNameText.getForeground();
        this.fWorkspaceNameText.setEnabled(false);
        this.fWorkspaceNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fWorkspaceNameText.setLayoutData((Object)layoutData);
        this.fSelectWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_WORKSPACE_BUTTON_TITLE, 0);
        this.fSelectWorkspaceButton.addSelectionListener(this.getSelectWorkspaceListener());
        this.fSelectWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.fCreateWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CREATE_WORKSPACE_BUTTON_TITLE, 0);
        this.fCreateWorkspaceButton.addSelectionListener(this.getCreateWorkspaceListener());
        this.fCreateWorkspaceButton.setLayoutData((Object)new TableWrapData());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
        if (property.getValue().length() == 0) {
            this.setWorkspaceNameText("", false);
            return;
        }
        this.setWorkspaceNameText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PENDING, false);
        final IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)property.getValue()), null);
        String jobName = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                JazzScmConfigurationEditor.this.fWorkspace = JazzScmConfigurationEditor.this.fetchWorkspace(workspaceHandle, monitor);
                JazzScmConfigurationEditor.this.handleUpdateWorkspaceText(JazzScmConfigurationEditor.this.fWorkspace.getName());
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    JazzScmConfigurationEditor.this.handleFetchFailed(status);
                }
            }
        };
        job.schedule();
    }

    protected void handleFetchFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    String errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_FETCHING;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_DELETED;
                    }
                    JazzScmConfigurationEditor.this.setWorkspaceNameText(errorMessage, false);
                }
            }
        });
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.fWorkspaceTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fWorkspaceTitleHyperlink.setUnderlined(enabled);
        this.fWorkspaceTitleHyperlink.setEnabled(enabled);
    }

    private void setWorkspaceNameText(String text, boolean workspaceSet) {
        this.fWorkspaceNameText.setText(text);
        this.fWorkspaceNameText.setEnabled(workspaceSet);
        this.setWorkspaceTitleHyperlinkEnablement(workspaceSet);
    }

    private void createLoadAndAcceptOptionsWidgets(Composite parent) {
        this.createSpacer(parent, 5, 1);
        Section section = this.fToolkit.createSection(parent, 450);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_LOAD);
        section.setDescription(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_LOAD);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.fetchChangesOnly");
        this.fLoadChangesOnlyButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCH_CHANGES_DESC, 16);
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 4);
        this.fLoadChangesOnlyButton.setLayoutData((Object)layoutData);
        this.fLoadChangesOnlyButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fLoadChangesOnlyButton.addSelectionListener(this.getLoadChangesOnlySelectionListener());
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
        this.fLoadAndBuildOnlyIfChanges_ChangesButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_BUILD_ONLY_IF_CHANGES_CHANGES_DESC, 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        layoutData.indent = 30;
        this.fLoadAndBuildOnlyIfChanges_ChangesButton.setLayoutData((Object)layoutData);
        this.fLoadAndBuildOnlyIfChanges_ChangesButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fLoadAndBuildOnlyIfChanges_ChangesButton.addSelectionListener(this.getBuildOnlyIfChanges_ChangesSelectionListener());
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.fetchChangesOnly");
        this.fLoadEverythingButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCH_EVERYTHING_DESC, 16);
        layoutData = new TableWrapData(2, 32, 1, 4);
        this.fLoadEverythingButton.setLayoutData((Object)layoutData);
        this.fLoadEverythingButton.setSelection(Boolean.valueOf(property.getValue()) == false);
        this.fLoadEverythingButton.addSelectionListener(this.getLoadChangesOnlySelectionListener());
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.clearDestinationBeforeFetch");
        this.fClearBeforeLoadButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CLEAR_DESTINATION_DESC, 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        layoutData.indent = 30;
        this.fClearBeforeLoadButton.setLayoutData((Object)layoutData);
        this.fClearBeforeLoadButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fClearBeforeLoadButton.addSelectionListener(this.getClearBeforeLoadSelectionListener());
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
        this.fAcceptBeforeLoadButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ACCEPT_DESC, 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        layoutData.indent = 30;
        this.fAcceptBeforeLoadButton.setLayoutData((Object)layoutData);
        this.fAcceptBeforeLoadButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fAcceptBeforeLoadButton.addSelectionListener(this.getAcceptBeforeLoadSelectionListener());
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
        this.fLoadAndBuildOnlyIfChanges_EverythingButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_BUILD_ONLY_IF_CHANGES_EVERYTHING_DESC, 32);
        layoutData = new TableWrapData(2, 32, 1, 4);
        layoutData.indent = 60;
        this.fLoadAndBuildOnlyIfChanges_EverythingButton.setLayoutData((Object)layoutData);
        this.fLoadAndBuildOnlyIfChanges_EverythingButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fLoadAndBuildOnlyIfChanges_EverythingButton.addSelectionListener(this.getBuildOnlyIfChanges_EverythingSelectionListener());
        this.fLoadAndBuildOnlyIfChanges_EverythingButton.setEnabled(this.fAcceptBeforeLoadButton.getSelection());
        this.enableLoadWidgets(this.fLoadChangesOnlyButton.getSelection());
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                JazzScmConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.fWorkspace)));
        }
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void handleUpdateWorkspaceText(final String workspaceName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    JazzScmConfigurationEditor.this.setWorkspaceNameText(workspaceName, true);
                }
            }
        });
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fWorkspaceNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fWorkspaceNameText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_REQUIRED, (Control)this.fWorkspaceNameText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fWorkspaceNameText, (Control)this.fWorkspaceNameText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    protected SelectionListener getSelectWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.setWorkspace(JazzScmConfigurationEditor.this.openWorkspaceChooserDialog(JazzScmConfigurationEditor.this.fWorkspaceTitleHyperlink.getShell(), JazzScmConfigurationEditor.this.getTeamRepository()));
            }
        };
    }

    protected SelectionListener getCreateWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.openWorkspaceCreationDialog();
            }
        };
    }

    protected void setWorkspace(IWorkspace workspace) {
        if (workspace != null) {
            Dialog dialog;
            int result;
            this.fWorkspace = workspace;
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
            property.setValue(workspace.getItemId().getUuidValue());
            this.setWorkspaceNameText(workspace.getName(), true);
            this.validate();
            this.setDirty(true);
            if (this.shouldShowWorkspaceOwnerWarning() && (result = (dialog = this.getWorkspaceOwnerWarningDialog()).open()) == 0) {
                this.openWorkspaceEditor();
            }
            new Thread(){

                @Override
                public void run() {
                    if (JazzScmConfigurationEditor.this.shouldShowMappingWarning()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).JazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                                    return;
                                }
                                Dialog dialog = JazzScmConfigurationEditor.this.getProjectLibraryMappingWarningDialog();
                                dialog.open();
                            }
                        });
                    }
                }
            }.start();
        }
    }

    private boolean shouldShowMappingWarning() {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID").getValue()), null);
        try {
            if (!FileSystemIUtil.getInstance().getNonMappedIProjects(workspaceHandle, this.getTeamRepository(), null).isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean shouldShowWorkspaceOwnerWarning() {
        return BuildUIPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING);
    }

    protected Dialog getWorkspaceOwnerWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_TITLE, null, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_MESSAGE, 2, new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPEN_WORKSPACE_BUTTON, IDialogConstants.OK_LABEL}, 1){

            protected Control createCustomArea(Composite parent) {
                new Label(parent, 0);
                JazzScmConfigurationEditor.this.fDontShowWarningButton = new Button(parent, 32);
                JazzScmConfigurationEditor.this.fDontShowWarningButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DONT_SHOW_WARNING_AGAIN);
                JazzScmConfigurationEditor.this.fDontShowWarningButton.addSelectionListener(JazzScmConfigurationEditor.this.getDontShowWarningButtonListener());
                return JazzScmConfigurationEditor.this.fDontShowWarningButton;
            }
        };
    }

    protected Dialog getProjectLibraryMappingWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_LIBRARY_MAPPING_WARNING_TITLE, null, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_LIBRARY_MAPPING_WARNING_MESSAGE, 2, new String[]{IDialogConstants.OK_LABEL}, 0){};
    }

    protected SelectionListener getDontShowWarningButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue(JazzScmConfigurationEditor.PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, !JazzScmConfigurationEditor.this.fDontShowWarningButton.getSelection());
                BuildUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    protected SelectionListener getClearBeforeLoadSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.clearDestinationBeforeFetch");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fClearBeforeLoadButton.getSelection()));
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getLoadChangesOnlySelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.fetchChangesOnly");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fLoadChangesOnlyButton.getSelection()));
                if (JazzScmConfigurationEditor.this.fLoadChangesOnlyButton.getSelection()) {
                    property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
                    property.setValue(Boolean.toString(true));
                } else {
                    property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
                    property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection()));
                    if (!JazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection()) {
                        JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setSelection(false);
                        JazzScmConfigurationEditor.this.getBuildOnlyIfChanges_EverythingSelectionListener().widgetSelected(null);
                    }
                }
                JazzScmConfigurationEditor.this.enableLoadWidgets(JazzScmConfigurationEditor.this.fLoadChangesOnlyButton.getSelection());
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void enableLoadWidgets(boolean changes) {
        this.enableLoadChangesOptions(changes);
        this.enableLoadEverythingOptions(!changes);
    }

    private void enableLoadEverythingOptions(boolean enable) {
        this.fClearBeforeLoadButton.setEnabled(enable);
        this.fAcceptBeforeLoadButton.setEnabled(enable);
        if (!enable) {
            this.fLoadAndBuildOnlyIfChanges_EverythingButton.setEnabled(enable);
        }
        if (this.fAcceptBeforeLoadButton.getSelection()) {
            this.fLoadAndBuildOnlyIfChanges_EverythingButton.setEnabled(enable);
        }
    }

    private void enableLoadChangesOptions(boolean enable) {
        this.fLoadAndBuildOnlyIfChanges_ChangesButton.setEnabled(enable);
    }

    protected SelectionListener getAcceptBeforeLoadSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection()));
                JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setSelection(JazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection());
                JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setEnabled(JazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection());
                JazzScmConfigurationEditor.this.getBuildOnlyIfChanges_EverythingSelectionListener().widgetSelected(null);
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChanges_ChangesSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_ChangesButton.getSelection()));
                JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setSelection(JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_ChangesButton.getSelection());
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChanges_EverythingSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JazzScmConfigurationEditor.this.validate();
                IBuildProperty property = JazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
                property.setValue(Boolean.toString(JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.getSelection()));
                JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_ChangesButton.setSelection(JazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.getSelection());
                JazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, (boolean)false, null, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected void openWorkspaceCreationDialog() {
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)this), this.getTeamRepository(), false, (IPartResult)new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper result) {
                JazzScmConfigurationEditor.this.setWorkspace(result.getWorkspace());
            }
        }, true, (IReadScope)IReadScope.FACTORY.createPublicScope());
        new WizardDialog(this.fWorkspaceTitleHyperlink.getShell(), (IWizard)wizard).open();
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public Control getFocusControl() {
        return this.fSelectWorkspaceButton;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionsystemijazzscm";
    }
}

