/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.ibmi.build.common.IBuildUtility;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.FileSelectionDialog;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.wizards.component.SelectSnapshotWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.teami.build.internal.ui.BaseLibraryListControl;
import com.ibm.teami.build.internal.ui.BaseLibraryListControlListener;
import com.ibm.teami.build.internal.ui.ProjectMappingControl;
import com.ibm.teami.build.internal.ui.ProjectMappingControlListener;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.ui.BuildUIPlugin;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.IProjectInfo;
import com.ibm.teami.scm.client.IScmIClientLibrary;
import com.ibm.teami.scm.common.IWorkspaceIHandle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.progress.UIJob;

public class IBMiAntJazzScmConfigurationEditor
extends AbstractConfigurationElementEditor {
    public static final String PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING = "showWorkspaceOwnerWarning";
    public static final String VAR_SEARCH = "&SP";
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    protected Button fLoadEverythingButton;
    protected Button fLoadChangesOnlyButton;
    protected Button fClearBeforeLoadButton;
    protected Button fAcceptBeforeLoadButton;
    protected Button fLoadAndBuildOnlyIfChanges_EverythingButton;
    protected Button fLoadAndBuildOnlyIfChanges_ChangesButton;
    protected FormToolkit fToolkit;
    protected Hyperlink fWorkspaceTitleHyperlink;
    protected Text fWorkspaceNameText;
    protected Button fSelectWorkspaceButton;
    protected Button fCreateWorkspaceButton;
    protected IWorkspace fWorkspace;
    protected Hyperlink fSnapshotTitleHyperlink;
    protected Text fSnapshotNameText;
    protected Button fSelectSnapshotButton;
    protected IBaselineSet fSnapshot;
    protected Button loadAllButton;
    protected Button loadSinceSnapshotButton;
    protected Button loadLatestButton;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    protected Button fDontShowWarningButton;
    private ProjectMappingControl projMapControl;
    private ProjectMappingControlListener fProjectMappingControlListener;
    private BaseLibraryListControl baseLiblControl;
    private BaseLibraryListControlListener fBaseLiblControlListener;
    private IWorkspaceHandle workspaceHandle;
    private List<IFolderHandle> folderHandles;
    private ArrayList<String> projectNames;
    private boolean firstTime = true;

    public IBMiAntJazzScmConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, true);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        parent.setLayout((Layout)layout);
        this.createWorkspaceNameWidgets(parent);
        this.createLoadOptionWidgets(parent);
        this.createProjectToLibraryMappingsAndBuildOrderWidgets(parent);
        this.createBaseLiblTableWidgets(parent);
    }

    private void createBaseLiblTableWidgets(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_BASELIBL);
        section.setDescription(NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_BASELIBL, (Object)VAR_SEARCH));
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildConfigurationElement buildConfig = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
        IConfigurationProperty baseLibraryListproperty = buildConfig.getConfigurationProperty("teami.scm.baseLibraries");
        String baseLiblProperty = baseLibraryListproperty.getValue();
        this.baseLiblControl = new BaseLibraryListControl(composite, this.fToolkit, baseLiblProperty);
        this.baseLiblControl.addListener(this.getBaseLibraryListControlListener());
    }

    private void createLoadOptionWidgets(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_SNAPSHOT);
        section.setDescription(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_SNAPSHOT2);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildConfigurationElement buildConfig = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
        IConfigurationProperty loadLatestProperty = buildConfig.getConfigurationProperty("teami.scm.loadLatest");
        this.loadLatestButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_LATEST_CHANGES_RADIO_LABEL, 16);
        TableWrapData layoutData = new TableWrapData();
        layoutData.colspan = 3;
        this.loadLatestButton.setLayoutData((Object)layoutData);
        this.loadLatestButton.setSelection(Boolean.valueOf(loadLatestProperty.getValue()).booleanValue());
        this.loadLatestButton.addSelectionListener(this.getLoadOptionsSelectionListener());
        IConfigurationProperty snapshotLoadProperty = buildConfig.getConfigurationProperty("teami.scm.loadSnapshot");
        this.loadSinceSnapshotButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_SINCE_SNAPSHOT_RADIO_LABEL, 16);
        layoutData = new TableWrapData();
        layoutData.colspan = 3;
        this.loadSinceSnapshotButton.setLayoutData((Object)layoutData);
        this.loadSinceSnapshotButton.setSelection(Boolean.valueOf(snapshotLoadProperty.getValue()).booleanValue());
        this.loadSinceSnapshotButton.addSelectionListener(this.getLoadOptionsSelectionListener());
        this.fSnapshotTitleHyperlink = this.fToolkit.createHyperlink(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SNAPSHOT_LABEL, 0);
        this.fSnapshotTitleHyperlink.addHyperlinkListener(this.getSnapshotHyperlinkListener());
        layoutData = new TableWrapData(2, 32);
        layoutData.colspan = 1;
        layoutData.indent = 30;
        this.fSnapshotTitleHyperlink.setLayoutData((Object)layoutData);
        this.fEnabledHyperlinkForegroundColor = this.fSnapshotTitleHyperlink.getForeground();
        this.fSnapshotNameText = this.fToolkit.createText(composite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fSnapshotNameText.getForeground();
        this.fSnapshotNameText.setEnabled(false);
        this.fSnapshotNameText.setEditable(false);
        layoutData = new TableWrapData(256, 32);
        this.fSnapshotNameText.setLayoutData((Object)layoutData);
        this.fSelectSnapshotButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_SNAPSHOT_BUTTON_TITLE, 0);
        this.fSelectSnapshotButton.addSelectionListener(this.getSelectSnapshotListener());
        this.fSelectSnapshotButton.setLayoutData((Object)new TableWrapData());
        IConfigurationProperty loadAllProperty = buildConfig.getConfigurationProperty("teami.scm.loadAll");
        this.loadAllButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOAD_ALL_RADIO_LABEL, 16);
        layoutData = new TableWrapData();
        layoutData.colspan = 3;
        this.loadAllButton.setLayoutData((Object)layoutData);
        this.loadAllButton.setSelection(Boolean.valueOf(loadAllProperty.getValue()).booleanValue());
        this.loadAllButton.addSelectionListener(this.getLoadOptionsSelectionListener());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("teami.scm.snapshotUUID");
        if (property == null || property.getValue() == null || property.getValue().equals("")) {
            this.setSnapshotNameText("", false);
            this.initializeLoadOptionWidgetsState();
            return;
        }
        final IBaselineSetHandle baselineSetHandle = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)property.getValue()), null);
        String jobName = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBMiAntJazzScmConfigurationEditor.this.fSnapshot = (IBaselineSet)IBMiAntJazzScmConfigurationEditor.this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 0, monitor);
                final String snapshot = IBMiAntJazzScmConfigurationEditor.this.fSnapshot.getName();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).IBMiAntJazzScmConfigurationEditor.this.fSnapshotNameText.isDisposed()) {
                            IBMiAntJazzScmConfigurationEditor.this.setSnapshotNameText(snapshot, true);
                            IBMiAntJazzScmConfigurationEditor.this.initializeLoadOptionWidgetsState();
                        }
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                status.getSeverity();
            }
        };
        job.schedule();
    }

    protected void initializeLoadOptionWidgetsState() {
        IBuildConfigurationElement buildConfig = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
        IConfigurationProperty snapshotLoadProperty = buildConfig.getConfigurationProperty("teami.scm.loadSnapshot");
        boolean snapshotLoadPropertyValue = Boolean.valueOf(snapshotLoadProperty.getValue());
        if (snapshotLoadPropertyValue) {
            if (!"".equals(this.fSnapshotNameText.getText())) {
                this.setSnapshotTitleHyperlinkEnablement(true);
            } else {
                this.setSnapshotTitleHyperlinkEnablement(false);
            }
            this.fSnapshotNameText.setEnabled(true);
            this.fSelectSnapshotButton.setEnabled(true);
        } else {
            this.setSnapshotTitleHyperlinkEnablement(false);
            this.fSnapshotNameText.setEnabled(false);
            this.fSelectSnapshotButton.setEnabled(false);
        }
    }

    private SelectionListener getLoadOptionsSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.validate();
                IBuildConfigurationElement buildConfig = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
                IConfigurationProperty property = buildConfig.getConfigurationProperty("teami.scm.loadAll");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.loadAllButton.getSelection()));
                property = buildConfig.getConfigurationProperty("teami.scm.loadLatest");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.loadLatestButton.getSelection()));
                property = buildConfig.getConfigurationProperty("teami.scm.loadSnapshot");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.loadSinceSnapshotButton.getSelection()));
                IBMiAntJazzScmConfigurationEditor.this.initializeLoadOptionWidgetsState();
                IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void setSnapshotNameText(String snapshot, boolean hyperlinkEnablement) {
        this.fSnapshotNameText.setText(snapshot);
        this.fSnapshotNameText.setEnabled(hyperlinkEnablement);
        this.setSnapshotTitleHyperlinkEnablement(hyperlinkEnablement);
    }

    private void setSnapshotTitleHyperlinkEnablement(boolean enabled) {
        this.fSnapshotTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fSnapshotTitleHyperlink.setUnderlined(enabled);
        this.fSnapshotTitleHyperlink.setEnabled(enabled);
    }

    protected IHyperlinkListener getSnapshotHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    TeamPlacePart2.open((IWorkbenchPage)page, (SnapshotEditorInput)SnapshotEditorInput.newForEdit((IBaselineSet)IBMiAntJazzScmConfigurationEditor.this.fSnapshot));
                }
            }
        };
    }

    private SelectionListener getSelectSnapshotListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectSnapshotWizard wizard = new SelectSnapshotWizard(IBMiAntJazzScmConfigurationEditor.this.getTeamRepository());
                WizardDialog dialog = new WizardDialog(IBMiAntJazzScmConfigurationEditor.this.fSnapshotTitleHyperlink.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    IBMiAntJazzScmConfigurationEditor.this.fSnapshot = wizard.getSnapshot().getSnapshot();
                    IBMiAntJazzScmConfigurationEditor.this.setSnapshotNameText(IBMiAntJazzScmConfigurationEditor.this.fSnapshot.getName(), true);
                    IBuildProperty property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("teami.scm.snapshotUUID");
                    property.setValue(IBMiAntJazzScmConfigurationEditor.this.fSnapshot.getItemId().getUuidValue());
                    IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
                }
            }
        };
    }

    protected void createProjectToLibraryMappingsAndBuildOrderWidgets(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_PROJECT_MAPPINGS_LOAD_ORDER);
        section.setDescription(NLS.bind((String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_DESC_PROJECT_MAPPINGS_LOAD_ORDER, (Object)VAR_SEARCH));
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.projMapControl = new ProjectMappingControl(composite, this.fToolkit);
        this.projMapControl.addListener(this.getProjectMappingControlListener());
        this.projMapControl.init(new ArrayList(), "", "", "", "", false);
        this.projMapControl.enable(true);
    }

    protected void initProjectMapControl(final boolean newWorkspace) {
        new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                String targetLibraryPropertyValue;
                String loadLibraryPropertyValue;
                String buildOrderValue;
                String buildPropertyValue;
                new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IBMiAntJazzScmConfigurationEditor.this.projMapControl.showLoadingMessage();
                        return Status.OK_STATUS;
                    }
                }.schedule();
                final List<String> projects = IBMiAntJazzScmConfigurationEditor.this.getWorkspaceProjects();
                IBuildConfigurationElement element = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
                if (element != null) {
                    IConfigurationProperty buildProperty = element.getConfigurationProperty("teami.scm.buildProjects");
                    IConfigurationProperty loadProperty = element.getConfigurationProperty("teami.scm.projectLoadDirectory");
                    IConfigurationProperty targetProperty = element.getConfigurationProperty("teami.scm.projectTargetDirectory");
                    IConfigurationProperty buildOrderProperty = element.getConfigurationProperty("teami.scm.projectBuildOrder");
                    buildPropertyValue = buildProperty.getValue();
                    buildOrderValue = buildOrderProperty.getValue();
                    loadLibraryPropertyValue = loadProperty.getValue();
                    targetLibraryPropertyValue = targetProperty.getValue();
                } else {
                    buildPropertyValue = "";
                    buildOrderValue = "";
                    loadLibraryPropertyValue = "";
                    targetLibraryPropertyValue = "";
                }
                new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IBMiAntJazzScmConfigurationEditor.this.projMapControl.init(projects, buildPropertyValue, buildOrderValue, loadLibraryPropertyValue, targetLibraryPropertyValue, newWorkspace);
                        if (IBMiAntJazzScmConfigurationEditor.this.projMapControl.foundNewProjectDuringInit()) {
                            IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected List<String> getWorkspaceProjects() {
        this.projectNames = new ArrayList();
        IWorkspaceHandle handle = this.workspaceHandle;
        this.folderHandles = new ArrayList<IFolderHandle>();
        ITeamRepository repository = this.getTeamRepository();
        if (handle == null || repository == null) {
            return this.projectNames;
        }
        IBuildProperty assumeProjectsAreIBMiProjectsProperty = this.fBuildDefinitionWorkingCopy.getProperty("teamp.build.assumeProjectsAreIBMiProjects");
        boolean assumeProjectsAreIBMiProjects = false;
        if (assumeProjectsAreIBMiProjectsProperty != null && assumeProjectsAreIBMiProjectsProperty.getValue() != null) {
            assumeProjectsAreIBMiProjects = Boolean.parseBoolean(assumeProjectsAreIBMiProjectsProperty.getValue());
        }
        try {
            List allProjects = FileSystemIUtil.getInstance().getIProjectsWithInfos(this.workspaceHandle, repository, false, assumeProjectsAreIBMiProjects);
            if (allProjects == null || allProjects.size() == 0) {
                return this.projectNames;
            }
            for (IProjectInfo projInfo : allProjects) {
                this.projectNames.add(projInfo.getName());
                this.folderHandles.add(projInfo.getFolderHandle());
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return this.projectNames;
    }

    protected void createWorkspaceNameWidgets(Composite parent) {
        IWorkspaceHandle workspaceHandle2;
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_TEXT_REPOSITORY);
        section.setDescription(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.fWorkspaceTitleHyperlink = this.fToolkit.createHyperlink(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_LABEL, 0);
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fWorkspaceTitleHyperlink.getForeground();
        this.fWorkspaceTitleHyperlink.setLayoutData((Object)new TableWrapData());
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fWorkspaceNameText = this.fToolkit.createText(composite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fWorkspaceNameText.getForeground();
        this.fWorkspaceNameText.setEnabled(false);
        this.fWorkspaceNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fWorkspaceNameText.setLayoutData((Object)layoutData);
        this.fSelectWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_WORKSPACE_BUTTON_TITLE, 0);
        this.fSelectWorkspaceButton.addSelectionListener(this.getSelectWorkspaceListener());
        this.fSelectWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.fCreateWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CREATE_WORKSPACE_BUTTON_TITLE, 0);
        this.fCreateWorkspaceButton.addSelectionListener(this.getCreateWorkspaceListener());
        this.fCreateWorkspaceButton.setLayoutData((Object)new TableWrapData());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
        if (property.getValue().length() == 0) {
            this.setWorkspaceNameText("", false);
            return;
        }
        this.setWorkspaceNameText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PENDING, false);
        this.workspaceHandle = workspaceHandle2 = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)property.getValue()), null);
        String jobName = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBMiAntJazzScmConfigurationEditor.this.fWorkspace = IBMiAntJazzScmConfigurationEditor.this.fetchWorkspace(workspaceHandle2, monitor);
                IBMiAntJazzScmConfigurationEditor.this.handleUpdateWorkspaceText(IBMiAntJazzScmConfigurationEditor.this.fWorkspace.getName());
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    IBMiAntJazzScmConfigurationEditor.this.handleFetchFailed(status);
                }
            }
        };
        job.schedule();
    }

    protected void handleFetchFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!IBMiAntJazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    String errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_FETCHING;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_DELETED;
                    }
                    IBMiAntJazzScmConfigurationEditor.this.setWorkspaceNameText(errorMessage, false);
                }
            }
        });
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.fWorkspaceTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fWorkspaceTitleHyperlink.setUnderlined(enabled);
        this.fWorkspaceTitleHyperlink.setEnabled(enabled);
    }

    private void setWorkspaceNameText(String text, boolean workspaceSet) {
        this.fWorkspaceNameText.setText(text);
        this.fWorkspaceNameText.setEnabled(workspaceSet);
        this.setWorkspaceTitleHyperlinkEnablement(workspaceSet);
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.fWorkspace)));
        }
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void handleUpdateWorkspaceText(final String workspaceName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!IBMiAntJazzScmConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    IBMiAntJazzScmConfigurationEditor.this.setWorkspaceNameText(workspaceName, true);
                    if (IBMiAntJazzScmConfigurationEditor.this.projMapControl != null) {
                        IBMiAntJazzScmConfigurationEditor.this.initProjectMapControl(false);
                    }
                }
            }
        });
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fWorkspaceNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fWorkspaceNameText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_REQUIRED, (Control)this.fWorkspaceNameText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fWorkspaceNameText, (Control)this.fWorkspaceNameText);
        }
        if (this.loadSinceSnapshotButton.getSelection() && this.fSnapshotNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fSnapshotNameText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SNAPSHOT_REQUIRED, (Control)this.fSnapshotNameText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fSnapshotNameText, (Control)this.fSnapshotNameText);
        }
        String mappingsValid = this.projMapControl.validate();
        if (mappingsValid != null) {
            this.addErrorMessageForRequiredField(this.projMapControl, mappingsValid, this.projMapControl.getTreeViewer().getControl());
            isValid = false;
        } else {
            this.removeErrorMessage(this.projMapControl, this.projMapControl.getTreeViewer().getControl());
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
        if (!this.firstTime) {
            String loadLibrary = this.projMapControl.getLoadLibProperty();
            try {
                IScmIClientLibrary clientLibrary = (IScmIClientLibrary)this.getTeamRepository().getClientLibrary(IScmIClientLibrary.class);
                IWorkspaceIHandle workspaceIHandle = clientLibrary.getWorkspaceI(this.workspaceHandle, (IProgressMonitor)new NullProgressMonitor());
                if (workspaceIHandle == null) {
                    workspaceIHandle = clientLibrary.createWorkspaceI(this.workspaceHandle, null);
                }
                Hashtable loadLibPair = IBuildUtility.parseNameValuePairFormat((String)loadLibrary);
                ArrayList<String> libraries = new ArrayList<String>();
                for (String projectName : this.projectNames) {
                    libraries.add((String)loadLibPair.get(projectName));
                }
                clientLibrary.setProjectToLibraryMappings(workspaceIHandle, this.folderHandles, libraries, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        this.firstTime = false;
    }

    protected Map<IComponentHandle, IFileItemHandle> openComponentLoadRulesSelector(Map<IComponentHandle, IFileItemHandle> initialSelection) {
        Map componentLoadRuleFiles = FileSelectionDialog.pickFilePerComponent((Shell)this.fWorkspaceTitleHyperlink.getShell(), (ITeamRepository)this.getTeamRepository(), (IWorkspace)this.fWorkspace, (String)BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PICK_COMPONENT_LOAD_RULES_FILE, initialSelection);
        return componentLoadRuleFiles;
    }

    protected SelectionListener getSelectWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.setWorkspace(IBMiAntJazzScmConfigurationEditor.this.openWorkspaceChooserDialog(IBMiAntJazzScmConfigurationEditor.this.fWorkspaceTitleHyperlink.getShell(), IBMiAntJazzScmConfigurationEditor.this.getTeamRepository()));
            }
        };
    }

    protected SelectionListener getCreateWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.openWorkspaceCreationDialog();
            }
        };
    }

    protected void setWorkspace(IWorkspace workspace) {
        if (workspace != null) {
            Dialog dialog;
            int result;
            boolean newWorkspace = this.fWorkspace != workspace;
            this.fWorkspace = workspace;
            IItemHandle itemHandle = this.fWorkspace.getItemHandle();
            if (itemHandle instanceof IWorkspaceHandle) {
                this.workspaceHandle = (IWorkspaceHandle)itemHandle;
            }
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
            property.setValue(workspace.getItemId().getUuidValue());
            this.setWorkspaceNameText(workspace.getName(), true);
            this.validate();
            this.setDirty(true);
            if (this.shouldShowWorkspaceOwnerWarning() && (result = (dialog = this.getWorkspaceOwnerWarningDialog()).open()) == 0) {
                this.openWorkspaceEditor();
            }
            this.initProjectMapControl(newWorkspace);
        }
    }

    private boolean shouldShowWorkspaceOwnerWarning() {
        return BuildUIPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING);
    }

    protected Dialog getWorkspaceOwnerWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_TITLE, null, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_MESSAGE, 2, new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPEN_WORKSPACE_BUTTON, IDialogConstants.OK_LABEL}, 1){

            protected Control createCustomArea(Composite parent) {
                new Label(parent, 0);
                IBMiAntJazzScmConfigurationEditor.this.fDontShowWarningButton = new Button(parent, 32);
                IBMiAntJazzScmConfigurationEditor.this.fDontShowWarningButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DONT_SHOW_WARNING_AGAIN);
                IBMiAntJazzScmConfigurationEditor.this.fDontShowWarningButton.addSelectionListener(IBMiAntJazzScmConfigurationEditor.this.getDontShowWarningButtonListener());
                return IBMiAntJazzScmConfigurationEditor.this.fDontShowWarningButton;
            }
        };
    }

    protected Dialog getProjectLibraryMappingWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_LIBRARY_MAPPING_WARNING_TITLE, null, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_LIBRARY_MAPPING_WARNING_MESSAGE, 2, new String[]{IDialogConstants.OK_LABEL}, 0){};
    }

    protected SelectionListener getDontShowWarningButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue(IBMiAntJazzScmConfigurationEditor.PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, !IBMiAntJazzScmConfigurationEditor.this.fDontShowWarningButton.getSelection());
                BuildUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    protected SelectionListener getClearBeforeLoadSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.clearDestinationBeforeFetch");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.fClearBeforeLoadButton.getSelection()));
                IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getLoadChangesOnlySelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.fetchChangesOnly");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.fLoadChangesOnlyButton.getSelection()));
                if (IBMiAntJazzScmConfigurationEditor.this.fLoadChangesOnlyButton.getSelection()) {
                    property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
                    property.setValue(Boolean.toString(true));
                } else {
                    property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
                    property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection()));
                    if (!IBMiAntJazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection()) {
                        IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setSelection(false);
                        IBMiAntJazzScmConfigurationEditor.this.getBuildOnlyIfChanges_EverythingSelectionListener().widgetSelected(null);
                    }
                }
                IBMiAntJazzScmConfigurationEditor.this.enableLoadWidgets(IBMiAntJazzScmConfigurationEditor.this.fLoadChangesOnlyButton.getSelection());
                IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void enableLoadWidgets(boolean changes) {
        this.enableLoadChangesOptions(changes);
        this.enableLoadEverythingOptions(!changes);
    }

    private void enableLoadEverythingOptions(boolean enable) {
        this.fClearBeforeLoadButton.setEnabled(enable);
        this.fAcceptBeforeLoadButton.setEnabled(enable);
        if (!enable) {
            this.fLoadAndBuildOnlyIfChanges_EverythingButton.setEnabled(enable);
        }
        if (this.fAcceptBeforeLoadButton.getSelection()) {
            this.fLoadAndBuildOnlyIfChanges_EverythingButton.setEnabled(enable);
        }
    }

    private void enableLoadChangesOptions(boolean enable) {
        this.fLoadAndBuildOnlyIfChanges_ChangesButton.setEnabled(enable);
    }

    protected SelectionListener getAcceptBeforeLoadSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection()));
                IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setSelection(IBMiAntJazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection());
                IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setEnabled(IBMiAntJazzScmConfigurationEditor.this.fAcceptBeforeLoadButton.getSelection());
                IBMiAntJazzScmConfigurationEditor.this.getBuildOnlyIfChanges_EverythingSelectionListener().widgetSelected(null);
                IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChanges_ChangesSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_ChangesButton.getSelection()));
                IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.setSelection(IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_ChangesButton.getSelection());
                IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChanges_EverythingSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
                property.setValue(Boolean.toString(IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.getSelection()));
                IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_ChangesButton.setSelection(IBMiAntJazzScmConfigurationEditor.this.fLoadAndBuildOnlyIfChanges_EverythingButton.getSelection());
                IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, (boolean)false, null, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected void openWorkspaceCreationDialog() {
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)this), this.getTeamRepository(), false, (IPartResult)new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper result) {
                IBMiAntJazzScmConfigurationEditor.this.setWorkspace(result.getWorkspace());
            }
        }, true, (IReadScope)IReadScope.FACTORY.createPublicScope());
        new WizardDialog(this.fWorkspaceTitleHyperlink.getShell(), (IWizard)wizard).open();
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public Control getFocusControl() {
        return this.fSelectWorkspaceButton;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionsystemibmiantjazzscm2";
    }

    protected ProjectMappingControlListener getProjectMappingControlListener() {
        if (this.fProjectMappingControlListener != null) {
            return this.fProjectMappingControlListener;
        }
        this.fProjectMappingControlListener = new ProjectMappingControlListener(){

            @Override
            public void projectMappingModified() {
                String buildProjects = IBMiAntJazzScmConfigurationEditor.this.projMapControl.getBuildProperty();
                String buildOrders = IBMiAntJazzScmConfigurationEditor.this.projMapControl.getBuildOrderProperty();
                String loadLibrary = IBMiAntJazzScmConfigurationEditor.this.projMapControl.getLoadLibProperty();
                String targetLibrary = IBMiAntJazzScmConfigurationEditor.this.projMapControl.getTargetLibProperty();
                IBuildConfigurationElement element = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
                if (element != null) {
                    IConfigurationProperty buildProperty = element.getConfigurationProperty("teami.scm.buildProjects");
                    IConfigurationProperty loadProperty = element.getConfigurationProperty("teami.scm.projectLoadDirectory");
                    IConfigurationProperty targetProperty = element.getConfigurationProperty("teami.scm.projectTargetDirectory");
                    IConfigurationProperty buildOrderProperty = element.getConfigurationProperty("teami.scm.projectBuildOrder");
                    buildProperty.setValue(buildProjects);
                    buildOrderProperty.setValue(buildOrders);
                    loadProperty.setValue(loadLibrary);
                    targetProperty.setValue(targetLibrary);
                    IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
                }
                IBMiAntJazzScmConfigurationEditor.this.validate();
            }
        };
        return this.fProjectMappingControlListener;
    }

    protected BaseLibraryListControlListener getBaseLibraryListControlListener() {
        if (this.fBaseLiblControlListener != null) {
            return this.fBaseLiblControlListener;
        }
        this.fBaseLiblControlListener = new BaseLibraryListControlListener(){

            @Override
            public void baseLibraryListModified() {
                String baseLibraries = IBMiAntJazzScmConfigurationEditor.this.baseLiblControl.getBaseLibraryListProperty();
                IBuildConfigurationElement element = IBMiAntJazzScmConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
                if (element != null) {
                    IConfigurationProperty baseLiblProperty = element.getConfigurationProperty("teami.scm.baseLibraries");
                    baseLiblProperty.setValue(baseLibraries);
                    IBMiAntJazzScmConfigurationEditor.this.setDirty(true);
                }
                IBMiAntJazzScmConfigurationEditor.this.validate();
            }
        };
        return this.fBaseLiblControlListener;
    }

    public void dispose() {
        super.dispose();
        this.workspaceHandle = null;
        if (this.projMapControl != null && this.fProjectMappingControlListener != null) {
            this.projMapControl.removeListener(this.fProjectMappingControlListener);
            this.projMapControl.cleanup();
        }
    }
}

