/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class IBMiAntConfigurationEditor
extends AbstractConfigurationElementEditor {
    private static final int FIELD_SPACING = 20;
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    private Section fBuildFileSection;
    protected Label fBuildFileTextLabel;
    protected Text fBuildFileText;
    protected Text fBuildTargetsText;
    protected Label fBuildTargetsTextLabel;
    protected Text fBuildGeneratedScriptsDirectoryText;
    protected Label fBuildGeneratedScriptsDirectoryTextLabel;
    protected Text fAntHomeText;
    protected Text fAntArgsText;
    protected Text fJavaHomeText;
    protected Text fJavaArgsText;
    protected Text fWorkingDirText;
    protected Text fPropertiesFileText;
    protected Combo fFailOnErrorLevelCombo;
    protected Combo fFailOnErrorCommandLevelCombo;
    private FormToolkit fToolkit;
    protected Button fIncludeToolkitButton;
    private Section fConfigurationSection;
    private Button fUseGeneratedScripts;
    private Button fUseSpecificBuildScript;
    private Button fFailOnErrorButton;
    private Button fFailOnErrorCommandButton;
    private Label fFailOnErrorSeverityLabel;
    private Label fFailOnErrorCommandSeverityLabel;
    protected Text fPreBuildCommandText;
    protected Text fPostBuildCommandText;

    public IBMiAntConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        this.fBuildFileSection = this.fToolkit.createSection(parent, 384);
        this.fBuildFileSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fBuildFileSection.setLayout((Layout)new TableWrapLayout());
        this.fBuildFileSection.setText(BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_SECTION_TEXT_BUILD_SCRIPT_INFO);
        this.fBuildFileSection.setDescription(BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_SECTION_DESC_BUILD_SCRIPT_INFO);
        Composite composite = this.fToolkit.createComposite((Composite)this.fBuildFileSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createSpacer(composite, 5, 2);
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.generated");
        this.fUseGeneratedScripts = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_BUILD_GENERATED_SCRIPTS_RADIO_LABEL, 16);
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 2);
        this.fUseGeneratedScripts.setLayoutData((Object)layoutData);
        this.fUseGeneratedScripts.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fUseGeneratedScripts.addSelectionListener(this.getGeneratedScriptSelectionListener());
        this.createBuildGeneratedScriptsLocation(composite);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.generated");
        this.fUseSpecificBuildScript = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_BUILD_SPECIFIC_SCRIPT_RADIO_LABEL, 16);
        layoutData = new TableWrapData(2, 32, 1, 2);
        this.fUseSpecificBuildScript.setLayoutData((Object)layoutData);
        this.fUseSpecificBuildScript.setSelection(Boolean.valueOf(property.getValue()) == false);
        this.fUseSpecificBuildScript.addSelectionListener(this.getGeneratedScriptSelectionListener());
        this.createBuildFileWidgets(composite);
        this.createBuildTargetWidgets(composite);
        this.fBuildFileSection.setClient((Control)composite);
        this.createSpacer(parent, 15, 1);
        this.fConfigurationSection = this.fToolkit.createSection(parent, 448);
        this.fConfigurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fConfigurationSection.setLayout((Layout)new TableWrapLayout());
        this.fConfigurationSection.setText(BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_SECTION_TEXT_FAIL_ON_ERROR);
        this.fConfigurationSection.setDescription(BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_SECTION_DESC_FAIL_ON_ERROR);
        composite = this.fToolkit.createComposite((Composite)this.fConfigurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createFailOnErrorWidgets(composite);
        this.fConfigurationSection.setClient((Control)composite);
        this.createSpacer(parent, 15, 1);
        this.createCommandWidgets(parent);
        this.createSpacer(parent, 15, 1);
        this.fConfigurationSection = this.fToolkit.createSection(parent, 386);
        this.fConfigurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.fConfigurationSection.setLayout((Layout)new TableWrapLayout());
        this.fConfigurationSection.setText(BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_ANT_CONFIGURATION_SECTION_TEXT);
        this.fConfigurationSection.setDescription(com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_CONFIG_SECTION_DESCRIPTION);
        composite = this.fToolkit.createComposite((Composite)this.fConfigurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createIncludeToolkitWidgets(composite);
        this.createAntHomeWidgets(composite);
        this.createAntArgsWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        this.fConfigurationSection.setClient((Control)composite);
        this.initializeWidgets();
    }

    private void createCommandWidgets(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 448);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_SECTION_TEXT_COMMAND);
        section.setDescription(BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_SECTION_DESC_COMMAND);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.createSpacer(composite, 5, 2);
        this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_PRE_BUILD_COMMAND_LABEL);
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("teami.preBuildCommand");
        this.fPreBuildCommandText = this.fToolkit.createText(composite, property.getValue(), 0);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fPreBuildCommandText.setLayoutData((Object)layoutData);
        this.fPreBuildCommandText.addModifyListener(this.getPreBuildCommandTextListener());
        this.createSpacer(composite, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_PRE_BUILD_COMMAND_DESC, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.createSpacer(composite, 5, 2);
        this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_POST_BUILD_COMMAND_LABEL);
        element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        property = element.getConfigurationProperty("teami.postBuildCommand");
        this.fPostBuildCommandText = this.fToolkit.createText(composite, property.getValue(), 0);
        layoutData = new TableWrapData(256, 32);
        this.fPostBuildCommandText.setLayoutData((Object)layoutData);
        this.fPostBuildCommandText.addModifyListener(this.getPostBuildCommandTextListener());
        this.createSpacer(composite, -1, 1);
        descriptionLabel = this.fToolkit.createLabel(composite, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_POST_BUILD_COMMAND_DESC, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
    }

    private ModifyListener getPreBuildCommandTextListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty property = element.getConfigurationProperty("teami.preBuildCommand");
                property.setValue(IBMiAntConfigurationEditor.this.fPreBuildCommandText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getPostBuildCommandTextListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty property = element.getConfigurationProperty("teami.postBuildCommand");
                property.setValue(IBMiAntConfigurationEditor.this.fPostBuildCommandText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void createFailOnErrorWidgets(Composite parent) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.icmd.failOnError");
        boolean failOnErrorFromCommand = true;
        if (property != null) {
            failOnErrorFromCommand = Boolean.valueOf(property.getValue());
        }
        this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_FAIL_ON_ERROR_COMMAND_LABEL);
        this.fFailOnErrorCommandButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_ANT_PROPERTY_FAIL_ON_ERROR_COMMAND_LABEL, 32);
        TableWrapData layoutData = new TableWrapData();
        layoutData.colspan = 2;
        this.fFailOnErrorCommandButton.setLayoutData((Object)layoutData);
        this.fFailOnErrorCommandButton.addSelectionListener(this.getFailOnErrorCommandSelectionListener());
        this.fFailOnErrorCommandButton.setSelection(failOnErrorFromCommand);
        this.createSpacer(parent, 20, 1);
        this.fFailOnErrorCommandSeverityLabel = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_FAIL_ON_ERROR_SEVERITY_LABEL);
        layoutData = new TableWrapData(2, 32);
        layoutData.indent = 30;
        this.fFailOnErrorCommandSeverityLabel.setLayoutData((Object)layoutData);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.icmd.failOnError.level");
        int failOnErrorCommandLevel = 40;
        if (property != null) {
            failOnErrorCommandLevel = Integer.valueOf(property.getValue());
        }
        this.fFailOnErrorCommandLevelCombo = new Combo(parent, 8);
        this.fFailOnErrorCommandLevelCombo.setItems(new String[]{"00", "10", "20", "30", "40", "50"});
        this.fFailOnErrorCommandLevelCombo.select(failOnErrorCommandLevel / 10);
        layoutData = new TableWrapData(2, 32);
        this.fFailOnErrorCommandLevelCombo.setLayoutData((Object)layoutData);
        this.fFailOnErrorCommandLevelCombo.addSelectionListener(this.getFailOnErrorCommandLevelSelectionListener());
        this.createSpacer(parent, -1, 2);
        Label label = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_FAIL_ON_ERROR_SEVERITY_COMBO_DESC, 64);
        layoutData = new TableWrapData(256);
        label.setLayoutData((Object)layoutData);
        label.setForeground(Display.getDefault().getSystemColor(16));
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.failOnError");
        this.createSpacer(parent, 5, 3);
        this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_FAIL_ON_ERROR_LABEL);
        this.fFailOnErrorButton = this.fToolkit.createButton(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_ANT_PROPERTY_FAIL_ON_ERROR_LABEL, 32);
        layoutData = new TableWrapData();
        layoutData.colspan = 2;
        this.fFailOnErrorButton.setLayoutData((Object)layoutData);
        this.fFailOnErrorButton.addSelectionListener(this.getFailOnErrorSelectionListener());
        this.fFailOnErrorButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.createSpacer(parent, 20, 1);
        this.fFailOnErrorSeverityLabel = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_FAIL_ON_ERROR_SEVERITY_LABEL);
        layoutData = new TableWrapData(2, 32);
        layoutData.indent = 30;
        this.fFailOnErrorSeverityLabel.setLayoutData((Object)layoutData);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.failOnError.level");
        this.fFailOnErrorLevelCombo = new Combo(parent, 8);
        this.fFailOnErrorLevelCombo.setItems(new String[]{"00", "10", "20", "30", "40", "50"});
        this.fFailOnErrorLevelCombo.select(Integer.valueOf(property.getValue()) / 10);
        layoutData = new TableWrapData(2, 32);
        this.fFailOnErrorLevelCombo.setLayoutData((Object)layoutData);
        this.fFailOnErrorLevelCombo.addSelectionListener(this.getFailOnErrorLevelSelectionListener());
        this.createSpacer(parent, -1, 2);
        label = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_FAIL_ON_ERROR_SEVERITY_COMBO_DESC, 64);
        layoutData = new TableWrapData(256);
        label.setLayoutData((Object)layoutData);
        label.setForeground(Display.getDefault().getSystemColor(16));
    }

    protected SelectionListener getFailOnErrorLevelSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.failOnError.level");
                property.setValue(IBMiAntConfigurationEditor.this.fFailOnErrorLevelCombo.getItem(IBMiAntConfigurationEditor.this.fFailOnErrorLevelCombo.getSelectionIndex()));
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorCommandLevelSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("com.ibm.teami.build.ant.icmd.failOnError.level", IBMiAntConfigurationEditor.this.fFailOnErrorCommandLevelCombo.getItem(IBMiAntConfigurationEditor.this.fFailOnErrorCommandLevelCombo.getSelectionIndex()));
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void createBuildGeneratedScriptsLocation(Composite parent) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.generated.loadDirectory");
        this.createSpacer(parent, 5, 2);
        this.fBuildGeneratedScriptsDirectoryTextLabel = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_BUILD_GENERATED_LOAD_DIRECTORY_LABEL);
        TableWrapData layoutData = new TableWrapData(2, 32);
        layoutData.colspan = 1;
        layoutData.indent = 30;
        this.fBuildGeneratedScriptsDirectoryTextLabel.setLayoutData((Object)layoutData);
        String dir = property.getValue();
        if (dir == null || "".equals(dir)) {
            char[] BuildDefinitionID = this.fBuildDefinitionWorkingCopy.getId().toCharArray();
            int i = 0;
            while (i < BuildDefinitionID.length) {
                if (BuildDefinitionID[i] == '\"' || BuildDefinitionID[i] == '<') {
                    BuildDefinitionID[i] = 32;
                }
                ++i;
            }
            dir = "/tmp/rtcp/load/" + String.valueOf(BuildDefinitionID);
        }
        this.fBuildGeneratedScriptsDirectoryText = this.fToolkit.createText(parent, dir);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        this.fBuildGeneratedScriptsDirectoryText.setLayoutData((Object)layoutData);
        property.setValue(this.fBuildGeneratedScriptsDirectoryText.getText().trim());
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_BUILD_GENERATED_LOAD_DIRECTORY_DESC, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.fBuildGeneratedScriptsDirectoryText.addModifyListener(this.getBuildGeneratedScriptsDirectoryListener());
    }

    private void initializeWidgets() {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.generated");
        boolean generated = Boolean.valueOf(property.getValue());
        if (generated) {
            this.fBuildFileText.setEnabled(false);
            this.fBuildFileTextLabel.setEnabled(false);
            this.fBuildTargetsText.setEnabled(false);
            this.fBuildTargetsTextLabel.setEnabled(false);
            this.fBuildGeneratedScriptsDirectoryText.setEnabled(true);
            this.fBuildGeneratedScriptsDirectoryTextLabel.setEnabled(true);
        } else {
            this.fBuildFileText.setEnabled(true);
            this.fBuildFileTextLabel.setEnabled(true);
            this.fBuildTargetsText.setEnabled(true);
            this.fBuildTargetsTextLabel.setEnabled(true);
            this.fBuildGeneratedScriptsDirectoryText.setEnabled(false);
            this.fBuildGeneratedScriptsDirectoryTextLabel.setEnabled(false);
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.failOnError.level");
        int level = 3;
        if (property != null && property.getValue() != null) {
            level = Integer.parseInt(property.getValue()) / 10;
        }
        this.fFailOnErrorLevelCombo.select(level);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.failOnError");
        if (property != null && Boolean.valueOf(property.getValue()).booleanValue()) {
            this.fFailOnErrorLevelCombo.setEnabled(true);
            this.fFailOnErrorSeverityLabel.setEnabled(true);
        } else {
            this.fFailOnErrorLevelCombo.setEnabled(false);
            this.fFailOnErrorSeverityLabel.setEnabled(false);
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.icmd.failOnError.level");
        level = 3;
        if (property != null && property.getValue() != null) {
            level = Integer.parseInt(property.getValue()) / 10;
        }
        this.fFailOnErrorCommandLevelCombo.select(level);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.icmd.failOnError");
        if (property != null && Boolean.valueOf(property.getValue()).booleanValue()) {
            this.fFailOnErrorCommandLevelCombo.setEnabled(true);
            this.fFailOnErrorCommandSeverityLabel.setEnabled(true);
        } else {
            this.fFailOnErrorCommandLevelCombo.setEnabled(false);
            this.fFailOnErrorCommandSeverityLabel.setEnabled(false);
        }
    }

    protected SelectionListener getFailOnErrorSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.failOnError");
                property.setValue(Boolean.toString(IBMiAntConfigurationEditor.this.fFailOnErrorButton.getSelection()));
                if (IBMiAntConfigurationEditor.this.fFailOnErrorButton.getSelection()) {
                    IBMiAntConfigurationEditor.this.fFailOnErrorLevelCombo.setEnabled(true);
                    IBMiAntConfigurationEditor.this.fFailOnErrorSeverityLabel.setEnabled(true);
                } else {
                    IBMiAntConfigurationEditor.this.fFailOnErrorLevelCombo.setEnabled(false);
                    IBMiAntConfigurationEditor.this.fFailOnErrorSeverityLabel.setEnabled(false);
                }
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorCommandSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("com.ibm.teami.build.ant.icmd.failOnError", Boolean.toString(IBMiAntConfigurationEditor.this.fFailOnErrorCommandButton.getSelection()));
                if (IBMiAntConfigurationEditor.this.fFailOnErrorCommandButton.getSelection()) {
                    IBMiAntConfigurationEditor.this.fFailOnErrorCommandLevelCombo.setEnabled(true);
                    IBMiAntConfigurationEditor.this.fFailOnErrorCommandSeverityLabel.setEnabled(true);
                } else {
                    IBMiAntConfigurationEditor.this.fFailOnErrorCommandLevelCombo.setEnabled(false);
                    IBMiAntConfigurationEditor.this.fFailOnErrorCommandSeverityLabel.setEnabled(false);
                }
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getGeneratedScriptSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildProperty property = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.generated");
                property.setValue(Boolean.toString(IBMiAntConfigurationEditor.this.fUseGeneratedScripts.getSelection()));
                if (IBMiAntConfigurationEditor.this.fUseGeneratedScripts.getSelection()) {
                    IBMiAntConfigurationEditor.this.fBuildFileText.setEnabled(false);
                    IBMiAntConfigurationEditor.this.fBuildTargetsText.setEnabled(false);
                    IBMiAntConfigurationEditor.this.fBuildFileTextLabel.setEnabled(false);
                    IBMiAntConfigurationEditor.this.fBuildTargetsTextLabel.setEnabled(false);
                    IBMiAntConfigurationEditor.this.fBuildGeneratedScriptsDirectoryTextLabel.setEnabled(true);
                    IBMiAntConfigurationEditor.this.fBuildGeneratedScriptsDirectoryText.setEnabled(true);
                } else {
                    IBMiAntConfigurationEditor.this.fBuildFileText.setEnabled(true);
                    IBMiAntConfigurationEditor.this.fBuildTargetsText.setEnabled(true);
                    IBMiAntConfigurationEditor.this.fBuildFileTextLabel.setEnabled(true);
                    IBMiAntConfigurationEditor.this.fBuildTargetsTextLabel.setEnabled(true);
                    IBMiAntConfigurationEditor.this.fBuildGeneratedScriptsDirectoryTextLabel.setEnabled(false);
                    IBMiAntConfigurationEditor.this.fBuildGeneratedScriptsDirectoryText.setEnabled(false);
                }
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void createBuildFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.buildFile");
        this.createSpacer(parent, 5, 2);
        this.fBuildFileTextLabel = this.fToolkit.createLabel(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_LABEL);
        TableWrapData layoutData = new TableWrapData(2, 32);
        layoutData.colspan = 1;
        layoutData.indent = 30;
        this.fBuildFileTextLabel.setLayoutData((Object)layoutData);
        this.fBuildFileText = this.fToolkit.createText(parent, property.getValue());
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        this.fBuildFileText.setLayoutData((Object)layoutData);
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_DESC, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.fBuildFileText.addModifyListener(this.getBuildFileModifiedListener());
    }

    private void createBuildTargetWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.targets");
        String targets = "";
        if (property != null) {
            targets = property.getValue();
        }
        this.createSpacer(parent, 5, 2);
        this.fBuildTargetsTextLabel = this.fToolkit.createLabel(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_TARGETS_LABEL);
        TableWrapData layoutData = new TableWrapData(2, 32);
        layoutData.colspan = 1;
        layoutData.indent = 30;
        this.fBuildTargetsTextLabel.setLayoutData((Object)layoutData);
        this.fBuildTargetsText = this.fToolkit.createText(parent, targets);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        this.fBuildTargetsText.setLayoutData((Object)layoutData);
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_TARGETS_DESCRIPTION, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.fBuildTargetsText.addModifyListener(this.getBuildTargetsModifiedListener());
    }

    private void createIncludeToolkitWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.includeToolkit");
        this.createSpacer(parent, 5, 2);
        this.fToolkit.createLabel(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_TOOLKIT_LABEL);
        this.fIncludeToolkitButton = this.fToolkit.createButton(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_INCLUDE_TOOLKIT_BUTTON, 32);
        this.fIncludeToolkitButton.setLayoutData((Object)new TableWrapData());
        this.fIncludeToolkitButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.fIncludeToolkitButton.addSelectionListener(this.getIncludeToolkitSelectionListener());
        this.createSpacer(parent, -1, 1);
        Label label = this.fToolkit.createLabel(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_TOOLKIT_DESCRIPTION, 64);
        label.setLayoutData((Object)new TableWrapData(256));
        label.setForeground(Display.getDefault().getSystemColor(16));
    }

    private void createWorkingDirWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.workingDir");
        this.createSpacer(parent, 20, 2);
        this.fWorkingDirText = this.createLabeledText(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_WORKING_DIR_LABEL, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_WORKING_DIR_DESC, property.getValue());
        this.fWorkingDirText.addModifyListener(this.getWorkingDirModifiedListener());
    }

    private void createPropertiesFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.propertiesFile");
        this.createSpacer(parent, 20, 2);
        this.fPropertiesFileText = this.createLabeledText(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_PROPERTIES_LABEL, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_PROPERTIES_DESC, property.getValue());
        this.fPropertiesFileText.addModifyListener(this.getPropertiesFileModifiedListener());
    }

    private void createAntHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.antHome");
        this.createSpacer(parent, 20, 2);
        this.fAntHomeText = this.createLabeledText(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_HOME_LABEL, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_HOME_DESC, property.getValue());
        this.fAntHomeText.addModifyListener(this.getAntHomeModifiedListener());
    }

    private void createAntArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.antArgs");
        this.createSpacer(parent, 20, 2);
        this.fAntArgsText = this.createLabeledText(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_ARGS_LABEL, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_ANT_ARGS_DESC, property.getValue());
        this.fAntArgsText.addModifyListener(this.getAntArgsModifiedListener());
    }

    private void createJavaHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.javaHome");
        this.createSpacer(parent, 20, 2);
        this.fJavaHomeText = this.createLabeledText(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_JAVA_HOME_LABEL, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_JAVA_HOME_DESC, property.getValue());
        this.fJavaHomeText.addModifyListener(this.getJavaHomeModifiedListener());
    }

    private void createJavaArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.javaVMArgs");
        this.createSpacer(parent, 20, 2);
        this.fJavaArgsText = this.createLabeledText(parent, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_VM_ARGS_LABEL, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_VM_ARGS_DESC, property.getValue());
        this.fJavaArgsText.addModifyListener(this.getJavaArgsModifiedListener());
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.fToolkit.createLabel(parent, label);
        Text text = this.fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private Text createLabeledTextWithIndent(Composite parent, String label, String description, String textValue, int indentValue) {
        Label l = this.fToolkit.createLabel(parent, label);
        TableWrapData layoutData = new TableWrapData(2, 32);
        layoutData.colspan = 1;
        layoutData.indent = 30;
        l.setLayoutData((Object)layoutData);
        Text text = this.fToolkit.createText(parent, textValue);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        text.setLayoutData((Object)layoutData);
        this.createSpacer(parent, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(parent, description, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        return text;
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    public boolean validate() {
        boolean isValid = true;
        boolean isLoadDirectoryValid = true;
        char[] loadDirectory = this.fBuildGeneratedScriptsDirectoryText.getText().trim().toCharArray();
        int i = 0;
        while (i < loadDirectory.length) {
            if (loadDirectory[i] == '\"' || loadDirectory[i] == '<') {
                isLoadDirectoryValid = false;
            }
            ++i;
        }
        if (this.fUseSpecificBuildScript.getSelection()) {
            if (this.fBuildFileText.getText().trim().equals("")) {
                this.addErrorMessageForRequiredField(this.fBuildFileText, com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages.AntConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.fBuildFileText);
                isValid = false;
            } else {
                this.removeErrorMessage(this.fBuildFileText, (Control)this.fBuildFileText);
            }
            this.removeErrorMessage(this.fBuildGeneratedScriptsDirectoryText, (Control)this.fBuildGeneratedScriptsDirectoryText);
        } else {
            if (this.fBuildGeneratedScriptsDirectoryText.getText().trim().equals("")) {
                this.addErrorMessageForRequiredField(this.fBuildGeneratedScriptsDirectoryText, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_BUILD_GENERATED_LOAD_DIRECTORY_REQUIRED, (Control)this.fBuildGeneratedScriptsDirectoryText);
                isValid = false;
            } else if (!isLoadDirectoryValid) {
                this.addErrorMessageForRequiredField(this.fBuildGeneratedScriptsDirectoryText, BuildDefinitionEditorMessages.IBMiAntConfigurationEditor_BUILD_GENERATED_LOAD_DIRECTORY_PATH_INVALID, (Control)this.fBuildGeneratedScriptsDirectoryText);
                isValid = false;
            } else {
                this.removeErrorMessage(this.fBuildGeneratedScriptsDirectoryText, (Control)this.fBuildGeneratedScriptsDirectoryText);
            }
            this.removeErrorMessage(this.fBuildFileText, (Control)this.fBuildFileText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    private ModifyListener getBuildGeneratedScriptsDirectoryListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildProperty buildFileProperty = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.teami.build.ant.generated.loadDirectory");
                buildFileProperty.setValue(IBMiAntConfigurationEditor.this.fBuildGeneratedScriptsDirectoryText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getBuildFileModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.buildFile");
                buildFileProperty.setValue(IBMiAntConfigurationEditor.this.fBuildFileText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getBuildTargetsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.targets");
                if (property == null) {
                    property = BuildItemFactory.createConfigurationProperty();
                    property.setName("com.ibm.team.build.ant.targets");
                    element.getConfigurationProperties().add(property);
                }
                property.setValue(IBMiAntConfigurationEditor.this.fBuildTargetsText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getAntHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.antHome");
                buildFileProperty.setValue(IBMiAntConfigurationEditor.this.fAntHomeText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getAntArgsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.antArgs");
                buildFileProperty.setValue(IBMiAntConfigurationEditor.this.fAntArgsText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaHomeModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.javaHome");
                buildFileProperty.setValue(IBMiAntConfigurationEditor.this.fJavaHomeText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getJavaArgsModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty buildFileProperty = element.getConfigurationProperty("com.ibm.team.build.ant.javaVMArgs");
                buildFileProperty.setValue(IBMiAntConfigurationEditor.this.fJavaArgsText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getWorkingDirModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.workingDir");
                property.setValue(IBMiAntConfigurationEditor.this.fWorkingDirText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getPropertiesFileModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.propertiesFile");
                property.setValue(IBMiAntConfigurationEditor.this.fPropertiesFileText.getText().trim());
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getIncludeToolkitSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiAntConfigurationEditor.this.validate();
                IBuildConfigurationElement element = IBMiAntConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.iant");
                IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.includeToolkit");
                property.setValue(Boolean.toString(IBMiAntConfigurationEditor.this.fIncludeToolkitButton.getSelection()));
                IBMiAntConfigurationEditor.this.setDirty(true);
            }
        };
    }

    public Control getFocusControl() {
        return this.fBuildFileText;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionsystemibmiantant";
    }
}

