/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.editors.builddefinition;

import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.ui.BuildUIPlugin;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class AutoLoadConfigurationEditor
extends AbstractConfigurationElementEditor {
    public static final String PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING = "showWorkspaceOwnerWarning";
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    protected FormToolkit fToolkit;
    protected Hyperlink fWorkspaceTitleHyperlink;
    protected Text fWorkspaceNameText;
    protected Button fSelectWorkspaceButton;
    protected Button fCreateWorkspaceButton;
    protected IWorkspace fWorkspace;
    protected Color fEnabledHyperlinkForegroundColor;
    protected Color fDisabledHyperlinkForegroundColor;
    protected Button fDontShowWarningButton;
    private boolean autoload = false;

    public AutoLoadConfigurationEditor(String elementId, String title) {
        super(elementId, title);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, true);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        Label l = this.fToolkit.createLabel(parent, BuildDefinitionEditorMessages.AutoLoadConfigurationEditor_SYSTEMIAUTOLOAD_LABEL, 64);
        l.setForeground(Display.getDefault().getSystemColor(2));
        l.setLayoutData((Object)new TableWrapData(2, 32, 1, 1));
        this.createWorkspaceNameWidgets(parent);
    }

    protected void createWorkspaceNameWidgets(Composite parent) {
        this.createSpacer(parent, 1, 1);
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(BuildDefinitionEditorMessages.AutoLoadConfigurationEditor_SECTION_TEXT_REPOSITORY);
        section.setDescription(BuildDefinitionEditorMessages.AutoLoadConfigurationEditor_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.fWorkspaceTitleHyperlink = this.fToolkit.createHyperlink(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_LABEL, 0);
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fEnabledHyperlinkForegroundColor = this.fWorkspaceTitleHyperlink.getForeground();
        this.fWorkspaceTitleHyperlink.setLayoutData((Object)new TableWrapData());
        this.fWorkspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.fWorkspaceNameText = this.fToolkit.createText(composite, "", 0);
        this.fDisabledHyperlinkForegroundColor = this.fWorkspaceNameText.getForeground();
        this.fWorkspaceNameText.setEnabled(false);
        this.fWorkspaceNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fWorkspaceNameText.setLayoutData((Object)layoutData);
        this.fSelectWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SELECT_WORKSPACE_BUTTON_TITLE, 0);
        this.fSelectWorkspaceButton.addSelectionListener(this.getSelectWorkspaceListener());
        this.fSelectWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.fCreateWorkspaceButton = this.fToolkit.createButton(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_CREATE_WORKSPACE_BUTTON_TITLE, 0);
        this.fCreateWorkspaceButton.addSelectionListener(this.getCreateWorkspaceListener());
        this.fCreateWorkspaceButton.setLayoutData((Object)new TableWrapData());
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
        if (property.getValue().length() == 0) {
            this.setWorkspaceNameText("", false);
            return;
        }
        this.setWorkspaceNameText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PENDING, false);
        final IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)property.getValue()), null);
        String jobName = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                AutoLoadConfigurationEditor.this.fWorkspace = AutoLoadConfigurationEditor.this.fetchWorkspace(workspaceHandle, monitor);
                AutoLoadConfigurationEditor.this.handleUpdateWorkspaceText(AutoLoadConfigurationEditor.this.fWorkspace.getName());
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    AutoLoadConfigurationEditor.this.handleFetchFailed(status);
                }
            }
        };
        job.schedule();
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    protected void handleFetchFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AutoLoadConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    String errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_ERROR_FETCHING;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_DELETED;
                    }
                    AutoLoadConfigurationEditor.this.setWorkspaceNameText(errorMessage, false);
                }
            }
        });
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.fWorkspaceTitleHyperlink.setForeground(enabled ? this.fEnabledHyperlinkForegroundColor : this.fDisabledHyperlinkForegroundColor);
        this.fWorkspaceTitleHyperlink.setUnderlined(enabled);
        this.fWorkspaceTitleHyperlink.setEnabled(enabled);
    }

    private void setWorkspaceNameText(String text, boolean workspaceSet) {
        this.fWorkspaceNameText.setText(text);
        this.fWorkspaceNameText.setEnabled(workspaceSet);
        this.setWorkspaceTitleHyperlinkEnablement(workspaceSet);
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AutoLoadConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.fWorkspace)));
        }
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void handleUpdateWorkspaceText(final String workspaceName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AutoLoadConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                    AutoLoadConfigurationEditor.this.setWorkspaceNameText(workspaceName, true);
                }
            }
        });
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.fWorkspaceNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fWorkspaceNameText, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_REQUIRED, (Control)this.fWorkspaceNameText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fWorkspaceNameText, (Control)this.fWorkspaceNameText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
        boolean bl = this.autoload = this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.autoload") != null;
        if (this.autoload && this.fBuildDefinitionWorkingCopy.getConfigurationElement("com.ibm.teami.build.autoloadprebuild") == null) {
            IBuildConfigurationElement element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement("com.ibm.teami.build.autoloadprebuild");
            this.fBuildDefinitionWorkingCopy.initializeConfiguration(element);
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.clearDestinationBeforeFetch");
            property.setValue(new Boolean(false).toString());
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.fetchChangesOnly");
            property.setValue(new Boolean(true).toString());
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.acceptBeforeFetch");
            property.setValue(new Boolean(true).toString());
            property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.buildOnlyIfChanges");
            property.setValue(new Boolean(true).toString());
        }
    }

    protected SelectionListener getSelectWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoLoadConfigurationEditor.this.setWorkspace(AutoLoadConfigurationEditor.this.openWorkspaceChooserDialog(AutoLoadConfigurationEditor.this.fWorkspaceTitleHyperlink.getShell(), AutoLoadConfigurationEditor.this.getTeamRepository()));
            }
        };
    }

    protected SelectionListener getCreateWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoLoadConfigurationEditor.this.openWorkspaceCreationDialog();
            }
        };
    }

    protected void setWorkspace(IWorkspace workspace) {
        if (workspace != null) {
            Dialog dialog;
            int result;
            this.fWorkspace = workspace;
            IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID");
            property.setValue(workspace.getItemId().getUuidValue());
            this.setWorkspaceNameText(workspace.getName(), true);
            this.validate();
            this.setDirty(true);
            if (this.shouldShowWorkspaceOwnerWarning() && (result = (dialog = this.getWorkspaceOwnerWarningDialog()).open()) == 0) {
                this.openWorkspaceEditor();
            }
            new Thread(){

                @Override
                public void run() {
                    if (AutoLoadConfigurationEditor.this.shouldShowMappingWarning()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).AutoLoadConfigurationEditor.this.fWorkspaceNameText.isDisposed()) {
                                    return;
                                }
                                Dialog dialog = AutoLoadConfigurationEditor.this.getProjectLibraryMappingWarningDialog();
                                dialog.open();
                            }
                        });
                    }
                }
            }.start();
        }
    }

    private boolean shouldShowMappingWarning() {
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fBuildDefinitionWorkingCopy.getProperty("team.scm.workspaceUUID").getValue()), null);
        try {
            if (!FileSystemIUtil.getInstance().getNonMappedIProjects(workspaceHandle, this.getTeamRepository(), null).isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected Dialog getProjectLibraryMappingWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_LIBRARY_MAPPING_WARNING_TITLE, null, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_LIBRARY_MAPPING_WARNING_MESSAGE, 2, new String[]{IDialogConstants.OK_LABEL}, 0){};
    }

    private boolean shouldShowWorkspaceOwnerWarning() {
        return BuildUIPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING);
    }

    protected Dialog getWorkspaceOwnerWarningDialog() {
        return new MessageDialog(this.fWorkspaceTitleHyperlink.getShell(), BuildDefinitionEditorMessages.JazzScmConfigurationEditor_WORKSPACE_OWNER_WARNING_TITLE, null, BuildDefinitionEditorMessages.AutoLoadConfigurationEditor_WORKSPACE_OWNER_WARNING_MESSAGE, 2, new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_OPEN_WORKSPACE_BUTTON, IDialogConstants.OK_LABEL}, 1){

            protected Control createCustomArea(Composite parent) {
                new Label(parent, 0);
                AutoLoadConfigurationEditor.this.fDontShowWarningButton = new Button(parent, 32);
                AutoLoadConfigurationEditor.this.fDontShowWarningButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_DONT_SHOW_WARNING_AGAIN);
                AutoLoadConfigurationEditor.this.fDontShowWarningButton.addSelectionListener(AutoLoadConfigurationEditor.this.getDontShowWarningButtonListener());
                return AutoLoadConfigurationEditor.this.fDontShowWarningButton;
            }
        };
    }

    protected SelectionListener getDontShowWarningButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildUIPlugin.getDefault().getPreferenceStore().setValue(AutoLoadConfigurationEditor.PREFERENCE_SHOW_WORKSPACE_OWNER_WARNING, !AutoLoadConfigurationEditor.this.fDontShowWarningButton.getSelection());
                BuildUIPlugin.getDefault().savePluginPreferences();
            }
        };
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, (boolean)false, null, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected void openWorkspaceCreationDialog() {
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)this), this.getTeamRepository(), false, (IPartResult)new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper result) {
                AutoLoadConfigurationEditor.this.setWorkspace(result.getWorkspace());
            }
        }, true, (IReadScope)IReadScope.FACTORY.createPublicScope());
        new WizardDialog(this.fWorkspaceTitleHyperlink.getShell(), (IWizard)wizard).open();
    }

    public Control getFocusControl() {
        return this.fSelectWorkspaceButton;
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionautoload";
    }
}

