/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.dialogs;

import com.ibm.teami.build.internal.ui.BuildUIMessages;
import com.ibm.teami.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.internal.ui.editors.builddefinition.ProjectMapping;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectMappingEntryDialog
extends Dialog {
    private String fTitle;
    private Label fErrorMessageLabel;
    private Text fProjectNameText;
    private Text fLoadLibText;
    private Text fTargetLibText;
    private Button fNeedBuildButton;
    private boolean fNeedBuild;
    private String fLoadLibName;
    private String fTargetLibName;
    private ProjectMapping fProjectMapping;

    public ProjectMappingEntryDialog(Shell parentShell, String title, ProjectMapping projectMapping) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fProjectMapping = projectMapping;
        this.fTargetLibName = projectMapping.getTargetLibrary();
        this.fLoadLibName = projectMapping.getLoadLibrary();
        this.fNeedBuild = projectMapping.needBuild();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 450;
        composite.setLayoutData((Object)gridData);
        this.createLabel(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_DESCRIPTION, null);
        this.fErrorMessageLabel = this.createLabel(composite, "", JFaceColors.getErrorText((Display)composite.getDisplay()));
        Label label = new Label(composite, 64);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_PROJECT);
        label = new Label(composite, 64);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(this.fProjectMapping.getProjectName());
        label.setToolTipText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_PROJECT_TOOLTIP);
        this.fLoadLibText = this.createText(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_LOADLIBRARY, this.fProjectMapping.getLoadLibrary(), 2);
        this.fLoadLibText.setTextLimit(10);
        this.fLoadLibText.setToolTipText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_LOADLIBRARY_TOOLTIP);
        this.fLoadLibText.addModifyListener(this.getLoadLibModifiedListener());
        this.fTargetLibText = this.createText(composite, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_TARGETLIBRARY, this.fProjectMapping.getTargetLibrary(), 2);
        this.fTargetLibText.setTextLimit(10);
        this.fTargetLibText.setToolTipText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_TARGETLIBRARY_TOOLTIP);
        this.fTargetLibText.addModifyListener(this.getTargetLibModifiedListener());
        Label label2 = this.createLabel(composite, "", null);
        this.fNeedBuildButton = new Button(composite, 0x800020);
        this.fNeedBuildButton.setText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_BUILD);
        this.fNeedBuildButton.setToolTipText(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_PROJECT_MAPPINGS_DIALOG_BUILD_TOOLTIP);
        this.fNeedBuildButton.setSelection(this.fProjectMapping.needBuild());
        this.fNeedBuildButton.addSelectionListener(this.getBuildModifiedListener());
        ProjectMappingEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private SelectionListener getBuildModifiedListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectMappingEntryDialog.this.validate(false);
                ProjectMappingEntryDialog.this.fNeedBuild = ProjectMappingEntryDialog.this.fNeedBuildButton.getSelection();
            }
        };
    }

    private ModifyListener getLoadLibModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectMappingEntryDialog.this.validate(false);
                ProjectMappingEntryDialog.this.fLoadLibName = ProjectMappingEntryDialog.this.fLoadLibText.getText();
            }
        };
    }

    private ModifyListener getTargetLibModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectMappingEntryDialog.this.validate(false);
                ProjectMappingEntryDialog.this.fTargetLibName = ProjectMappingEntryDialog.this.fTargetLibText.getText();
            }
        };
    }

    public ProjectMapping getProjectMapping() {
        return this.fProjectMapping;
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        if (color != null) {
            label.setForeground(color);
        }
        return label;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2052);
        text.setText(defaultText);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = textHorizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    private String getErrorMessage() {
        if (this.fLoadLibText.getText().equals("")) {
            return BuildUIDialogMessages.LibraryListEntryDialog_LOAD_LIBRARY_NAME_REQUIRED;
        }
        if (!this.fLoadLibText.getText().equals("") && !IBMiLibraryValidator.isValidLibraryName((String)this.fLoadLibText.getText())) {
            return NLS.bind((String)BuildUIMessages.LibraryListControl_ERROR_LIB_NAME_CONFORMANCE, (Object)this.fLoadLibText.getText());
        }
        if (this.fTargetLibText.getText().equals("")) {
            return BuildUIDialogMessages.LibraryListEntryDialog_TARGET_LIBRARY_NAME_REQUIRED;
        }
        if (!this.fTargetLibText.getText().equals("") && !IBMiLibraryValidator.isValidLibraryName((String)this.fTargetLibText.getText())) {
            return NLS.bind((String)BuildUIMessages.LibraryListControl_ERROR_LIB_NAME_CONFORMANCE, (Object)this.fTargetLibText.getText());
        }
        return null;
    }

    private void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.fErrorMessageLabel.setText("");
        } else {
            this.fErrorMessageLabel.setText(errorMessage);
        }
        this.fErrorMessageLabel.redraw();
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
    }

    protected void okPressed() {
        super.okPressed();
        this.fProjectMapping.setNeedBuild(this.fNeedBuild);
        this.fProjectMapping.setLoadLibrary(this.fLoadLibName);
        this.fProjectMapping.setTargetLibrary(this.fTargetLibName);
    }
}

