/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui.dialogs;

import com.ibm.teami.build.internal.ui.BuildUIMessages;
import com.ibm.teami.build.internal.ui.dialogs.BuildUIDialogMessages;
import com.ibm.teami.filesystem.common.validators.IBMiLibraryValidator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BaseLibraryListEntryDialog
extends Dialog {
    private String fTitle;
    private Label fErrorMessageLabel;
    private Text fLibraryNameText;
    private String fLibraryListEntry;
    private boolean fIsNewEntry;
    private String name;
    private String originalName;
    private List<String> baseLibraryListEntries;
    private List<String> uppercaseLibraryNames = new ArrayList<String>();

    public BaseLibraryListEntryDialog(Shell parentShell, String title, String entry, List<String> baseLibraryListEntries, boolean isNewEntry) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fLibraryListEntry = entry;
        this.fIsNewEntry = isNewEntry;
        this.originalName = entry;
        this.baseLibraryListEntries = baseLibraryListEntries;
        this.generateUppercaseList();
    }

    private void generateUppercaseList() {
        if (this.baseLibraryListEntries == null) {
            return;
        }
        int i = 0;
        while (i < this.baseLibraryListEntries.size()) {
            String libName = this.baseLibraryListEntries.get(i);
            String uppercaseName = new String(libName);
            if (libName.startsWith("\"")) {
                String tempLib = libName.substring(1, libName.length() - 1);
                if (tempLib.equals(tempLib.toUpperCase())) {
                    uppercaseName = tempLib;
                }
            } else {
                uppercaseName = libName.toUpperCase();
            }
            this.uppercaseLibraryNames.add(uppercaseName);
            ++i;
        }
    }

    private void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.fErrorMessageLabel.setText("");
        } else {
            this.fErrorMessageLabel.setText(errorMessage);
        }
        this.fErrorMessageLabel.redraw();
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 350;
        composite.setLayoutData((Object)gridData);
        String message = BuildUIDialogMessages.LibraryListEntryDialog_HEADER;
        this.createLabel(composite, message, null);
        this.fErrorMessageLabel = this.createLabel(composite, "", JFaceColors.getErrorText((Display)composite.getDisplay()));
        this.fLibraryNameText = !this.fIsNewEntry ? this.createText(composite, BuildUIMessages.LibraryListControl_LIBRARY, this.fLibraryListEntry.substring(0, this.fLibraryListEntry.length()), 2) : this.createText(composite, BuildUIMessages.LibraryListControl_LIBRARY, "", 2);
        this.name = this.fLibraryNameText.getText();
        this.fLibraryNameText.addModifyListener(this.getNameModifiedListener());
        BaseLibraryListEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private ModifyListener getNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseLibraryListEntryDialog.this.validate(false);
                BaseLibraryListEntryDialog.this.name = BaseLibraryListEntryDialog.this.fLibraryNameText.getText();
            }
        };
    }

    public String getLibraryListEntry() {
        return this.name;
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2052);
        text.setText(defaultText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    private String getErrorMessage() {
        if (this.fLibraryNameText.getText().equals("")) {
            return BuildUIDialogMessages.LibraryListEntryDialog_LIBRARY_NAME_REQUIRED;
        }
        if (!this.fLibraryNameText.getText().equals(this.originalName) && this.isDuplicateLibraryName(this.fLibraryNameText.getText())) {
            return BuildUIDialogMessages.LibraryListEntryDialog_DUPLICATE_ENTRY;
        }
        if (!IBMiLibraryValidator.isValidLibraryName((String)this.fLibraryNameText.getText())) {
            return NLS.bind((String)BuildUIMessages.LibraryListControl_ERROR_LIB_NAME_CONFORMANCE, (Object)this.fLibraryNameText.getText());
        }
        return null;
    }

    private boolean isDuplicateLibraryName(String libName) {
        String uppercaseName = new String(libName);
        if (libName.startsWith("\"")) {
            String tempLib = libName.substring(1, libName.length() - 1);
            if (tempLib.equals(tempLib.toUpperCase())) {
                uppercaseName = tempLib;
            }
            if (this.uppercaseLibraryNames.contains(uppercaseName)) {
                return true;
            }
        } else {
            uppercaseName = libName.toUpperCase();
            if (this.uppercaseLibraryNames.contains(uppercaseName)) {
                return true;
            }
        }
        return false;
    }
}

