/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui;

import com.ibm.team.enterprise.ibmi.build.common.IBuildUtility;
import com.ibm.teami.build.internal.ui.BuildUIMessages;
import com.ibm.teami.build.internal.ui.ProjectMappingControlListener;
import com.ibm.teami.build.internal.ui.dialogs.ProjectMappingEntryDialog;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.internal.ui.editors.builddefinition.ProjectMapping;
import com.ibm.teami.build.internal.ui.editors.builddefinition.ProjectMappingTableContentProvider;
import com.ibm.teami.build.internal.ui.editors.builddefinition.ProjectMappingTableLabelProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProjectMappingControl {
    public static String copyright = "(c) Copyright IBM Corp 2009.";
    protected List<ProjectMapping> projectMappingEntries;
    private final Button fMoveUpButton;
    private final Button fMoveDownButton;
    private final Button fEditButton;
    private final CheckboxTableViewer fTableViewer;
    private final ListenerList fListenerList = new ListenerList();
    private final FormToolkit fToolkit;
    private final Shell fParentShell;
    private String buildProperty;
    private List projects;
    private String buildOrderProperty;
    private String loadLibProperty;
    private String targetLibProperty;
    private boolean foundNewProject = false;

    public ProjectMappingControl(Composite parent, FormToolkit toolkit) {
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        Composite composite = this.fToolkit.createComposite(parent);
        TableWrapData data = new TableWrapData(256, 256);
        composite.setLayoutData((Object)data);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        Composite tableComposite = this.fToolkit.createComposite(composite);
        layout = new TableWrapLayout();
        layout.numColumns = 1;
        tableComposite.setLayout((Layout)layout);
        data = new TableWrapData(256, 256);
        tableComposite.setLayoutData((Object)data);
        Table table = this.fToolkit.createTable(tableComposite, 68386);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnHeaders = new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_BUILD, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_PROJECT, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_LOADLIBRARY, BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_COLUMN_TARGETLIBRARY};
        int[] columnWeights = new int[]{5, 25, 25, 25};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new CheckboxTableViewer(table);
        ProjectMappingTableContentProvider contentProvider = new ProjectMappingTableContentProvider();
        ProjectMappingTableLabelProvider labelProvider = new ProjectMappingTableLabelProvider();
        this.fTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.projectMappingEntries = this.computeProjectMappings(false);
        this.fTableViewer.setInput(this.projectMappingEntries);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTableViewer.addCheckStateListener(this.getCheckStateListener());
        this.fTableViewer.addDoubleClickListener(this.getDoubleClickListener());
        Composite buttonBar = this.fToolkit.createComposite(composite);
        TableWrapLayout layOut = new TableWrapLayout();
        layOut.numColumns = 1;
        buttonBar.setLayout((Layout)layOut);
        this.fEditButton = this.createButton(buttonBar, BuildUIMessages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectMappingControl.this.editMappingEntry();
            }
        });
        this.fMoveUpButton = this.createButton(buttonBar, BuildUIMessages.MOVE_UP_BUTTON_LABEL, 8);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectMappingControl.this.moveEntries(true);
            }
        });
        this.fMoveDownButton = this.createButton(buttonBar, BuildUIMessages.MOVE_DOWN_BUTTON_LABEL, 8);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectMappingControl.this.moveEntries(false);
            }
        });
        this.updatePropertyButtonEnablement();
        this.setButtonLayoutData();
    }

    public TableViewer getTreeViewer() {
        return this.fTableViewer;
    }

    private IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectMappingControl.this.editMappingEntry();
            }
        };
    }

    protected List<ProjectMapping> getProjectMappingEntries() {
        if (this.projectMappingEntries == null) {
            this.projectMappingEntries = new ArrayList<ProjectMapping>();
        }
        return this.projectMappingEntries;
    }

    public void init(List projects, String buildProperty, String buildOrderProperty, String loadLibProperty, String targetLibProperty, boolean newWorkspace) {
        this.projects = projects;
        this.buildProperty = buildProperty;
        this.buildOrderProperty = buildOrderProperty;
        this.loadLibProperty = loadLibProperty;
        this.targetLibProperty = targetLibProperty;
        if (this.projectMappingEntries != null) {
            this.projectMappingEntries.clear();
        }
        this.projectMappingEntries = this.computeProjectMappings(newWorkspace);
        this.fTableViewer.setInput(this.projectMappingEntries);
        for (ProjectMapping mapping : this.projectMappingEntries) {
            this.fTableViewer.setChecked((Object)mapping, mapping.needBuild());
        }
        this.enable(true);
    }

    public void showLoadingMessage() {
        this.projectMappingEntries = new ArrayList<ProjectMapping>();
        this.projectMappingEntries.add(new ProjectMapping(BuildDefinitionEditorMessages.JazzScmConfigurationEditor_LOADING));
        this.fTableViewer.setInput(this.projectMappingEntries);
        this.enable(false);
    }

    public void enable(boolean enable) {
        if (enable) {
            this.fTableViewer.getTable().setEnabled(true);
            this.updatePropertyButtonEnablement();
        } else {
            this.fTableViewer.getTable().setEnabled(false);
            this.fEditButton.setEnabled(false);
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    protected ICheckStateListener getCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectMapping mapping = (ProjectMapping)event.getElement();
                mapping.setNeedBuild(event.getChecked());
                ProjectMappingControl.this.notifyMappingModified();
            }
        };
    }

    protected List<ProjectMapping> computeProjectMappings(boolean newWorkspace) {
        block12: {
            List<Object> projectOrderList;
            block11: {
                if (this.projects == null || this.projects.size() == 0) {
                    return new ArrayList<ProjectMapping>();
                }
                projectOrderList = new ArrayList();
                if (!newWorkspace) break block11;
                for (String projectName : this.projects) {
                    this.getProjectMapping(projectName);
                }
                break block12;
            }
            Iterator projectIter = this.projects.iterator();
            if (this.buildOrderProperty.trim().length() > 0) {
                projectOrderList = this.parseCompactFormat(this.buildOrderProperty);
            }
            List<String> buildProjectList = this.parseCompactFormat(this.buildProperty);
            Hashtable loadLibPair = IBuildUtility.parseNameValuePairFormat((String)this.loadLibProperty);
            Hashtable targetLibPair = IBuildUtility.parseNameValuePairFormat((String)this.targetLibProperty);
            while (projectIter.hasNext()) {
                String projectName = (String)projectIter.next();
                ProjectMapping projectMapping = this.getProjectMapping(projectName);
                projectMapping.setNeedBuild(buildProjectList.contains(projectName));
                String loadLib = (String)loadLibPair.get(projectName);
                String targetLib = (String)targetLibPair.get(projectName);
                if (loadLib != null) {
                    projectMapping.setLoadLibrary(loadLib);
                }
                if (targetLib == null) continue;
                projectMapping.setTargetLibrary(targetLib);
            }
            if (projectOrderList.size() <= 0) break block12;
            int location = 0;
            int i = 0;
            while (i < projectOrderList.size()) {
                int projectLocation = this.findProjectInProjectMappingList((String)projectOrderList.get(i));
                if (projectLocation != -1) {
                    ProjectMapping mapping = this.projectMappingEntries.get(projectLocation);
                    this.projectMappingEntries.remove(projectLocation);
                    this.projectMappingEntries.add(location, mapping);
                    ++location;
                }
                ++i;
            }
            i = 0;
            while (i < this.projectMappingEntries.size()) {
                String projectMapName = this.projectMappingEntries.get(i).getProjectName();
                boolean found = false;
                int j = 0;
                while (j < projectOrderList.size() && !found) {
                    String name = (String)projectOrderList.get(j);
                    if (name.equals(projectMapName)) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this.projectMappingEntries.get(i).setNeedBuild(true);
                    this.foundNewProject = true;
                }
                ++i;
            }
        }
        return this.projectMappingEntries;
    }

    public boolean foundNewProjectDuringInit() {
        return this.foundNewProject;
    }

    private int findProjectInProjectMappingList(String project) {
        int i = 0;
        while (i < this.projectMappingEntries.size()) {
            if (project.equals(this.projectMappingEntries.get(i).getProjectName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ProjectMapping getProjectMapping(String projectName) {
        ProjectMapping projectMapping2;
        for (ProjectMapping projectMapping2 : this.getProjectMappingEntries()) {
            if (!projectMapping2.getProjectName().equals(projectName)) continue;
            return projectMapping2;
        }
        Hashtable loadLibPair = IBuildUtility.parseNameValuePairFormat((String)this.loadLibProperty);
        Hashtable targetLibPair = IBuildUtility.parseNameValuePairFormat((String)this.targetLibProperty);
        projectMapping2 = new ProjectMapping(projectName);
        String loadLib = (String)loadLibPair.get(projectName);
        String targetLib = (String)targetLibPair.get(projectName);
        if (loadLib != null) {
            projectMapping2.setLoadLibrary(loadLib);
        }
        if (targetLib != null) {
            projectMapping2.setTargetLibrary(targetLib);
        }
        this.projectMappingEntries.add(projectMapping2);
        return projectMapping2;
    }

    protected List<String> parseCompactFormat(String concatedProjectNames) {
        String[] projects = concatedProjectNames.split(";;");
        ArrayList<String> projectNameList = new ArrayList<String>();
        String[] stringArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            if (projectName.trim().length() > 0) {
                projectNameList.add(projectName);
            }
            ++n2;
        }
        return projectNameList;
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectMappingControl.this.updatePropertyButtonEnablement();
            }
        };
    }

    private Button createButton(Composite parent, String label, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createButton(parent, label, style);
        }
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    private void moveEntries(boolean up) {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (up) {
                for (ProjectMapping entry : structuredSelection) {
                    int orig = this.projectMappingEntries.indexOf(entry);
                    this.projectMappingEntries.remove(entry);
                    this.projectMappingEntries.add(orig - 1, entry);
                }
            } else {
                Vector<ProjectMapping> move = new Vector<ProjectMapping>();
                for (ProjectMapping entry : structuredSelection) {
                    move.add(0, entry);
                }
                int i = 0;
                while (i < move.size()) {
                    int orig = this.projectMappingEntries.indexOf(move.get(i));
                    this.projectMappingEntries.remove(move.get(i));
                    this.projectMappingEntries.add(orig + 1, (ProjectMapping)move.get(i));
                    ++i;
                }
            }
            this.fTableViewer.refresh();
            this.updatePropertyButtonEnablement();
            this.notifyMappingModified();
        }
    }

    private void editMappingEntry() {
        ISelection selection = this.fTableViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        ProjectMapping entry = (ProjectMapping)((IStructuredSelection)selection).getFirstElement();
        ProjectMappingEntryDialog dialog = new ProjectMappingEntryDialog(this.fParentShell, BuildUIMessages.ProjectMappingControl_EDIT_TITLE, entry);
        String oldTargetLib = entry.getTargetLibrary();
        String oldLoadLib = entry.getLoadLibrary();
        boolean oldBuildFlag = entry.needBuild();
        if (!(dialog.open() != 0 || entry.getLoadLibrary().equals(oldLoadLib) && entry.getTargetLibrary().equals(oldTargetLib) && entry.needBuild() == oldBuildFlag)) {
            this.fTableViewer.setChecked((Object)entry, entry.needBuild());
            this.fTableViewer.refresh();
            this.notifyMappingModified();
        }
    }

    private IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updatePropertyButtonEnablement() {
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fEditButton.setEnabled(selection.size() == 1);
        if (!selection.isEmpty()) {
            int size = selection.size();
            ProjectMapping first = (ProjectMapping)selection.getFirstElement();
            if (this.projectMappingEntries.indexOf(first) == 0) {
                this.fMoveUpButton.setEnabled(false);
            } else {
                this.fMoveUpButton.setEnabled(true);
            }
            if (this.projectMappingEntries.indexOf(first) + size == this.projectMappingEntries.size()) {
                this.fMoveDownButton.setEnabled(false);
            } else {
                this.fMoveDownButton.setEnabled(true);
            }
        } else {
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    private void setButtonLayoutData() {
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fEditButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fMoveUpButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fMoveDownButton.setLayoutData((Object)tableWrapData);
    }

    public String getBuildProperty() {
        StringBuffer projBuildProperty = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (!mapping.needBuild()) continue;
            if (projBuildProperty.length() != 0) {
                projBuildProperty.append(";;");
            }
            projBuildProperty.append(mapping.getProjectName());
        }
        return projBuildProperty.toString();
    }

    public String getBuildOrderProperty() {
        StringBuffer buildOrder = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (buildOrder.length() != 0) {
                buildOrder.append(";;");
            }
            buildOrder.append(mapping.getProjectName());
        }
        return buildOrder.toString();
    }

    public String getLoadLibProperty() {
        StringBuffer projLoadLibrary = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (projLoadLibrary.length() != 0) {
                projLoadLibrary.append(";;");
            }
            projLoadLibrary.append(mapping.getProjectName());
            projLoadLibrary.append("=");
            projLoadLibrary.append(mapping.getLoadLibrary());
        }
        return projLoadLibrary.toString();
    }

    public String getTargetLibProperty() {
        StringBuffer projTargetLibrary = new StringBuffer();
        for (ProjectMapping mapping : this.projectMappingEntries) {
            if (projTargetLibrary.length() != 0) {
                projTargetLibrary.append(";;");
            }
            projTargetLibrary.append(mapping.getProjectName());
            projTargetLibrary.append("=");
            projTargetLibrary.append(mapping.getTargetLibrary());
        }
        return projTargetLibrary.toString();
    }

    public void addListener(ProjectMappingControlListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeListener(ProjectMappingControlListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected void notifyMappingModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof ProjectMappingControlListener) {
                ProjectMappingControlListener listener = (ProjectMappingControlListener)listeners[i];
                listener.projectMappingModified();
            }
            ++i;
        }
    }

    public void cleanup() {
    }

    public String validate() {
        for (ProjectMapping entry : this.projectMappingEntries) {
            String loadLib = entry.getLoadLibrary();
            String targLib = entry.getTargetLibrary();
            if (loadLib != null && !loadLib.equals("") && targLib != null && !targLib.equals("")) continue;
            return BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_PROJECT_MAPPINGS_TABLE_INVALID_STATE;
        }
        return null;
    }
}

