/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui;

import com.ibm.teami.build.internal.ui.BuildUIMessages;
import com.ibm.teami.build.internal.ui.LibraryListControlListener;
import com.ibm.teami.build.internal.ui.dialogs.LibraryListEntryDialog;
import com.ibm.teami.build.internal.ui.editors.builddefinition.LibraryListTableContentProvider;
import com.ibm.teami.build.internal.ui.editors.builddefinition.LibraryListTableLabelProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LibraryListControl {
    private Shell fParentShell;
    protected List<String> libraryListEntries;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private TableViewer fTableViewer;
    private ListenerList fListenerList = new ListenerList();
    private static final String COLUMN_LIBRARY = "library";
    private static final String COLUMN_POSITION = "position";
    private FormToolkit fToolkit;

    public LibraryListControl(Composite parent, FormToolkit toolkit, String libraryListProperty, boolean isEditable) {
        this.libraryListEntries = this.getLibraryList(libraryListProperty);
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        Composite composite = this.fToolkit.createComposite(parent);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        Composite tableComposite = this.fToolkit.createComposite(composite);
        tableComposite.setLayoutData((Object)new TableWrapData(256, 256));
        Table table = this.fToolkit.createTable(tableComposite, 68354);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnProperties = new String[]{COLUMN_LIBRARY};
        String[] columnHeaders = new String[]{BuildUIMessages.LibraryListControl_LIBRARY};
        int[] columnWeights = new int[]{100};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        LibraryListTableLabelProvider labelProvider = new LibraryListTableLabelProvider(this.fTableViewer);
        this.fTableViewer.setContentProvider((IContentProvider)new LibraryListTableContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTableViewer.setInput(this.libraryListEntries);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        if (isEditable) {
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    LibraryListControl.this.handleDoubleClick(event);
                }
            });
            Composite buttonBar = this.fToolkit.createComposite(composite);
            TableWrapLayout twl = new TableWrapLayout();
            twl.numColumns = 1;
            buttonBar.setLayout((Layout)twl);
            this.fAddButton = this.createButton(buttonBar, BuildUIMessages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LibraryListControl.this.addEntry();
                }
            });
            this.fRemoveButton = this.createButton(buttonBar, BuildUIMessages.REMOVE_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LibraryListControl.this.removeSelectedEntries();
                }
            });
            this.fEditButton = this.createButton(buttonBar, BuildUIMessages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LibraryListControl.this.editEntry();
                }
            });
            this.fMoveUpButton = this.createButton(buttonBar, BuildUIMessages.MOVE_UP_BUTTON_LABEL, 8);
            this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LibraryListControl.this.moveEntries(true);
                }
            });
            this.fMoveDownButton = this.createButton(buttonBar, BuildUIMessages.MOVE_DOWN_BUTTON_LABEL, 8);
            this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LibraryListControl.this.moveEntries(false);
                }
            });
            this.updatePropertyButtonEnablement();
            this.setButtonLayoutData();
        }
    }

    private List<String> getLibraryList(String libraryListProperty) {
        Vector<String> v = new Vector<String>();
        if (libraryListProperty != null && libraryListProperty.length() > 0) {
            StringTokenizer st = new StringTokenizer(libraryListProperty, new String(new char[]{'?'}));
            while (st.hasMoreTokens()) {
                String lib = st.nextToken();
                v.add(lib);
            }
        }
        return v;
    }

    public String getLibraryListProperty() {
        String libraryList = "";
        int i = 0;
        while (i < this.libraryListEntries.size()) {
            libraryList = libraryList.concat(this.libraryListEntries.get(i));
            if (i < this.libraryListEntries.size() - 1) {
                libraryList = libraryList.concat(new String(new char[]{'?'}));
            }
            ++i;
        }
        return libraryList;
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LibraryListControl.this.updatePropertyButtonEnablement();
            }
        };
    }

    public void addListener(LibraryListControlListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeListener(LibraryListControlListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected void notifyListModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof LibraryListControlListener) {
                LibraryListControlListener listener = (LibraryListControlListener)listeners[i];
                listener.libraryListModified();
            }
            ++i;
        }
    }

    private void addEntry() {
        LibraryListEntryDialog dialog = this.getBuildPropertyDialog("");
        if (dialog.open() == 0) {
            this.libraryListEntries.add(dialog.getLibraryListEntry());
            this.fTableViewer.refresh();
            this.notifyListModified();
        }
    }

    private LibraryListEntryDialog getBuildPropertyDialog(String entry) {
        return new LibraryListEntryDialog(this.fParentShell, BuildUIMessages.LibraryListControl_ADD_TITLE, entry, this.libraryListEntries, true);
    }

    private void editEntry() {
        ISelection selection = this.fTableViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        String entry = (String)((IStructuredSelection)selection).getFirstElement();
        LibraryListEntryDialog dialog = new LibraryListEntryDialog(this.fParentShell, BuildUIMessages.LibraryListControl_EDIT_TITLE, entry, this.libraryListEntries, false);
        if (dialog.open() == 0) {
            int pos = this.libraryListEntries.indexOf(entry);
            this.libraryListEntries.remove(entry);
            this.libraryListEntries.add(pos, dialog.getLibraryListEntry());
            this.fTableViewer.refresh();
            this.notifyListModified();
        }
    }

    private void removeSelectedEntries() {
        ISelection selection;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)this.fParentShell, (String)BuildUIMessages.LibraryListControl_CONFIRM_TITLE, (String)BuildUIMessages.LibraryListControl_CONFIRM);
        if (deleteConfirmed && (selection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<String> entriesRemoved = new ArrayList<String>();
            for (String entry : structuredSelection) {
                this.fTableViewer.remove((Object)entry);
                this.libraryListEntries.remove(entry);
                entriesRemoved.add(entry);
            }
            if (!entriesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.updatePropertyButtonEnablement();
                this.notifyListModified();
            }
        }
    }

    private void moveEntries(boolean up) {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (up) {
                for (String entry : structuredSelection) {
                    int orig = this.libraryListEntries.indexOf(entry);
                    this.libraryListEntries.remove(entry);
                    this.libraryListEntries.add(orig - 1, entry);
                }
            } else {
                Vector<String> move = new Vector<String>();
                for (String entry : structuredSelection) {
                    move.add(0, entry);
                }
                int i = 0;
                while (i < move.size()) {
                    int orig = this.libraryListEntries.indexOf(move.get(i));
                    this.libraryListEntries.remove(move.get(i));
                    this.libraryListEntries.add(orig + 1, (String)move.get(i));
                    ++i;
                }
            }
            this.fTableViewer.refresh();
            this.updatePropertyButtonEnablement();
            this.notifyListModified();
        }
    }

    private IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updatePropertyButtonEnablement() {
        if (this.fEditButton == null) {
            return;
        }
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fEditButton.setEnabled(selection.size() == 1);
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        if (!selection.isEmpty()) {
            int size = selection.size();
            String first = (String)selection.getFirstElement();
            if (this.libraryListEntries.indexOf(first) == 0) {
                this.fMoveUpButton.setEnabled(false);
            } else {
                this.fMoveUpButton.setEnabled(true);
            }
            if (this.libraryListEntries.indexOf(first) + size == this.libraryListEntries.size()) {
                this.fMoveDownButton.setEnabled(false);
            } else {
                this.fMoveDownButton.setEnabled(true);
            }
        } else {
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    private Button createButton(Composite parent, String label, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createButton(parent, label, style);
        }
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.editEntry();
    }

    private void setButtonLayoutData() {
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fAddButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fEditButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fRemoveButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fMoveUpButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fMoveDownButton.setLayoutData((Object)tableWrapData);
    }
}

