/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.internal.ui;

import com.ibm.teami.build.internal.ui.BuildUIMessages;
import com.ibm.teami.build.internal.ui.ProjectMappingControlListener;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BaseLibraryListTableContentProvider;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BaseLibraryListTableLabelProvider;
import com.ibm.teami.build.internal.ui.editors.builddefinition.BuildDefinitionEditorMessages;
import com.ibm.teami.build.ui.AbstractReferencedLibrariesControl;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BaseLibraryListControl
extends AbstractReferencedLibrariesControl {
    public static String copyright = "(c) Copyright IBM Corp 2009.";
    private final FormToolkit fToolkit;
    private static final String COLUMN_LIBRARY = "library";

    public BaseLibraryListControl(Composite parent, FormToolkit toolkit, String baseLibraryListProperty) {
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        Composite composite = this.fToolkit.createComposite(parent);
        TableWrapData data = new TableWrapData(256, 256);
        composite.setLayoutData((Object)data);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        Composite tableComposite = this.fToolkit.createComposite(composite);
        layout = new TableWrapLayout();
        layout.numColumns = 1;
        tableComposite.setLayout((Layout)layout);
        data = new TableWrapData(256, 256);
        tableComposite.setLayoutData((Object)data);
        Table table = this.fToolkit.createTable(tableComposite, 68354);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnProperties = new String[]{COLUMN_LIBRARY};
        String[] columnHeader = new String[]{BuildDefinitionEditorMessages.JazzScmConfigurationEditor_SECTION_BASE_LIBRARIES_TABLE_COLUMN_BASELIBRARY};
        int[] columnWeight = new int[]{5};
        int i = 0;
        while (i < columnHeader.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeader[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeight[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        BaseLibraryListTableContentProvider contentProvider = new BaseLibraryListTableContentProvider();
        BaseLibraryListTableLabelProvider labelProvider = new BaseLibraryListTableLabelProvider(this.fTableViewer);
        this.fTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.baseLibraryListEntries = this.getBaseLibraryList(baseLibraryListProperty);
        this.fTableViewer.setInput((Object)this.baseLibraryListEntries);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BaseLibraryListControl.this.handleDoubleClick(event);
            }
        });
        Composite baseLiblButtonBar = this.fToolkit.createComposite(composite);
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 1;
        baseLiblButtonBar.setLayout((Layout)twl);
        this.fAddButton = this.createButton(baseLiblButtonBar, BuildUIMessages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseLibraryListControl.this.addEntry();
            }
        });
        this.fRemoveButton = this.createButton(baseLiblButtonBar, BuildUIMessages.REMOVE_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseLibraryListControl.this.removeSelectedEntries();
            }
        });
        this.fEditButton = this.createButton(baseLiblButtonBar, BuildUIMessages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseLibraryListControl.this.editEntry();
            }
        });
        this.fMoveUpButton = this.createButton(baseLiblButtonBar, BuildUIMessages.MOVE_UP_BUTTON_LABEL, 8);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseLibraryListControl.this.moveEntries(true);
            }
        });
        this.fMoveDownButton = this.createButton(baseLiblButtonBar, BuildUIMessages.MOVE_DOWN_BUTTON_LABEL, 8);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseLibraryListControl.this.moveEntries(false);
            }
        });
        this.updatePropertyButtonEnablement();
        this.setButtonLayoutData();
    }

    private Button createButton(Composite parent, String label, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createButton(parent, label, style);
        }
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    private void setButtonLayoutData() {
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fAddButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fEditButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fRemoveButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fMoveUpButton.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(128);
        tableWrapData.colspan = 1;
        this.fMoveDownButton.setLayoutData((Object)tableWrapData);
    }

    public void removeListener(ProjectMappingControlListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    public void cleanup() {
    }

    public String validate() {
        return null;
    }
}

