<?xml version="1.0" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" exclude-result-prefixes="ibuild"
 xmlns:ibuild="http://www.ibm.com/com.ibm.etools.iseries.projects/ibuild/1.0.0">
<xsl:output method="xml" encoding="UTF-8" indent="yes" /> 
<xsl:param name="BASE_DIR"/>

<!-- Transform template -->
<xsl:template match="/"> 


<project name="Build" default="all">
<property file="./build.properties"/>

<property name="loadDir">
<xsl:attribute name="value"> 
<xsl:value-of select="$BASE_DIR"/>
</xsl:attribute>
</property>

<typedef name="AS400Type" classname="com.ibm.iant.types.AS400Type"/>
<typedef name="tasks" classname="com.ibm.iant.types.build.IBMITasks"/>
<taskdef name="iBuildSpecTargetTask" classname="com.ibm.iant.taskdefs.build.IBMIBuildTask"/>
<taskdef name="itag" classname="com.ibm.iant.taskdefs.build.IBMITagTask"/>
<taskdef name="ibuild" classname="com.ibm.iant.taskdefs.build.IBMIGenericBuildTask"/>
<taskdef name="isetup" classname="com.ibm.iant.taskdefs.build.IBMIBuildSetupTask"/>
<taskdef name="iteardown" classname="com.ibm.iant.taskdefs.build.IBMIBuildCompleteTask"/>

<typedef name="AS400System" classname="com.ibm.iant.types.AS400Type"/> 	 

<AS400Type>
<xsl:attribute name="systemname"> 
<xsl:text>${hostname}</xsl:text>
</xsl:attribute>

<xsl:attribute name="userid"> 
<xsl:text>${userid}</xsl:text>
</xsl:attribute>
<xsl:attribute name="userpassword"> 
<xsl:text>${userpw}</xsl:text>		
</xsl:attribute>
<xsl:attribute name="id"> 
<xsl:text>SystemInstance</xsl:text>
</xsl:attribute>
</AS400Type>
 
<!-- only run it when it has not been run before -->
<target name="all" unless="alreadyRun">
	<echo>Starting build for project: ${projectName}</echo>
	<condition property="runDependencies">
   		<and>
   			<not>
      			<isset property="com.ibm.iant.devBuild"/>
      		</not>
      		<not>
      			<isset property="alreadyRun"/>
      		</not>
		</and>
	</condition>
	<antcall target="build" inheritAll="true" />
</target>

<target name="build" depends="dependencies,prebuild,main,postbuild"></target>

<target name="dependencies" if="runDependencies">
	<xsl:for-each select="//ibuild:projectref[@type='*DEPENDENCY']">  
 		<ant>
  			<xsl:attribute name="antfile"> 
  			<xsl:text>${loadDir}/</xsl:text><xsl:value-of select="@project"/><xsl:text>/.ibmi/build.xml</xsl:text>
  			</xsl:attribute>
  			<xsl:attribute name="dir"> 
  			<xsl:text>${loadDir}/</xsl:text><xsl:value-of select="@project"/><xsl:text>/.ibmi</xsl:text>
  			</xsl:attribute>
  			<xsl:attribute name="inheritAll"> 
  			<xsl:text>false</xsl:text>
  			</xsl:attribute>
  			<xsl:attribute name="inheritRefs"> 
  			<xsl:text>true</xsl:text>
  			</xsl:attribute>
  		</ant> 
 	</xsl:for-each>
</target>
<target name="prebuild" unless="alreadyRun">
		<isetup systemref="SystemInstance"> 
		<xsl:attribute name="curlib">
		<xsl:text>${ibuild.targetLibrary}</xsl:text>
		</xsl:attribute> 
		</isetup>
		<itag systemref="SystemInstance"> 
		<xsl:attribute name="library">
		<xsl:text>${ibuild.targetLibrary}</xsl:text>
		</xsl:attribute> 
		<xsl:attribute name="buildid">
		<xsl:text>${build.tag.id}</xsl:text>
		</xsl:attribute></itag>
</target>
<target name="postbuild" unless="alreadyRun">
		<itag systemref="SystemInstance" tag="true"/>
		<iteardown systemref="SystemInstance"/>
		<echo file="build.properties" append="true" message="alreadyRun = true"></echo>
</target>

<target name="main" unless="alreadyRun">
<xsl:attribute name="depends"> 
<xsl:call-template name="getMainDepends"/> 
</xsl:attribute> 
</target>

<xsl:for-each select="//ibuild:target">  
<xsl:element name="target">
<xsl:attribute name="name"> 
<xsl:value-of select="@id"/> 
</xsl:attribute>
<xsl:attribute name="depends"> 
<xsl:call-template name="getTargetDepends"/> 
</xsl:attribute> 
<iBuildSpecTargetTask systemref="SystemInstance">
<xsl:apply-templates select="ibuild:output"/> 
<xsl:apply-templates select="ibuild:inputs"/> 
<xsl:apply-templates select="ibuild:taskrefs"/> 
<xsl:apply-templates select="ibuild:variables"/>
<xsl:apply-templates select="//ibuild:project/ibuild:variables"/>
</iBuildSpecTargetTask>

</xsl:element>
</xsl:for-each>

<tasks> 
<xsl:for-each select="//ibuild:task">  
<ibuild>
<xsl:apply-templates select="@id |@checkObject|*"/> 
</ibuild>
</xsl:for-each>

<!-- copy over the referenced tasks from the referenced build specification -->
<xsl:for-each select="//ibuild:projectref[@type='*IMPORT']"> 
<xsl:variable name="project"><xsl:value-of select="$BASE_DIR"/>/<xsl:value-of select="@project"/>/.ibmi/.ibuild</xsl:variable>
  <xsl:apply-templates select="document($project)//ibuild:task">
  	<xsl:with-param name="projectname" select="@id"/>
  </xsl:apply-templates>
</xsl:for-each>

</tasks>
</project>
</xsl:template> 

<!-- template to identity copy taskrefs, replacing id with taskid. 
If it references a project, prefix the taskid with the project name -->
<xsl:template match="ibuild:taskrefs">
    <xsl:element name="{name()}">
        <xsl:for-each select="ibuild:taskref">
        <xsl:element name="{name()}">
        	<xsl:attribute name="taskid">
        	    <xsl:if test="@projectRefID!=''">
        	       <xsl:value-of select="@projectRefID"/><xsl:text>_</xsl:text>
        	    </xsl:if>        	
        	 <xsl:value-of select="@refid"/>
        	</xsl:attribute>
        	<xsl:apply-templates select="*"/>
        </xsl:element>
        </xsl:for-each>
    </xsl:element>
</xsl:template>

<!-- template to identity copy task, prefix the id with the project name
because it is defined in the referenced project build spec -->
<xsl:template match="ibuild:task">
   <xsl:param name="projectname"/>
    <xsl:element name="ibuild">
        <xsl:attribute name="id">
        	 <xsl:value-of select="concat($projectname,'_',@id)"/>
        </xsl:attribute>
        	<xsl:apply-templates select="*"/>
    </xsl:element>
</xsl:template>


<!-- identity copy element without namespaces -->
<xsl:template match="ibuild:project/ibuild:variables">
    <xsl:element name="global{name()}">
        <xsl:apply-templates select="@*|*"/>
    </xsl:element>
</xsl:template>

<!-- identity copy element without namespaces -->
<xsl:template match="*">
    <xsl:element name="{name()}">
        <xsl:apply-templates select="@*|*"/>
    </xsl:element>
</xsl:template>

<!-- copy attributes-->
<xsl:template match="@*">
    <xsl:copy>
        <xsl:apply-templates select="."/>
    </xsl:copy>
</xsl:template>

<!-- get the target depends for the main target -->
<xsl:template name="getMainDepends">  
<xsl:for-each select="//ibuild:target">  
<xsl:value-of select="@id"/>  
<xsl:if test="position()!=last()">  
<xsl:text>,</xsl:text>  
</xsl:if>  
</xsl:for-each>  
</xsl:template>  


<!-- get the target depends for the a target -->
<xsl:template name="getTargetDepends">  
<xsl:for-each select="ibuild:targetrefs/ibuild:targetref">  
<xsl:value-of select="@refid"/>  
<xsl:if test="position()!=last()">  
<xsl:text> , </xsl:text>  
</xsl:if>  
</xsl:for-each>  
</xsl:template>  

<!-- get the project name from the projectreference -->
<xsl:template name="getTaskProjectID"> 
<xsl:param name="refid"/>
<xsl:if test="//ibuild:tasks/ibuild:proxyTask[@refid=$refid]">
<xsl:value-of select="//ibuild:tasks/ibuild:proxyTask[@refid=$refid]/@projectRefID"/><xsl:text>_</xsl:text>
</xsl:if>
</xsl:template>  


</xsl:stylesheet>