/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.task;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSFileWriter;
import com.ibm.as400.access.Job;
import com.ibm.etools.iseries.util.AS400Factory;
import com.ibm.team.build.ant.task.AbstractPublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.ant.task.LogPublisherTask;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.publishing.WorkItemPublisher;
import com.ibm.team.build.internal.scm.BuildWorkspaceDescriptor;
import com.ibm.team.build.internal.scm.RepositoryManager;
import com.ibm.team.build.internal.scm.ScmMessages;
import com.ibm.team.enterprise.ibmi.build.common.IBuildUtility;
import com.ibm.team.enterprise.internal.ibmi.build.client.scm.IBMISourceControlUtility;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanResultHandle;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.common.model.ScanStatus;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.teami.build.internal.generator.IBuildAntGenerator;
import com.ibm.teami.filesystem.client.internal.operations.AcceptIReport;
import com.ibm.teami.filesystem.client.util.FileSystemIUtil;
import com.ibm.teami.filesystem.common.util.IProjectInfo;
import com.ibm.teamp.build.ant.task.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IBMIPreBuildTask
extends AbstractTeamBuildTask {
    public static final String WORKSPACE_UUID = "workspaceUUID";
    public static final String BUILD_REQUEST_UUID = "buildRequestUUID";
    public static final String BUILD_RESULT_UUID = "buildResultUUID";
    private static final int KILO_BYTE_IN_BYTES = 1024;
    private static final int BUFFER_SIZE = 32768;
    private static final String BUILD_PROPERY_PREFIX = "ibuild";
    private static final String BUILD_PROPERTY_SOURCE_LIBRARY = "ibuild.sourceLibrary";
    private static final String BUILD_PROPERTY_TARGET_LIBRARY = "ibuild.targetLibrary";
    private static final String BUILD_PROPERTY_FIX_LIBRARIES = "ibuild.fixlibl";
    private static final String BUILD_PROPERTY_BASE_LIBRARIES = "ibuild.baselibl";
    private static final String BUILD_PROPERTY_COMPONENT_UUID = "ibuild.componentUUID";
    private static final String BUILD_PROPERTY_PROJECT_UUID = "ibuild.projectUUID";
    private static final String BUILD_PROPERTY_PROJECT_NAME = "projectName";
    private static final String BUILD_PROPERTY_CIRCULAR_PROJECT_DEPENDENCY = "circularProjectDependency";
    private static final String BUILD_SPEC_PROJECTREF_ATTRIBUTE_NAME_TYPE = "type";
    private static final String BUILD_SPEC_PROJECTREF_ATTRIBUTE_VALUE_TYPE_IMPORT = "*IMPORT";
    private static final String BUILD_SPEC_PROJECTREF_ATTRIBUTE_VALUE_TYPE_DEPENDENCY = "*DEPENDENCY";
    private static final String BUILD_SPEC_PROJECTREF_ATTRIBUTE_NAME_PROJECT = "project";
    private static final String BUILD_SPEC_ELEMENT_PROJECTREF = "projectref";
    private String fWorkspaceUUID;
    private String fBuildResultUUID;
    private String fBuildRequestUUID;
    private AcceptIReport acceptReport = null;
    private IUpdateReport updateReport = null;
    private RepositoryManager fRepositoryManager;
    protected static List<String> projNames;
    private ITeamBuildClient buildClient = null;
    private String parentActivityId = null;

    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        BuildItemFactory.initializeBuildPackage();
        FileSystemCore.startUp();
    }

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(WORKSPACE_UUID, this.fWorkspaceUUID, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_RESULT_UUID, this.fBuildResultUUID, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_REQUEST_UUID, this.fBuildRequestUUID, false));
    }

    protected void doExecute() throws Exception {
        this.fRepositoryManager = RepositoryManager.createWith((ITeamRepository)this.getTeamRepository());
        boolean shouldBuild = this.shouldBuild();
        if (shouldBuild) {
            this.buildClient = (ITeamBuildClient)this.getTeamRepository().getClientLibrary(ITeamBuildClient.class);
            IBuildResult result = this.getBuildResult(this.getTeamRepository());
            this.parentActivityId = this.buildClient.startBuildActivity((IBuildResultHandle)result, Messages.JazzScmPreBuildParticipant_PRE_BUILD_ACTIVITY, null, false, null);
            this.preBuild();
            this.printToBuildLog("Starting to scan metadata...");
            String scanActivityId = this.buildClient.startBuildActivity((IBuildResultHandle)result, Messages.JazzScmPreBuildParticipant_METADATA_SCAN_ACTIVITY, null, false, null);
            this.scanMetadata();
            this.buildClient.completeBuildActivity((IBuildResultHandle)result, scanActivityId, null);
            this.printToBuildLog("Metadata scanning is finished.");
            this.buildClient.completeBuildActivity((IBuildResultHandle)result, this.parentActivityId, null);
        }
    }

    protected void scanMetadata() {
        block9: {
            try {
                IScdClient scdClient = (IScdClient)this.getTeamRepository().getClientLibrary(IScdClient.class);
                ITeamRepository repository = this.getTeamRepository();
                IWorkspace workspace = this.getWorkspace(repository);
                IWorkspace stream = this.getWorkspaceStream(workspace, repository);
                if (stream != null) {
                    IWorkspaceHandle[] workspaceHandles = new IWorkspaceHandle[]{stream};
                    boolean force = false;
                    try {
                        force = Boolean.valueOf(this.getProject().getProperty("forceMetadataRescan"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (force) {
                        System.out.println("IBMiPreBuildTask.scanMetadata(): Starting to full scan metadata for stream " + stream.getName());
                    } else {
                        System.out.println("IBMiPreBuildTask.scanMetadata(): Starting to update metadata for stream " + stream.getName());
                    }
                    IScanConfiguration scanConfiguration = scdClient.getScanConfiguration((IWorkspaceHandle)stream);
                    IScanRequest scanRequest = scdClient.createBuildScanRequest(scanConfiguration, (IAuditableHandle)this.getBuildResult(this.getTeamRepository()), force);
                    NullProgressMonitor progressMonitor = new NullProgressMonitor();
                    IScanResultHandle scanResultHandle = scanRequest.getScanResult();
                    IScanResult scanResult = (IScanResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)scanResultHandle, 1, (IProgressMonitor)progressMonitor);
                    boolean scanFinished = scanResult.getState() == ScanState.COMPLETED || scanResult.getState() == ScanState.CANCELLED;
                    while (!scanFinished) {
                        Thread.sleep(3000L);
                        scanResult = (IScanResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)scanResultHandle, 1, (IProgressMonitor)progressMonitor);
                        boolean bl = scanFinished = scanResult.getState() == ScanState.COMPLETED || scanResult.getState() == ScanState.CANCELLED;
                    }
                    if (scanResult.getStatus() == ScanStatus.ERROR) {
                        throw new TeamBuildException("Error scanning stream");
                    }
                    System.out.println("IBMiPreBuildTask.scanMetadata(): Finished metadata scanning for stream " + stream.getName());
                    break block9;
                }
                System.out.println("IBMiPreBuildTask.scanMetadata(): Error when scanning metadata: stream is NULL");
            }
            catch (Exception e) {
                System.out.println("IBMiPreBuildTask.scanMetadata():" + NLS.bind((String)Messages.AntBuildParticipant_ERROR_SCAN_DEPENDENCY_METADATA, (Object)e.getMessage()));
            }
        }
    }

    public boolean shouldBuild() throws Exception {
        String[] projectBuildOrder = this.getBuildOrder().split(";;");
        Hashtable loadLibrariesPerProject = IBuildUtility.parseNameValuePairFormat((String)this.getLoadLibrariesPerProject());
        Hashtable targetLibrariesPerProject = IBuildUtility.parseNameValuePairFormat((String)this.getTargetLibrariesPerProject());
        String[] stringArray = projectBuildOrder;
        int n = projectBuildOrder.length;
        int n2 = 0;
        while (n2 < n) {
            String project = stringArray[n2];
            String loadLibrary = (String)loadLibrariesPerProject.get(project);
            String targetLibrary = (String)targetLibrariesPerProject.get(project);
            if (loadLibrary == null || targetLibrary == null) {
                this.getBuildLog().println(this.formatMessage(Messages.JazzScmPreBuildParticipant_LOAD_TARGET_LIBRARY_MAPPINGS_INCOMPLETE));
                return false;
            }
            ++n2;
        }
        return true;
    }

    public BuildStatus preBuild() throws Exception {
        BuildStatus returnStat = BuildStatus.OK;
        IBuildResult result = this.getBuildResult(this.getTeamRepository());
        IBuildDefinitionInstance buildDefinitionInstance = this.getBuildRequest().getBuildDefinitionInstance();
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (buildDefinitionInstance.getConfigurationElement("com.ibm.teami.build.jazzscm.iant") != null) {
            String fetchDestination = null;
            boolean generatedAnt = this.getGeneratedBuild(buildDefinitionInstance);
            if (generatedAnt) {
                fetchDestination = this.getFetchDestination(buildDefinitionInstance);
            }
            if (this.fWorkspaceUUID == null) {
                return BuildStatus.OK;
            }
            if (fetchDestination == null && generatedAnt) {
                return BuildStatus.ERROR;
            }
            IWorkspace workspace = this.getWorkspace(this.getTeamRepository());
            IWorkspaceManager workspaceManagerOriginalContents = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository());
            IWorkspaceConnection workspaceOriginalContents = null;
            IBaselineSet originalContentsSnapshot = null;
            try {
                String changeJobCommandString;
                CommandCall command;
                boolean ok;
                FileSystemCore.startUp();
                this.printToBuildLog(NLS.bind((String)Messages.JazzScmPreBuildParticipant_ACCEPTING, (Object)workspace.getName()));
                this.buildClient.startBuildActivity((IBuildResultHandle)result, Messages.JazzScmPreBuildParticipant_ACTIVITY_ACCEPTING_CHANGES, this.parentActivityId, true, null);
                String snapshotName = String.valueOf(this.getBuildRequest().getBuildDefinitionInstance().getBuildDefinitionId()) + "_" + result.getLabel();
                this.acceptReport = new AcceptIReport();
                IBuildDefinition buildDefinition = (IBuildDefinition)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)result.getBuildDefinition(), 1, null);
                IBuildProperty buildWorkspaceUUID = buildDefinition.getProperty("team.scm.workspaceUUID");
                IWorkspaceConnection workspaceConnectionOriginalContents = new BuildWorkspaceDescriptor(this.getTeamRepository(), buildWorkspaceUUID.getValue(), null).getConnection(this.getRepositoryManager(), true, (IProgressMonitor)monitor);
                IBaselineSetHandle snapshotOriginalContents = workspaceConnectionOriginalContents.createBaselineSet((Collection)Collections.EMPTY_LIST, Messages.ORIGINAL_WORKSPACE_CONTENTS_SNAPSHOT_NAME, ScmMessages.SourceControlUtility_SNAPSHOT_CREATED_BY_BUILD, true, (IProgressMonitor)monitor);
                originalContentsSnapshot = (IBaselineSet)workspaceConnectionOriginalContents.teamRepository().itemManager().fetchCompleteItem((IItemHandle)snapshotOriginalContents, 0, (IProgressMonitor)monitor);
                workspaceOriginalContents = workspaceManagerOriginalContents.createWorkspace((IContributorHandle)this.getTeamRepository().loggedInContributor(), NLS.bind((String)Messages.ORIGINAL_WORKSPACE_CONTENTS_NAME, (Object)result.getLabel()), Messages.ORIGINAL_WORKSPACE_CONTENTS_DESCRIPTION, (IProgressMonitor)monitor);
                ArrayList<IFlowNodeConnection.IComponentAdditionOp> componentOpsOriginalContents = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
                for (IBaselineHandle baselineHandle : originalContentsSnapshot.getBaselines()) {
                    IBaseline baseline = (IBaseline)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 1, (IProgressMonitor)monitor);
                    componentOpsOriginalContents.add(workspaceOriginalContents.componentOpFactory().addComponent(baseline.getComponent(), (IConnection)workspaceManagerOriginalContents.getBaselineConnection(baseline, (IProgressMonitor)monitor), false));
                }
                workspaceOriginalContents.applyComponentOperations(componentOpsOriginalContents, (IProgressMonitor)monitor);
                this.acceptReport.setOriginalWorkspace(workspaceOriginalContents.getResolvedWorkspace());
                if (!result.isPersonalBuild()) {
                    this.performAccept(workspace, snapshotName, (IBuildResultHandle)result, this.getTeamRepository(), null);
                    Object[] acceptChanges = new Object[]{this.acceptReport.getAcceptChangeSets().length, this.acceptReport.getDiscardChangeSets().length, this.acceptReport.getComponentAdds().length, this.acceptReport.getComponentRemovals().length};
                    this.printToBuildLog(NLS.bind((String)Messages.JazzScmPreBuildParticipant_NUMBER_CHANGES, (Object[])acceptChanges));
                }
                AS400 conn = AS400Factory.getInstance().getAS400();
                String jobCCSIDProperty = this.getProject().getProperty("teamp.build.jobCCSID");
                if (jobCCSIDProperty != null && !"".equals(jobCCSIDProperty) && !(ok = (command = new CommandCall(conn)).run(changeJobCommandString = "CHGJOB CCSID(" + jobCCSIDProperty + ")"))) {
                    this.getProject().log(NLS.bind((String)Messages.JazzScmPreBuildParticipant_WARNING_JOB_CCSID_USE, (Object)jobCCSIDProperty));
                }
                CommandCall tempCmd = new CommandCall(conn);
                Job jvmJob = tempCmd.getServerJob();
                String hostName = "";
                InetAddress localAddress = InetAddress.getLocalHost();
                hostName = localAddress.getHostName();
                this.printToBuildLog(NLS.bind((String)Messages.QcmdBuildParticipant_CMD_JOB, (Object)jvmJob.toString(), (Object)hostName));
                IStatus stat = Status.OK_STATUS;
                try {
                    boolean loadLatest = this.getLoadLatest();
                    boolean snapshotLoad = this.getSnapshotLoad();
                    if (snapshotLoad) {
                        this.printToBuildLog(Messages.LOAD_OPTION_SNAPSHOT);
                        String snapshotUuid = this.getSnapshotUuid(buildDefinitionInstance);
                        IBaselineSet previousSnapshot = this.getSnapshot(snapshotUuid, this.getTeamRepository(), null);
                        IBaselineSet currentSnapshot = null;
                        if (result.isPersonalBuild()) {
                            IWorkspaceConnection workspaceConnection = new BuildWorkspaceDescriptor(this.getTeamRepository(), workspace).getConnection(this.getRepositoryManager(), true, (IProgressMonitor)monitor);
                            IBaselineSetHandle snapshot = workspaceConnection.createBaselineSet((Collection)Collections.EMPTY_LIST, snapshotName, ScmMessages.SourceControlUtility_SNAPSHOT_CREATED_BY_BUILD, true, (IProgressMonitor)monitor);
                            currentSnapshot = (IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)snapshot, 0, (IProgressMonitor)monitor);
                        } else {
                            currentSnapshot = this.acceptReport.getSnapshot();
                        }
                        this.processSnapshots(previousSnapshot, currentSnapshot, result, null);
                        Object[] snapshotChanges = new Object[]{this.acceptReport.getAcceptChangeSets().length, this.acceptReport.getDiscardChangeSets().length, this.acceptReport.getComponentAdds().length, this.acceptReport.getComponentRemovals().length};
                        this.printToBuildLog(NLS.bind((String)Messages.JazzScmPreBuildParticipant_SNAPSHOT_NUMBER_CHANGES, (Object[])snapshotChanges));
                    } else if (loadLatest) {
                        this.printToBuildLog(Messages.LOAD_OPTION_LATEST);
                        if (result.isPersonalBuild()) {
                            IWorkspaceConnection workspaceConnection = new BuildWorkspaceDescriptor(this.getTeamRepository(), buildWorkspaceUUID.getValue(), null).getConnection(this.getRepositoryManager(), true, (IProgressMonitor)monitor);
                            IBaselineSetHandle snapshot = workspaceConnection.createBaselineSet((Collection)Collections.EMPTY_LIST, "Temp Snapshot", ScmMessages.SourceControlUtility_SNAPSHOT_CREATED_BY_BUILD, true, (IProgressMonitor)monitor);
                            IBaselineSet tempSnapshot = (IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)snapshot, 0, (IProgressMonitor)monitor);
                            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository());
                            IWorkspaceConnection workspaceDuplicateOfBuildWorkspace = workspaceManager.createWorkspace((IContributorHandle)this.getTeamRepository().loggedInContributor(), "WSLATEST" + result.getLabel(), "Temporary Workspace Based On Build Workspace", (IProgressMonitor)monitor);
                            ArrayList<IFlowNodeConnection.IComponentAdditionOp> componentOps = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
                            for (IBaselineHandle baselineHandle : tempSnapshot.getBaselines()) {
                                IBaseline baseline = (IBaseline)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 1, (IProgressMonitor)monitor);
                                componentOps.add(workspaceDuplicateOfBuildWorkspace.componentOpFactory().addComponent(baseline.getComponent(), (IConnection)workspaceManager.getBaselineConnection(baseline, (IProgressMonitor)monitor), false));
                            }
                            workspaceDuplicateOfBuildWorkspace.applyComponentOperations(componentOps, (IProgressMonitor)monitor);
                            IFlowTable flowTable = workspaceDuplicateOfBuildWorkspace.getFlowTable();
                            flowTable = flowTable.getWorkingCopy();
                            flowTable.addAcceptFlow((IFlowNodeHandle)workspace, null, null, null, null);
                            workspaceDuplicateOfBuildWorkspace.setFlowTable(flowTable, (IProgressMonitor)monitor);
                            this.performAccept(workspaceDuplicateOfBuildWorkspace.getResolvedWorkspace(), null, null, this.getTeamRepository(), (IProgressMonitor)monitor);
                            workspaceManager.deleteWorkspace((IWorkspaceHandle)workspaceDuplicateOfBuildWorkspace.getResolvedWorkspace(), (IProgressMonitor)monitor);
                            workspaceConnection.removeBaselineSet((IBaselineSetHandle)tempSnapshot, (IProgressMonitor)monitor);
                        }
                    } else {
                        this.printToBuildLog(Messages.LOAD_OPTION_ALL);
                        this.acceptReport = null;
                    }
                    String ccsidMapping = this.getProject().getProperty("teamp.scm.ccsidmappings");
                    HashMap<String, String> properties = this.collectProperties(this.getProject());
                    stat = IBMISourceControlUtility.updateFileCopyArea((ITeamRepository)this.getTeamRepository(), (IWorkspaceHandle)workspace, (boolean)false, (AcceptIReport)this.acceptReport, null, (Hashtable)IBuildUtility.parseNameValuePairFormat((String)this.getTargetLibrariesPerProject()), (String)ccsidMapping, properties, null);
                }
                catch (Exception e) {
                    String logFileLocation = this.getProject().getProperty("teamp.build.load.log.file.location");
                    if (logFileLocation != null && !logFileLocation.equals("")) {
                        LogPublisherTask logPublisherTask = new LogPublisherTask();
                        logPublisherTask.setFilePath(new File(logFileLocation));
                        logPublisherTask.setLabel(Messages.LOAD_LOG_FILE_LABEL);
                        logPublisherTask.setRepositoryAddress(this.getTeamRepository().getRepositoryURI());
                        logPublisherTask.setUserId(this.getProject().getProperty("userId"));
                        logPublisherTask.setPasswordFile(new File(this.getProject().getProperty("passwordFile")));
                        logPublisherTask.setBuildResultUUID(this.fBuildResultUUID);
                        logPublisherTask.setStatus((AbstractPublisherTask.BuildStatusAttribute)AbstractPublisherTask.BuildStatusAttribute.getInstance(AbstractPublisherTask.BuildStatusAttribute.class, (String)"ERROR"));
                        logPublisherTask.execute();
                    }
                    this.printToBuildLog(NLS.bind((String)Messages.JazzScmPreBuildParticipant_LOAD_FAILED_ERROR, (Object)e.getMessage()));
                    throw e;
                }
                if (stat.getCode() == 20) {
                    this.printToBuildLog(Messages.JazzScmPreBuildParticipant_NO_IPROJECTS_TO_LIB_MAPPINGS);
                    returnStat = BuildStatus.ERROR;
                }
                this.addWorkspaceContribution(workspace, (IBuildResultHandle)result, this.getTeamRepository(), null);
                this.createTargetLibraries(conn);
                if (generatedAnt) {
                    IFSFile fetchDestinationFile = new IFSFile(conn, fetchDestination);
                    this.clearBuildSpecificationsLoadLocation(conn, fetchDestinationFile, null);
                    this.loadBuildSpecifications(conn, fetchDestinationFile, null);
                    returnStat = this.createMasterScript(conn, fetchDestination, null);
                }
            }
            catch (Throwable throwable) {
                if (workspaceOriginalContents != null && originalContentsSnapshot != null) {
                    workspaceOriginalContents.removeBaselineSet(originalContentsSnapshot, (IProgressMonitor)monitor);
                }
                if (workspaceManagerOriginalContents != null && workspaceOriginalContents != null) {
                    workspaceManagerOriginalContents.deleteWorkspace((IWorkspaceHandle)workspaceOriginalContents.getResolvedWorkspace(), (IProgressMonitor)monitor);
                }
                FileSystemCore.shutDown();
                throw throwable;
            }
            if (workspaceOriginalContents != null && originalContentsSnapshot != null) {
                workspaceOriginalContents.removeBaselineSet((IBaselineSetHandle)originalContentsSnapshot, (IProgressMonitor)monitor);
            }
            if (workspaceManagerOriginalContents != null && workspaceOriginalContents != null) {
                workspaceManagerOriginalContents.deleteWorkspace((IWorkspaceHandle)workspaceOriginalContents.getResolvedWorkspace(), (IProgressMonitor)monitor);
            }
            FileSystemCore.shutDown();
        }
        return returnStat;
    }

    private HashMap<String, String> collectProperties(Project project) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String property = project.getProperty("teamp.build.threads");
        if (property != null) {
            properties.put("teamp.build.threads", property);
        }
        if ((property = project.getProperty("teamp.build.ignore.description.changes")) != null) {
            properties.put("teamp.build.ignore.description.changes", property);
        }
        if ((property = project.getProperty("teamp.build.load.log.file.location")) != null) {
            properties.put("teamp.build.load.log.file.location", property);
        }
        if ((property = project.getProperty("teamp.build.tracing")) != null) {
            properties.put("teamp.build.tracing", property);
        }
        return properties;
    }

    private void processSnapshots(IBaselineSet previousSnapshot, IBaselineSet currentSnapshot, IBuildResult buildResult, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaseline baseline;
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository());
        IWorkspaceConnection workspacePreviousSnapshot = workspaceManager.createWorkspace((IContributorHandle)this.getTeamRepository().loggedInContributor(), "WS1" + buildResult.getLabel(), "Temporary Workspace Based On Previous Snapshot", monitor);
        IWorkspaceConnection workspaceCurrentSnapshot = workspaceManager.createWorkspace((IContributorHandle)this.getTeamRepository().loggedInContributor(), "WS2" + buildResult.getLabel(), "Temporary Workspace Based On Current Snapshot", monitor);
        ArrayList<IFlowNodeConnection.IComponentAdditionOp> componentOps = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
        for (IBaselineHandle baselineHandle : previousSnapshot.getBaselines()) {
            baseline = (IBaseline)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 1, monitor);
            componentOps.add(workspacePreviousSnapshot.componentOpFactory().addComponent(baseline.getComponent(), (IConnection)workspaceManager.getBaselineConnection(baseline, monitor), false));
        }
        workspacePreviousSnapshot.applyComponentOperations(componentOps, monitor);
        componentOps = new ArrayList();
        for (IBaselineHandle baselineHandle : currentSnapshot.getBaselines()) {
            baseline = (IBaseline)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 1, monitor);
            componentOps.add(workspaceCurrentSnapshot.componentOpFactory().addComponent(baseline.getComponent(), (IConnection)workspaceManager.getBaselineConnection(baseline, monitor), false));
        }
        workspaceCurrentSnapshot.applyComponentOperations(componentOps, monitor);
        IFlowTable flowTable = workspacePreviousSnapshot.getFlowTable();
        flowTable = flowTable.getWorkingCopy();
        flowTable.addAcceptFlow((IFlowNodeHandle)((IWorkspaceHandle)workspaceCurrentSnapshot.getContextHandle()), null, null, null, null);
        workspacePreviousSnapshot.setFlowTable(flowTable, monitor);
        this.performAccept(workspacePreviousSnapshot.getResolvedWorkspace(), null, null, this.getTeamRepository(), monitor);
        workspaceManager.deleteWorkspace((IWorkspaceHandle)workspacePreviousSnapshot.getResolvedWorkspace(), monitor);
        workspaceManager.deleteWorkspace((IWorkspaceHandle)workspaceCurrentSnapshot.getResolvedWorkspace(), monitor);
    }

    private void createTargetLibraries(AS400 as400) throws Exception {
        Hashtable table = IBuildUtility.parseNameValuePairFormat((String)this.getTargetLibrariesPerProject());
        Set projects = table.keySet();
        for (String project : projects) {
            String library = (String)table.get(project);
            boolean libraryExists = FileSystemIUtil.isHostLibraryExist((String)library, (AS400)as400);
            if (libraryExists) continue;
            String command = "CRTLIB " + library + " ASPDEV(*SYSTEM)";
            this.printToBuildLog(NLS.bind((String)Messages.QcmdBuildParticipant_RUNNING_CMD, (Object)command));
            CommandCall cmd = new CommandCall(as400, command);
            if (cmd.run()) continue;
            this.printToBuildLog(NLS.bind((String)Messages.JazzScmPreBuildParticipant_TARGET_LIBRARY_CREATION_FAILED, (Object)library));
        }
    }

    private void clearBuildSpecificationsLoadLocation(AS400 conn, IFSFile loadDir, IProgressMonitor monitor) throws Exception {
        if (loadDir.exists()) {
            IFSFile[] files;
            loadDir.setPatternMatching(1);
            IFSFile[] iFSFileArray = files = loadDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFSFile child = iFSFileArray[n2];
                if (child.isDirectory()) {
                    this.clearBuildSpecificationsLoadLocation(conn, child, monitor);
                }
                child.delete();
                ++n2;
            }
        }
    }

    private void loadBuildSpecifications(AS400 conn, IFSFile loadDir, IProgressMonitor monitor) throws Exception {
        boolean createDirSuccess;
        if (!loadDir.exists() && !(createDirSuccess = loadDir.mkdirs())) {
            throw new Exception();
        }
        String loadDirAbsolutePath = loadDir.getAbsolutePath();
        ITeamRepository repository = this.getTeamRepository();
        IWorkspace workspace = this.getWorkspace(repository);
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)workspace.getItemHandle();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(workspaceHandle, null);
        FileSystemIUtil util = FileSystemIUtil.getInstance();
        List componentHandles = workspaceConnection.getComponents();
        ArrayList<IProjectInfo> projectInfos = new ArrayList<IProjectInfo>();
        HashMap<String, IConfiguration> configPerProject = new HashMap<String, IConfiguration>();
        ArrayList<IFSFile> filesToGenerate = new ArrayList<IFSFile>();
        for (IComponentHandle componentHandle : componentHandles) {
            IConfiguration configuration = workspaceConnection.configuration(componentHandle);
            List componentProjectInfos = util.getIProjectsWithInfos(workspaceHandle, componentHandle, repository, false);
            projectInfos.addAll(componentProjectInfos);
            for (IProjectInfo tempInfo : componentProjectInfos) {
                String projectName = tempInfo.getName();
                configPerProject.put(projectName, configuration);
            }
        }
        for (IProjectInfo tempInfo : projectInfos) {
            boolean createProjectDirSuccess;
            IConfiguration configuration;
            String projectName = tempInfo.getName();
            IFolderHandle projectHandle = tempInfo.getFolderHandle();
            IFileItemHandle buildFileHandle = util.getIProjectBuildFile(projectHandle, configuration = (IConfiguration)configPerProject.get(projectName));
            if (buildFileHandle == null) continue;
            String projectMetadataFolderPath = String.valueOf(loadDirAbsolutePath) + projectName + "/" + ".ibmi";
            IFSFile projectMetadataFolder = new IFSFile(conn, projectMetadataFolderPath);
            if (!projectMetadataFolder.exists() && !(createProjectDirSuccess = projectMetadataFolder.mkdirs())) {
                throw new Exception();
            }
            String buildFileAbsolutePath = String.valueOf(projectMetadataFolderPath) + "/" + ".ibuild";
            IFSFile buildFile = new IFSFile(conn, buildFileAbsolutePath);
            if (buildFile.exists() && !buildFile.delete()) {
                this.printToBuildLog(NLS.bind((String)Messages.JazzScmPreBuildParticipant_FAILED_TO_DELETE_PREVIOUS_BUILD_SPECIFICATION, (Object)buildFile.getAbsolutePath()));
            }
            if (!buildFile.createNewFile()) {
                throw new Exception(NLS.bind((String)Messages.JazzScmPreBuildParticipant_FAILED_TO_CREATE_NEW_BUILD_SPECIFICATION_FILE, (Object)buildFile.getAbsolutePath()));
            }
            buildFile.setCCSID(1208);
            IFileItem buildFileItem = util.getFileItem(buildFileHandle, configuration);
            IFileContent content = buildFileItem.getContent();
            InputStream inputStream = FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)buildFileItem, content, null);
            IFSFileOutputStream outputStream = new IFSFileOutputStream(buildFile);
            byte[] buffer = new byte[32768];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead > 0) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
            projNames = new ArrayList<String>();
            projNames.add(projectName);
            InputStream inputStreamBaseLibraries = FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)buildFileItem, content, null);
            String baseLibraries = this.getAppendedBaseLibraries(this.getBaseLibraryList(), projectName, configPerProject, projectInfos, util, inputStreamBaseLibraries, false);
            inputStream.close();
            inputStreamBaseLibraries.close();
            outputStream.close();
            filesToGenerate.add(new IFSFile(conn, buildFileAbsolutePath));
            String propertiesFileAbsolutePath = String.valueOf(projectMetadataFolderPath) + "/" + "build.properties";
            IFSFile propertiesFile = new IFSFile(conn, propertiesFileAbsolutePath);
            if (propertiesFile.exists()) {
                propertiesFile.delete();
            }
            if (!propertiesFile.createNewFile()) {
                throw new Exception();
            }
            propertiesFile.setCCSID(819);
            outputStream = new IFSFileOutputStream(propertiesFile);
            Properties properties = new Properties();
            String circularDependency = "false";
            String loadLibrary = this.getLibraryForProject(this.getLoadLibrariesPerProject(), projectName);
            String targetLibrary = this.getLibraryForProject(this.getTargetLibrariesPerProject(), projectName);
            StringTokenizer st = new StringTokenizer(baseLibraries);
            String baseLibraryList = "";
            while (st.hasMoreTokens()) {
                String checkDuplicate = st.nextToken();
                if (checkDuplicate.equalsIgnoreCase("circularDependencyExists")) {
                    circularDependency = "true";
                    break;
                }
                if (targetLibrary.equalsIgnoreCase(checkDuplicate) || loadLibrary.equalsIgnoreCase(checkDuplicate)) continue;
                baseLibraryList = baseLibraryList.concat(String.valueOf(checkDuplicate) + new String(new char[]{' '}));
            }
            String fixLibraries = "";
            fixLibraries = !loadLibrary.equalsIgnoreCase(targetLibrary) ? String.valueOf(loadLibrary) + " " + targetLibrary : loadLibrary;
            this.specifyProperties(properties, loadLibrary, targetLibrary, fixLibraries, baseLibraryList, tempInfo.getComponentHandle().getItemId().getUuidValue(), projectHandle.getItemId().getUuidValue(), projectName, circularDependency);
            try {
                properties.store((OutputStream)outputStream, null);
            }
            finally {
                outputStream.close();
            }
        }
        for (IFSFile ibuildFile : filesToGenerate) {
            IBuildAntGenerator generator = new IBuildAntGenerator(ibuildFile, this.getBuildLog());
            generator.generate();
        }
    }

    private void specifyProperties(Properties properties, String loadLibrary, String targetLibrary, String fixLibraries, String baseLibraries, String componentUUID, String projectUUID, String projectName, String circularProjectDependency) {
        if (loadLibrary != null) {
            properties.setProperty(BUILD_PROPERTY_SOURCE_LIBRARY, loadLibrary);
        }
        if (targetLibrary != null) {
            properties.setProperty(BUILD_PROPERTY_TARGET_LIBRARY, targetLibrary);
        }
        if (fixLibraries != null) {
            properties.setProperty(BUILD_PROPERTY_FIX_LIBRARIES, fixLibraries);
        }
        if (baseLibraries != null) {
            properties.setProperty(BUILD_PROPERTY_BASE_LIBRARIES, baseLibraries);
        }
        if (componentUUID != null) {
            properties.setProperty(BUILD_PROPERTY_COMPONENT_UUID, componentUUID);
        }
        if (projectUUID != null) {
            properties.setProperty(BUILD_PROPERTY_PROJECT_UUID, projectUUID);
        }
        if (projectName != null) {
            properties.setProperty(BUILD_PROPERTY_PROJECT_NAME, projectName);
        }
        Hashtable bdProperties = this.getProject().getProperties();
        bdProperties.put(BUILD_PROPERTY_CIRCULAR_PROJECT_DEPENDENCY, circularProjectDependency);
        Set keys = bdProperties.keySet();
        for (String property : keys) {
            properties.setProperty(property, (String)bdProperties.get(property));
        }
    }

    private String getLibraryForProject(String librariesPerProject, String projectName) {
        return (String)IBuildUtility.parseNameValuePairFormat((String)librariesPerProject).get(projectName);
    }

    private BuildStatus createMasterScript(AS400 conn, String fetchDestination, IProgressMonitor monitor) throws Exception {
        String[] order;
        BuildStatus status = BuildStatus.OK;
        IFSFile masterScript = new IFSFile(conn, String.valueOf(fetchDestination) + "master.xml");
        if (masterScript.exists()) {
            masterScript.delete();
        }
        if (!masterScript.createNewFile()) {
            return BuildStatus.ERROR;
        }
        masterScript.setCCSID(1208);
        IBuildConfigurationElement element = this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.teami.build.iant");
        IConfigurationProperty preBuildCommand = element.getConfigurationProperty("teami.preBuildCommand");
        IConfigurationProperty postBuildCommand = element.getConfigurationProperty("teami.postBuildCommand");
        String buildOrder = this.getBuildOrder();
        String projectsToBuild = this.getProjectsToBuild();
        List<String> projects = this.getIProjects(monitor);
        BufferedWriter writer = new BufferedWriter((Writer)new IFSFileWriter(masterScript));
        writer.write("<project name=\"Master Build\" default=\"default\">");
        writer.newLine();
        writer.write("\t<typedef name=\"AS400Type\" classname=\"com.ibm.iant.types.AS400Type\"/>");
        writer.newLine();
        writer.write("\t<typedef name=\"tasks\" classname=\"com.ibm.iant.types.build.IBMITasks\"/>");
        writer.newLine();
        writer.newLine();
        writer.write("\t<taskdef name=\"iBuildSpecTargetTask\" classname=\"com.ibm.iant.taskdefs.build.IBMIBuildTask\"/>");
        writer.newLine();
        writer.write("\t<taskdef name=\"ibmicommand\" classname=\"com.ibm.iant.taskdefs.build.IBMICommandTask\"/>");
        writer.newLine();
        writer.write("\t<taskdef name=\"itag\" classname=\"com.ibm.iant.taskdefs.build.IBMITagTask\"/>");
        writer.newLine();
        writer.write("\t<taskdef name=\"isetup\" classname=\"com.ibm.iant.taskdefs.build.IBMIBuildSetupTask\"/>");
        writer.newLine();
        writer.write("\t<taskdef name=\"iteardown\" classname=\"com.ibm.iant.taskdefs.build.IBMIBuildCompleteTask\"/>");
        writer.newLine();
        writer.write("\t<taskdef name=\"ibuild\" classname=\"com.ibm.iant.taskdefs.build.IBMIGenericBuildTask\"/>");
        writer.newLine();
        writer.newLine();
        writer.write("\t<AS400Type systemname=\"\" userid=\"\" userpassword=\"\" id=\"SystemInstance\"/>");
        writer.newLine();
        writer.newLine();
        writer.write("\t<target name=\"default\">");
        writer.newLine();
        if (preBuildCommand.getValue() != null && !preBuildCommand.getValue().equals("")) {
            writer.write("\t\t<ibmicommand commandString=\"" + preBuildCommand.getValue() + "\" systemref=\"SystemInstance\"/>");
            writer.newLine();
        }
        if ((status = this.validateOrderMapping(projects, order = buildOrder.split(";;"))) != BuildStatus.ERROR) {
            String[] stringArray = order;
            int n = order.length;
            int n2 = 0;
            while (n2 < n) {
                String project = stringArray[n2];
                if (this.shouldBuildProject(projectsToBuild, project) && this.containsProjectInList(project, projects.toArray(new String[projects.size()]))) {
                    String antFile = String.valueOf(fetchDestination) + project + "/" + ".ibmi" + "/" + "build.xml";
                    String dir = String.valueOf(fetchDestination) + project + "/" + ".ibmi";
                    writer.write("\t\t<ant antfile=\"" + antFile + "\" dir=\"" + dir + "\" inheritrefs=\"true\" inheritall=\"false\"/>");
                    writer.newLine();
                }
                ++n2;
            }
        }
        writer.newLine();
        if (postBuildCommand.getValue() != null && !postBuildCommand.getValue().equals("")) {
            writer.write("\t\t<ibmicommand commandString=\"" + postBuildCommand.getValue() + "\" systemref=\"SystemInstance\"/>");
            writer.newLine();
        }
        writer.write("\t</target>");
        writer.newLine();
        writer.write("</project>");
        try {
            writer.close();
        }
        catch (ConnectionDroppedException e) {
            this.printToBuildLog("Ignoring ConnectionDroppedException until Toolbox is updated with JTOpen 8.7+.");
            e.printStackTrace();
        }
        return status;
    }

    private BuildStatus validateOrderMapping(List<String> projects, String[] order) {
        if (projects.size() > order.length) {
            this.getBuildLog().println(this.formatMessage(Messages.JazzScmPreBuildParticipant_BUILD_DEFINITION_MISSING_PROJECT_LIBRARY_INFORMATION));
            return BuildStatus.ERROR;
        }
        for (String project : projects) {
            boolean found = this.containsProjectInList(project, order);
            if (found) continue;
            this.getBuildLog().println(this.formatMessage(Messages.JazzScmPreBuildParticipant_BUILD_DEFINITION_MISSING_PROJECT_LIBRARY_INFORMATION));
            return BuildStatus.ERROR;
        }
        return BuildStatus.OK;
    }

    private boolean containsProjectInList(String project, String[] projects) {
        boolean found = false;
        int i = 0;
        while (i < projects.length && !found) {
            if (project.equals(projects[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    private boolean shouldBuildProject(String needBuildString, String project) {
        String[] needBuild = needBuildString.split(";;");
        int i = 0;
        while (i < needBuild.length) {
            if (needBuild[i].equals(project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean getGeneratedBuild(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("com.ibm.teami.build.ant.generated");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.parseBoolean(property.getValue());
        }
        return false;
    }

    private IWorkspace getWorkspace(String uuid, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID workspaceUuid = null;
        try {
            workspaceUuid = UUID.valueOf((String)uuid);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_INVALID_WORKSPACE_UUID, (Object)uuid), (Throwable)exception);
        }
        IItem item = null;
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
        try {
            item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, monitor);
        }
        catch (ItemNotFoundException exception) {
            throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_WORKSPACE_NOT_FOUND, (Object)uuid), (Throwable)exception);
        }
        if (!(item instanceof IWorkspaceHandle)) {
            throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_NOT_A_WORKSPACE, (Object)uuid, (Object)item.getItemType().getName()));
        }
        return (IWorkspace)item;
    }

    private IBaselineSet getSnapshot(String uuid, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID snapshotUUID = null;
        try {
            snapshotUUID = UUID.valueOf((String)uuid);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_INVALID_SNAPSHOT_UUID, (Object)uuid), (Throwable)exception);
        }
        IItem item = null;
        IBaselineSetHandle baselineSetHandle = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle(snapshotUUID, null);
        try {
            item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineSetHandle, 1, monitor);
        }
        catch (ItemNotFoundException exception) {
            throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_SNAPSHOT_NOT_FOUND, (Object)uuid), (Throwable)exception);
        }
        if (!(item instanceof IBaselineSetHandle)) {
            throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_NOT_A_SNAPSHOT, (Object)uuid, (Object)item.getItemType().getName()));
        }
        return (IBaselineSet)item;
    }

    private static List determineComponents(IFlowTable flowTable, IFlowNodeHandle source, IWorkspaceConnection sourceWorkspaceConnection) throws TeamRepositoryException {
        ArrayList componentScopes = new ArrayList();
        HashMap<UUID, IComponentHandle> allComponents = new HashMap<UUID, IComponentHandle>(sourceWorkspaceConnection.getComponents().size());
        for (IComponentHandle component : sourceWorkspaceConnection.getComponents()) {
            allComponents.put(component.getItemId(), component);
        }
        HashSet<UUID> toRetain = new HashSet<UUID>();
        for (IComponentHandle component : flowTable.getComponentScopes(source)) {
            toRetain.add(component.getItemId());
        }
        allComponents.keySet().retainAll(toRetain);
        componentScopes.addAll(allComponents.values());
        return componentScopes;
    }

    private void performAccept(IWorkspace workspace, String snapshotName, IBuildResultHandle resultHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineSet baselineSet;
        IBaselineSetHandle snapshot;
        IWorkspaceConnection workspaceConnection = new BuildWorkspaceDescriptor(this.getTeamRepository(), workspace).getConnection(this.getRepositoryManager(), true, monitor);
        IFlowTable flowTable = workspaceConnection.getFlowTable();
        Iterator acceptSourceIter = flowTable.acceptSources().iterator();
        HashSet<UUID> incomingComponentIds = new HashSet<UUID>(workspaceConnection.getComponents().size());
        ArrayList<ITeamRepository> toLogout = new ArrayList<ITeamRepository>();
        IChangeHistorySyncReport report = null;
        ArrayList<Object> ops = new ArrayList<Object>();
        ArrayList<IFlowNodeConnection.IComponentReplacementOp> ops2 = new ArrayList<IFlowNodeConnection.IComponentReplacementOp>();
        while (acceptSourceIter.hasNext()) {
            ITeamRepository sourceRepository;
            IFlowEntry flowEntry = (IFlowEntry)acceptSourceIter.next();
            IFlowNodeHandle source = flowEntry.getFlowNode();
            String remoteRepositoryURI = flowEntry.getRemoteRepositoryURI();
            if (remoteRepositoryURI == null) {
                sourceRepository = workspaceConnection.teamRepository();
            } else {
                sourceRepository = this.getRepositoryManager().getRepository(remoteRepositoryURI, false);
                if (sourceRepository == null) {
                    if (this.getRepositoryManager().hasAuthenticationFailure(remoteRepositoryURI)) {
                        throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_WORKSPACE_FLOW_HAD_PREVIOUS_AUTH_FAILURE, (Object)workspaceConnection.getName(), (Object)remoteRepositoryURI));
                    }
                    throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_FLOW_WORKSPACE_AUTH_MISSING, (Object)workspaceConnection.getName(), (Object)remoteRepositoryURI));
                }
                if (!sourceRepository.loggedIn()) {
                    this.getRepositoryManager().login(sourceRepository, monitor);
                    toLogout.add(sourceRepository);
                }
            }
            if (!(source instanceof IWorkspaceHandle)) continue;
            IWorkspaceConnection sourceWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)sourceRepository).getWorkspaceConnection((IWorkspaceHandle)source, monitor);
            sourceWorkspaceConnection.refresh(monitor);
            List componentScopes = IBMIPreBuildTask.determineComponents(flowTable, source, sourceWorkspaceConnection);
            if (componentScopes.isEmpty()) {
                report = workspaceConnection.compareTo((IFlowNodeConnection)sourceWorkspaceConnection, 0, Collections.EMPTY_LIST, monitor);
                componentScopes.addAll(report.remoteComponents());
            } else {
                HashSet<UUID> helper = new HashSet<UUID>();
                ArrayList<IComponentHandle> exclusions = new ArrayList<IComponentHandle>();
                for (IComponentHandle component : componentScopes) {
                    helper.add(component.getItemId());
                }
                for (IComponentHandle component : workspaceConnection.getComponents()) {
                    if (helper.contains(component.getItemId())) continue;
                    exclusions.add(component);
                }
                report = workspaceConnection.compareTo((IFlowNodeConnection)sourceWorkspaceConnection, 0, exclusions, monitor);
            }
            this.acceptReport.addAcceptChangeSets(report.incomingChangeSets());
            for (IComponentHandle componentHandle : componentScopes) {
                if (incomingComponentIds.add(componentHandle.getItemId())) continue;
                String componentName = "";
                try {
                    IComponentHandle component;
                    component = (IComponent)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, monitor);
                    componentName = component.getName();
                }
                catch (TeamRepositoryException component) {
                    // empty catch block
                }
                throw new TeamRepositoryException(NLS.bind((String)ScmMessages.SourceControlUtility_MULTIPLE_COMPONENT_ACCEPT_FLOWS, (Object)componentName));
            }
            for (IComponentHandle componentHandle : componentScopes) {
                List incomingChanges = report.incomingChangeSets(componentHandle);
                List outgoingChanges = report.outgoingChangeSets(componentHandle);
                if (incomingChanges.isEmpty() && outgoingChanges.isEmpty()) continue;
                ops.add(workspaceConnection.componentOpFactory().replaceComponent(componentHandle, (IConnection)sourceWorkspaceConnection, true));
            }
            Iterator iComponents = componentScopes.iterator();
            while (iComponents.hasNext()) {
                IComponentHandle componentHandle;
                componentHandle = (IComponentHandle)iComponents.next();
                if (IBMIPreBuildTask.componentExists(componentHandle, report.localComponents())) continue;
                this.acceptReport.componentAdd(componentHandle);
                ops.add(workspaceConnection.componentOpFactory().addComponent(componentHandle, false));
                ops2.add(workspaceConnection.componentOpFactory().replaceComponent(componentHandle, (IConnection)sourceWorkspaceConnection, true));
                iComponents.remove();
            }
        }
        if (!flowTable.acceptSources().isEmpty()) {
            List components = workspaceConnection.getComponents();
            for (IComponentHandle componentHandle : components) {
                if (incomingComponentIds.contains(componentHandle.getItemId())) continue;
                this.acceptReport.componentRemoval(componentHandle);
                ops.add(workspaceConnection.componentOpFactory().removeComponent(componentHandle, false));
            }
        }
        if (!ops.isEmpty()) {
            this.updateReport = workspaceConnection.applyComponentOperations(ops, monitor);
            this.acceptReport.setUpdateReport(this.updateReport);
            workspaceConnection.applyComponentOperations(ops2, monitor);
            if (snapshotName != null && snapshotName.length() > 0) {
                snapshot = workspaceConnection.createBaselineSet((Collection)Collections.EMPTY_LIST, snapshotName, ScmMessages.SourceControlUtility_SNAPSHOT_CREATED_BY_BUILD, true, monitor);
                baselineSet = (IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)snapshot, 0, monitor);
                if (baselineSet != null) {
                    this.addSnapshotContribution(baselineSet, resultHandle, teamRepository, monitor);
                    this.acceptReport.addSnapshot(baselineSet);
                }
                if (report != null && resultHandle != null) {
                    WorkItemPublisher workItemPublisher = new WorkItemPublisher();
                    workItemPublisher.publish(resultHandle, this.acceptReport.getAcceptChangeSets(), teamRepository);
                }
            }
        } else if (snapshotName != null && snapshotName.length() > 0) {
            snapshot = workspaceConnection.createBaselineSet((Collection)Collections.EMPTY_LIST, snapshotName, ScmMessages.SourceControlUtility_SNAPSHOT_CREATED_BY_BUILD, true, monitor);
            baselineSet = (IBaselineSet)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)snapshot, 0, monitor);
            if (baselineSet != null) {
                this.acceptReport.addSnapshot(baselineSet);
            }
        }
    }

    private static boolean componentExists(IComponentHandle componentHandle, Collection components) {
        for (IComponentHandle existingComponentHandle : components) {
            if (!existingComponentHandle.getItemId().equals((Object)componentHandle.getItemId())) continue;
            return true;
        }
        return false;
    }

    private void addWorkspaceContribution(IWorkspace workspace, IBuildResultHandle resultHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionTypeId("buildWorkspace");
        contribution.setImpactsPrimaryResult(false);
        contribution.setLabel(workspace.getName());
        contribution.setExtendedContribution((IItemHandle)workspace);
        ITeamBuildClient client = (ITeamBuildClient)this.getTeamRepository().getClientLibrary(ITeamBuildClient.class);
        client.addBuildResultContribution(resultHandle, contribution, monitor);
    }

    private void addSnapshotContribution(IBaselineSet snapshot, IBuildResultHandle resultHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionTypeId("buildSnapshot");
        contribution.setImpactsPrimaryResult(false);
        contribution.setLabel(NLS.bind((String)Messages.JazzScmPreBuildParticipant_SNAPSHOT_LABEL, (Object)snapshot.getName()));
        contribution.setExtendedContribution((IItemHandle)snapshot);
        ITeamBuildClient client = (ITeamBuildClient)this.getTeamRepository().getClientLibrary(ITeamBuildClient.class);
        client.addBuildResultContribution(resultHandle, contribution, monitor);
    }

    private String getWorkspaceUuid() {
        return this.fWorkspaceUUID;
    }

    private String getSnapshotUuid(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("teami.scm.snapshotUUID");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return null;
    }

    private String getFetchDestination(IBuildDefinitionInstance instance) throws IOException, Exception {
        IBuildProperty property = instance.getProperty("com.ibm.teami.build.ant.generated.loadDirectory");
        if (property != null && property.getValue().length() > 0) {
            String fetchDestination = this.convertToPlatformSeparator(String.valueOf(property.getValue()) + "_" + this.getWorkspaceUuid());
            if (!fetchDestination.endsWith("/")) {
                fetchDestination = String.valueOf(fetchDestination) + "/";
            }
            return fetchDestination;
        }
        return null;
    }

    private boolean getLoadAll() throws TeamRepositoryException {
        IBuildProperty buildProperty = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.loadAll");
        if (buildProperty == null) {
            IConfigurationProperty property = this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.loadAll");
            if (property != null && property.getValue().length() > 0) {
                return Boolean.valueOf(property.getValue());
            }
        } else {
            return Boolean.valueOf(buildProperty.getValue());
        }
        return false;
    }

    private boolean getLoadLatest() throws TeamRepositoryException {
        IBuildProperty buildProperty = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.loadLatest");
        if (buildProperty == null) {
            IConfigurationProperty property = this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.loadLatest");
            if (property != null && property.getValue().length() > 0) {
                return Boolean.valueOf(property.getValue());
            }
        } else {
            return Boolean.valueOf(buildProperty.getValue());
        }
        return false;
    }

    private boolean getSnapshotLoad() throws TeamRepositoryException {
        IBuildProperty buildProperty = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.loadSnapshot");
        if (buildProperty == null) {
            IConfigurationProperty property = this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.loadSnapshot");
            if (property != null && property.getValue().length() > 0) {
                return Boolean.valueOf(property.getValue());
            }
        } else {
            return Boolean.valueOf(buildProperty.getValue());
        }
        return false;
    }

    private String convertToPlatformSeparator(String input) {
        String converted = null;
        if (input != null) {
            converted = input.replace("/", "/");
            converted = converted.replace("\\", "/");
        }
        return converted;
    }

    private String formatMessage(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date(System.currentTimeMillis()));
        return NLS.bind((String)Messages.JazzScmPreBuildParticipant_LOG_PREFIX, (Object)timestamp, (Object)message);
    }

    private void printToBuildLog(String message) {
        System.out.println(this.formatMessage(message));
    }

    protected PrintWriter getBuildLog() {
        return new PrintWriter(System.out);
    }

    private void print(String message) {
        System.out.println(this.formatMessage(message));
    }

    private String getAppendedBaseLibraries(String baseLibraries, String projName, Map<String, IConfiguration> configPerProject, List<IProjectInfo> projectInfos, FileSystemIUtil util, InputStream inputStream, boolean isDependentProject) throws Exception {
        int i = 0;
        while (i < projNames.size()) {
            if (projName.equalsIgnoreCase(projNames.get(i)) && isDependentProject) {
                String dependencyTree = this.circularDependencies(projName);
                this.getBuildLog().println(this.formatMessage(NLS.bind((String)Messages.JazzScmPreBuildParticipant_INVALID_PROJECT_REFERENCES_EXIST, (Object)dependencyTree)));
                String circularProjectRefs = "circularDependencyExists";
                return circularProjectRefs;
            }
            ++i;
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            NodeList tags = doc.getElementsByTagName(BUILD_SPEC_ELEMENT_PROJECTREF);
            int j = 0;
            while (j < tags.getLength()) {
                Element elem;
                if (tags.item(j) instanceof Element && !(elem = (Element)tags.item(j)).getAttribute(BUILD_SPEC_PROJECTREF_ATTRIBUTE_NAME_TYPE).equals(BUILD_SPEC_PROJECTREF_ATTRIBUTE_VALUE_TYPE_IMPORT) && elem.getAttribute(BUILD_SPEC_PROJECTREF_ATTRIBUTE_NAME_TYPE).equals(BUILD_SPEC_PROJECTREF_ATTRIBUTE_VALUE_TYPE_DEPENDENCY)) {
                    String projectName = elem.getAttribute(BUILD_SPEC_PROJECTREF_ATTRIBUTE_NAME_PROJECT);
                    for (IProjectInfo tempInfo : projectInfos) {
                        String projectNameFromInfo = tempInfo.getName();
                        if (!projectName.equalsIgnoreCase(projectNameFromInfo)) continue;
                        IFolderHandle projectHandle = tempInfo.getFolderHandle();
                        IConfiguration configuration = configPerProject.get(projectNameFromInfo);
                        IFileItemHandle buildFileHandle = util.getIProjectBuildFile(projectHandle, configuration);
                        IFileItem buildFileItem = util.getFileItem(buildFileHandle, configuration);
                        IFileContent content = buildFileItem.getContent();
                        InputStream newInputStream = FileSystemCore.getContentManager((ITeamRepository)configuration.teamRepository()).retrieveContentStream((IFileItemHandle)buildFileItem, content, null);
                        if (isDependentProject) {
                            projNames.add(projName);
                        }
                        baseLibraries = this.getAppendedBaseLibraries(baseLibraries, projectName, configPerProject, projectInfos, util, newInputStream, true);
                        newInputStream.close();
                    }
                }
                ++j;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXParseException spe) {
            spe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        if (isDependentProject) {
            String loadLibrary = this.getLibraryForProject(this.getLoadLibrariesPerProject(), projName);
            String targetLibrary = this.getLibraryForProject(this.getTargetLibrariesPerProject(), projName);
            boolean loadLibraryAlreadyExists = false;
            boolean targetLibraryAlreadyExists = false;
            String projectDependentLibraries = "";
            StringTokenizer st = new StringTokenizer(baseLibraries);
            while (st.hasMoreTokens()) {
                String checkDuplicate = st.nextToken();
                if (targetLibrary.equalsIgnoreCase(checkDuplicate)) {
                    targetLibraryAlreadyExists = true;
                }
                if (!loadLibrary.equalsIgnoreCase(checkDuplicate)) continue;
                loadLibraryAlreadyExists = true;
            }
            if (!targetLibraryAlreadyExists) {
                projectDependentLibraries = projectDependentLibraries.concat(String.valueOf(targetLibrary) + new String(new char[]{' '}));
            }
            if (!loadLibraryAlreadyExists && !targetLibrary.equalsIgnoreCase(loadLibrary)) {
                projectDependentLibraries = projectDependentLibraries.concat(String.valueOf(loadLibrary) + new String(new char[]{' '}));
            }
            baseLibraries = projectDependentLibraries.concat(baseLibraries);
        }
        return baseLibraries;
    }

    private String circularDependencies(String projName) {
        String circularDependencies = "";
        int i = 0;
        while (i < projNames.size() - 1) {
            circularDependencies = circularDependencies.concat(String.valueOf(projNames.get(i)) + " depends on " + projNames.get(i + 1) + "; ");
            ++i;
        }
        circularDependencies = circularDependencies.concat(String.valueOf(projNames.get(projNames.size() - 1)) + " depends on " + projName);
        return circularDependencies;
    }

    protected IBuildConfigurationElement getJazzScmIAntElement() throws TeamRepositoryException {
        return this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.teami.build.jazzscm.iant");
    }

    protected String getBuildOrder() throws TeamRepositoryException {
        IBuildProperty property = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.projectBuildOrder");
        if (property == null) {
            return this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.projectBuildOrder").getValue();
        }
        return property.getValue();
    }

    protected String getProjectsToBuild() throws TeamRepositoryException {
        IBuildProperty property = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.buildProjects");
        if (property == null) {
            return this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.buildProjects").getValue();
        }
        return property.getValue();
    }

    protected String getLoadLibrariesPerProject() throws TeamRepositoryException {
        IBuildProperty property = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.projectLoadDirectory");
        if (property == null) {
            return this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.projectLoadDirectory").getValue();
        }
        return property.getValue();
    }

    protected String getTargetLibrariesPerProject() throws TeamRepositoryException {
        IBuildProperty property = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.projectTargetDirectory");
        if (property == null) {
            return this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.projectTargetDirectory").getValue();
        }
        return property.getValue();
    }

    protected String getBaseLibraryList() throws TeamRepositoryException {
        IBuildProperty property = this.getBuildRequest().getBuildDefinitionInstance().getProperty("teami.scm.baseLibraries");
        if (property == null) {
            return this.getJazzScmIAntElement().getConfigurationProperty("teami.scm.baseLibraries").getValue();
        }
        return property.getValue();
    }

    protected List<String> getIProjects(IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<String> projectNames = new ArrayList<String>();
        IWorkspace workspace = this.getWorkspace(this.getTeamRepository());
        ITeamRepository repository = this.getTeamRepository();
        IWorkspaceHandle handle = (IWorkspaceHandle)workspace.getItemHandle();
        if (handle == null || repository == null) {
            return projectNames;
        }
        List allProjects = FileSystemIUtil.getInstance().getIProjectsWithInfos(handle, repository, false);
        if (allProjects == null | allProjects.size() == 0) {
            return projectNames;
        }
        for (IProjectInfo projInfo : allProjects) {
            projectNames.add(projInfo.getName());
        }
        return projectNames;
    }

    public void setWorkspaceUUID(String workspaceUUID) {
        this.fWorkspaceUUID = workspaceUUID;
    }

    public void setRequestUUID(String buildRequestUUID) {
        this.fBuildRequestUUID = buildRequestUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.fBuildResultUUID = buildResultUUID;
    }

    protected IWorkspace getWorkspace(ITeamRepository teamRepository) throws TeamRepositoryException {
        IWorkspace workspace = null;
        UUID workspaceUuid = null;
        if (this.fWorkspaceUUID != null) {
            try {
                workspaceUuid = UUID.valueOf((String)this.fWorkspaceUUID);
            }
            catch (IllegalArgumentException exception) {
                throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_INVALID_WORKSPACE_UUID, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            IItem item = null;
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
            try {
                item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, this.getProgressMonitor());
            }
            catch (ItemNotFoundException exception) {
                throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_WORKSPACE_NOT_FOUND, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            if (!(item instanceof IWorkspace)) {
                throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_NOT_A_WORKSPACE, (Object)this.fWorkspaceUUID, (Object)item.getItemType().getName()));
            }
            workspace = (IWorkspace)item;
        }
        return workspace;
    }

    protected IWorkspace getWorkspaceStream(IWorkspace workspace, ITeamRepository repo) throws TeamRepositoryException {
        IWorkspace flowTarget;
        IWorkspaceHandle flowTargetHandle;
        UUID defaultFlow;
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspace stream = null;
        Workspace ws = (Workspace)workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows != null && (defaultFlow = flows.getDefaultAcceptFlow()) != null && (flowTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(defaultFlow, null)) != null && (flowTarget = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)flowTargetHandle, 0, (IProgressMonitor)new NullProgressMonitor())).isStream()) {
            stream = flowTarget;
        }
        return stream;
    }

    private IBuildRequest getBuildRequest() throws TeamRepositoryException {
        IBuildRequest buildRequest = null;
        if (this.fBuildRequestUUID != null) {
            IBuildRequestHandle buildRequestHandle = (IBuildRequestHandle)IBuildRequest.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fBuildRequestUUID), null);
            try {
                buildRequest = (IBuildRequest)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildRequestHandle, 1, this.getProgressMonitor());
            }
            catch (ItemNotFoundException e) {
                throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)BUILD_REQUEST_UUID, (Object)this.fBuildRequestUUID), (Throwable)e);
            }
        }
        return buildRequest;
    }

    private IBuildResult getBuildResult(ITeamRepository teamRepository) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResult buildResult = null;
        try {
            UUID buildResultUuid = UUID.valueOf((String)this.fBuildResultUUID);
            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(buildResultUuid, null);
            buildResult = (IBuildResult)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 1, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (PermissionDeniedException permissionDeniedException) {
            // empty catch block
        }
        return buildResult;
    }

    protected RepositoryManager getRepositoryManager() {
        return this.fRepositoryManager;
    }
}

