/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.task;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teami.build.IBMIPasswordHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractCompilePublisherTask
extends Task {
    private ITeamRepository fTeamRepository = null;
    private IBuildResult fBuildResult = null;
    protected Collection<IBuildResultContribution> contributions = new LinkedList<IBuildResultContribution>();
    protected Map<String, ICompilePackage> packages = new HashMap<String, ICompilePackage>();
    protected Map<String, ICompileContribution> projects = new HashMap<String, ICompileContribution>();

    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        BuildItemFactory.initializeBuildPackage();
        FileSystemCore.startUp();
    }

    public ICompilePackage searchListForFolder(List<ICompilePackage> packages, String name) {
        for (ICompilePackage compilePackage : packages) {
            if (!name.equals(compilePackage.getPackageName())) continue;
            return compilePackage;
        }
        return null;
    }

    public IBuildRequest getBuildRequest() throws TeamRepositoryException, IOException {
        IBuildRequestHandle buildRequestHandle = (IBuildRequestHandle)IBuildRequest.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getProject().getProperty("env.requestUUID")), null);
        IBuildRequest buildRequest = (IBuildRequest)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildRequestHandle, 1, this.getProgressMonitor());
        return buildRequest;
    }

    public String getRelativeFileName(String fullFilename, String loadDir) {
        if ("".equals(loadDir) || loadDir == null) {
            return null;
        }
        if (fullFilename.contains(loadDir)) {
            if (loadDir.charAt(loadDir.length() - 1) == '/') {
                return fullFilename.substring(loadDir.length() - 1);
            }
            return fullFilename.substring(loadDir.length());
        }
        return null;
    }

    public void createSimpleContribution(ICompileSource sourceFile) throws IOException, FileNotFoundException, TeamRepositoryException {
        FileInfoRecord fileInfo = new FileInfoRecord();
        List errors = sourceFile.getErrors();
        List warnings = sourceFile.getWarnings();
        for (ICompileProblem compileProblem : errors) {
            fileInfo.addError(compileProblem.getLineNumber(), compileProblem.getMessageText());
            fileInfo.incrementErrorCount();
        }
        for (ICompileProblem compileProblem : warnings) {
            fileInfo.addWarning(compileProblem.getLineNumber(), compileProblem.getMessageText());
            fileInfo.incrementWarningCount();
        }
        this.createCompileContribution(sourceFile.getSourcePath(), fileInfo.getWarningCount(), fileInfo.getErrorCount(), fileInfo.getWarnings(), fileInfo.getErrors(), (IBuildResultHandle)this.getBuildResult(), this.getTeamRepository());
    }

    public ICompilePackage addProject(String projectName, IBuildResultHandle buildResult, ICompileSource sourceFile) {
        ICompileContribution project = this.projects.get(projectName);
        if (project == null) {
            project = this.createProject(projectName, buildResult);
            this.projects.put(projectName, project);
        }
        project.setClassCount(project.getClassCount() + 1);
        project.setErrorCount(project.getErrorCount() + sourceFile.getErrorCount());
        project.setWarningCount(project.getWarningCount() + sourceFile.getWarningCount());
        List projectPackages = project.getCompilePackages();
        return (ICompilePackage)projectPackages.get(0);
    }

    public void recursivelyAddFolder(ICompilePackage compilePackage, StringTokenizer tokenizedFilename, ICompileSource sourceFile, IBuildResultHandle buildResult) {
        String name = tokenizedFilename.nextToken();
        if (!tokenizedFilename.hasMoreTokens()) {
            this.addSourceFile(compilePackage, sourceFile);
            return;
        }
        ICompilePackage nextCompilePackage = this.addCompilePackage(compilePackage, name, sourceFile.getErrorCount(), sourceFile.getWarningCount(), buildResult);
        this.recursivelyAddFolder(nextCompilePackage, tokenizedFilename, sourceFile, buildResult);
    }

    public void createPath(String relativeFilename, ICompileSource sourceFile, IBuildResultHandle buildResult) throws IOException, FileNotFoundException, TeamRepositoryException {
        StringTokenizer tokenizedFilename = new StringTokenizer(relativeFilename, "/");
        int directories = tokenizedFilename.countTokens();
        if (directories == 1) {
            this.createSimpleContribution(sourceFile);
        } else if (directories > 1) {
            String projectName = tokenizedFilename.nextToken();
            ICompilePackage project = this.addProject(projectName, buildResult, sourceFile);
            this.recursivelyAddFolder(project, tokenizedFilename, sourceFile, buildResult);
        }
    }

    public ICompileSource createSourceFile(String filename, String path) {
        ICompileSource compileSource = BuildItemFactory.createCompileSource();
        compileSource.setSourceName(filename);
        compileSource.setSourcePath(path);
        return compileSource;
    }

    public void addSourceFile(ICompilePackage compilePackage, ICompileSource sourceFile) {
        compilePackage.setErrorCount(compilePackage.getErrorCount() + sourceFile.getErrorCount());
        compilePackage.setWarningCount(compilePackage.getWarningCount() + sourceFile.getWarningCount());
        compilePackage.setClassCount(compilePackage.getClassCount() + 1);
        List sourceFiles = compilePackage.getCompileSources();
        sourceFiles.add(sourceFile);
    }

    public ICompilePackage addCompilePackage(ICompilePackage compilePackage, String compilePackageLabel, int errorCount, int warningCount, IBuildResultHandle buildResult) {
        List subPackages = compilePackage.getSubCompilePackages();
        ICompilePackage subCompilePackage = this.searchListForFolder(subPackages, compilePackageLabel);
        if (subCompilePackage == null) {
            subCompilePackage = BuildItemFactory.createCompilePackage();
            subCompilePackage.setPackageName(compilePackageLabel);
            subCompilePackage.setPackageType("folder");
            subCompilePackage.setBuildResult(buildResult);
            subPackages.add(subCompilePackage);
        }
        compilePackage.setClassCount(compilePackage.getClassCount() + 1);
        compilePackage.setErrorCount(compilePackage.getErrorCount() + errorCount);
        compilePackage.setWarningCount(compilePackage.getWarningCount() + warningCount);
        return subCompilePackage;
    }

    public ICompileContribution createProject(String compileContributionLabel, IBuildResultHandle buildResult) {
        ICompileContribution compileContribution = BuildItemFactory.createCompileContribution();
        compileContribution.setBuildResult(buildResult);
        List compilePackageList = compileContribution.getCompilePackages();
        ICompilePackage compilePackage = BuildItemFactory.createCompilePackage();
        compilePackage.setPackageName(compileContributionLabel);
        compilePackage.setPackageType("project");
        compilePackage.setBuildResult(buildResult);
        compilePackageList.add(compilePackage);
        IBuildResultContribution buildResultContribution = BuildItemFactory.createBuildResultContribution();
        buildResultContribution.setLabel(compileContributionLabel);
        buildResultContribution.setImpactsPrimaryResult(true);
        buildResultContribution.setExtendedContribution((IItemHandle)compileContribution);
        buildResultContribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
        this.contributions.add(buildResultContribution);
        return compileContribution;
    }

    public void createCompileContribution(String compileContributionLabel, int warningCount, int errorCount, String warnings, String errors, IBuildResultHandle buildResult, ITeamRepository teamRepository) throws TeamRepositoryException {
        ICompileContribution compileContribution = BuildItemFactory.createCompileContribution();
        compileContribution.setWarningCount(warningCount);
        compileContribution.setErrorCount(errorCount);
        compileContribution.setBuildResult(buildResult);
        if (!"".equals(warnings)) {
            compileContribution.setWarnings(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)warnings, (IProgressMonitor)new NullProgressMonitor()));
        }
        if (!"".equals(errors)) {
            compileContribution.setErrors(ContentUtil.stringToContent((ITeamRepository)teamRepository, (String)errors, (IProgressMonitor)new NullProgressMonitor()));
        }
        IBuildResultContribution buildResultContribution = BuildItemFactory.createBuildResultContribution();
        buildResultContribution.setLabel(compileContributionLabel);
        buildResultContribution.setImpactsPrimaryResult(true);
        buildResultContribution.setExtendedContribution((IItemHandle)compileContribution);
        buildResultContribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
        this.contributions.add(buildResultContribution);
    }

    private void saveCompilePackage(ICompilePackage compilePackage, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        for (Object object : compilePackage.getSubCompilePackages()) {
            this.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compilePackage, monitor);
    }

    protected void publishBuildResultContributions(IBuildResult buildResult, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IBuildResultContribution contribution : this.contributions) {
            ICompileContribution compileContribution = (ICompileContribution)contribution.getExtendedContribution();
            if (compileContribution.getErrorCount() > 0) {
                contribution.setStatus(BuildStatus.ERROR);
            } else if (compileContribution.getWarningCount() > 0) {
                contribution.setStatus(BuildStatus.WARNING);
            } else {
                contribution.setStatus(BuildStatus.OK);
            }
            for (Object object : compileContribution.getCompilePackages()) {
                this.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
            }
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compileContribution, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, this.contributions.toArray(new IBuildResultContribution[this.contributions.size()]), monitor);
    }

    protected IBuildResult getBuildResult() throws BuildException {
        try {
            if (this.fBuildResult == null) {
                IBuildResultHandle resultHandle = this.getBuildResultHandle();
                this.fBuildResult = (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)resultHandle, 1, this.getProgressMonitor());
            }
            return this.fBuildResult;
        }
        catch (ItemNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected IBuildResultHandle getBuildResultHandle() throws TeamRepositoryException {
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID()), null);
    }

    protected String getBuildResultUUID() {
        return this.getProject().getProperty("env.buildResultUUID");
    }

    public String getRepositoryAddress() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.repositoryAddress");
    }

    protected ITeamRepository getTeamRepository() throws TeamRepositoryException, FileNotFoundException, IOException {
        if (this.fTeamRepository == null) {
            Project p = this.getProject();
            this.fTeamRepository = AuthenticationUtilities.getLoggedInTeamRepository((Project)p, (String)this.getRepositoryAddress(), (String)this.getUserId(), (File)new File(this.getPasswordFile()));
        }
        return this.fTeamRepository;
    }

    protected IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    public String getUserId() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_USER");
    }

    public String getPasswordFile() throws FileNotFoundException, IOException {
        return this.getProject().getProperty("env.JAZZ_PASSWORD_FILE");
    }

    protected String getProvidedPassword() throws TeamRepositoryException, FileNotFoundException, IOException {
        File passwordFile = new File(this.getPasswordFile());
        try {
            return this.decryptPassword(passwordFile);
        }
        catch (Exception exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    protected String decryptPassword(File passwordFile) throws Exception {
        return IBMIPasswordHelper.getPassword((File)passwordFile);
    }

    public class FileInfoRecord {
        private static final char newLine = '\n';
        int errorCount = 0;
        int warningCount = 0;
        StringBuffer warnings = new StringBuffer();
        StringBuffer errors = new StringBuffer();

        public void incrementErrorCount() {
            ++this.errorCount;
        }

        public void incrementWarningCount() {
            ++this.warningCount;
        }

        public void addWarning(double lineNum, String msg) {
            this.addRecord(this.warnings, lineNum, msg);
        }

        public void addError(double integer, String msg) {
            this.addRecord(this.errors, integer, msg);
        }

        private void addRecord(StringBuffer buffer, double lineNum, String msg) {
            if (!"".equals(buffer.toString())) {
                buffer.append('\n');
            }
            buffer.append(lineNum);
            buffer.append(": ");
            buffer.append(msg);
        }

        public String getWarnings() {
            return this.warnings.toString();
        }

        public String getErrors() {
            return this.errors.toString();
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }
}

