/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.task;

import com.ibm.etools.unix.cobol.projects.adata.AdataError;
import com.ibm.etools.unix.cobol.projects.adata.AdataModel;
import com.ibm.etools.unix.cobol.projects.adata.AdataRecordType;
import com.ibm.etools.unix.cobol.projects.adata.BuildDirMapParser;
import com.ibm.etools.unix.cobol.projects.adata.CompilationUnit;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.CompileProblemType;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AIXCOBOLParser {
    Map<String, ICompileSource> ProblemsPerSource = new HashMap<String, ICompileSource>();

    public ICompileSource createSourceFile(String filename, String path) {
        ICompileSource compileSource = BuildItemFactory.createCompileSource();
        compileSource.setSourceName(filename);
        compileSource.setSourcePath(path);
        return compileSource;
    }

    public void addSourceFile(String fileName, String adataFileName) {
        AdataModel adataModel = new AdataModel(adataFileName, EnumSet.of(AdataRecordType.ERRORS));
        ICompileSource sourceFile = this.createSourceFile(fileName.substring(fileName.lastIndexOf(47) + 1), fileName);
        List compileProblemErrors = sourceFile.getErrors();
        List compilationUnits = adataModel.getCompilationUnits();
        for (CompilationUnit compileUnit : compilationUnits) {
            List errors = compileUnit.getErrors();
            for (AdataError error : errors) {
                ICompileProblem compileProblem = BuildItemFactory.createCompileProblem();
                compileProblem.setMessageText(error.getMessage());
                compileProblem.setLineNumber(error.getLineNumber());
                compileProblem.setProblemType(CompileProblemType.ERROR);
                compileProblemErrors.add(compileProblem);
            }
            sourceFile.setErrorCount(sourceFile.getErrorCount() + errors.size());
        }
        this.ProblemsPerSource.put(fileName, sourceFile);
    }

    public Map<String, ICompileSource> parseLogFile(BuildDirMapParser buildMap, List<String> filesWithErrors) {
        for (String filename : filesWithErrors) {
            String buildDir = buildMap.getBuildDirFor(filename);
            String adataFileName = this.getAdataFileName(buildDir, filename);
            this.addSourceFile(filename, adataFileName);
        }
        return this.ProblemsPerSource;
    }

    private String getAdataFileName(String buildDir, String sourceFile) {
        int idxExtension;
        int idxSeparator = sourceFile.lastIndexOf(47);
        if (idxSeparator != -1) {
            sourceFile = sourceFile.substring(idxSeparator + 1);
        }
        if ((idxExtension = sourceFile.lastIndexOf(46)) != -1) {
            sourceFile = sourceFile.substring(0, idxExtension);
        }
        if (buildDir.charAt(buildDir.length() - 1) != '/') {
            buildDir = String.valueOf(buildDir) + '/';
        }
        return String.valueOf(buildDir) + sourceFile + ".adt";
    }
}

