/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.task;

import com.ibm.etools.unix.cobol.projects.adata.BuildDirMapParser;
import com.ibm.etools.unix.cobol.projects.adata.BuildStatusParser;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamp.build.ant.task.AIXCOBOLParser;
import com.ibm.teamp.build.ant.task.AbstractCompilePublisherTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;

public class AIXCOBOLLogPublisherTask
extends AbstractCompilePublisherTask {
    InputStream buildDirMapFile;
    InputStream buildStatusFile;

    public void execute() {
        this.getProject().log("COBOL Compilation Result parser is running.");
        try {
            this.buildDirMapFile = new FileInputStream(String.valueOf(this.getProject().getProperty("env.IBM_BUILD_STATUS_DIR")) + "/.buildDirMap");
            this.buildStatusFile = new FileInputStream(String.valueOf(this.getProject().getProperty("env.IBM_BUILD_STATUS_DIR")) + "/.buildStatus");
            BuildStatusParser buildStatus = new BuildStatusParser(this.buildStatusFile);
            BuildDirMapParser buildMap = new BuildDirMapParser(this.buildDirMapFile);
            List filesWithErrors = buildStatus.getFilesCompiledWithErrors();
            List cleanFiles = buildStatus.getFilesCompiledClean();
            AIXCOBOLParser cobolParser = new AIXCOBOLParser();
            Map<String, ICompileSource> problemsPerSource = cobolParser.parseLogFile(buildMap, filesWithErrors);
            int numFiles = 0;
            Set<String> KeySet2 = problemsPerSource.keySet();
            Iterator<String> Keys = KeySet2.iterator();
            String loadDir = this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.jazzscm") != null ? this.getBuildRequest().getBuildDefinitionInstance().getProperty("team.scm.fetchDestination").getValue() : this.getProject().getProperty("env.loadDirectory");
            while (Keys.hasNext()) {
                ++numFiles;
                String fullSourceFileName = Keys.next();
                String relativeFilename = this.getRelativeFileName(fullSourceFileName, loadDir);
                if (relativeFilename == null) {
                    this.createSimpleContribution(problemsPerSource.get(fullSourceFileName));
                    continue;
                }
                ICompileSource sourceFile = problemsPerSource.get(fullSourceFileName);
                IBuildResult buildResult = this.getBuildResult();
                this.createPath(relativeFilename, sourceFile, (IBuildResultHandle)buildResult);
            }
            for (String filename : cleanFiles) {
                String relativeFilename = this.getRelativeFileName(filename, loadDir);
                ICompileSource sourceFile = this.createSourceFile(this.getFilename(filename), filename);
                IBuildResult buildResult = this.getBuildResult();
                this.createPath(relativeFilename, sourceFile, (IBuildResultHandle)buildResult);
            }
            this.publishBuildResultContributions(this.getBuildResult(), this.getTeamRepository(), this.getProgressMonitor());
            File builddir = new File(String.valueOf(this.getProject().getProperty("env.IBM_BUILD_STATUS_DIR")) + "/.buildDirMap");
            File buildstatus = new File(String.valueOf(this.getProject().getProperty("env.IBM_BUILD_STATUS_DIR")) + "/.buildStatus");
            builddir.delete();
            buildstatus.delete();
        }
        catch (FileNotFoundException f) {
            throw new BuildException((Throwable)f);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException t) {
            throw new BuildException((Throwable)t);
        }
    }

    public String getFilename(String sourceFile) {
        int idxSeparator = sourceFile.lastIndexOf(47);
        if (idxSeparator != -1) {
            sourceFile = sourceFile.substring(idxSeparator + 1);
        }
        return sourceFile;
    }
}

