/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.task;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.CompileProblemType;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AIXCCPPParser {
    private String curDir;
    private static final char UNIX_SEPARATOR = '/';
    Map<String, ICompileSource> ProblemsPerSource = new HashMap<String, ICompileSource>();

    public AIXCCPPParser(String curDir) {
        this.setCurDir(curDir);
    }

    public void setCurDir(String curDir) {
        this.curDir = curDir.charAt(curDir.length() - 1) == '/' ? curDir.substring(0, curDir.length() - 1) : curDir;
    }

    public String getCurDir() {
        return this.curDir;
    }

    public void getDirectory(String line) {
        int index = line.indexOf("Entering directory ");
        if (index != -1) {
            this.setCurDir(line.substring(index + 20, line.length() - 1));
        }
    }

    public String resolveFilePath(String filepath) {
        ArrayList<String> path = new ArrayList<String>();
        int index = 0;
        String dir = "";
        int i = 0;
        while (i < filepath.length()) {
            if (filepath.charAt(i) != '/') {
                dir = String.valueOf(dir) + filepath.charAt(i);
            } else {
                if (dir.equals("..") && index > 0) {
                    System.out.println("remdir : " + (String)path.get(--index));
                    path.remove(index);
                } else if (!dir.equals("..") && dir != "") {
                    System.out.println("dir : " + dir);
                    path.add(dir);
                    ++index;
                }
                dir = "";
            }
            ++i;
        }
        String resolvedFilepath = "";
        int i2 = 0;
        while (i2 < index) {
            resolvedFilepath = String.valueOf(resolvedFilepath) + '/';
            resolvedFilepath = resolvedFilepath.concat((String)path.get(i2));
            ++i2;
        }
        System.out.println("resolvedFilepath :: " + resolvedFilepath);
        return String.valueOf(resolvedFilepath) + '/' + dir;
    }

    public ICompileSource createSourceFile(String filename, String path) {
        ICompileSource compileSource = BuildItemFactory.createCompileSource();
        compileSource.setSourceName(filename);
        compileSource.setSourcePath(path);
        return compileSource;
    }

    public ICompileSource addProblemToSource(String fullSourceFileName, ICompileProblem compileProblem) {
        ICompileSource sourceFile = this.ProblemsPerSource.get(fullSourceFileName);
        if (sourceFile == null) {
            sourceFile = this.createSourceFile(fullSourceFileName.substring(fullSourceFileName.lastIndexOf(47) + 1), fullSourceFileName);
            this.ProblemsPerSource.put(fullSourceFileName, sourceFile);
        }
        if (compileProblem.getProblemType() == CompileProblemType.ERROR) {
            List problemList = sourceFile.getErrors();
            sourceFile.setErrorCount(sourceFile.getErrorCount() + 1);
            problemList.add(compileProblem);
        } else {
            List problemList = sourceFile.getWarnings();
            sourceFile.setWarningCount(sourceFile.getWarningCount() + 1);
            problemList.add(compileProblem);
        }
        return sourceFile;
    }

    public ICompileSource getErrorInfo(String line) {
        Pattern CompilationOutput = Pattern.compile("\"(.*)\", line (.*):.*\\((.)\\) (.*)");
        Matcher matchedCompilationOutput = CompilationOutput.matcher(line);
        if (matchedCompilationOutput.find()) {
            ICompileProblem compileProblem = BuildItemFactory.createCompileProblem();
            compileProblem.setMessageText(matchedCompilationOutput.group(4));
            compileProblem.setLineNumber((int)Double.parseDouble(matchedCompilationOutput.group(2)));
            switch (matchedCompilationOutput.group(3).charAt(0)) {
                case 'I': 
                case 'W': {
                    compileProblem.setProblemType(CompileProblemType.WARNING);
                    break;
                }
                case 'E': 
                case 'S': {
                    compileProblem.setProblemType(CompileProblemType.ERROR);
                    break;
                }
                default: {
                    return null;
                }
            }
            String name = matchedCompilationOutput.group(1);
            if (name.charAt(0) == '/') {
                return this.addProblemToSource(name, compileProblem);
            }
            if (name.contains("..")) {
                return this.addProblemToSource(this.resolveFilePath(String.valueOf(this.getCurDir()) + '/' + name), compileProblem);
            }
            return this.addProblemToSource(String.valueOf(this.getCurDir()) + '/' + name, compileProblem);
        }
        this.getDirectory(line);
        return null;
    }

    public Map<String, ICompileSource> parseLogFile(String Filename) throws IOException, FileNotFoundException {
        try (BufferedReader logFile = null;){
            String line;
            logFile = new BufferedReader(new FileReader(Filename));
            while ((line = logFile.readLine()) != null) {
                this.getErrorInfo(line);
            }
        }
        return this.ProblemsPerSource;
    }
}

