/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamp.build.ant.task;

import com.ibm.team.build.ant.task.LogPublisherTask;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamp.build.ant.task.AIXCCPPParser;
import com.ibm.teamp.build.ant.task.AbstractCompilePublisherTask;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;

public class AIXCCPPLogPublisherTask
extends AbstractCompilePublisherTask {
    private static final char UNIX_SEPARATOR = '/';

    public void execute() {
        this.getProject().log("CCPP Compilation Result parser is running.");
        String logFile = this.getProject().getProperty("logFile");
        try {
            String loadDirectory;
            String directory = this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.rational.buildforge.buildagent.cmdline").getConfigurationProperty("com.ibm.rational.buildforge.buildagent.cmdline.workingDir").getValue();
            if (this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.jazzscm") != null) {
                loadDirectory = this.getBuildRequest().getBuildDefinitionInstance().getProperty("team.scm.fetchDestination").getValue();
                directory = directory.replace("${team.scm.fetchDestination}", loadDirectory);
                this.getProject().log(directory);
            } else {
                loadDirectory = this.getProject().getProperty("env.loadDirectory");
            }
            AIXCCPPParser AIXCPPparser = new AIXCCPPParser(directory);
            Map<String, ICompileSource> problemsPerSource = logFile.charAt(0) == '/' ? AIXCPPparser.parseLogFile(logFile) : AIXCPPparser.parseLogFile(String.valueOf(directory) + '/' + logFile);
            int numFiles = 0;
            Set<String> KeySet = problemsPerSource.keySet();
            Iterator<String> Keys = KeySet.iterator();
            while (Keys.hasNext()) {
                ++numFiles;
                String fullSourceFileName = Keys.next();
                String relativeFilename = this.getRelativeFileName(fullSourceFileName, loadDirectory);
                if (relativeFilename == null) {
                    this.createSimpleContribution(problemsPerSource.get(fullSourceFileName));
                    continue;
                }
                this.createPath(relativeFilename, problemsPerSource.get(fullSourceFileName), (IBuildResultHandle)this.getBuildResult());
            }
            this.publishBuildResultContributions(this.getBuildResult(), this.getTeamRepository(), this.getProgressMonitor());
            LogPublisherTask logPublisherTask = new LogPublisherTask();
            logPublisherTask.setFilePath(new File(logFile));
            logPublisherTask.setUserId(this.getUserId());
            logPublisherTask.setRepositoryAddress(this.getRepositoryAddress());
            logPublisherTask.setBuildResultUUID(this.getBuildResultUUID());
            logPublisherTask.setLabel("Makefile Log");
            logPublisherTask.setPasswordFile(new File(this.getPasswordFile()));
            logPublisherTask.execute();
        }
        catch (IOException e) {
            this.getProject().log("IO Exception");
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException t) {
            this.getProject().log("TeamRepositoryException");
            throw new BuildException((Throwable)t);
        }
    }
}

