/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.listener;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.publishing.LogPublisher;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teami.build.IBMIPasswordHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class IBMiJazzSCMListener
implements SubBuildListener {
    public static String copyright = "(c) Copyright IBM Corp 2012.";
    private static final String LOAD_FILE_LOCATION_PROPERTY = "teamp.build.load.file.location";
    private ITeamRepository fTeamRepository = null;
    private IBuildResult fBuildResult = null;
    protected String buildResultUUID = null;
    protected String repositoryAddress = null;
    protected String userId = null;
    protected String passwordFile = null;

    public void buildFinished(BuildEvent event) {
        block5: {
            try {
                String loadFilePath = event.getProject().getProperty(LOAD_FILE_LOCATION_PROPERTY);
                ITeamRepository teamRepository = null;
                IBuildResult buildResult = null;
                try {
                    teamRepository = this.getTeamRepository(event);
                    buildResult = this.getBuildResult(event);
                }
                catch (Exception e) {
                    return;
                }
                BuildStatus status = BuildStatus.OK;
                if (event.getException() != null) {
                    status = BuildStatus.ERROR;
                }
                LogPublisher publisher = new LogPublisher(loadFilePath, "Loading Log", "application/unknown", null);
                publisher.publish((IBuildResultHandle)buildResult, status, teamRepository);
            }
            catch (Exception e) {
                event.getProject().log("Failed Publishing Load Log File", (Throwable)e, 0);
                if (e.getMessage() == null) break block5;
                event.getProject().log(e.getMessage());
            }
        }
    }

    public void buildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    public void subBuildStarted(BuildEvent event) {
    }

    public void subBuildFinished(BuildEvent event) {
    }

    protected ITeamRepository getTeamRepository(BuildEvent event) throws TeamRepositoryException, FileNotFoundException, IOException {
        if (this.fTeamRepository == null) {
            Project p = event.getProject();
            this.fTeamRepository = AuthenticationUtilities.getLoggedInTeamRepository((Project)p, (String)this.getRepositoryAddress(event), (String)this.getUserId(event), (File)new File(this.getPasswordFile(event)));
        }
        return this.fTeamRepository;
    }

    public String getUserId(BuildEvent event) throws FileNotFoundException, IOException {
        if (this.userId == null) {
            this.userId = event.getProject().getProperty("userId");
        }
        return this.userId;
    }

    public String getPasswordFile(BuildEvent event) throws FileNotFoundException, IOException {
        if (this.passwordFile == null) {
            this.passwordFile = event.getProject().getProperty("passwordFile");
        }
        return this.passwordFile;
    }

    protected String getProvidedPassword(BuildEvent event) throws TeamRepositoryException, FileNotFoundException, IOException {
        File passwordFile = new File(this.getPasswordFile(event));
        try {
            return this.decryptPassword(passwordFile);
        }
        catch (Exception exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    protected String decryptPassword(File passwordFile) throws Exception {
        return IBMIPasswordHelper.getPassword((File)passwordFile);
    }

    public String getRepositoryAddress(BuildEvent event) throws FileNotFoundException, IOException {
        if (this.repositoryAddress == null) {
            this.repositoryAddress = event.getProject().getProperty("repositoryAddress");
        }
        return this.repositoryAddress;
    }

    protected IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected IBuildResult getBuildResult(BuildEvent event) throws BuildException {
        try {
            if (this.fBuildResult == null) {
                IBuildResultHandle resultHandle = this.getBuildResultHandle(event);
                this.fBuildResult = (IBuildResult)this.getTeamRepository(event).itemManager().fetchCompleteItem((IItemHandle)resultHandle, 1, this.getProgressMonitor());
            }
            return this.fBuildResult;
        }
        catch (ItemNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected IBuildResultHandle getBuildResultHandle(BuildEvent event) throws TeamRepositoryException {
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID(event)), null);
    }

    protected String getBuildResultUUID(BuildEvent event) {
        if (this.buildResultUUID == null) {
            this.buildResultUUID = event.getProject().getProperty("buildResultUUID");
        }
        return this.buildResultUUID;
    }
}

