/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.listener;

import com.ibm.etools.iseries.comm.interfaces.ISequentialFileReader;
import com.ibm.etools.iseries.util.SequentialFileReader;
import com.ibm.etools.iseries.util.evfparser.EventsFileParserCore;
import com.ibm.etools.iseries.util.evfparser.QSYSEventsFileErrorInformationRecord;
import com.ibm.etools.iseries.util.evfparser.QSYSEventsFileFileIDRecord;
import com.ibm.iant.IBMIBuildEvent;
import com.ibm.iant.listener.AbstractIBMIEventFileListener;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompileProblem;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResource;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResourceCollection;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teami.build.IBMIPasswordHelper;
import com.ibm.teami.build.toolkit.listener.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class IBMiEventFileListener
extends AbstractIBMIEventFileListener {
    private ITeamRepository fTeamRepository = null;
    private IBuildResult fBuildResult = null;
    private int highestSev = 0;
    private Boolean isBuildSpecificationBuild = true;
    private String isPersonalBuildProperty = "com.ibm.iant.devBuild";
    private String isGenerateProperty = "com.ibm.teami.build.ant.generated";
    private String isFailOnErrorProperty = "com.ibm.teami.build.ant.failOnError";
    private String failOnErrorLevelProperty = "com.ibm.teami.build.ant.failOnError.level";
    protected static final String newLine = "\n";
    private final String information = "I";
    private final String warning = "W";
    protected String buildResultUUID = null;
    protected String repositoryAddress = null;
    protected String userId = null;
    protected String passwordFile = null;
    protected Collection<IBuildResultContribution> contributions = new LinkedList<IBuildResultContribution>();
    protected Map<String, ICompileContribution> projects = new HashMap<String, ICompileContribution>();

    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        BuildItemFactory.initializeBuildPackage();
        FileSystemCore.startUp();
    }

    public void buildFinished(BuildEvent event) {
        block3: {
            try {
                String devBuild = event.getProject().getProperty(this.isPersonalBuildProperty);
                if (!(this.contributions.size() <= 0 || devBuild != null && this.isBuildSpecificationBuild.booleanValue())) {
                    this.publishBuildResultContributions(this.getBuildResult(event), this.getTeamRepository(event), this.getProgressMonitor());
                }
            }
            catch (Exception e) {
                event.getProject().log(Messages.FAILED_PUBLISHING_RESULTS, (Throwable)e, 0);
                if (e.getMessage() == null) break block3;
                event.getProject().log(e.getMessage());
            }
        }
    }

    public void processEventFile(IBMIBuildEvent event) {
        block6: {
            try {
                String devBuild = event.getProject().getProperty(this.isPersonalBuildProperty);
                if (devBuild == null || !this.isBuildSpecificationBuild.booleanValue()) {
                    this.highestSev = -1;
                    this.parseEventsFile(this.getCCSID(), this.getEventFileLibrary(), this.getEventFileFile(), this.getEventFileMember(), event);
                    this.checkShouldBuildFail(event);
                    this.getTeamRepository((BuildEvent)event);
                }
            }
            catch (OperationCanceledException e) {
                if (e.getMessage() != null) {
                    event.getProject().log(e.getMessage());
                }
                event.getProject().log(Messages.COULD_NOT_CONNECT_TO_REPOSITORY, 0);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                event.getProject().log(String.valueOf(Messages.ERROR_PARSING_EVENT_FILE) + e.getClass().getName(), (Throwable)e, 0);
                if (e.getMessage() == null) break block6;
                event.getProject().log(e.getMessage());
            }
        }
    }

    private void checkShouldBuildFail(IBMIBuildEvent event) throws BuildException {
        boolean failOnError = Boolean.valueOf(event.getProject().getProperty(this.isFailOnErrorProperty));
        int failOnErrorThreshold = Integer.valueOf(event.getProject().getProperty(this.failOnErrorLevelProperty));
        if (failOnError && this.highestSev >= failOnErrorThreshold) {
            throw new BuildException(Messages.SEVERITY_THRESHOLD_HIT);
        }
    }

    public void parseEventsFile(int ccsid, String eventsFilelibrary, String eventsFileSrcFile, String eventsFileMember, IBMIBuildEvent event) throws TeamRepositoryException, Exception {
        int index;
        HashMap<String, FileInfoRecord> filesToErrors = new HashMap<String, FileInfoRecord>();
        EventsFileParserCore eventsParser = new EventsFileParserCore();
        String iProjectName = null;
        SequentialFileReader sfr = new SequentialFileReader(event.getSystem(), ccsid, eventsFilelibrary, eventsFileSrcFile, eventsFileMember);
        eventsParser.parse((ISequentialFileReader)sfr, ccsid, null);
        sfr.close();
        boolean genlvlSet = false;
        int genlvl = 0;
        String cmd = event.getCommand();
        if (cmd != null && (index = (cmd = cmd.toUpperCase()).indexOf("GENLVL(")) > 0) {
            genlvlSet = true;
            String subCmd = cmd.substring(index + 7);
            int indexBracket = subCmd.indexOf(")");
            genlvl = Integer.parseInt(subCmd.substring(0, indexBracket));
        }
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle((BuildEvent)event);
        Set allFileNames = this.getAllFileNamesFromEventFile(eventsParser.getAllFileIDRecords());
        LinkedList allErrors = eventsParser.getAllErrors();
        int i = 0;
        while (i < allErrors.size()) {
            String sevChar;
            QSYSEventsFileErrorInformationRecord error = (QSYSEventsFileErrorInformationRecord)allErrors.get(i);
            String file = error.getFileName();
            FileInfoRecord record = (FileInfoRecord)filesToErrors.get(file);
            if (record == null) {
                record = new FileInfoRecord();
                filesToErrors.put(file, record);
            }
            if ((sevChar = error.getSevChar()).equals("I") || sevChar.equals("W")) {
                record.incrementWarningCount();
                record.addWarning(new Integer(error.getStartErrLine()), error.getSevNum(), error.getMsgId(), error.getMsg());
            } else if (genlvlSet && Integer.parseInt(error.getSevNum()) <= genlvl) {
                record.incrementWarningCount();
                record.addWarning(new Integer(error.getStartErrLine()), error.getSevNum(), error.getMsgId(), error.getMsg());
            } else {
                record.incrementErrorCount();
                record.addError(new Integer(error.getStartErrLine()), error.getSevNum(), error.getMsgId(), error.getMsg());
            }
            int sev = Integer.parseInt(error.getSevNum());
            if (sev > this.highestSev) {
                this.highestSev = sev;
            }
            ++i;
        }
        boolean generated = event.getProject().getProperty(this.isGenerateProperty) == null || Boolean.valueOf(event.getProject().getProperty(this.isGenerateProperty)) != false;
        for (String file : filesToErrors.keySet()) {
            if (generated) {
                CompilationProblem problem;
                int openBracketIndex;
                File baseDir = event.getProject().getBaseDir();
                String library = "";
                String srcFile = "";
                String member = "";
                int slashIndex = file.indexOf("/");
                if (slashIndex > 0 && (openBracketIndex = file.indexOf("(")) > 0) {
                    library = file.substring(0, slashIndex);
                    srcFile = file.substring(slashIndex + 1, openBracketIndex);
                    member = file.substring(openBracketIndex + 1, file.length() - 1);
                }
                iProjectName = baseDir.getParentFile().getName().trim();
                if (event.getProjectName() != null && event.getComponentName() != null) {
                    iProjectName = String.valueOf(event.getComponentName()) + "/" + event.getProjectName();
                    ReturnCodeResource rcResource = new ReturnCodeResource(event.getComponentName(), event.getProjectName(), String.valueOf(library) + "/" + srcFile, member, String.valueOf(this.highestSev));
                    ReturnCodeResourceCollection.getInstance().addResource(event.getComponentName(), event.getProjectName(), (Object)rcResource);
                }
                FileInfoRecord record = (FileInfoRecord)filesToErrors.get(file);
                List errors = record.getErrors();
                List warnings = record.getWarnings();
                ICompileSource sourceFile = this.createSourceFile(member, member, errors.size(), warnings.size());
                int i2 = 0;
                while (i2 < errors.size()) {
                    problem = (CompilationProblem)errors.get(i2);
                    this.addErrorToSource(sourceFile, problem.getLineNumber(), problem.getProblemMessage());
                    ++i2;
                }
                i2 = 0;
                while (i2 < warnings.size()) {
                    problem = (CompilationProblem)warnings.get(i2);
                    this.addWarningToSource(sourceFile, problem.getLineNumber(), problem.getProblemMessage());
                    ++i2;
                }
                ICompileContribution compileContribution = this.projects.get(iProjectName);
                if (compileContribution == null) {
                    compileContribution = this.createProject(iProjectName, buildResultHandle);
                    this.projects.put(iProjectName, compileContribution);
                }
                ICompilePackage compileProject = (ICompilePackage)compileContribution.getCompilePackages().get(0);
                List packages = compileProject.getSubCompilePackages();
                ICompilePackage compilePackage = null;
                int i3 = 0;
                while (i3 < packages.size()) {
                    ICompilePackage pck = (ICompilePackage)packages.get(i3);
                    if (pck.getPackageName().equals(srcFile)) {
                        compilePackage = pck;
                        break;
                    }
                    ++i3;
                }
                if (compilePackage == null) {
                    compilePackage = this.addCompilePackage(compileProject, srcFile, buildResultHandle);
                }
                List compileSources = compilePackage.getCompileSources();
                compileSources.add(sourceFile);
                this.updateCompilePackageCounts(compilePackage, errors.size(), warnings.size());
                this.updateCompilePackageCounts(compileProject, errors.size(), warnings.size());
            }
            if (!allFileNames.contains(file)) continue;
            allFileNames.remove(file);
        }
        Iterator iter = allFileNames.iterator();
        while (iter.hasNext()) {
            int openBracketIndex;
            String file;
            String label = file = (String)iter.next();
            if (!generated) continue;
            File baseDir = event.getProject().getBaseDir();
            label = this.getGeneratedLabel(file, baseDir);
            String srcFile = "";
            String member = "";
            int slashIndex = file.indexOf("/");
            if (slashIndex > 0 && (openBracketIndex = file.indexOf("(")) > 0) {
                srcFile = file.substring(slashIndex + 1, openBracketIndex);
                member = file.substring(openBracketIndex + 1, file.length() - 1);
            }
            iProjectName = baseDir.getParentFile().getName().trim();
            if (event.getProjectName() != null && event.getComponentName() != null) {
                iProjectName = String.valueOf(event.getComponentName()) + "/" + event.getProjectName();
            }
            ICompileSource sourceFile = this.createSourceFile(member, member, 0, 0);
            ICompileContribution compileContribution = this.projects.get(iProjectName);
            if (compileContribution == null) {
                compileContribution = this.createProject(iProjectName, buildResultHandle);
                this.projects.put(iProjectName, compileContribution);
            }
            ICompilePackage compileProject = (ICompilePackage)compileContribution.getCompilePackages().get(0);
            List packages = compileProject.getSubCompilePackages();
            ICompilePackage compilePackage = null;
            int i4 = 0;
            while (i4 < packages.size()) {
                ICompilePackage pck = (ICompilePackage)packages.get(i4);
                if (pck.getPackageName().equals(srcFile)) {
                    compilePackage = pck;
                    break;
                }
                ++i4;
            }
            if (compilePackage == null) {
                compilePackage = this.addCompilePackage(compileProject, srcFile, buildResultHandle);
            }
            List compileSources = compilePackage.getCompileSources();
            compileSources.add(sourceFile);
            this.updateCompilePackageCounts(compilePackage, 0, 0);
            this.updateCompilePackageCounts(compileProject, 0, 0);
        }
    }

    private Set getAllFileNamesFromEventFile(Set allFileIDRecords) {
        if (allFileIDRecords.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> fileNames = new HashSet<String>();
        for (QSYSEventsFileFileIDRecord fileIDRecord : allFileIDRecords) {
            String name;
            String sourceID = fileIDRecord.getSourceId();
            int id = -1;
            try {
                id = new Integer(sourceID);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (id != 1 || (name = fileIDRecord.getFilename()).indexOf("EVFTEMPF01") != -1 || name.indexOf("EVFTEMPF02") != -1) continue;
            fileNames.add(name);
        }
        return fileNames;
    }

    private String getGeneratedLabel(String file, File baseDir) {
        int openBracketIndex;
        String srcFile = "";
        String member = "";
        int slashIndex = file.indexOf("/");
        if (slashIndex > 0 && (openBracketIndex = file.indexOf("(")) > 0) {
            srcFile = file.substring(slashIndex + 1, openBracketIndex);
            member = file.substring(openBracketIndex + 1, file.length() - 1);
        }
        String iProjectName = baseDir.getParentFile().getName();
        return String.valueOf(iProjectName) + " - " + srcFile + "(" + member + ")";
    }

    private void publishBuildResultContributions(IBuildResult buildResult, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IBuildResultContribution contribution : this.contributions) {
            ICompileContribution compileContribution = (ICompileContribution)contribution.getExtendedContribution();
            for (Object object : compileContribution.getCompilePackages()) {
                ICompilePackage compilePackage = (ICompilePackage)object;
                compileContribution.setClassCount(compileContribution.getClassCount() + compilePackage.getClassCount());
                compileContribution.setErrorCount(compileContribution.getErrorCount() + compilePackage.getErrorCount());
                compileContribution.setWarningCount(compileContribution.getWarningCount() + compilePackage.getWarningCount());
                this.saveCompilePackage(compilePackage, teamRepository, monitor);
            }
            if (compileContribution.getErrorCount() > 0) {
                contribution.setStatus(BuildStatus.ERROR);
            }
            ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compileContribution, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContributions((IBuildResultHandle)buildResult, this.contributions.toArray(new IBuildResultContribution[this.contributions.size()]), monitor);
    }

    protected String getBuildResultUUID(BuildEvent event) {
        if (this.buildResultUUID == null) {
            this.buildResultUUID = event.getProject().getProperty("buildResultUUID");
        }
        return this.buildResultUUID;
    }

    public String getRepositoryAddress(BuildEvent event) throws FileNotFoundException, IOException {
        if (this.repositoryAddress == null) {
            this.repositoryAddress = event.getProject().getProperty("repositoryAddress");
        }
        return this.repositoryAddress;
    }

    public String getUserId(BuildEvent event) throws FileNotFoundException, IOException {
        if (this.userId == null) {
            this.userId = event.getProject().getProperty("userId");
        }
        return this.userId;
    }

    public String getPasswordFile(BuildEvent event) throws FileNotFoundException, IOException {
        if (this.passwordFile == null) {
            this.passwordFile = event.getProject().getProperty("passwordFile");
        }
        return this.passwordFile;
    }

    protected String getProvidedPassword(BuildEvent event) throws TeamRepositoryException, FileNotFoundException, IOException {
        File passwordFile = new File(this.getPasswordFile(event));
        try {
            return this.decryptPassword(passwordFile);
        }
        catch (Exception exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    protected String decryptPassword(File passwordFile) throws Exception {
        return IBMIPasswordHelper.getPassword((File)passwordFile);
    }

    protected IBuildResult getBuildResult(BuildEvent event) throws BuildException {
        try {
            if (this.fBuildResult == null) {
                IBuildResultHandle resultHandle = this.getBuildResultHandle(event);
                this.fBuildResult = (IBuildResult)this.getTeamRepository(event).itemManager().fetchCompleteItem((IItemHandle)resultHandle, 1, this.getProgressMonitor());
            }
            return this.fBuildResult;
        }
        catch (ItemNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected IBuildResultHandle getBuildResultHandle(BuildEvent event) throws TeamRepositoryException {
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID(event)), null);
    }

    protected IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected ITeamRepository getTeamRepository(BuildEvent event) throws TeamRepositoryException, FileNotFoundException, IOException {
        if (this.fTeamRepository == null) {
            Project p = event.getProject();
            this.fTeamRepository = AuthenticationUtilities.getLoggedInTeamRepository((Project)p, (String)this.getRepositoryAddress(event), (String)this.getUserId(event), (File)new File(this.getPasswordFile(event)));
        }
        return this.fTeamRepository;
    }

    public ICompileSource createSourceFile(String filename, String path, int errors, int warnings) {
        ICompileSource compileSource = BuildItemFactory.createCompileSource();
        compileSource.setSourceName(filename);
        compileSource.setSourcePath(path);
        compileSource.setWarningCount(warnings);
        compileSource.setErrorCount(errors);
        return compileSource;
    }

    public void addErrorToSource(ICompileSource sourceFile, int lineNumber, String msg) {
        ICompileProblem errorObject = BuildItemFactory.createCompileProblem();
        errorObject.setLineNumber(lineNumber);
        errorObject.setMessageText(msg);
        List compileProblems = sourceFile.getErrors();
        compileProblems.add(errorObject);
    }

    public void addWarningToSource(ICompileSource sourceFile, int lineNumber, String msg) {
        ICompileProblem warningObject = BuildItemFactory.createCompileProblem();
        warningObject.setLineNumber(lineNumber);
        warningObject.setMessageText(msg);
        List compileProblems = sourceFile.getWarnings();
        compileProblems.add(warningObject);
    }

    public ICompileContribution createProject(String compileContributionLabel, IBuildResultHandle buildResult) {
        ICompileContribution compileContribution = BuildItemFactory.createCompileContribution();
        compileContribution.setBuildResult(buildResult);
        List compilePackageList = compileContribution.getCompilePackages();
        ICompilePackage compilePackage = BuildItemFactory.createCompilePackage();
        compilePackage.setPackageName(compileContributionLabel);
        compilePackage.setPackageType("project");
        compilePackage.setBuildResult(buildResult);
        compilePackageList.add(compilePackage);
        IBuildResultContribution buildResultContribution = BuildItemFactory.createBuildResultContribution();
        buildResultContribution.setLabel(compileContributionLabel);
        buildResultContribution.setImpactsPrimaryResult(true);
        buildResultContribution.setExtendedContribution((IItemHandle)compileContribution);
        buildResultContribution.setExtendedContributionTypeId(ICompileContribution.EXTENDED_CONTRIBUTION_TYPE_ID);
        this.contributions.add(buildResultContribution);
        return compileContribution;
    }

    public ICompilePackage addCompilePackage(ICompilePackage compilePackage, String compilePackageLabel, IBuildResultHandle buildResult) {
        List subPackages = compilePackage.getSubCompilePackages();
        ICompilePackage subCompilePackage = BuildItemFactory.createCompilePackage();
        subCompilePackage.setPackageName(compilePackageLabel);
        subCompilePackage.setPackageType("folder");
        subCompilePackage.setBuildResult(buildResult);
        subPackages.add(subCompilePackage);
        return subCompilePackage;
    }

    public void updateCompilePackageCounts(ICompilePackage compilePackage, int errors, int warnings) {
        compilePackage.setErrorCount(compilePackage.getErrorCount() + errors);
        compilePackage.setWarningCount(compilePackage.getWarningCount() + warnings);
        compilePackage.setClassCount(compilePackage.getClassCount() + 1);
    }

    private void saveCompilePackage(ICompilePackage compilePackage, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        for (Object object : compilePackage.getSubCompilePackages()) {
            this.saveCompilePackage((ICompilePackage)object, teamRepository, monitor);
        }
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(compilePackage, monitor);
    }

    public void setIsPersonalBuildProperty(String isPersonalBuildProperty) {
        this.isBuildSpecificationBuild = false;
        this.isPersonalBuildProperty = isPersonalBuildProperty;
    }

    public void setIsGenerateProperty(String isGenerateProperty) {
        this.isGenerateProperty = isGenerateProperty;
    }

    public void setIsFailOnErrorProperty(String isFailOnErrorProperty) {
        this.isFailOnErrorProperty = isFailOnErrorProperty;
    }

    public void setFailOnErrorLevelProperty(String failOnErrorLevelProperty) {
        this.failOnErrorLevelProperty = failOnErrorLevelProperty;
    }

    public class CompilationProblem {
        int lineNum;
        String sev;
        String msgId;
        String msg;

        public CompilationProblem(int lineNum, String sev, String msgId, String msg) {
            this.lineNum = lineNum;
            this.msgId = msgId;
            this.msg = msg;
            this.sev = sev;
        }

        public int getLineNumber() {
            return this.lineNum;
        }

        public String getProblemMessage() {
            return String.valueOf(this.msgId) + " - " + this.sev + " - " + this.msg;
        }
    }

    public class FileInfoRecord {
        int errorCount = 0;
        int warningCount = 0;
        List warnings = new ArrayList();
        List errors = new ArrayList();

        public void incrementErrorCount() {
            ++this.errorCount;
        }

        public void incrementWarningCount() {
            ++this.warningCount;
        }

        public void addWarning(Integer lineNum, String sev, String msgId, String msg) {
            this.addRecord(this.warnings, lineNum, sev, msgId, msg);
        }

        public void addError(Integer lineNum, String sev, String msgId, String msg) {
            this.addRecord(this.errors, lineNum, sev, msgId, msg);
        }

        private void addRecord(List list, int lineNum, String sev, String msgId, String msg) {
            list.add(new CompilationProblem(lineNum, sev, msgId, msg));
        }

        public List getWarnings() {
            return this.warnings;
        }

        public List getErrors() {
            return this.errors;
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }
}

