/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class IBMiAntBuildResult {
    public static String copyright = "(c) Copyright IBM Corp 2009.";
    private final Hashtable<String, Object> buildResultTable = new Hashtable();

    public void addResultEntry(String projectName, String buildSpecTargetName, String outputObjectLib, String outputObjectName, String outputObjectType, String outputObjectAttribute, Collection inputs, String decision) {
        BuildSpecTargetBuildResult targetResultObject = this.getTargetBuildResult(projectName, buildSpecTargetName);
        OutputEntry newEntry = new OutputEntry(outputObjectLib, outputObjectName, outputObjectType, outputObjectAttribute, inputs, decision);
        targetResultObject.addResult(newEntry);
    }

    public void updateResultEntry(String projectName, String buildSpecTargetName, String outputObjectLib, String outputObjectName, String outputObjectType, String outputObjectAttribute, String buildStatus) {
        BuildSpecTargetBuildResult targetResultObject = this.getTargetBuildResult(projectName, buildSpecTargetName);
        OutputEntry outputEntry = this.findOutputEntry(targetResultObject, outputObjectLib, outputObjectName, outputObjectType, outputObjectAttribute);
        if (outputEntry != null) {
            outputEntry.setPostBuildExistStatus(buildStatus);
        }
    }

    protected OutputEntry findOutputEntry(BuildSpecTargetBuildResult targetResultObject, String outputObjectLib, String outputObjectName, String outputObjectType, String outputObjectAttribute) {
        if (targetResultObject == null) {
            return null;
        }
        Collection<OutputEntry> entries = targetResultObject.getResults();
        for (OutputEntry entry : entries) {
            if (!entry.getOutputObjectName().equalsIgnoreCase(outputObjectName) || !entry.getOutputObjectLib().equalsIgnoreCase(outputObjectLib) || !entry.getOutputObjectType().equalsIgnoreCase(outputObjectType)) continue;
            return entry;
        }
        return null;
    }

    protected BuildSpecTargetBuildResult getTargetBuildResult(String projectName, String buildSpecTargetName) {
        Object targetResultObject;
        Hashtable projectResultTable = this.buildResultTable.get(projectName);
        if (projectResultTable == null) {
            projectResultTable = new Hashtable();
            this.buildResultTable.put(projectName, projectResultTable);
        }
        if ((targetResultObject = ((Hashtable)projectResultTable).get(buildSpecTargetName)) == null) {
            targetResultObject = new BuildSpecTargetBuildResult(buildSpecTargetName);
            projectResultTable.put(buildSpecTargetName, targetResultObject);
        }
        if (!(targetResultObject instanceof BuildSpecTargetBuildResult)) {
            return null;
        }
        return (BuildSpecTargetBuildResult)targetResultObject;
    }

    public Hashtable getBuildResults() {
        return this.buildResultTable;
    }

    public Collection<OutputEntry> getAllOutputs() {
        HashSet<OutputEntry> outputs = new HashSet<OutputEntry>();
        Enumeration<String> projects = this.buildResultTable.keys();
        while (projects.hasMoreElements()) {
            String projectName = projects.nextElement();
            Hashtable targetResultsTable = (Hashtable)this.buildResultTable.get(projectName);
            Enumeration targets = targetResultsTable.keys();
            while (targets.hasMoreElements()) {
                String targetId = (String)targets.nextElement();
                BuildSpecTargetBuildResult targetResult = (BuildSpecTargetBuildResult)targetResultsTable.get(targetId);
                for (OutputEntry outputEntry : targetResult.getResults()) {
                    try {
                        outputs.add(outputEntry);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return outputs;
    }

    public class BuildSpecTargetBuildResult {
        private Collection<OutputEntry> outputEntries;
        private final String buildSpecTargetName;

        public BuildSpecTargetBuildResult(String buildSpecTargetName) {
            this.buildSpecTargetName = buildSpecTargetName;
        }

        public Collection<OutputEntry> getResults() {
            if (this.outputEntries == null) {
                this.outputEntries = new ArrayList<OutputEntry>();
            }
            return this.outputEntries;
        }

        public void addResult(OutputEntry newEntry) {
            this.getResults().add(newEntry);
        }
    }

    public class OutputEntry {
        private final String outputObjectLib;
        private final String outputObjectName;
        private final String outputObjectType;
        private final String outputObjectAttribute;
        private Collection inputs;
        private boolean deployable;
        private String buildDecision;
        private String postBuildExistStatus;

        public OutputEntry(String outputObjectLib, String outputObjectName, String outputObjectType, String outputObjectAttribute, Collection inputs, String buildDecision) {
            this(outputObjectLib, outputObjectName, outputObjectType, outputObjectAttribute, inputs, buildDecision, "UNDETERMINED", true);
        }

        public OutputEntry(String outputObjectLib, String outputObjectName, String outputObjectType, String outputObjectAttribute, Collection inputs, String buildDecision, String postBuildExistStatus, boolean deployable) {
            this.outputObjectLib = outputObjectLib;
            this.outputObjectName = outputObjectName;
            this.outputObjectType = outputObjectType;
            this.outputObjectAttribute = outputObjectAttribute;
            this.inputs = inputs == null ? new ArrayList() : inputs;
            this.deployable = deployable;
            this.buildDecision = buildDecision;
            this.postBuildExistStatus = postBuildExistStatus;
        }

        public String getOutputObjectLib() {
            return this.outputObjectLib;
        }

        public String getOutputObjectName() {
            return this.outputObjectName;
        }

        public String getOutputObjectType() {
            return this.outputObjectType;
        }

        public String getOutputObjectAttribute() {
            return this.outputObjectAttribute;
        }

        public Collection getInputs() {
            return this.inputs;
        }

        public boolean isDeployable() {
            return this.deployable;
        }

        public String getBuildDecision() {
            return this.buildDecision;
        }

        public String getPostBuildExistStatus() {
            return this.postBuildExistStatus;
        }

        public void setBuildDecision(String buildDecision) {
            this.buildDecision = buildDecision;
        }

        public void setPostBuildExistStatus(String postBuildExistStatus) {
            this.postBuildExistStatus = postBuildExistStatus;
        }

        public void setDeployable(boolean deployable) {
            this.deployable = deployable;
        }
    }
}

