/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.listener;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberBrief;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberNameOnly;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.teami.build.toolkit.listener.IBMiAntBuildResult;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IBMiAntBuildReportGenerator {
    public static String copyright = "(c) Copyright IBM Corp 2009, 2010.";
    public static String TAGNAME_BUILDRECORDS = "buildrecords";
    public static String TAGNAME_PROJECT = "project";
    public static String TAGNAME_TARGET = "builder";
    public static String TAGNAME_OUTPUTS = "outputs";
    public static String TAGNAME_OUTPUT_ENTRY = "output";
    public static String TAGNAME_INPUT = "input";
    public static String ATTRIBUTE_PROJECT_NAME = "name";
    public static String ATTRIBUTE_TARGET_ID = "id";
    public static String ATTRIBUTE_LIB = "library";
    public static String ATTRIBUTE_NAME = "name";
    public static String ATTRIBUTE_TYPE = "type";
    public static String ATTRIBUTE_OBJECT_SUBTYPE = "attribute";
    public static String ATTRIBUTE_OBJECT_DEPLOYABLE = "deployable";
    public static String ATTRIBUTE_OBJECT_STATUS = "status";
    public static String ATTRIBUTE_MEMBER_FILE = "file";
    private final IBMiAntBuildResult buildResult;

    public IBMiAntBuildReportGenerator(IBMiAntBuildResult buildResult) {
        this.buildResult = buildResult;
    }

    public void generate(IFSFile outputFile) throws Exception {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docBuildFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return;
        }
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement(TAGNAME_BUILDRECORDS);
        doc.appendChild(root);
        Hashtable resultsTable = this.buildResult.getBuildResults();
        Enumeration projects = resultsTable.keys();
        while (projects.hasMoreElements()) {
            String projectName = (String)projects.nextElement();
            Element projectElement = doc.createElement(TAGNAME_PROJECT);
            projectElement.setAttribute(ATTRIBUTE_PROJECT_NAME, projectName);
            root.appendChild(projectElement);
            Hashtable targetResultsTable = (Hashtable)resultsTable.get(projectName);
            Enumeration targets = targetResultsTable.keys();
            while (targets.hasMoreElements()) {
                String targetId = (String)targets.nextElement();
                IBMiAntBuildResult.BuildSpecTargetBuildResult targetResult = (IBMiAntBuildResult.BuildSpecTargetBuildResult)targetResultsTable.get(targetId);
                Element targetElement = doc.createElement(TAGNAME_TARGET);
                projectElement.appendChild(targetElement);
                targetElement.setAttribute(ATTRIBUTE_TARGET_ID, targetId);
                Element outputsElement = doc.createElement(TAGNAME_OUTPUTS);
                targetElement.appendChild(outputsElement);
                for (IBMiAntBuildResult.OutputEntry outputEntry : targetResult.getResults()) {
                    Element outputEntryElement = doc.createElement(TAGNAME_OUTPUT_ENTRY);
                    outputsElement.appendChild(outputEntryElement);
                    outputEntryElement.setAttribute(ATTRIBUTE_LIB, outputEntry.getOutputObjectLib());
                    outputEntryElement.setAttribute(ATTRIBUTE_NAME, outputEntry.getOutputObjectName());
                    outputEntryElement.setAttribute(ATTRIBUTE_TYPE, outputEntry.getOutputObjectType());
                    outputEntryElement.setAttribute(ATTRIBUTE_OBJECT_SUBTYPE, outputEntry.getOutputObjectAttribute());
                    outputEntryElement.setAttribute(ATTRIBUTE_OBJECT_STATUS, outputEntry.getPostBuildExistStatus());
                    for (Object inputEntry : outputEntry.getInputs()) {
                        Element inputElement = doc.createElement(TAGNAME_INPUT);
                        if (inputEntry instanceof IISeriesHostMemberNameOnly) {
                            outputEntryElement.appendChild(inputElement);
                            inputElement.setAttribute(ATTRIBUTE_LIB, ((IISeriesHostMemberNameOnly)inputEntry).getLibrary());
                            inputElement.setAttribute(ATTRIBUTE_MEMBER_FILE, ((IISeriesHostMemberNameOnly)inputEntry).getFile());
                            inputElement.setAttribute(ATTRIBUTE_NAME, ((IISeriesHostMemberNameOnly)inputEntry).getName());
                            if (!(inputEntry instanceof IISeriesHostMemberBrief)) continue;
                            inputElement.setAttribute(ATTRIBUTE_TYPE, ((IISeriesHostMemberBrief)inputEntry).getType());
                            continue;
                        }
                        if (!(inputEntry instanceof IISeriesHostObjectBrief)) continue;
                        outputEntryElement.appendChild(inputElement);
                        inputElement.setAttribute(ATTRIBUTE_LIB, ((IISeriesHostObjectBrief)inputEntry).getLibrary());
                        inputElement.setAttribute(ATTRIBUTE_NAME, ((IISeriesHostObjectBrief)inputEntry).getName());
                        inputElement.setAttribute(ATTRIBUTE_TYPE, ((IISeriesHostObjectBrief)inputEntry).getType());
                        inputElement.setAttribute(ATTRIBUTE_OBJECT_SUBTYPE, ((IISeriesHostObjectBrief)inputEntry).getSubType());
                    }
                }
            }
        }
        this.writeToFile(doc, outputFile);
    }

    protected void writeToFile(Document doc, IFSFile outputFile) throws Exception {
        doc.normalize();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult((OutputStream)new IFSFileOutputStream(outputFile));
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("encoding", "UTF-8");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        xformer.transform(source, result);
    }
}

