/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.listener;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.iant.IBMIBuildEvent;
import com.ibm.iant.IBMiBuildOutputBuildStatusEvent;
import com.ibm.iant.IBMiBuildOutputResolveEvent;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.publishing.LogPublisher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teami.build.toolkit.listener.IBMiAntBuildReportGenerator;
import com.ibm.teami.build.toolkit.listener.IBMiAntBuildResult;
import com.ibm.teami.build.toolkit.listener.IBMiEventFileListener;
import com.ibm.teami.build.toolkit.listener.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildEvent;

public class IBMiAntBuildListener
extends IBMiEventFileListener {
    public static String copyright = "(c) Copyright IBM Corp 2009.";
    public static final String BUILD_RECORD_FILE_NAME = "bldrec-";
    public static final String BUILD_RECORD_FILE_EXTENSION = ".xml";
    public static final String PROJECT_PROPERTY_NAME = "projectName";
    private IBMiAntBuildResult buildSpecBuildResult = null;
    private AS400 system = null;
    private BuildStatus overallStatus = BuildStatus.OK;

    public void beforeCommandRun(IBMIBuildEvent event) {
        if (this.system == null) {
            this.system = event.getSystem();
        }
        if (event instanceof IBMiBuildOutputResolveEvent) {
            this.processOutputResoveEvent((IBMiBuildOutputResolveEvent)event);
        } else {
            super.beforeCommandRun(event);
        }
        try {
            this.getRepositoryAddress((BuildEvent)event);
            this.getUserId((BuildEvent)event);
            this.getPasswordFile((BuildEvent)event);
            this.getBuildResultUUID((BuildEvent)event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void afterCommandRun(IBMIBuildEvent event) {
        if (this.system == null) {
            this.system = event.getSystem();
        }
        if (event instanceof IBMiBuildOutputBuildStatusEvent) {
            this.processOutputStatusEvent((IBMiBuildOutputBuildStatusEvent)event);
        } else {
            super.afterCommandRun(event);
        }
    }

    public void processOutputResoveEvent(IBMiBuildOutputResolveEvent event) {
        String projectName;
        if (this.system == null) {
            this.system = event.getSystem();
        }
        if ((projectName = event.getProject().getProperty(PROJECT_PROPERTY_NAME)) == null || projectName.trim().length() == 0) {
            projectName = event.getProject().getName();
        }
        this.getBuildResultData().addResultEntry(projectName, event.getBuildSpecTargetName(), event.getOutputObjectLib(), event.getOutputObjectName(), event.getOutputObjectType(), event.getOutputObjectAttribute(), event.getInputs(), event.getBuildDecision());
    }

    public void processOutputStatusEvent(IBMiBuildOutputBuildStatusEvent event) {
        String projectName;
        if (this.system == null) {
            this.system = event.getSystem();
        }
        if ((projectName = event.getProject().getProperty(PROJECT_PROPERTY_NAME)) == null || projectName.trim().length() == 0) {
            projectName = event.getProject().getName();
        }
        this.getBuildResultData().updateResultEntry(projectName, event.getBuildSpecTargetName(), event.getOutputObjectLib(), event.getOutputObjectName(), event.getOutputObjectType(), event.getOutputObjectAttribute(), event.getBuildStatus());
        if ("BUILD_FAILED".equals(event.getBuildStatus())) {
            this.overallStatus = BuildStatus.ERROR;
        }
    }

    public IBMiAntBuildResult getBuildResultData() {
        if (this.buildSpecBuildResult == null) {
            this.buildSpecBuildResult = new IBMiAntBuildResult();
        }
        return this.buildSpecBuildResult;
    }

    @Override
    public void buildFinished(BuildEvent event) {
        block11: {
            try {
                super.buildFinished(event);
                if (this.system == null) {
                    return;
                }
                String devBuild = event.getProject().getProperty("com.ibm.iant.devBuild");
                ITeamRepository teamRepository = null;
                IBuildResult antBuildResult = null;
                if (devBuild == null) {
                    try {
                        teamRepository = this.getTeamRepository(event);
                        antBuildResult = this.getBuildResult(event);
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                String buildRecordFileFolderPath = "";
                StringBuffer buildRecordFilePathBuffer = new StringBuffer();
                if (devBuild == null) {
                    File baseDir = event.getProject().getBaseDir();
                    buildRecordFileFolderPath = baseDir != null ? baseDir.getAbsolutePath() : this.computeBuildRecordFilePath(antBuildResult, event);
                    if (buildRecordFileFolderPath == null || buildRecordFileFolderPath.trim().length() == 0) {
                        buildRecordFileFolderPath = new StringBuffer("/home/").append(this.getUserId(event)).toString();
                    }
                    buildRecordFilePathBuffer = new StringBuffer(buildRecordFileFolderPath).append("/").append(BUILD_RECORD_FILE_NAME).append(antBuildResult.getLabel()).append(BUILD_RECORD_FILE_EXTENSION);
                } else {
                    buildRecordFilePathBuffer.append(event.getProject().getProperty("com.ibm.iant.buildRecFile"));
                }
                IFSFile buildRecordFile = new IFSFile(this.system, buildRecordFilePathBuffer.toString());
                if (!buildRecordFile.createNewFile()) {
                    throw new IOException();
                }
                buildRecordFile.setCCSID(1208);
                this.generateBuildRecords(this.getBuildResultData(), buildRecordFile);
                if (devBuild == null) {
                    this.publishBuildRecord(buildRecordFile.getAbsolutePath(), antBuildResult, teamRepository, this.overallStatus);
                }
            }
            catch (Exception e) {
                event.getProject().log(Messages.FAILED_PUBLISHING_RESULTS, (Throwable)e, 0);
                if (e.getMessage() == null) break block11;
                event.getProject().log(e.getMessage());
            }
        }
    }

    public void generateBuildRecords(IBMiAntBuildResult buildResult, IFSFile buildRecordFile) throws Exception {
        IBMiAntBuildReportGenerator generator = new IBMiAntBuildReportGenerator(buildResult);
        generator.generate(buildRecordFile);
    }

    protected void publishBuildRecord(String buildRecordFilePath, IBuildResult buildResult, ITeamRepository teamRepository, BuildStatus status) throws TeamRepositoryException {
        LogPublisher publisher = new LogPublisher(buildRecordFilePath, Messages.BUILD_RECORD_FILE_LABEL, "text/plain", "UTF-8");
        publisher.publish((IBuildResultHandle)buildResult, status, teamRepository);
    }

    protected String computeBuildRecordFilePath(IBuildResult buildResult, BuildEvent event) {
        IBuildRequest buildRequest;
        block6: {
            buildRequest = null;
            List buildRequests = buildResult.getBuildRequests();
            try {
                if (buildRequests.size() <= 0 || buildResult.getState() != BuildState.IN_PROGRESS) break block6;
                List<String> requestProperties = Arrays.asList(IBuildRequest.PROPERTY_BUILD_ACTION, IBuildRequest.PROPERTY_HANDLER);
                for (IBuildRequestHandle buildRequestHandle : buildRequests) {
                    buildRequest = (IBuildRequest)this.getTeamRepository(event).itemManager().fetchPartialItem((IItemHandle)buildRequestHandle, 1, requestProperties, this.getProgressMonitor());
                    if (buildRequest == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (TeamRepositoryException ex) {
                return null;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        return element.getConfigurationProperty("com.ibm.team.build.ant.workingDir").getValue();
    }
}

