/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.sysapi;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.model.BndsrcObj;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractApi;

public class GetSrvpgmBndsrcApi
extends AbstractApi {
    private QBNRSPGM_Info fApiInfo;

    public GetSrvpgmBndsrcApi(AS400 system, String libName, String pgmName) {
        this.setSystem(system);
        this.setApi("/QSYS.LIB/QBNRSPGM.PGM");
        this.setupParms(libName, pgmName);
        int rc = this.run();
        if (rc == 0) {
            this.fetchReturnValuesFromStruct();
        }
    }

    private void setupParms(String libName, String pgmName) {
        this.fBuffer = new byte[433];
        byte[] errorcode = new byte[80];
        byte[] qualifiedObject = new byte[20];
        this.convertQualifiedObject(qualifiedObject, libName, pgmName);
        this.initErrorCode();
        this.fParmList = new ProgramParameter[5];
        this.fParmList[0] = new ProgramParameter(2, 433);
        this.fParmList[1] = new ProgramParameter(1, this.fBin4.toBytes(433));
        this.fParmList[2] = new ProgramParameter(2, this.convertString("SPGI0100", false));
        this.fParmList[3] = new ProgramParameter(2, qualifiedObject);
        this.fParmList[4] = new ProgramParameter(2, errorcode, 80);
    }

    protected void fetchReturnValuesFromStruct() {
        byte[] bndsrcfBytes = new byte[10];
        byte[] bndsrcfLibBytes = new byte[10];
        byte[] bndsrcfMbrBytes = new byte[10];
        byte[] srvpgmSignatureBytes = new byte[16];
        byte[] returnData = this.fParmList[0].getOutputData();
        System.arraycopy(returnData, 61, bndsrcfBytes, 0, 10);
        System.arraycopy(returnData, 71, bndsrcfLibBytes, 0, 10);
        System.arraycopy(returnData, 81, bndsrcfMbrBytes, 0, 10);
        System.arraycopy(returnData, 121, srvpgmSignatureBytes, 0, 16);
        String bndsrcfName = this.convertBytesToString(bndsrcfBytes);
        String bndsrcfLibName = this.convertBytesToString(bndsrcfLibBytes);
        String bndsrcfMbrName = this.convertBytesToString(bndsrcfMbrBytes);
        this.fApiInfo = bndsrcfName.equals("          ") ? new QBNRSPGM_Info() : new QBNRSPGM_Info(new BndsrcObj(bndsrcfLibName, bndsrcfName, bndsrcfMbrName));
        this.fApiInfo.setSignature(srvpgmSignatureBytes);
        this.setHasData(true);
    }

    public QBNRSPGM_Info retrieveApiOutput() {
        if (this.hasData()) {
            return this.fApiInfo;
        }
        return null;
    }

    public class QBNRSPGM_Info {
        private boolean fExportAll = true;
        private BndsrcObj fBndsrc;
        private byte[] fSignature;

        public boolean hasBndsrc() {
            return !this.fExportAll;
        }

        public void setHasBndsrc(boolean hasBndsrc) {
            this.fExportAll = hasBndsrc;
        }

        public BndsrcObj getBndsrc() {
            return this.fBndsrc;
        }

        public void setBndsrc(BndsrcObj bndsrc) {
            this.fBndsrc = bndsrc;
        }

        public void setSignature(byte[] signature) {
            this.fSignature = signature;
        }

        public byte[] getSignature() {
            return this.fSignature;
        }

        public void debugPrint() {
            Log log = LogFactory.getLog();
            log.println(" **ILE Srvpgm Data**");
            if (this.fExportAll) {
                log.println("   EXPORT(*ALL) used - no binding source");
            } else {
                log.println("   Binding Source: " + this.fBndsrc.getLibName() + "/" + this.fBndsrc.getObjName() + "(" + this.fBndsrc.getMember() + ")");
            }
            log.println("  SRVPGM Signature:" + this.fSignature);
        }

        QBNRSPGM_Info(BndsrcObj bndsrc) {
            this.fBndsrc = bndsrc;
            this.fExportAll = false;
        }

        QBNRSPGM_Info() {
            this.fExportAll = true;
        }
    }
}

