/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.sysapi;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractApi;

public class GetPgmEntryModApi
extends AbstractApi {
    private QCLRPGMI_Info fApiInfo;

    public GetPgmEntryModApi(AS400 system, String libName, String pgmName) {
        this.setSystem(system);
        this.setApi("/QSYS.LIB/QCLRPGMI.PGM");
        this.setupParms(libName, pgmName);
        int rc = this.run();
        if (rc == 0) {
            this.fetchReturnValuesFromStruct();
        }
    }

    private void setupParms(String libName, String pgmName) {
        this.fBuffer = new byte[536];
        byte[] errorcode = new byte[80];
        byte[] qualifiedObject = new byte[20];
        this.convertQualifiedObject(qualifiedObject, libName, pgmName);
        this.initErrorCode();
        this.fParmList = new ProgramParameter[5];
        this.fParmList[0] = new ProgramParameter(2, 536);
        this.fParmList[1] = new ProgramParameter(1, this.fBin4.toBytes(536));
        this.fParmList[2] = new ProgramParameter(2, this.convertString("PGMI0100", false));
        this.fParmList[3] = new ProgramParameter(2, qualifiedObject);
        this.fParmList[4] = new ProgramParameter(2, errorcode, 80);
    }

    protected void fetchReturnValuesFromStruct() {
        byte[] entryModuleBytes = new byte[10];
        byte[] entryModuleLibBytes = new byte[10];
        byte[] returnData = this.fParmList[0].getOutputData();
        System.arraycopy(returnData, 358, entryModuleLibBytes, 0, 10);
        System.arraycopy(returnData, 348, entryModuleBytes, 0, 10);
        boolean isIlePgm = false;
        String entryModule = this.convertBytesToString(entryModuleBytes);
        String entryModuleLib = this.convertBytesToString(entryModuleLibBytes);
        isIlePgm = !entryModule.equals("          ");
        this.fApiInfo = new QCLRPGMI_Info(isIlePgm, entryModuleLib, entryModule);
        this.setHasData(true);
    }

    public QCLRPGMI_Info retrieveApiOutput() {
        if (this.hasData()) {
            return this.fApiInfo;
        }
        return null;
    }

    public class QCLRPGMI_Info {
        private boolean fIsIlePgm;
        private String fEntryModuleLib;
        private String fEntryModule;

        public boolean isIlePgm() {
            return this.fIsIlePgm;
        }

        public void set_isIle(boolean _isIle) {
            this.fIsIlePgm = _isIle;
        }

        public String getEntModLib() {
            return this.fEntryModuleLib;
        }

        public void setEntModLib(String _entModLib) {
            this.fEntryModuleLib = _entModLib;
        }

        public String getEntMod() {
            return this.fEntryModule;
        }

        public void setEntMod(String _entMod) {
            this.fEntryModule = _entMod;
        }

        public void debugPrint() {
            Log log = LogFactory.getLog();
            if (this.fIsIlePgm) {
                log.println("ILE Pgm: true");
                log.println("Entry Module: " + this.fEntryModuleLib + "/" + this.fEntryModule);
            } else {
                log.println("ILE Pgm: false");
            }
        }

        QCLRPGMI_Info(boolean isIle, String entModLib, String entMod) {
            this.fIsIlePgm = isIle;
            this.fEntryModuleLib = entModLib;
            this.fEntryModule = entMod;
        }
    }
}

