/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.sysapi;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractApi;

public class GetFileDescriptionApi
extends AbstractApi {
    private QDBRTVFD_Info fApiInfo;

    public GetFileDescriptionApi(AS400 system, String libName, String fileName) {
        this.setSystem(system);
        this.setApi("/QSYS.LIB/QDBRTVFD.PGM");
        this.setupParms0100(libName, fileName);
        int rc = this.run();
        if (rc == 0) {
            this.fetch0100ReturnValuesFromStruct();
        }
        this.setupParms0200(libName, fileName);
        rc = this.run();
        if (rc == 0) {
            this.fetch0200ReturnValuesFromStruct();
        }
    }

    private void setupParms0100(String libName, String fileName) {
        this.fBuffer = new byte[400];
        byte[] errorcode = new byte[80];
        byte[] qualifiedObject = new byte[20];
        this.convertQualifiedObject(qualifiedObject, libName, fileName);
        this.initErrorCode();
        this.fParmList = new ProgramParameter[10];
        this.fParmList[0] = new ProgramParameter(2, 400);
        this.fParmList[1] = new ProgramParameter(1, this.fBin4.toBytes(400));
        this.fParmList[2] = new ProgramParameter(2, 20);
        this.fParmList[3] = new ProgramParameter(2, this.convertString("FILD0100", false));
        this.fParmList[4] = new ProgramParameter(2, qualifiedObject);
        this.fParmList[5] = new ProgramParameter(2, this.convertString("*FIRST    ", false));
        this.fParmList[6] = new ProgramParameter(2, this.convertString("0", false));
        this.fParmList[7] = new ProgramParameter(2, this.convertString("*FILETYPE ", false));
        this.fParmList[8] = new ProgramParameter(2, this.convertString("*INT      ", false));
        this.fParmList[9] = new ProgramParameter(2, errorcode, 80);
    }

    private void setupParms0200(String libName, String fileName) {
        this.fBuffer = new byte[356];
        byte[] errorcode = new byte[80];
        this.initErrorCode();
        this.fParmList[0] = new ProgramParameter(2, 356);
        this.fParmList[1] = new ProgramParameter(1, this.fBin4.toBytes(356));
        this.fParmList[3] = new ProgramParameter(2, this.convertString("FILD0200", false));
        this.fParmList[9] = new ProgramParameter(2, errorcode, 80);
    }

    protected void fetch0200ReturnValuesFromStruct() {
        byte[] returnData = this.fParmList[0].getOutputData();
        byte[] recfmtBytes = new byte[10];
        byte[] reclenBytes = new byte[4];
        System.arraycopy(returnData, 70, recfmtBytes, 0, 10);
        System.arraycopy(returnData, 66, reclenBytes, 0, 4);
        int reclen = this.fBin4.toInt(reclenBytes);
        String recfmt = this.convertBytesToString(recfmtBytes);
        this.fApiInfo.setRecordLength(reclen);
        this.fApiInfo.setRecordFormat(recfmt);
        this.setHasData(true);
    }

    protected void fetch0100ReturnValuesFromStruct() {
        this.fApiInfo = new QDBRTVFD_Info();
        this.fApiInfo.setPhysicalFile(true);
        this.fApiInfo.setSourcePf(true);
    }

    public QDBRTVFD_Info retrieveApiOutput() {
        if (this.hasData()) {
            return this.fApiInfo;
        }
        return null;
    }

    public class QDBRTVFD_Info {
        private int fRecordLength = 0;
        private String fRecordFormat = null;
        private boolean fIsPhysicalFile = true;
        private boolean fIsSourcePF = true;

        public int getRecordLength() {
            return this.fRecordLength;
        }

        public String getRecordFormat() {
            return this.fRecordFormat;
        }

        public void setRecordLength(int reclen) {
            this.fRecordLength = reclen;
        }

        public void setRecordFormat(String recfmt) {
            this.fRecordFormat = recfmt;
        }

        public boolean isPhysicalFile() {
            return this.fIsPhysicalFile;
        }

        public boolean isSourcePf() {
            return this.fIsSourcePF;
        }

        public void setPhysicalFile(boolean isPf) {
            this.fIsPhysicalFile = isPf;
        }

        public void setSourcePf(boolean isSrcPf) {
            this.fIsSourcePF = isSrcPf;
        }

        public void debugPrint() {
            Log log = LogFactory.getLog();
            log.println("Record Format: " + this.fRecordFormat);
            log.println("Record Length: " + this.fRecordLength);
            log.println("Is this *FILE type PF? : " + this.fIsPhysicalFile);
            log.println("Is this *FILE type PF-SRC? : " + this.fIsSourcePF);
        }
    }
}

