/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.sysapi;

import com.ibm.as400.access.ProgramParameter;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.model.FileObj;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractUsrspcListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public abstract class GetDbRelationsApi
extends AbstractUsrspcListApi {
    protected DependentFileInfo fApiFileInfo;
    protected String fApiUsrspcName;
    protected String fApiFormat;

    @Override
    public void setUsrspcName(String usrspc) {
        this.fApiUsrspcName = usrspc;
    }

    @Override
    public void setApiFormat(String format) {
        this.fApiFormat = format;
    }

    protected void setupParms(String libName, String fileName, String mbrName, String recfmtName) {
        this.fBuffer = new byte[536];
        byte[] errorcode = new byte[80];
        byte[] qualifiedObject = new byte[20];
        this.convertQualifiedObject(qualifiedObject, libName, fileName);
        byte[] qualifiedUsrspc = new byte[20];
        this.convertQualifiedObject(qualifiedUsrspc, this.fApiUsrspcLibName, this.fApiUsrspcName);
        if (mbrName == null) {
            mbrName = "*ALL      ";
        }
        if (recfmtName == null) {
            recfmtName = "*ALL      ";
        }
        this.initErrorCode();
        this.fParmList = new ProgramParameter[6];
        this.fParmList[0] = new ProgramParameter(2, qualifiedUsrspc);
        this.fParmList[1] = new ProgramParameter(2, this.convertString(this.fApiFormat, false));
        this.fParmList[2] = new ProgramParameter(2, qualifiedObject);
        this.fParmList[3] = new ProgramParameter(2, this.convertString(mbrName, 10, false));
        this.fParmList[4] = new ProgramParameter(2, this.convertString(recfmtName, 10, false));
        this.fParmList[5] = new ProgramParameter(2, errorcode, 80);
    }

    protected void fetchReturnValuesFromUsrspc() throws Exception {
        int entrySize;
        int numEntries;
        int listOffset;
        byte[] intBuffer = new byte[4];
        byte[] nameBuffer = new byte[10];
        try {
            this.fApiReturnUsrspc.read(intBuffer, 124);
            listOffset = this.fBin4.toInt(intBuffer);
            this.fApiReturnUsrspc.read(intBuffer, 132);
            numEntries = this.fBin4.toInt(intBuffer);
            this.fApiReturnUsrspc.read(intBuffer, 136);
            entrySize = this.fBin4.toInt(intBuffer);
        }
        catch (Exception e) {
            LogFactory.getLog().println(Messages.GetDbRelationsApi_ErrorReadingQdbldbr1);
            throw e;
        }
        this.fApiFileInfo = new DependentFileInfo();
        int entryOffset = listOffset;
        String depobjName = null;
        String depobjLibName = null;
        int i = 0;
        while (i < numEntries) {
            try {
                this.fApiReturnUsrspc.read(nameBuffer, entryOffset + 20);
                depobjName = this.convertBytesToString(nameBuffer);
                this.fApiReturnUsrspc.read(nameBuffer, entryOffset + 30);
                depobjLibName = this.convertBytesToString(nameBuffer);
            }
            catch (Exception e) {
                LogFactory.getLog().println(NLS.bind((String)Messages.GetDbRelationsApi_ErrorReadingQdbldbr2, (Object)i));
                throw e;
            }
            FileObj depFile = new FileObj(depobjLibName, depobjName);
            this.fApiFileInfo.addFile(depFile);
            entryOffset += entrySize;
            ++i;
        }
        this.setHasData(true);
    }

    public DependentFileInfo retrieveDbrApiOutput() {
        if (this.hasData()) {
            return this.fApiFileInfo;
        }
        return null;
    }

    public class DependentFileInfo {
        private int fNumFiles = 0;
        private List<FileObj> fFiles = null;

        DependentFileInfo() {
        }

        public int count() {
            return this.fNumFiles;
        }

        public List<FileObj> getDepFiles() {
            return this.fFiles;
        }

        public void addFile(FileObj file) {
            if (this.fNumFiles == 0) {
                this.fFiles = new ArrayList<FileObj>();
            }
            this.fFiles.add(file);
            ++this.fNumFiles;
        }
    }
}

