/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.sysapi;

import com.ibm.as400.access.ProgramParameter;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.model.ModuleObj;
import com.ibm.teami.build.toolkit.genlink.model.SrvpgmObj;
import com.ibm.teami.build.toolkit.genlink.sysapi.AbstractUsrspcListApi;
import com.ibm.teami.build.toolkit.genlink.sysapi.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBindListApi
extends AbstractUsrspcListApi {
    protected BoundModuleInfo fApiModInfo;
    protected BoundSrvpgmInfo fApiSrvpgmInfo;
    protected String fApiUsrspcName;
    protected String fApiFormat;
    private boolean fGettingBndsrvpgms;

    @Override
    public void setUsrspcName(String usrspc) {
        this.fApiUsrspcName = usrspc;
    }

    @Override
    public void setApiFormat(String format) {
        this.fApiFormat = format;
        this.fGettingBndsrvpgms = this.fApiFormat == "PGML0200" || this.fApiFormat == "SPGL0200";
    }

    protected void setupParms(String libName, String pgmName) {
        this.fBuffer = new byte[536];
        byte[] errorcode = new byte[80];
        byte[] qualifiedObject = new byte[20];
        this.convertQualifiedObject(qualifiedObject, libName, pgmName);
        byte[] qualifiedUsrspc = new byte[20];
        this.convertQualifiedObject(qualifiedUsrspc, this.fApiUsrspcLibName, this.fApiUsrspcName);
        this.initErrorCode();
        this.fParmList = new ProgramParameter[4];
        this.fParmList[0] = new ProgramParameter(2, qualifiedUsrspc);
        this.fParmList[1] = new ProgramParameter(2, this.convertString(this.fApiFormat, false));
        this.fParmList[2] = new ProgramParameter(2, qualifiedObject);
        this.fParmList[3] = new ProgramParameter(2, errorcode, 80);
    }

    protected void fetchReturnValuesFromUsrspc() throws Exception {
        int entrySize;
        int numEntries;
        int listOffset;
        byte[] intBuffer = new byte[4];
        byte[] nameBuffer = new byte[10];
        byte[] signatureBuffer = new byte[16];
        try {
            this.fApiReturnUsrspc.read(intBuffer, 124);
            listOffset = this.fBin4.toInt(intBuffer);
            this.fApiReturnUsrspc.read(intBuffer, 132);
            numEntries = this.fBin4.toInt(intBuffer);
            this.fApiReturnUsrspc.read(intBuffer, 136);
            entrySize = this.fBin4.toInt(intBuffer);
        }
        catch (Exception e) {
            LogFactory.getLog().println(Messages.AbstractBindListApi_ErrorReadingQbnlpgmiUsrspc);
            throw e;
        }
        if (this.fGettingBndsrvpgms) {
            this.fApiSrvpgmInfo = new BoundSrvpgmInfo();
        } else {
            this.fApiModInfo = new BoundModuleInfo();
        }
        int entryOffset = listOffset;
        String bndobjName = null;
        String bndobjLibName = null;
        byte[] srvpgmSignature = null;
        int i = 0;
        while (i < numEntries) {
            try {
                this.fApiReturnUsrspc.read(nameBuffer, entryOffset + 20);
                bndobjName = this.convertBytesToString(nameBuffer);
                this.fApiReturnUsrspc.read(nameBuffer, entryOffset + 30);
                bndobjLibName = this.convertBytesToString(nameBuffer);
                if (bndobjLibName.isEmpty()) {
                    bndobjLibName = "*LIBL";
                }
                if (this.fGettingBndsrvpgms) {
                    this.fApiReturnUsrspc.read(signatureBuffer, entryOffset + 40);
                    srvpgmSignature = signatureBuffer;
                }
            }
            catch (Exception e) {
                LogFactory.getLog().println(NLS.bind((String)Messages.AbstractBindListApi_ErrorReadingPgml0100, (Object)i));
                throw e;
            }
            if (this.fGettingBndsrvpgms) {
                SrvpgmObj srvpgm = new SrvpgmObj(bndobjLibName, bndobjName);
                srvpgm.setSignature(srvpgmSignature);
                this.fApiSrvpgmInfo.addSrvpgm(srvpgm);
            } else {
                ModuleObj module = new ModuleObj(bndobjLibName, bndobjName);
                this.fApiModInfo.addModule(module);
            }
            entryOffset += entrySize;
            ++i;
        }
        this.setHasData(true);
        this.fApiReturnUsrspc.close();
    }

    public BoundModuleInfo retrieveModuleApiOutput() {
        if (this.hasData()) {
            return this.fApiModInfo;
        }
        return null;
    }

    public BoundSrvpgmInfo retrieveSrvpgmApiOutput() {
        if (this.hasData()) {
            return this.fApiSrvpgmInfo;
        }
        return null;
    }

    public class BoundModuleInfo {
        private int fNumModules = 0;
        private List<ModuleObj> fModules = null;

        BoundModuleInfo() {
        }

        public int count() {
            return this.fNumModules;
        }

        public List<ModuleObj> getModules() {
            return this.fModules;
        }

        public void addModule(ModuleObj module) {
            if (this.fNumModules == 0) {
                this.fModules = new ArrayList<ModuleObj>();
            }
            this.fModules.add(module);
            ++this.fNumModules;
        }
    }

    public class BoundSrvpgmInfo {
        private int fNumBndsrvpgms = 0;
        private List<SrvpgmObj> fBndsrvpgms = null;

        BoundSrvpgmInfo() {
        }

        public int count() {
            return this.fNumBndsrvpgms;
        }

        public List<SrvpgmObj> getSrvpgms() {
            return this.fBndsrvpgms;
        }

        public void addSrvpgm(SrvpgmObj srvpgm) {
            if (this.fNumBndsrvpgms == 0) {
                this.fBndsrvpgms = new ArrayList<SrvpgmObj>();
            }
            this.fBndsrvpgms.add(srvpgm);
            ++this.fNumBndsrvpgms;
        }
    }
}

