/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teami.build.toolkit.genlink.sysapi;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.teami.build.toolkit.genlink.filesystem.Log;
import com.ibm.teami.build.toolkit.genlink.filesystem.LogFactory;
import com.ibm.teami.build.toolkit.genlink.sysapi.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractApi {
    protected boolean fHasData = false;
    protected AS400 fSystem = null;
    protected ProgramParameter[] fParmList = null;
    protected byte[] fBuffer = null;
    protected String fApiFormat = null;
    protected byte[] fApiErrorCode = null;
    protected String fApiPgmName = null;
    protected AS400Bin4 fBin4 = new AS400Bin4();
    protected AS400UnsignedBin4 fUBin4 = new AS400UnsignedBin4();
    protected AS400Bin2 fBin2;
    protected AS400UnsignedBin2 fUbin2;

    AbstractApi() {
    }

    protected void setHasData(boolean state) {
        this.fHasData = state;
    }

    public boolean hasData() {
        return this.fHasData;
    }

    public void setSystem(AS400 system) {
        this.fSystem = system;
    }

    public void setApi(String api) {
        this.fApiPgmName = api;
    }

    public void setApiFormat(String format) {
        this.fApiFormat = format;
    }

    public String apiFormat() {
        return this.fApiFormat;
    }

    public int run() {
        int rc = 0;
        ProgramCall api = new ProgramCall(this.fSystem);
        Log log = LogFactory.getLog();
        try {
            api.setProgram(this.fApiPgmName, this.fParmList);
            if (!api.run()) {
                log.println("Program failed!");
                AS400Message[] messagelist = api.getMessageList();
                int i = 0;
                while (i < messagelist.length) {
                    log.println(messagelist[i].toString());
                    ++i;
                }
                rc = 4;
            }
        }
        catch (Exception e) {
            log.println(NLS.bind((String)Messages.AbstractApi_ErrorProgramException, (Object)api.getProgram()));
            e.printStackTrace(log.toPrintStream());
            rc = 8;
        }
        return rc;
    }

    public void disconnect() {
        this.fSystem.disconnectAllServices();
    }

    protected void initErrorCode() {
        byte[] errorcode = new byte[80];
        errorcode[0] = 0;
        errorcode[1] = 0;
        errorcode[2] = 0;
        errorcode[3] = 64;
        errorcode[4] = 0;
        errorcode[5] = 0;
        errorcode[6] = 0;
        errorcode[7] = 0;
    }

    protected byte[] convertString(String source, boolean nullTerminate) {
        AS400Text text = new AS400Text(source.length(), this.fSystem);
        if (nullTerminate) {
            byte[] ebcdic = new byte[source.length() + 1];
            text.toBytes((Object)source, ebcdic);
            ebcdic[source.length()] = 0;
            return ebcdic;
        }
        return text.toBytes((Object)source);
    }

    protected byte[] convertString(String source, int len, boolean nullTerminate) {
        AS400Text text = new AS400Text(len, this.fSystem);
        if (nullTerminate) {
            byte[] ebcdic = new byte[len + 1];
            text.toBytes((Object)source, ebcdic);
            ebcdic[len] = 0;
            return ebcdic;
        }
        return text.toBytes((Object)source);
    }

    protected String convertBytesToString(byte[] bytes) {
        int length = bytes.length;
        int i = 0;
        while (i < bytes.length && length == bytes.length) {
            if (bytes[i] == 0) {
                length = i;
            }
            ++i;
        }
        AS400Text text = new AS400Text(length, this.fSystem);
        return (String)text.toObject(bytes);
    }

    protected void convertQualifiedObject(byte[] qualifiedObjBytes, String libName, String objName) {
        AS400Text libText = new AS400Text(10, this.fSystem);
        AS400Text objText = new AS400Text(10, this.fSystem);
        byte[] objBytes = objText.toBytes((Object)objName);
        byte[] libBytes = libText.toBytes((Object)libName);
        int i = 0;
        while (i < 10) {
            qualifiedObjBytes[i] = objBytes[i];
            qualifiedObjBytes[i + 10] = libBytes[i];
            ++i;
        }
    }
}

